/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/

/*
  Confocal Slicer

  Nick Salmon
       Light Microscopy Group
       European Molecular Biology Laboratory
       Meyerhofstrasse 1
       69117 Heidelberg
       email: salmon@EMBL-Heidelberg.DE

This code is a modification of the public domain module "new_arbitrary_slicer",
from which the following copyright message is retained.
*/

/*   

Copyright (C) 1994, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus it is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*/

#define BIGNUM  1e10
#define SMALLNUM -1e10
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#define MAX(a,b) ((a) > (b) ? (a) : (b))


#include <stdio.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/geom.h>
#include <avs/field.h>
#include <avs/flow.h>
#include "gmatrix.h"

#include <avs/udata.h>

static char file_version[] = "@(#)confocal_slicer.c	1.0 NJS/EMBL 12/8/94";
typedef float FLOAT3[3];

__ansi_fflush(ptr)  /* added SRT */
FILE *ptr;
{
        fflush(ptr);
}


AVSinit_modules()
{
    int abslice();
    AVSmodule_from_desc(abslice);
}

int
abslice()
{
    int abslice_p();
    int p, field_output;

    AVSset_module_name("confocal slicer",MODULE_MAPPER);

    AVScreate_input_port("Input Field","field 3D byte",REQUIRED);
#if 0
    p=AVScreate_input_port("XformInfo","struct upstream_transform",
			      OPTIONAL | INVISIBLE);
    p = AVSset_input_class(p,"upstream transform");
#endif
    
    p = AVScreate_output_port("g_slice", "geom");
    AVScreate_output_port("Output Field","field 2D irregular");

    p=AVSadd_float_parameter("X Rotate",0.,-360.0,360.0);
    AVSconnect_widget(p,"dial");
    p=AVSadd_float_parameter("Y Rotate",0.,-360.0,360.0);
    AVSconnect_widget(p,"dial");
    p=AVSadd_float_parameter("Z Rotate",0.,-360.0,360.0);
    AVSconnect_widget(p,"dial");
    
    p=AVSadd_float_parameter("X Translate",0.,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"dial");
    p=AVSadd_float_parameter("Y Translate",0.,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"dial");
    p=AVSadd_float_parameter("Z Translate",0.,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"dial");
    
    p=AVSadd_float_parameter("X Scale",1.,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"dial");
    p=AVSadd_float_parameter("Y Scale",1.,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"dial");
    
    p=AVSadd_parameter("Mesh U Resolution","integer",60,10,500);
    AVSconnect_widget(p,"islider");
    p=AVSadd_parameter("Mesh V Resolution","integer",60,10,500);
    AVSconnect_widget(p,"islider");

    p=AVSadd_float_parameter("Background value",-1.,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"dial");

    /* Add a toggle to determine whether we want a field or geometry output */
    field_output=AVSadd_parameter("Field Output", "boolean", 0,0,1);
    AVSconnect_widget(field_output,"boolean");
 
    AVSset_compute_proc(abslice_p);
}

#if 0
abslice_p(inf,xform,g_slice,xr,yr,zr,xt,yt,zt,xs,ys,zs,xres,yres)
#endif
abslice_p(inf,g_slice,outf,xr,yr,zr,xt,yt,zt,xs,ys,xres,yres,undef,field_output)
AVSfield *inf;
GEOMedit_list *g_slice;
AVSfield **outf;
#if 0
struct upstream_transform *xform;
#endif
float *xr,*yr,*zr,*xt,*yt,*zt,*xs,*ys;
int xres,yres;
float *undef;
int field_output;
{
    AVSfield template;
    int dims[2],i,status;
    matrix4x4 xfm;
    float lxr,lyr,lzr,lxt,lyt,lzt,lxs,lys;

    avs_vertex *vertex;
    FLOAT3 *normal;
    unsigned long *colors, grey, red, green, blue, alpha; 
    register int *vdata, *pdata;
    register float *scalar;
    int num_out_pts, veclen;
    GEOMobj *obj;

    memset((char *)&template,0,sizeof(AVSfield));

    /* make local copies of parameters which could change...*/
    lxr = *xr;
    lyr = *yr;
    lzr = *zr;
    lxt = *xt;
    lyt = *yt;
    lzt = *zt;
    lxs = *xs;
    lys = *ys;

    if (inf->uniform == IRREGULAR || inf->uniform == RECTILINEAR){
      AVSwarning(" Only Regular fields supported.");
      return(0);
    }
    if (inf->points == NULL){
      AVSwarning("Input field must contain field->points information.");
      return(0);
    }

    template.ndim = 2;
    template.nspace = 3;
    template.veclen = inf->veclen;
    template.type = inf->type;
    template.size = inf->size;
    template.uniform = IRREGULAR;
    dims[0] = xres;
    dims[1] = yres;

    if(field_output){
      /* only free up the output field if we are going to create a new one */
      if (*outf) AVSfield_free(*outf);
      *outf = (AVSfield *)AVSfield_alloc(&template,dims);
      if (*outf == NULL){
	AVSerror("malloc error in abslice");
	return(0);
      }
    }

    num_out_pts = xres * yres;
    veclen = inf->veclen;

    if(!field_output){
      /* int colours are perfectly good for us ! */
      colors = (unsigned long *) malloc(sizeof(unsigned long)*num_out_pts);
      vertex = (avs_vertex *) malloc(sizeof(avs_vertex)*num_out_pts);
    }

    /* do the initial settings for this module, set slice plane parameters
       to something sane for this field. */
    
    if (AVSinput_changed("Input Field",0))
    {
      lxs = (0.5 * (inf->points[1] - inf->points[0])) - 0.5;
      lys = (0.5 * (inf->points[3] - inf->points[2])) - 0.5;
      lxt = (0.5 * (inf->points[1] - inf->points[0])) - 0.5 + inf->points[0];
      lyt = (0.5 * (inf->points[3] - inf->points[2])) - 0.5 + inf->points[2];
      lzt = (0.5 * (inf->points[5] - inf->points[4])) - 0.5 + inf->points[4];
      AVSmodify_float_parameter("X Scale",AVS_VALUE,(double)lxs,
				(double)lxs,(double)lxs);
      AVSmodify_float_parameter("Y Scale",AVS_VALUE,(double)lys,
				(double)lys,(double)lys);
      AVSmodify_float_parameter("X Translate",AVS_VALUE,(double)lxt,
				(double)lxt,(double)lxt);
      AVSmodify_float_parameter("Y Translate",AVS_VALUE,(double)lyt,
				(double)lyt,(double)lyt);
      AVSmodify_float_parameter("Z Translate",AVS_VALUE,(double)lzt,
				(double)lzt,(double)lzt);
    }

    make_global_xfrm(&xfm,&lxr,&lyr,&lzr,&lxt,&lyt,&lzt,&lxs,&lys);

    if(field_output){
      build_field_coords(*outf,&xfm);
      status = interp_uniform_field_data(*outf,inf,undef);
    } else {
      build_geom_coords(vertex,xres,yres,&xfm);
      status = interp_uniform_geom_data(vertex,colors,xres,yres,inf,undef);
    
      obj = GEOMcreate_mesh_with_data(NULL,vertex,NULL,colors,xres,
				      yres, GEOM_DONT_COPY_DATA);
      
      *g_slice = GEOMinit_edit_list(*g_slice);
      GEOMedit_geometry(*g_slice,"Confocal Slice",obj);
      GEOMdestroy_obj(obj); 
    }
    return(status);
}

#define PI 3.14159
#define DEGREES_TO_RADIANS(a) ((a)/180.*PI)

make_global_xfrm(xfm,xr,yr,zr,xt,yt,zt,xs,ys)
matrix4x4 *xfm;
float *xr,*yr,*zr,*xt,*yt,*zt,*xs,*ys;
{
    matrix4x4 rotx,roty,rotz,translate,scale;
    extern double cos(),sin();
    double d,t;

    identity_4x4(&scale);
    scale.m[0][0] = *xs;
    scale.m[1][1] = *ys;

    identity_4x4(&translate);
    translate.m[3][0] = *xt;
    translate.m[3][1] = *yt;
    translate.m[3][2] = *zt;

    identity_4x4(&rotx);
    d = DEGREES_TO_RADIANS(*xr);
    t = cos(d);
    rotx.m[1][1] = rotx.m[2][2] = t;
    t = sin(d);
    rotx.m[1][2] = t;
    rotx.m[2][1] = -1. * t;
	
    identity_4x4(&roty);
    d = DEGREES_TO_RADIANS(*yr);
    roty.m[0][0] = roty.m[2][2] = cos(d);
    roty.m[2][0] = sin(d);
    roty.m[0][2] = -1. * sin(d);
	
    identity_4x4(&rotz);
    d = DEGREES_TO_RADIANS(*zr);
    rotz.m[0][0] = rotz.m[1][1] = cos(d);
    rotz.m[0][1] = sin(d);
    rotz.m[1][0] = -1. * sin(d);

    identity_4x4(xfm);
    mmul_4x4(xfm,&scale);
    
    mmul_4x4(xfm,&rotx);
    mmul_4x4(xfm,&roty);
    mmul_4x4(xfm,&rotz);
    
    mmul_4x4(xfm,&translate);
}

/**
  * in building the coordinate list for the output irregular field,
  * what we will do is step through a predefined range in each of
  * the U&V parametric spaces, and pass that coordinate vector through
  * the xformation matrix.
  * since we have only U&V to construct a 3-d coordinate, we assume
  * an initial Z value of 0.0.
**/
build_field_coords(outf,xfm)
AVSfield *outf;
matrix4x4 *xfm;
{
    int i,j;
    double x,dx,y,dy,z;
    vector4 v,r;
    float *dest_x,*dest_y,*dest_z;

    dest_x = outf->points;
    dest_y = dest_x + (outf->dimensions[0]*outf->dimensions[1]);
    dest_z = dest_y + (outf->dimensions[0]*outf->dimensions[1]);

    x = -1.;
    dx = 2./(double)(outf->dimensions[0]-1);  /* increment to x=1.0 */
    y = -1.;
    dy = 2./(double)(outf->dimensions[1]-1); /* increment to y=1.0 */
    z = 0.0;

    for (j=0;j<outf->dimensions[1];j++,y+=dy)
    {
	x = -1;
	for (i=0;i<outf->dimensions[0];i++,x+=dx)
        {
	    v.v[0] = x;
	    v.v[1] = y;
	    v.v[2] = z;
	    v.v[3] = 1.0;
	    vector_matrix_mult_4(&v,xfm,&r);
	    *dest_x++ = r.v[0];
	    *dest_y++ = r.v[1];
	    *dest_z++ = r.v[2];
	}
    }
}

/**
  * in building the coordinate list for the output geometry,
  * what we will do is step through a predefined range in each of
  * the U&V parametric spaces, and pass that coordinate vector through
  * the xformation matrix.
  * since we have only U&V to construct a 3-d coordinate, we assume
  * an initial Z value of 0.0.
**/
build_geom_coords(outf,xres,yres,xfm)
avs_vertex *outf;
int xres,yres;
matrix4x4 *xfm;
{
    int i,j;
    double x,dx,y,dy,z;
    vector4 v,r;

    x = -1.;
    dx = 2./(double)(xres-1);  /* increment to x=1.0 */
    y = -1.;
    dy = 2./(double)(yres-1); /* increment to y=1.0 */
    z = 0.0;

    for (j=0;j<yres;j++,y+=dy)
    {
	x = -1;
	for (i=0;i<xres;i++,x+=dx)
        {
	    v.v[0] = x;
	    v.v[1] = y;
	    v.v[2] = z;
	    v.v[3] = 1.0;
	    vector_matrix_mult_4(&v,xfm,&r);
	    outf->v[0] = (float)(r.v[0]);
	    outf->v[1] = (float)(r.v[1]);
	    outf->v[2] = (float)(r.v[2]);
	    outf++;
	}
    }
}

/**
  * NOTE: the following routine WILL NOT WORK RIGHT in AVS 2.0 !!
  * as such, there are no ifdef's for AVS 3.
**/
int
interp_uniform_field_data(outf,inf,undef)
AVSfield *outf,*inf;
float *undef;
{
    float *srcx,*srcy,*srcz;
    int num_out_pts,i;
    static weight_uniform_points();
    int veclen, offset;

    veclen = inf->veclen;
    num_out_pts = outf->dimensions[0] * outf->dimensions[1];

    /* these are used as indices to the !points! array */
    srcx = outf->points;
    srcy = srcx + num_out_pts;
    srcz = srcy + num_out_pts;
	       
    /* num_out_pts */
    for (i=0;i<num_out_pts;i++)
    {
      if(!weight_uniform_points(srcx+i,srcy+i,srcz+i,inf,outf,i,NULL))
	for(offset=0;offset<veclen;offset++)
	  *(outf->field_union.field_data_char+i*veclen+offset) = (unsigned char) *undef;
    }

    return(1);
}

/**
  * NOTE: the following routine WILL NOT WORK RIGHT in AVS 2.0 !!
  * as such, there are no ifdef's for AVS 3.
**/
int
interp_uniform_geom_data(vertex,colors,xres,yres,inf,undef)
avs_vertex *vertex;
unsigned long *colors;
int xres,yres;
AVSfield *inf;
float *undef;
{
    float x,y,z;
    int num_out_pts,i;
    static weight_uniform_points();
    int veclen;
    unsigned char colours[4];
    
    for(i=0;i<4;i++)
      colours[i]=(unsigned char)(*undef);

    veclen = inf->veclen;
    num_out_pts = xres*yres;
	       
    for (i=0;i<num_out_pts;i++)
    {
      x = (vertex+i)->v[0];
      y = (vertex+i)->v[1];
      z = (vertex+i)->v[2];
      if(!weight_uniform_points(&x,&y,&z,inf,NULL,0,colors+i))
	*(colors+i) = *( (unsigned long *)colours);
    }

    return(1);
}


static int
weight_uniform_points(x,y,z,inf,outf,o_offset,colors)
float *x, *y, *z;
AVSfield *inf, *outf;
int o_offset;
unsigned long *colors;
{
    int i, ii, j, jj, k, kk;
    double p, p1, p2;
    double p000, p001, p010, p011, p100, p101, p110, p111;
    double xf, yf, zf, xf1, yf1, zf1, val;
    int xypts, ypts, offset;
    double px, py, pz;
    int veclen;
    unsigned char colours[4];

    veclen = inf->veclen;
    xypts = veclen * inf->dimensions[1]*inf->dimensions[0];
    ypts = veclen * inf->dimensions[0];

    /* first refer our "points" value to the "dimensions" co'ordinate sytem */
    px= ((*x) - inf->points[0]) * ((float)inf->dimensions[0]/(inf->points[1]-inf->points[0]));
    py= ((*y) - inf->points[2]) * ((float)inf->dimensions[1]/(inf->points[3]-inf->points[2]));
    pz= ((*z) - inf->points[4]) * ((float)inf->dimensions[2]/(inf->points[5]-inf->points[4]));
      
    /* now find what is the nearest point in our array to this value */
    i = (int)px;
    j = (int)py;
    k = (int)pz;

    /* check that we will not be trying to look outside the input array */
    if( px<0. || i<0 || i>=inf->dimensions[0] || 
        py<0. || j<0 || j>=inf->dimensions[1] || 
        pz<0. || k<0 || k>=inf->dimensions[2]){
      return(0);
    }

    ii = MIN((i+1),(inf->dimensions[0] - 1));
    jj = MIN((j+1),(inf->dimensions[1] - 1));
    kk = MIN((k+1),(inf->dimensions[2] - 1));

    if (i == ii) xf = 1.0;
    else xf = (px - i) / (ii - i);

    if (j == jj) yf = 1.0;
    else yf = (py - j) / (jj - j);

    if (k == kk) zf = 1.0;
    else zf = (pz - k) / (kk - k);

    xf1 = 1. - xf;
    yf1 = 1. - yf;
    zf1 = 1. - zf;

    if(colors){
      for(offset=0;offset<veclen;offset++){
	p000 = *(inf->field_union.field_data_char + k*xypts + j*ypts + i*veclen + offset);
	p001 = *(inf->field_union.field_data_char + kk*xypts + j*ypts + i*veclen + offset);
	p010 = *(inf->field_union.field_data_char + k*xypts + jj*ypts + i*veclen + offset);
	p011 = *(inf->field_union.field_data_char + kk*xypts + jj*ypts + i*veclen + offset);
	p100 = *(inf->field_union.field_data_char + k*xypts + j*ypts + ii*veclen + offset);
	p101 = *(inf->field_union.field_data_char + kk*xypts + j*ypts + ii*veclen + offset);
	p110 = *(inf->field_union.field_data_char + k*xypts + jj*ypts + ii*veclen + offset);
	p111 = *(inf->field_union.field_data_char + kk*xypts + jj*ypts + ii*veclen + offset);
	val = zf1 * (yf1 * (xf1 * p000 + xf * p100) + yf * (xf1 * p010 + xf * p110)) +
	  zf  * (yf1 * (xf1 * p001 + xf * p101) + yf * (xf1 * p011 + xf * p111));
	colours[offset] = (unsigned char)val;
      }
      if(veclen==1) /* put our one value as a greyscale image */
	for(offset=1;offset<4;offset++)
	  colours[offset] = colours[0];

      *colors = *( (unsigned long *)colours);
    } else {
      for(offset=0;offset<veclen;offset++){
	p000 = *(inf->field_union.field_data_char + k*xypts + j*ypts + i*veclen + offset);
	p001 = *(inf->field_union.field_data_char + kk*xypts + j*ypts + i*veclen + offset);
	p010 = *(inf->field_union.field_data_char + k*xypts + jj*ypts + i*veclen + offset);
	p011 = *(inf->field_union.field_data_char + kk*xypts + jj*ypts + i*veclen + offset);
	p100 = *(inf->field_union.field_data_char + k*xypts + j*ypts + ii*veclen + offset);
	p101 = *(inf->field_union.field_data_char + kk*xypts + j*ypts + ii*veclen + offset);
	p110 = *(inf->field_union.field_data_char + k*xypts + jj*ypts + ii*veclen + offset);
	p111 = *(inf->field_union.field_data_char + kk*xypts + jj*ypts + ii*veclen + offset);
	val = zf1 * (yf1 * (xf1 * p000 + xf * p100) + yf * (xf1 * p010 + xf * p110)) +
	  zf  * (yf1 * (xf1 * p001 + xf * p101) + yf * (xf1 * p011 + xf * p111));
	*(outf->field_union.field_data_char + o_offset*veclen + offset) = (unsigned char)val;
      }
    }
  
    return(1);
}



/** misc matrix stuff. **/

identity_4x4(m)
matrix4x4 *m;
{
    int i,j;
    for (i=0;i<4;i++)
	for (j=0;j<4;j++)
	    m->m[i][j] = ((i==j) ? 1. : 0.);
}

mmul_4x4(a,b)
matrix4x4 *a,*b;  /* take product of a and b, put result in a */
{
    matrix4x4 tmp;
    int row,col;

    clear_4x4(&tmp);

    for (row=0;row<4;row++)
    {
	for (col=0;col<4;col++)
	    tmp.m[row][col] = a->m[row][0]*b->m[0][col] +
		a->m[row][1]*b->m[1][col] + a->m[row][2]*b->m[2][col] +
		    a->m[row][3]*b->m[3][col];
    }
    for (row=0;row<4;row++)
	for (col=0;col<4;col++)
	    a->m[row][col] = tmp.m[row][col];
}

vector_matrix_mult_4(v,m,result)
vector4 *v,*result;
matrix4x4 *m;
{
    int i,j;

    for (j=0;j<4;j++)
    {
	result->v[j] = 0.;
	for (i=0;i<4;i++)
	    result->v[j] += v->v[i] * m->m[i][j];
    }
}
clear_4x4(m)
matrix4x4 *m;
{
    int i,j;
    for (i=0;i<4;i++)
	for (j=0;j<4;j++)
	    m->m[i][j] = 0.;
}

static int last_i= -1,last_j= -1,last_k= -1;
static int deja_vu=0;

get_rectilinear_ijk(i,j,k,inf,x,y,z)
int *i,*j,*k;
AVSfield *inf;
float *x,*y,*z;
{
    register float *f1,*f2;
    register int l;
    
    /* find the index which bounds the input x,y,z point. */
    /* do x coords first */
    
    f1 = inf->points;
    f2 = f1+1;
    if (deja_vu == 0)
    {
	for (l=0;l<inf->dimensions[0]-1;l++,f1++,f2++)
	    if ((*x >= *f1) && (*x <= *f2))
		break;
	if (l == inf->dimensions[0])
	    return(0);
	else
	    *i = last_i = l;
    }
    else
    {
	f1 = f1 + last_i;
	f2 = f1+1;
	/* see if the last one we looked at is still valid. */
	if ((*x >= *f1) && (*x <= *f2))
	    *i = last_i;
	else
	{
	    if (*x < *f1) /* search downward in list */
	    {
		f2 = f1;
		f1 = f1 - 1;
		for (l=last_i - 1;l >= 0;l--,f1--,f2--)
		    if ((*x >= *f1) && (*x <= *f2))
			break;
		if (l == -1)
		    return(0);
	    }
	    else /* search upward in list */
	    {
		f1 = f2;
		f2 = f2+1;
		for (l=last_i+1;l<inf->dimensions[0];l++,f1++,f2++)
		    if ((*x >= *f1) && (*x <= *f2))
			break;
		if (l == inf->dimensions[0])
		    return(0);
	    }
	    *i = last_i = l;
	}
    }
	
    /* do y coords next. */
    f1 = inf->points + inf->dimensions[0];
    f2 = f1+1;
    if (deja_vu == 0)
    {
	for (l=0;l<inf->dimensions[1]-1;l++,f1++,f2++)
	    if ((*y >= *f1) && (*y <= *f2))
		break;
	if (l == inf->dimensions[1])
	    return(0);
	else
	    *j = last_j = l;
    }
    else
    {
	f1 = f1 + last_j;
	f2 = f1+1;
	/* see if the last one we looked at is still valid. */
	if ((*y >= *f1) && (*y <= *f2))
	    *j = last_j;
	else
	{
	    if (*y < *f1) /* search downward in list */
	    {
		f2 = f1;
		f1 = f1 - 1;
		for (l=last_j - 1;l >= 0;l--,f1--,f2--)
		    if ((*y >= *f1) && (*y <= *f2))
			break;
		if (l == -1)
		    return(0);
	    }
	    else /* search upward in list */
	    {
		f1 = f2;
		f2 = f2+1;
		for (l=last_j+1;l<inf->dimensions[1];l++,f1++,f2++)
		    if ((*y >= *f1) && (*y <= *f2))
			break;
		if (l == inf->dimensions[1])
		    return(0);
	    }
	    *j = last_j = l;
	}
    }

    /* do z coords last. */
    f1 = inf->points + inf->dimensions[0] + inf->dimensions[1];
    f2 = f1+1;

    if (deja_vu == 0)
    {
	for (l=0;l<inf->dimensions[2]-1;l++,f1++,f2++)
	    if ((*z >= *f1) && (*z <= *f2))
		break;
	if (l == inf->dimensions[2])
	    return(0);
	else
	    *k = last_k = l;
    }
    else
    {
	f1 = f1 + last_k;
	f2 = f1+1;
	/* see if the last one we looked at is still valid. */
	if ((*z >= *f1) && (*z <= *f2))
	    *k = last_k;
	else
	{
	    if (*z < *f1) /* search downward in list */
	    {
		f2 = f1;
		f1 = f1 - 1;
		for (l=last_k - 1;l >= 0;l--,f1--,f2--)
		    if ((*z >= *f1) && (*z <= *f2))
			break;
		if (l == -1)
		    return(0);
	    }
	    else /* search upward in list */
	    {
		f1 = f2;
		f2 = f2+1;
		for (l=last_k+1;l<inf->dimensions[2];l++,f1++,f2++)
		    if ((*z >= *f1) && (*z <= *f2))
			break;
		if (l == inf->dimensions[2])
		    return(0);
	    }
	    *k = last_k = l;
	}
    }
    
    deja_vu = 1;
    
    return(1);
}

int
boundary_point(b,d)
int *b,*d;
{
    int status = 0;
    int i;

    for (i=0;i<3;i++)
    {
	if (b[i] == 0)
	    status |= 1;
	else if (b[i] == (d[i] - 1))
	    status |= 1;
    }
    return(status);
    
}

