/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/******************************************************************************/
/*
 *  Contour_Field produces a geometry object which is the contouring of
 *  a 2D field.
 *
 */



#include	"avs_utils.h"
#include	"contour.h"



#define		CONTOUR_NO_Z_LIMIT		1.0e+30



void		contour_out ();	/* Function to dispose of contour output. */

void		contour_out_line ();
void		contour_out_labl ();
void		contour_out_conv ();



GEOMobj		*cont_line_obj, *cont_temp_obj;
AVSfield	*cont_field;
AVScolormap	*cont_cmap;
FLOAT3		*cont_pclr, cont_colors[GEOM_MAX_VERTS], cont_offs;
FLOAT3		 cont_xyz, cont_prev;
int		 cont_ilev, cont_nlev;
float		 cont_zint, cont_zmin, cont_zmax;
float		 cont_zlev, cont_zfac;

GEOMobj		*cont_labl_obj, *cont_pins_obj;
FLOAT3		*cont_labl_pclr, cont_labl_offs, cont_labl_adj;
char		 cont_labl_str[21], cont_labl_fmt[5] = "%.0f";
int		*cont_labl_lev, cont_labl_flags, cont_labl_made;
float		 cont_labl_ht, cont_labl_ht2;
float		 cont_labl_int, cont_labl_offset;
float		 cont_labl_fac, cont_labl_prec;
float		 cont_labl_den, cont_labl_den2, cont_labl_dist;



char		in_field_port[]		= "Input Field";
char		in_cmap_port[]		= "Input Colormap";
char		out_geom_port[]		= "Output Geom";
char		parm_safety[]		= "safety";
char		parm_automatic[]	= "automatic";
char		parm_contour_int[]	= "contour interval   ";
char		parm_contour_min[]	= "contour minimum ";
char		parm_contour_max[]	= "contour maximum";
char		parm_label_int[]	= "label interval       ";
char		parm_label_density[]	= "label density       ";
char		parm_label_offset[]	= "label offset         ";
char		parm_label_factor[]	= "label value factor";
char		parm_label_prec[]	= "label precision     ";
char		parm_label_ht[]		= "label height         ";
char		parm_label_font[]	= "label font            ";
char		parm_label_declutter[]	= "label declutter";
char		parm_label_colored[]	= "labels colored";
char		parm_tri_grid[]		= "triangular grid";
char		parm_z_scale[]		= "z scale factor";
char		parm_contour_file[]	= "contour data file";
char		parm_man_c_int[]	= "manual    c_int";
char		parm_man_c_min[]	= "manual    c_min";
char		parm_man_c_max[]	= "manual    c_max";
char		parm_man_l_int[]	= "manual    l_int";
char		parm_man_l_den[]	= "manual    l_den";
char		parm_man_l_off[]	= "manual    l_off";
char		parm_man_l_fac[]	= "manual    l_fac";
char		parm_man_l_prc[]	= "manual    l_prc";



contour_field_desc ()

{
    int		contour_field_compute ();
    int		out_port, iparm, i, ip;
    char	layout_txt[10000];

    AVSset_module_name ("contour field", MODULE_MAPPER);

    AVScreate_input_port (in_field_port, "field 2D scalar", REQUIRED);

    AVScreate_input_port (in_cmap_port, "colormap", OPTIONAL);

    out_port = AVScreate_output_port (out_geom_port, "geom");
    AVSautofree_output (out_port);


    AVSadd_parameter (parm_safety, "boolean", FALSE, FALSE, TRUE);
    AVSadd_parameter (parm_automatic, "boolean", TRUE, FALSE, TRUE);


    iparm = AVSadd_float_parameter (parm_contour_int,
                                    0.0, 0.0, FLOAT_UNBOUND);
    AVSconnect_widget (iparm, "typein_real");
    iparm = AVSadd_float_parameter (parm_contour_min,
                                    0.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
    AVSconnect_widget (iparm, "typein_real");
    iparm = AVSadd_float_parameter (parm_contour_max,
                                    0.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
    AVSconnect_widget (iparm, "typein_real");


    iparm = AVSadd_float_parameter (parm_label_int,
                                    0.0, 0.0, FLOAT_UNBOUND);
    AVSconnect_widget (iparm, "typein_real");
    iparm = AVSadd_float_parameter (parm_label_density,
                                    0.0, 0.0, FLOAT_UNBOUND);
    AVSconnect_widget (iparm, "typein_real");
    iparm = AVSadd_float_parameter (parm_label_offset,
                                    0.0, 0.0, FLOAT_UNBOUND);
    AVSconnect_widget (iparm, "typein_real");
    iparm = AVSadd_float_parameter (parm_label_factor,
                                    1.0, 0.0, FLOAT_UNBOUND);
    AVSconnect_widget (iparm, "typein_real");
    iparm = AVSadd_float_parameter (parm_label_prec,
                                    1.0, 0.0, FLOAT_UNBOUND);
    AVSconnect_widget (iparm, "typein_real");
    iparm = AVSadd_float_parameter (parm_label_ht,
                                    0.03, 0.0, FLOAT_UNBOUND);
    AVSconnect_widget (iparm, "typein_real");
    iparm = AVSadd_parameter (parm_label_font, "integer", 1, 0, 20);
    AVSconnect_widget (iparm, "typein_integer");
    AVSadd_parameter_prop (iparm, "width", "integer", 2);
    AVSadd_parameter (parm_label_declutter, "boolean", TRUE, FALSE, TRUE);
    AVSadd_parameter (parm_label_colored, "boolean", TRUE, FALSE, TRUE);

    AVSadd_parameter (parm_tri_grid, "boolean", TRUE, FALSE, TRUE);

    AVSadd_float_parameter (parm_z_scale, 1.0, FLOAT_UNBOUND, FLOAT_UNBOUND);

    iparm = AVSadd_parameter (parm_contour_file, "string",
                              NULL_STR, NULL, NULL);
    AVSconnect_widget (iparm, "browser");


    i = 0;
    iparm = AVSadd_parameter (parm_man_c_int, "boolean", FALSE, FALSE, TRUE);
    AVSadd_parameter_prop (iparm, "width", "integer", 1);
    i += layout_toggle ((layout_txt+i), parm_man_c_int, 187,  54, 59, 22);
    ip = AVSadd_parameter (parm_man_c_min, "boolean", FALSE, FALSE, TRUE);
    AVSadd_parameter_prop (ip, "width", "integer", 1);
    i += layout_toggle ((layout_txt+i), parm_man_c_min, 187,  76, 59, 22);
    ip = AVSadd_parameter (parm_man_c_max, "boolean", FALSE, FALSE, TRUE);
    AVSadd_parameter_prop (ip, "width", "integer", 1);
    i += layout_toggle ((layout_txt+i), parm_man_c_max, 187,  98, 59, 22);
    ip = AVSadd_parameter (parm_man_l_int, "boolean", FALSE, FALSE, TRUE);
    AVSadd_parameter_prop (ip, "width", "integer", 1);
    i += layout_toggle ((layout_txt+i), parm_man_l_int, 187, 120, 59, 22);
    ip = AVSadd_parameter (parm_man_l_den, "boolean", FALSE, FALSE, TRUE);
    AVSadd_parameter_prop (ip, "width", "integer", 1);
    i += layout_toggle ((layout_txt+i), parm_man_l_den, 187, 142, 59, 22);
    ip = AVSadd_parameter (parm_man_l_off, "boolean", FALSE, FALSE, TRUE);
    AVSadd_parameter_prop (ip, "width", "integer", 1);
    i += layout_toggle ((layout_txt+i), parm_man_l_off, 187, 164, 59, 22);
    ip = AVSadd_parameter (parm_man_l_fac, "boolean", FALSE, FALSE, TRUE);
    AVSadd_parameter_prop (ip, "width", "integer", 1);
    i += layout_toggle ((layout_txt+i), parm_man_l_fac, 187, 186, 59, 22);
    ip = AVSadd_parameter (parm_man_l_prc, "boolean", FALSE, FALSE, TRUE);
    AVSadd_parameter_prop (ip, "width", "integer", 1);
    i += layout_toggle ((layout_txt+i), parm_man_l_prc, 187, 208, 59, 22);

    AVSadd_parameter_prop (iparm, "layout", "string_block", layout_txt);


    AVSset_compute_proc (contour_field_compute);

    return;
}



int	layout_toggle (layout_txt, name, ix, iy, iw, ih)

char	*layout_txt, *name;
int	ix, iy, iw, ih;
{

    sprintf (layout_txt, "%s%s%s%s%d,%d%s%d,%d\n\0",
             "    manipulator $Module:\"", name, "\" -w toggle -p $Module \\\n", 
             "        -xy ", ix, iy, " -wh ", iw, ih);


    return (strlen (layout_txt));
}



/******************************************************************************/
/*
 *  Inform AVS of the name of the description procedure for this module.
 *
 */


AVSinit_modules()
{
    AVSmodule_from_desc (contour_field_desc);
    return ;
}



contour_field_compute (in_field, in_cmap, out_geom, 
                       safety, automatic,
                       p_cont_int, p_cont_min, p_cont_max,
                       p_label_int, p_label_den, p_label_off,
                       p_label_factor, p_label_prec, p_label_ht,
                       i_label_font, i_label_declut, i_label_color,
                       i_tri_grid, p_z_scale, file_name,
                       man_c_int, man_c_min, man_c_max,
                       man_l_int, man_l_den, man_l_off, man_l_fac, man_l_prc)

AVSfield	*in_field;
AVScolormap	*in_cmap;
GEOMedit_list	*out_geom;
int		safety, automatic;
float		*p_cont_int, *p_cont_min, *p_cont_max;
float		*p_label_int, *p_label_den, *p_label_off;
float		*p_label_factor, *p_label_prec, *p_label_ht;
int		i_label_font, i_label_declut, i_label_color;
int		i_tri_grid;
float		*p_z_scale;
char		*file_name;
int		man_c_int, man_c_min, man_c_max;
int		man_l_int, man_l_den, man_l_off, man_l_fac, man_l_prc;
{
    static char		line_obj_name[] = "contour_lines";
    static char		labl_obj_name[] = "contour_labels";
    static char		pins_obj_name[] = "contour_label_pins";

    register int	i, j, n, ip;
    int			nx, ny, nlev;
    float		parm1, parm2, *parms, *p_cont_data;
    float		xtmp, min, max, xyzmin[3], xyzmax[3];
    char		*work;
    FILE		*file;



    i = (*p_cont_min > *p_cont_max);
    AVSparameter_visible (parm_contour_file, i);


    if (safety)
    {
        AVSmark_output_unchanged (out_geom_port);
        return (1);
    }


    *out_geom = GEOMinit_edit_list (*out_geom);


    if (in_field == NULL) return (1);

    if (in_field->ndim != 2)
    {
        AVSerror ("%s", "Only 2D fields can be contoured.");
        return (1);
    }

    nx = in_field->dimensions[0];
    ny = in_field->dimensions[1];

    UTILS_field_pt_init (in_field);


    if (automatic)
    {
        min = 1.0e30, max = -1.0e30;

        for (j = 0; j < ny; j++)
        {
            for (i = 0; i < nx; i++)
            {
                xtmp = UTILS_field_pt_val (i, j, 0);
                if (xtmp < min) min = xtmp;
                if (xtmp > max) max = xtmp;
            }
        }

        if (!man_c_int) *p_cont_int = (max - min) / 10.0;
        if (!man_c_min) *p_cont_min = min;
        if (!man_c_max) *p_cont_max = max;

        if (!man_l_int) *p_label_int = *p_cont_int;

        if (!man_l_den)
        {
            UTILS_field_pt_limits (xyzmin, xyzmax);
            UTILS_float3_sub      (xyzmax, xyzmin);
            *p_label_den = UTILS_float3_sqrt (xyzmax) / 3.0;
        }

        if (!man_l_off)
        {
            UTILS_field_offsets_from_surf (in_field, xyzmin);
            xtmp = 0.0;
            if (xyzmin[X_COORD] != 0.0) xtmp = xyzmin[X_COORD];
            if (xyzmin[Y_COORD] != 0.0) xtmp = xyzmin[Y_COORD];
            if (xyzmin[Z_COORD] != 0.0) xtmp = xyzmin[Z_COORD];
            if (xtmp < 0.0) xtmp = -xtmp;
            *p_label_off = xtmp * 5.0;
        }

        max = fabs (max), min = fabs (min);
        if (min > max) xtmp = max, max = min, min = xtmp;

        i = log10 (max);
        if (max < 1.0) i--;
        if (i > 4)
        {
            if (!man_l_fac) *p_label_factor = pow (10.0, (float)(i - 2));
            if (!man_l_prc) *p_label_prec   = 1.0;
        }
        else if (i <= 0)
        {
            if (!man_l_fac) *p_label_factor = pow (10.0, (float)(i));
            if (!man_l_prc) *p_label_prec   = 0.1;
        }
        else
        {
            if (!man_l_fac) *p_label_factor = 1.0;
            if (!man_l_prc) *p_label_prec   = 1.0;
        }

        AVSmodify_float_parameter (parm_contour_int, AVS_VALUE,
                                   *p_cont_int, 0.0, 0.0);
        AVSmodify_float_parameter (parm_contour_min, AVS_VALUE,
                                   *p_cont_min, 0.0, 0.0);
        AVSmodify_float_parameter (parm_contour_max, AVS_VALUE,
                                   *p_cont_max, 0.0, 0.0);
        AVSmodify_float_parameter (parm_label_int, AVS_VALUE,
                                   *p_label_int, 0.0, 0.0);
        AVSmodify_float_parameter (parm_label_density, AVS_VALUE,
                                   *p_label_den, 0.0, 0.0);
        AVSmodify_float_parameter (parm_label_offset, AVS_VALUE,
                                   *p_label_off, 0.0, 0.0);
        AVSmodify_float_parameter (parm_label_factor, AVS_VALUE,
                                   *p_label_factor, 0.0, 0.0);
        AVSmodify_float_parameter (parm_label_prec, AVS_VALUE,
                                   *p_label_prec, 0.0, 0.0);

        if (!man_c_min)
            *p_cont_min = (float) ((int) (*p_cont_min / *p_cont_int)) *
                          *p_cont_int;
        if (!man_c_max)
            *p_cont_max = (float) ((int) (*p_cont_max / *p_cont_int)) *
                          *p_cont_int;
    }


    parms         = NULL;
    ip            = (i_tri_grid) ? 1 : 0;
    cont_labl_lev = NULL;

    if (*p_cont_min > *p_cont_max)
    {
        AVSparameter_visible (parm_contour_file, TRUE);

        file = UTILS_file_name_check (&file_name, "r",
                                      "The contour data file");
        if (file == NULL) return (1);

        nlev = 0;
        while ((i = fgetc (file)) != EOF) if (i == '\n') nlev++;

        parms         = (float *) malloc ((nlev + 2 + ip) * sizeof (float));
        cont_labl_lev = (int *) malloc (nlev * sizeof (int));

        parms[ip++] = CONTOUR_NO_Z_LIMIT;
        parms[ip++] = nlev;
        rewind (file);
        n = 0;
        for (i = 0; i < nlev; i++, ip++)
        {
            fscanf (file, "%f", (parms+ip));

            cont_labl_lev[i] = FALSE;
            while ((j = fgetc (file)) != '\n')
                if (isgraph (j)) cont_labl_lev[i] = TRUE, n++;
        }
        fclose (file);

        if (n == 0)
        {
            free (cont_labl_lev);
            cont_labl_lev = NULL;
            *p_label_int  = 0.0;
        }
    }


    cont_line_obj = GEOMcreate_obj (GEOM_POLYTRI, GEOM_NULL);
    if (cont_line_obj == GEOM_NULL) return (1);

    cont_field = in_field;
    cont_zfac  = *p_z_scale;
    cont_cmap  = in_cmap;
    cont_pclr  = (cont_cmap == GEOM_NULL) ? GEOM_NULL : cont_colors;


    cont_labl_obj   = GEOM_NULL;
    cont_pins_obj   = GEOM_NULL;

    cont_labl_flags = GEOMcreate_label_flags (i_label_font, 0,
                                              i_label_declut, 0, 
                                              GEOM_LABEL_CENTER, 0);
    cont_labl_ht     = *p_label_ht;
    cont_labl_den    = *p_label_den;
    cont_labl_int    = *p_label_int;
    cont_labl_offset = *p_label_off;
    cont_labl_fac    = *p_label_factor;
    cont_labl_prec   = (*p_label_prec <= 0.0) ? 1.0 :
                       (*p_label_prec >= 1.0) ? 1.0 : *p_label_prec;
    cont_labl_pclr   = (i_label_color) ? cont_pclr : GEOM_NULL;
    cont_labl_ht2    = (cont_labl_ht / 2.0) * 0.75;
    cont_labl_den2   = cont_labl_den / 2.0;

    if ((i_label_font  <=   0) ||
        (cont_labl_den <= 0.0) ||
        (cont_labl_ht  <= 0.0) ||
        (cont_labl_fac == 0.0) ||
        ((cont_labl_int == 0.0) && (cont_labl_lev == NULL)))
    {
        GEOMedit_visibility (*out_geom, labl_obj_name, GEOM_EDIT_DELETE);
    }
    else
    {
        cont_labl_obj = GEOMcreate_label (GEOM_NULL, cont_labl_flags);


        if (cont_labl_offset == 0.0)
            GEOMedit_visibility (*out_geom, pins_obj_name, GEOM_EDIT_DELETE);
        else
            cont_pins_obj = GEOMcreate_obj (GEOM_POLYTRI, GEOM_NULL);
    }

    cont_temp_obj = cont_line_obj;



    p_cont_data = in_field->field_data_float;
    if (in_field->type != AVS_TYPE_REAL)
    {
        UTILS_field_pt_init (in_field);
        p_cont_data = (float *) malloc (nx * ny * sizeof (float));
        n = 0;
        for (j = 0; j < ny; j++)
            for (i = 0; i < nx; i++, n++)
                *(p_cont_data+n) = UTILS_field_pt_val (i, j, 0);
    }


    if (parms == NULL)
    {
        parms = (float *) malloc (5 * sizeof (float));

        cont_zint = *p_cont_int;
        cont_zmin = *p_cont_min;
        cont_zmax = *p_cont_max;

        parm1     = cont_zmin;
        parm2     = cont_zmax;

        if (cont_zint == 0.0)
        {
            nlev = (cont_zmin == cont_zmax) ? 11 : 1;
        }
        else
        {
            if (cont_zmax == cont_zmin)
            {
                nlev  = 0;
                parm1 = cont_zint;
            }
            else
            {
                nlev      = 1 + ((cont_zmax - cont_zmin) / cont_zint);
                parm2     = cont_zmin + (cont_zint * (((float) (nlev - 1))));
                if (parm2 < cont_zmax) nlev++, parm2 += cont_zint;
                cont_zmax = parm2;
            }
        }
        parms[ip++] = CONTOUR_NO_Z_LIMIT;
        parms[ip++] = -nlev;
        parms[ip++] = parm1;
        parms[ip++] = parm2;
    }

    n    = (i_tri_grid) ? 3 : 2;
    work = (char *) malloc (nx * ny * n);


    if (i_tri_grid)
    {
        parms[0] = -1.0;	/* Negative triangulation direction   */
        contour_tri_ (p_cont_data, &nx, &ny, parms, work, contour_out);
    }
    else
    {
        contour_rec_ (p_cont_data, &nx, &ny, parms, work, contour_out);
    }

    free (parms);
    free (work);
    if (p_cont_data != in_field->field_data_float) free (p_cont_data);
    UTILS_field_pt_xy_to_xyz (NULL);


    GEOMedit_geometry (*out_geom, line_obj_name, cont_line_obj);
    GEOMdestroy_obj (cont_line_obj);

    if (cont_labl_obj != NULL)
    {
        GEOMedit_geometry (*out_geom, labl_obj_name, cont_labl_obj);
        GEOMedit_parent   (*out_geom, labl_obj_name, line_obj_name);
        GEOMdestroy_obj   (cont_labl_obj);

        if (cont_pins_obj != GEOM_NULL)
        {
            GEOMedit_geometry (*out_geom, pins_obj_name, cont_pins_obj);
            GEOMedit_parent   (*out_geom, pins_obj_name, labl_obj_name);
            GEOMdestroy_obj   (cont_pins_obj);
        }
    }


    return (1);
}



/******************************************************************************/
/*
 *  Dispose of the contour information passed by contour.
 *
 */


void	contour_out (kode, x, y)

int	*kode;
float	*x, *y;
{

    register int	itmp;
    float		xtmp;

    UTILS_float3_copy (cont_xyz, cont_prev);

    switch (*kode)
    {
        case CONTOUR_POINT :

            contour_out_conv (*x, *y);
            contour_out_line (cont_xyz);
            contour_out_labl (cont_labl_den);
            break;

        case CONTOUR_START :

            cont_nlev = *x;

            xtmp = log10 ((double) cont_labl_prec);
            itmp = -xtmp;
            itmp = (itmp < 0) ? 0 : (itmp > 9) ? 9 : itmp;
            cont_labl_fmt[2] = itmp + 48;

            UTILS_field_offsets_from_surf (cont_field, cont_offs);

            itmp = -1;
            if (cont_offs[X_COORD] != 0.0) itmp = X_COORD;
            if (cont_offs[Y_COORD] != 0.0) itmp = Y_COORD;
            if (cont_offs[Z_COORD] != 0.0) itmp = Z_COORD;
            cont_labl_offs[0] = cont_labl_offs[1] = cont_labl_offs[2] = 0.0;
            if (itmp != -1) cont_labl_offs[itmp] = cont_labl_offset;
            cont_labl_offs[Y_COORD] = -cont_labl_offs[Y_COORD];

            cont_labl_adj[0] = cont_labl_adj[1] = cont_labl_adj[2] = 0.0;
            if (itmp == Z_COORD)
                cont_labl_adj[Y_COORD] = cont_labl_ht2;
            else
                cont_labl_adj[Z_COORD] = cont_labl_ht2;

            contour_out_line (NULL);

            break;

        case CONTOUR_START_LEVEL :

            cont_ilev = *x - 1;
            cont_zlev = *y;

            cont_zlev -= cont_zmin;
            contour_out_isint (&cont_zlev, &cont_zint);
            cont_zlev += cont_zmin;

            if (cont_pclr != GEOM_NULL)
            {
                UTILS_color_rgb_from_value (cont_cmap, cont_zlev, cont_colors);
                for (itmp = 1; itmp < GEOM_MAX_VERTS; itmp++)
                    UTILS_float3_copy (cont_colors, (cont_colors+itmp));
            }

            itmp = FALSE;
            if (cont_labl_lev != NULL)
                itmp = cont_labl_lev[cont_ilev];
            else
            {
                if (cont_labl_int != 0.0)
                {
                    if (cont_zint == 0.0)
                        itmp = TRUE;
                    else
                    {
                        xtmp = cont_zlev;
                        if (cont_zmin < cont_zmax)
                        {
                            xtmp -= cont_zmin;
                            contour_out_isint (&xtmp, &cont_zint);
                        }
                        itmp = contour_out_isint (&xtmp, &cont_labl_int);
                    }
                }
            }
            cont_labl_str[0] = '\0';
            if (itmp)
            {
                xtmp = cont_zlev;
                if (cont_labl_fac != 0.0) xtmp /= cont_labl_fac;
                sprintf (cont_labl_str, cont_labl_fmt, xtmp);
            }

            break;

        case CONTOUR_START_CONTOUR :

            contour_out_conv (*x, *y);
            contour_out_line (cont_xyz);
            cont_labl_made = FALSE;
            cont_labl_dist = 0.0;
            break;

        case CONTOUR_REVERSE :

            contour_out_conv (*x, *y);
            contour_out_line (NULL);
            contour_out_line (cont_xyz);
            xtmp = (cont_labl_made) ? cont_labl_dist : cont_labl_den2;
            contour_out_labl (xtmp);
            break;

        case CONTOUR_END_CONTOUR_CLOSED :

            contour_out_conv (*x, *y);
            contour_out_line (cont_xyz);
            contour_out_line (NULL);
            contour_out_labl (cont_labl_den2);
            break;

        case CONTOUR_END_CONTOUR_OPEN :

            contour_out_labl (cont_labl_den2);
            contour_out_line (NULL);
            break;

        case CONTOUR_END_LEVEL :

            cont_ilev = *x - 1;
            cont_zlev = *y;
            break;

        case CONTOUR_END :

            cont_nlev     = *x;
            cont_pclr     = NULL;
            cont_temp_obj = NULL;
            contour_out_line (NULL);
            break;

        default :

            break;

    }

    return ;
}



/******************************************************************************/
/*
 *  Add a contour line segment to the contour geometry object.
 *
 */


void	contour_out_line (xyz)

FLOAT3		xyz;
{

    UTILS_geom_polyline_add_pt (cont_temp_obj, xyz, cont_pclr);

    return ;
}



/******************************************************************************/
/*
 *  Add a contour label to the contour label geometry object.
 *
 */


void	contour_out_labl (dist_test)

float	dist_test;
{
    register float	dx, dy;
    FLOAT3		pt_label, line[2];

    if (cont_labl_obj != GEOM_NULL)
    {
        if (cont_labl_str[0] != '\0')
        {
            dx              = cont_xyz[0] - cont_prev[0];
            dy              = cont_xyz[1] - cont_prev[1];
            cont_labl_dist += sqrt ((double) ((dx * dx) + (dy * dy)));
            if (cont_labl_dist >= dist_test)
            {
                cont_labl_made = TRUE;
                cont_labl_dist = 0.0;

                UTILS_float3_copy (cont_xyz, pt_label);
                UTILS_float3_add  (pt_label, cont_labl_offs);

                GEOMadd_label (cont_labl_obj, cont_labl_str, pt_label,
                               cont_labl_adj, cont_labl_ht, cont_labl_pclr,
                               cont_labl_flags);

                if (cont_pins_obj != GEOM_NULL)
                {
                    UTILS_float3_copy (cont_xyz, &line[0][0]);
                    UTILS_float3_copy (pt_label, &line[1][0]);

                    GEOMadd_disjoint_line (cont_pins_obj, line, cont_labl_pclr,
                                           2, GEOM_COPY_DATA);
                }
            }
        }
    }

    return ;
}



/******************************************************************************/
/*
 *  Convert contour xy to physical xyz.
 *
 */


void	contour_out_conv (x, y)

float		x, y;
{

    x--, y--;		/* Coords from FORTRAN are 1-based */

    cont_xyz[0] = x, cont_xyz[1] = y;

    UTILS_field_pt_xy_to_xyz (cont_xyz);

    cont_xyz[2] *= cont_zfac;

    cont_xyz[0] += cont_offs[0];
    cont_xyz[1] += cont_offs[1];
    cont_xyz[2] += cont_offs[2];


    return ;
}



/******************************************************************************/
/*
 *  Check a value to see if it is an integer multiple of an interval.
 *
 */


int	contour_out_isint (p_x, p_xint)

float	*p_x, *p_xint;
{
    static float		fuzz = 1.0e-05;

    float	x, xx, xint, diff;

    diff = 0.0;

    if (*p_xint != 0.0)
    {
        x = *p_x, xint = *p_xint;

        xx = x / xint;
        xx = (xx < 0.0) ? xx - 0.5 : (xx > 0.0) ? xx + 0.5 : xx;
        xx = ((float) ((int) xx)) * xint;

        diff  = (xx > x) ? xx - x : x - xx;
        diff /= xint;

        *p_x = xx;
    }


    return (diff < fuzz);
}
