/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

AUTHOR : Stardent Computer, Inc.
******************************************************************************/
/*
 * contour to geom - finds contours in 2 and three dimensions and generates geometries
 * 
 * AUTHOR: 	anonymous
 * COMPANY:	Stardent Computers Inc. (617)-964-1000
 * EMAIL:	avsmods@stardent.com
 *
 */

#include <stdio.h>
#include <math.h>
#include <avs/flow.h>
#include <avs/field.h>
#include <avs/geomdata.h>

static float	*point_list;
static int	num_vertex = 0;

contour_body(input,geom,threshold)
AVSfield_char	*input;
GEOMedit_list	*geom;
int		threshold;
{ int		width, height;
  float		*buffer;
  GEOMobj	*obj;
  float		extent[6];
  int		nslices;
  int		npoints;
  int		i;
  float		*x_ptr, *y_ptr, *z_ptr;

  if(input->ndim!=2 && input->ndim!=3)
    return 0;

  if(input->uniform!=UNIFORM && input->uniform!=IRREGULAR)
    return 0;

  width = MAXX(input);
  height = MAXY(input);
  if(input->ndim == 3)
    nslices = MAXZ(input);
  else
    nslices = 1;

  /* Try and guess the maximum number of points */
  npoints = 1048576;

  buffer = (float *)malloc(width*height*sizeof(float));
  point_list = (float *)malloc(npoints*3*sizeof(float));

  *geom = GEOMinit_edit_list(*geom);

  if(input->uniform == UNIFORM)
  {
      num_vertex = 0;
      for(i=0;i<nslices;i++)
      {   unpack(buffer,&input->data[i*width*height],(float)threshold,width*height);
	  contour(buffer,width,height,(float)i);
      }
      extent[0] = extent[2] = extent[4] = 0.0;
      extent[1] = MAXX(input);
      extent[3] = MAXY(input);
      extent[5] = nslices;
      obj = GEOMcreate_obj(GEOM_POLYTRI,extent);
  }
  else
  {
      num_vertex = 0;
      for(i=0;i<nslices;i++)
      {   unpack(buffer,&input->data[i*width*height],(float)threshold,width*height);
	  x_ptr = input->points + i*width*height;
	  y_ptr = input->points + i*width*height +   width*height*nslices;
	  z_ptr = input->points + i*width*height + 2*width*height*nslices;
	  irregular_contour(buffer,width,height,x_ptr,y_ptr,z_ptr);
      }
      obj = GEOMcreate_obj(GEOM_POLYTRI,NULL);
  }

  printf("%d vertices\n",num_vertex);
  GEOMadd_disjoint_line(obj,point_list,NULL,num_vertex,GEOM_COPY_DATA);
  if(input->uniform == UNIFORM)
    GEOMauto_transform(obj);
  GEOMedit_geometry(*geom,"contour",obj);
  GEOMdestroy_obj(obj);

}

/**** Specifications ****/
contour_spec()
{ int	in_port, out_port;

  AVSset_module_name("contour to geom",MODULE_MAPPER);
  AVScreate_input_port("Input","field scalar byte",REQUIRED);
  AVScreate_output_port("Output","geom",REQUIRED);
  AVSadd_parameter("threshold","integer",128,0,255);
  AVSset_compute_proc(contour_body);
}


int ((*module_list[])()) = { contour_spec };
AVSinit_modules() { AVSinit_from_module_list(module_list, sizeof(module_list)/sizeof(module_list[0])); }

/**** Utilities ****/
unpack(dst,src,threshold,n)
float		dst[];
unsigned char	src[];
float		threshold;
int		n;
{ int	i;

  for(i=0;i<n;i++)
    dst[i] = (float)(src[i]) - threshold;
}

#define DATA(x,y) data[(y)*width+(x)]

#define LL 1
#define LR 2
#define UL 4
#define UR 8

#define AddPoint(x,y) point_list[3*num_vertex+0] = x; point_list[3*num_vertex+1] = y; point_list[3*num_vertex+2] = z; num_vertex++;

int
contour(data,width,height,z)
float	data[];
int	width;
int	height;
float	z;
{   int		mask;
    int		i, j;
    float	x, y, t0, t1;

    for(j=0;j<height-1;j++)
    {   for(i=0;i<width-1;i++)
	{   mask = 0;
	    if(DATA(i  ,j  ) > 0.0)
	      mask |= LL;
	    if(DATA(i+1,j  ) > 0.0)
	      mask |= LR;
	    if(DATA(i  ,j+1) > 0.0)
	      mask |= UL;
	    if(DATA(i+1,j+1) > 0.0)
	      mask |= UR;

	    if( (mask==0) || (mask==(LL|UL|LR|UR)) )
	      continue;
	      
	    x = i;
	    y = j;
	    switch(mask)
	    {
	      case LL:
		t0 =  DATA(i  ,j  )/(DATA(i  ,j  )-DATA(i+1,j  ));
		t1 =  DATA(i  ,j  )/(DATA(i  ,j  )-DATA(i  ,j+1));
		AddPoint(x+t0 ,y   );
		AddPoint(x    ,y+t1);
		break;
	      case       LR:
		t0 = -DATA(i  ,j  )/(DATA(i+1,j  )-DATA(i  ,j  ));
		t1 =  DATA(i+1,j  )/(DATA(i+1,j  )-DATA(i+1,j+1));
		AddPoint(x+t0 ,y);
		AddPoint(x+1.0,y+t1);
		break;
	      case            UL:
		t0 =  DATA(i  ,j+1)/(DATA(i  ,j+1)-DATA(i+1,j+1));
		t1 = -DATA(i  ,j  )/(DATA(i  ,j+1)-DATA(i  ,j  ));
		AddPoint(x+t0 ,y+1.0);
		AddPoint(x    ,y+t1);
		break;
	      case                 UR:
		t0 = -DATA(i  ,j+1)/(DATA(i+1,j+1)-DATA(i  ,j+1));
		t1 = -DATA(i+1,j  )/(DATA(i+1,j+1)-DATA(i+1,j  ));
		AddPoint(x+t0 ,y+1.0);
		AddPoint(x+1.0,y+t1);
		break;
	      case (LL | LR):
		t0 = -DATA(i  ,j  )/(DATA(i  ,j+1)-DATA(i  ,j  ));
		t1 = -DATA(i+1,j  )/(DATA(i+1,j+1)-DATA(i+1,j  ));
		AddPoint(x    ,y+t0);
		AddPoint(x+1.0,y+t1);
		break;
	      case (LL |      UL):
		t0 =  DATA(i  ,j  )/(DATA(i  ,j  )-DATA(i+1,j  ));
		t1 =  DATA(i  ,j+1)/(DATA(i  ,j+1)-DATA(i+1,j+1));
		AddPoint(x+t0,y    );
		AddPoint(x+t1,y+1.0);
		break;
	      case (LL |           UR):
		t0 =  DATA(i  ,j  )/(DATA(i  ,j  )-DATA(i+1,j  ));
		t1 =  DATA(i+1,j  )/(DATA(i+1,j  )-DATA(i+1,j+1)); /* Was -, Ham found it */
		AddPoint(x+t0 ,y   );
		AddPoint(x+1.0,y+t1);
		t0 =  DATA(i  ,j  )/(DATA(i  ,j  )-DATA(i  ,j+1));
		t1 = -DATA(i  ,j+1)/(DATA(i+1,j+1)-DATA(i  ,j+1));
		AddPoint(x   ,y+t0);
		AddPoint(x+t1,y+1.0);
		break;
	      case (     LR | UL):
		t0 = -DATA(i  ,j  )/(DATA(i+1,j  )-DATA(i  ,j  ));
		t1 =  DATA(i+1,j  )/(DATA(i+1,j  )-DATA(i+1,j+1));
		AddPoint(x+t0 ,y);
		AddPoint(x+1.0,y+t1);
		t0 = -DATA(i  ,j  )/(DATA(i  ,j+1)-DATA(i  ,j  ));
		t1 =  DATA(i  ,j+1)/(DATA(i  ,j+1)-DATA(i+1,j+1));
		AddPoint(x   ,y+t0);
		AddPoint(x+t1,y+1.0);
		break;
	      case (     LR |      UR):
		t0 = -DATA(i  ,j  )/(DATA(i+1,j  )-DATA(i  ,j  ));
		t1 = -DATA(i  ,j+1)/(DATA(i+1,j+1)-DATA(i  ,j+1));
		AddPoint(x+t0,y    );
		AddPoint(x+t1,y+1.0);
		break;
	      case (          UL | UR):
		t0 = -DATA(i  ,j  )/(DATA(i  ,j+1)-DATA(i  ,j  ));
		t1 = -DATA(i+1,j  )/(DATA(i+1,j+1)-DATA(i+1,j  ));
		AddPoint(x    ,y+t0);
		AddPoint(x+1.0,y+t1);
		break;
	      case (LL | LR | UL):
		t0 =  DATA(i  ,j+1)/(DATA(i  ,j+1)-DATA(i+1,j+1));
		t1 =  DATA(i+1,j  )/(DATA(i+1,j  )-DATA(i+1,j+1));
		AddPoint(x+t0 ,y+1.0);
		AddPoint(x+1.0,y+t1);
		break;
	      case (LL | LR |      UR):
		t0 =  DATA(i  ,j  )/(DATA(i  ,j  )-DATA(i  ,j+1));
		t1 = -DATA(i  ,j+1)/(DATA(i+1,j+1)-DATA(i  ,j+1));
		AddPoint(x   ,y+t0);
		AddPoint(x+t1,y+1.0);
		break;
	      case (LL |      UL | UR):
		t0 =  DATA(i  ,j  )/(DATA(i  ,j  )-DATA(i+1,j  ));
		t1 = -DATA(i+1,j  )/(DATA(i+1,j+1)-DATA(i+1,j  ));
		AddPoint(x+t0 ,y);
		AddPoint(x+1.0,y+t1);
		break;
	      case (     LR | UL | UR):
		t0 = -DATA(i  ,j  )/(DATA(i+1,j  )-DATA(i  ,j  ));
		t1 = -DATA(i  ,j  )/(DATA(i  ,j+1)-DATA(i  ,j  ));
		AddPoint(x+t0,y);
		AddPoint(x   ,y+t1);
		break;
	    }
	}
    }
    return 1;
}

#define AddPoint3(x,y,z) \
point_list[3*num_vertex+0] = x; \
point_list[3*num_vertex+1] = y; \
point_list[3*num_vertex+2] = z; \
num_vertex++;

#define X(i,j) x_lst[(j)*width+(i)]
#define Y(i,j) y_lst[(j)*width+(i)]
#define Z(i,j) z_lst[(j)*width+(i)]

int
irregular_contour(data,width,height,x_lst,y_lst,z_lst)
float	data[];
int	width;
int	height;
float	x_lst[];
float	y_lst[];
float	z_lst[];
{   int		mask;
    int		i, j;
    float	x0, x1, y0, y1, z0, z1, t0, t1;

    for(j=0;j<height-1;j++)
    {   for(i=0;i<width-1;i++)
	{   mask = 0;
	    if(DATA(i  ,j  ) > 0.0)
	      mask |= LL;
	    if(DATA(i+1,j  ) > 0.0)
	      mask |= LR;
	    if(DATA(i  ,j+1) > 0.0)
	      mask |= UL;
	    if(DATA(i+1,j+1) > 0.0)
	      mask |= UR;

	    if( (mask==0) || (mask==(LL|UL|LR|UR)) )
	      continue;
	      
	    switch(mask)
	    {
	      case LL:
		t0 =  DATA(i  ,j  )/(DATA(i  ,j  )-DATA(i+1,j  ));
		t1 =  DATA(i  ,j  )/(DATA(i  ,j  )-DATA(i  ,j+1));
		x0 = (1.0-t0)*X(i  ,j  ) + t0*X(i+1,j  );
		y0 = (1.0-t0)*Y(i  ,j  ) + t0*Y(i+1,j  );
		z0 = (1.0-t0)*Z(i  ,j  ) + t0*Z(i+1,j  );
		x1 = (1.0-t1)*X(i  ,j  ) + t1*X(i  ,j+1);
		y1 = (1.0-t1)*Y(i  ,j  ) + t1*Y(i  ,j+1);
		z1 = (1.0-t1)*Z(i  ,j  ) + t1*Z(i  ,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		break;
	      case       LR:
		t0 = -DATA(i  ,j  )/(DATA(i+1,j  )-DATA(i  ,j  ));
		t1 =  DATA(i+1,j  )/(DATA(i+1,j  )-DATA(i+1,j+1));
		x0 = (1.0-t0)*X(i  ,j  ) + t0*X(i+1,j  );
		y0 = (1.0-t0)*Y(i  ,j  ) + t0*Y(i+1,j  );
		z0 = (1.0-t0)*Z(i  ,j  ) + t0*Z(i+1,j  );
		x1 = (1.0-t1)*X(i+1,j  ) + t1*X(i+1,j+1);
		y1 = (1.0-t1)*Y(i+1,j  ) + t1*Y(i+1,j+1);
		z1 = (1.0-t1)*Z(i+1,j  ) + t1*Z(i+1,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		break;
	      case            UL:
		t0 =  DATA(i  ,j+1)/(DATA(i  ,j+1)-DATA(i+1,j+1));
		t1 = -DATA(i  ,j  )/(DATA(i  ,j+1)-DATA(i  ,j  ));
		x0 = (1.0-t0)*X(i  ,j+1) + t0*X(i+1,j+1);
		y0 = (1.0-t0)*Y(i  ,j+1) + t0*Y(i+1,j+1);
		z0 = (1.0-t0)*Z(i  ,j+1) + t0*Z(i+1,j+1);
		x1 = (1.0-t1)*X(i  ,j  ) + t1*X(i  ,j+1);
		y1 = (1.0-t1)*Y(i  ,j  ) + t1*Y(i  ,j+1);
		z1 = (1.0-t1)*Z(i  ,j  ) + t1*Z(i  ,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		break;
	      case                 UR:
		t0 = -DATA(i  ,j+1)/(DATA(i+1,j+1)-DATA(i  ,j+1));
		t1 = -DATA(i+1,j  )/(DATA(i+1,j+1)-DATA(i+1,j  ));
		x0 = (1.0-t0)*X(i  ,j+1) + t0*X(i+1,j+1);
		y0 = (1.0-t0)*Y(i  ,j+1) + t0*Y(i+1,j+1);
		z0 = (1.0-t0)*Z(i  ,j+1) + t0*Z(i+1,j+1);
		x1 = (1.0-t1)*X(i+1,j  ) + t1*X(i+1,j+1);
		y1 = (1.0-t1)*Y(i+1,j  ) + t1*Y(i+1,j+1);
		z1 = (1.0-t1)*Z(i+1,j  ) + t1*Z(i+1,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		break;
	      case (LL | LR):
		t0 = -DATA(i  ,j  )/(DATA(i  ,j+1)-DATA(i  ,j  ));
		t1 = -DATA(i+1,j  )/(DATA(i+1,j+1)-DATA(i+1,j  ));
		x0 = (1.0-t0)*X(i  ,j  ) + t0*X(i  ,j+1);
		y0 = (1.0-t0)*Y(i  ,j  ) + t0*Y(i  ,j+1);
		z0 = (1.0-t0)*Z(i  ,j  ) + t0*Z(i  ,j+1);
		x1 = (1.0-t1)*X(i+1,j  ) + t1*X(i+1,j+1);
		y1 = (1.0-t1)*Y(i+1,j  ) + t1*Y(i+1,j+1);
		z1 = (1.0-t1)*Z(i+1,j  ) + t1*Z(i+1,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		break;
	      case (LL |      UL):
		t0 =  DATA(i  ,j  )/(DATA(i  ,j  )-DATA(i+1,j  ));
		t1 =  DATA(i  ,j+1)/(DATA(i  ,j+1)-DATA(i+1,j+1));
		x0 = (1.0-t0)*X(i  ,j  ) + t0*X(i+1,j  );
		y0 = (1.0-t0)*Y(i  ,j  ) + t0*Y(i+1,j  );
		z0 = (1.0-t0)*Z(i  ,j  ) + t0*Z(i+1,j  );
		x1 = (1.0-t1)*X(i  ,j+1) + t1*X(i+1,j+1);
		y1 = (1.0-t1)*Y(i  ,j+1) + t1*Y(i+1,j+1);
		z1 = (1.0-t1)*Z(i  ,j+1) + t1*Z(i+1,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		break;
	      case (LL |           UR):
		t0 =  DATA(i  ,j  )/(DATA(i  ,j  )-DATA(i+1,j  ));
		t1 =  DATA(i+1,j  )/(DATA(i+1,j  )-DATA(i+1,j+1));
		x0 = (1.0-t0)*X(i  ,j  ) + t0*X(i+1,j  );
		y0 = (1.0-t0)*Y(i  ,j  ) + t0*Y(i+1,j  );
		z0 = (1.0-t0)*Z(i  ,j  ) + t0*Z(i+1,j  );
		x1 = (1.0-t1)*X(i+1,j  ) + t1*X(i+1,j+1);
		y1 = (1.0-t1)*Y(i+1,j  ) + t1*Y(i+1,j+1);
		z1 = (1.0-t1)*Z(i+1,j  ) + t1*Z(i+1,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		t0 =  DATA(i  ,j  )/(DATA(i  ,j  )-DATA(i  ,j+1));
		t1 = -DATA(i  ,j+1)/(DATA(i+1,j+1)-DATA(i  ,j+1));
		x0 = (1.0-t0)*X(i  ,j  ) + t0*X(i  ,j+1);
		y0 = (1.0-t0)*Y(i  ,j  ) + t0*Y(i  ,j+1);
		z0 = (1.0-t0)*Z(i  ,j  ) + t0*Z(i  ,j+1);
		x1 = (1.0-t1)*X(i  ,j+1) + t1*X(i+1,j+1);
		y1 = (1.0-t1)*Y(i  ,j+1) + t1*Y(i+1,j+1);
		z1 = (1.0-t1)*Z(i  ,j+1) + t1*Z(i+1,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		break;
	      case (     LR | UL):
		t0 = -DATA(i  ,j  )/(DATA(i+1,j  )-DATA(i  ,j  ));
		t1 =  DATA(i+1,j  )/(DATA(i+1,j  )-DATA(i+1,j+1));
		x0 = (1.0-t0)*X(i  ,j  ) + t0*X(i+1,j  );
		y0 = (1.0-t0)*Y(i  ,j  ) + t0*Y(i+1,j  );
		z0 = (1.0-t0)*Z(i  ,j  ) + t0*Z(i+1,j  );
		x1 = (1.0-t1)*X(i+1,j  ) + t1*X(i+1,j+1);
		y1 = (1.0-t1)*Y(i+1,j  ) + t1*Y(i+1,j+1);
		z1 = (1.0-t1)*Z(i+1,j  ) + t1*Z(i+1,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		t0 = -DATA(i  ,j  )/(DATA(i  ,j+1)-DATA(i  ,j  ));
		t1 =  DATA(i  ,j+1)/(DATA(i  ,j+1)-DATA(i+1,j+1));
		x0 = (1.0-t0)*X(i  ,j  ) + t0*X(i  ,j+1);
		y0 = (1.0-t0)*Y(i  ,j  ) + t0*Y(i  ,j+1);
		z0 = (1.0-t0)*Z(i  ,j  ) + t0*Z(i  ,j+1);
		x1 = (1.0-t1)*X(i  ,j+1) + t1*X(i+1,j+1);
		y1 = (1.0-t1)*Y(i  ,j+1) + t1*Y(i+1,j+1);
		z1 = (1.0-t1)*Z(i  ,j+1) + t1*Z(i+1,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		break;
	      case (     LR |      UR):
		t0 = -DATA(i  ,j  )/(DATA(i+1,j  )-DATA(i  ,j  ));
		t1 = -DATA(i  ,j+1)/(DATA(i+1,j+1)-DATA(i  ,j+1));
		x0 = (1.0-t0)*X(i  ,j  ) + t0*X(i+1,j  );
		y0 = (1.0-t0)*Y(i  ,j  ) + t0*Y(i+1,j  );
		z0 = (1.0-t0)*Z(i  ,j  ) + t0*Z(i+1,j  );
		x1 = (1.0-t1)*X(i  ,j+1) + t1*X(i+1,j+1);
		y1 = (1.0-t1)*Y(i  ,j+1) + t1*Y(i+1,j+1);
		z1 = (1.0-t1)*Z(i  ,j+1) + t1*Z(i+1,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		break;
	      case (          UL | UR):
		t0 = -DATA(i  ,j  )/(DATA(i  ,j+1)-DATA(i  ,j  ));
		t1 = -DATA(i+1,j  )/(DATA(i+1,j+1)-DATA(i+1,j  ));
		x0 = (1.0-t0)*X(i  ,j  ) + t0*X(i  ,j+1);
		y0 = (1.0-t0)*Y(i  ,j  ) + t0*Y(i  ,j+1);
		z0 = (1.0-t0)*Z(i  ,j  ) + t0*Z(i  ,j+1);
		x1 = (1.0-t1)*X(i+1,j  ) + t1*X(i+1,j+1);
		y1 = (1.0-t1)*Y(i+1,j  ) + t1*Y(i+1,j+1);
		z1 = (1.0-t1)*Z(i+1,j  ) + t1*Z(i+1,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		break;
	      case (LL | LR | UL):
		t0 =  DATA(i  ,j+1)/(DATA(i  ,j+1)-DATA(i+1,j+1));
		t1 =  DATA(i+1,j  )/(DATA(i+1,j  )-DATA(i+1,j+1));
		x0 = (1.0-t0)*X(i  ,j+1) + t0*X(i+1,j+1);
		y0 = (1.0-t0)*Y(i  ,j+1) + t0*Y(i+1,j+1);
		z0 = (1.0-t0)*Z(i  ,j+1) + t0*Z(i+1,j+1);
		x1 = (1.0-t1)*X(i+1,j  ) + t1*X(i+1,j+1);
		y1 = (1.0-t1)*Y(i+1,j  ) + t1*Y(i+1,j+1);
		z1 = (1.0-t1)*Z(i+1,j  ) + t1*Z(i+1,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		break;
	      case (LL | LR |      UR):
		t0 =  DATA(i  ,j  )/(DATA(i  ,j  )-DATA(i  ,j+1));
		t1 = -DATA(i  ,j+1)/(DATA(i+1,j+1)-DATA(i  ,j+1));
		x0 = (1.0-t0)*X(i  ,j  ) + t0*X(i  ,j+1);
		y0 = (1.0-t0)*Y(i  ,j  ) + t0*Y(i  ,j+1);
		z0 = (1.0-t0)*Z(i  ,j  ) + t0*Z(i  ,j+1);
		x1 = (1.0-t1)*X(i  ,j+1) + t1*X(i+1,j+1);
		y1 = (1.0-t1)*Y(i  ,j+1) + t1*Y(i+1,j+1);
		z1 = (1.0-t1)*Z(i  ,j+1) + t1*Z(i+1,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		break;
	      case (LL |      UL | UR):
		t0 =  DATA(i  ,j  )/(DATA(i  ,j  )-DATA(i+1,j  ));
		t1 = -DATA(i+1,j  )/(DATA(i+1,j+1)-DATA(i+1,j  ));
		x0 = (1.0-t0)*X(i  ,j  ) + t0*X(i+1,j  );
		y0 = (1.0-t0)*Y(i  ,j  ) + t0*Y(i+1,j  );
		z0 = (1.0-t0)*Z(i  ,j  ) + t0*Z(i+1,j  );
		x1 = (1.0-t1)*X(i+1,j  ) + t1*X(i+1,j+1);
		y1 = (1.0-t1)*Y(i+1,j  ) + t1*Y(i+1,j+1);
		z1 = (1.0-t1)*Z(i+1,j  ) + t1*Z(i+1,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		break;
	      case (     LR | UL | UR):
		t0 = -DATA(i  ,j  )/(DATA(i+1,j  )-DATA(i  ,j  ));
		t1 = -DATA(i  ,j  )/(DATA(i  ,j+1)-DATA(i  ,j  ));
		x0 = (1.0-t0)*X(i  ,j  ) + t0*X(i+1,j  );
		y0 = (1.0-t0)*Y(i  ,j  ) + t0*Y(i+1,j  );
		z0 = (1.0-t0)*Z(i  ,j  ) + t0*Z(i+1,j  );
		x1 = (1.0-t1)*X(i  ,j  ) + t1*X(i  ,j+1);
		y1 = (1.0-t1)*Y(i  ,j  ) + t1*Y(i  ,j+1);
		z1 = (1.0-t1)*Z(i  ,j  ) + t1*Z(i  ,j+1);
		AddPoint3(x0,y0,z0);
		AddPoint3(x1,y1,z1);
		break;
	    }
	}
    }
    return 1;
}


