/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>

#include <avs/colormap.h>
#include <avs/field.h>
#include <avs/flow.h>
#include <avs/geom.h>
#include <avs/geomdata.h>
#include <avs/vex.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>

#define max(a, b) ((a) > (b) ? (a) : (b))

extern int FlowVerbose;

/* Used for AVSmessage() */
static char file_version[] = "@(#)field2d to lines v1.1 01/04/92";

/*
 * version 1.1
 * date    01/04/92
 */

#define GAMMA 1.4

/*
 * Output lines with height for field with any type of grid
 *
 *   Input:
 *     - field, 2D, scalar, 3-space, float (REQUIRED)
 *
 *   Output:
 *     - geom
 */

fld2dlines()
{
 int field2d_to_lines_compute();
 int parm;

/* Set network editor module name */
 AVSset_module_name("field lines", MODULE_MAPPER);

/* Create input port */
 AVScreate_input_port("input field", "field 2D scalar 3-space float", REQUIRED);
/* Create output ports */
 AVScreate_output_port("field lines", "geom");
 AVScreate_output_port("field planes", "geom");

/* Dial for lines-height control */
 AVSadd_parameter("i", "boolean", 1, 0 , 1);
 AVSadd_parameter("j", "boolean", 1, 0 , 1);

 parm = AVSadd_float_parameter("line height", 1.0, 
                               FLOAT_UNBOUND, FLOAT_UNBOUND);
 AVSconnect_widget(parm, "dial");

 AVSset_compute_proc(field2d_to_lines_compute);
}

field2d_to_lines_compute(InFld, OutGeom, OutGeom2, ichoice, jchoice, MeshHeight)
AVSfield_float *InFld;
GEOMedit_list  *OutGeom, *OutGeom2;
int            ichoice, jchoice;
float          *MeshHeight;
{
  GEOMobj        *LineObj;
  GEOMobj        *PlaneObj;
  int            *FldDims;
  int            i, j, k, l;
  int            imax, jmax, dimmax;
  int            done;
  float          *vert, color[3];
  float          *xg, *yg;

/* Take input field, determine dimensions */
  FldDims = InFld->dimensions;
  imax = FldDims[0];
  jmax = FldDims[1];
  dimmax = max(imax, jmax);

  *OutGeom = GEOMinit_edit_list(*OutGeom);
  *OutGeom2 = GEOMinit_edit_list(*OutGeom2);

/* Allocate arrays */

  vert = (float *)ALLOC_LOCAL(2*3*dimmax*sizeof(float));
  if (InFld->uniform == UNIFORM) {
     xg = (float *)ALLOC_LOCAL(imax*sizeof(float));
     yg = (float *)ALLOC_LOCAL(jmax*sizeof(float));
     for (i=0; i<imax; i++) 
        xg[i] = (float) i;
     for (j=0; j<jmax; j++) 
        yg[j] = (float) j;
  }
  else {
     xg = InFld->points;
     yg = InFld->points+imax;
  }

/* Create the vertices for the mesh */
  if (ichoice) {
     for (i=0; i<imax; i++) {
        LineObj = GEOMcreate_obj(GEOM_POLYTRI,GEOM_NULL);
        k = 0;
        for (j=0; j<jmax; j++) {
           l = j*imax + i;
           vert[k++]   = xg[i];
           vert[k++] = yg[j];
           vert[k++] = *MeshHeight * InFld->data[l];
        }
        done = ((i+1)*50)/imax;
        AVSmodule_status("creating lines", done);

        GEOMadd_polyline(LineObj,vert,GEOM_NULL,jmax,GEOM_COPY_DATA);
        GEOMedit_geometry(*OutGeom, "lines", LineObj);
        GEOMdestroy_obj(LineObj);

        for (j=0; j<jmax; j++) {
           vert[k++] = xg[i];
           vert[k++] = yg[j];
           vert[k++] = 0;
        }
        PlaneObj = GEOMcreate_mesh(GEOM_NULL, vert, jmax, 2, GEOM_COPY_DATA);
        GEOMcvt_mesh_to_polytri(PlaneObj, GEOM_SURFACE|GEOM_WIREFRAME);
        GEOMedit_geometry(*OutGeom2, "planes", PlaneObj);
        GEOMdestroy_obj(PlaneObj);
     }
  }

  if (jchoice) {
     for (j=0; j<jmax; j++) {
        LineObj = GEOMcreate_obj(GEOM_POLYTRI,GEOM_NULL);
        k=0;
        for (i=0; i<imax; i++) {
           l = j*imax + i;
           vert[k++]   = xg[i];
           vert[k++] = yg[j];
           vert[k++] = *MeshHeight * InFld->data[l];
        }
        done = 50 + ((j+1)*50)/jmax;
        AVSmodule_status("creating lines", done);

        GEOMadd_polyline(LineObj,vert,GEOM_NULL,imax,GEOM_COPY_DATA);
        GEOMedit_geometry(*OutGeom, "lines", LineObj);
        GEOMdestroy_obj(LineObj);

        for (i=0; i<imax; i++) {
           vert[k++] = xg[i];
           vert[k++] = yg[j];
           vert[k++] = 0;
        }
        PlaneObj = GEOMcreate_mesh(GEOM_NULL, vert, imax, 2, GEOM_COPY_DATA);
        GEOMcvt_mesh_to_polytri(PlaneObj, GEOM_SURFACE|GEOM_WIREFRAME);
        GEOMedit_geometry(*OutGeom2, "planes", PlaneObj);
        GEOMdestroy_obj(PlaneObj);
     }
  }

  color[0]=0.;
  color[1]=0.;
  color[2]=0.;
  GEOMedit_color(*OutGeom, "lines", color);
  GEOMedit_render_mode(*OutGeom2, "planes", "no_light");

/*  free local data  */
  FREE_LOCAL(vert);
  if (InFld->uniform == UNIFORM) {
     FREE_LOCAL(xg);
     FREE_LOCAL(yg);
  }

  return(1);
}

int ((*data_mod_list[])()) = {
  fld2dlines,
};

#define NMODS sizeof(data_mod_list) / sizeof(char *) 

AVSinit_modules()
{
  AVSinit_from_module_list(data_mod_list, NMODS);
}

