/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/* mod_gen Version 1                                                     */
/* Module Name: "field params" (Mapper) (Subroutine)                       */
/* Author: John Tee                                                      */
/* Date Created: Mon Sep 28 20:04:21 1992                                */
/*                                                                       */
/* Provide basic field statistics (minimum, maximum) as floating point */
/* output parameters. Intended for use with threshold, generate colormap etc */
/* Each output parameter has a scaling parameter associated with it */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
 
/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int field_params_desc()
{

	int in_port, out_port, param;
	extern int field_params_compute();

	AVSset_module_name("field params", MODULE_MAPPER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("Input", "field", REQUIRED);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("X size", "integer");
	out_port = AVScreate_output_port("Y size", "integer");
        out_port = AVScreate_output_port("Min", "real");
        out_port = AVScreate_output_port("Max", "real");

	/* Parameter Specifications                */
	param = AVSadd_float_parameter("X scale", 1.00000, 0.00000, 1.00000);
	AVSconnect_widget(param, "dial");
	param = AVSadd_float_parameter("Y scale", 1.00000, 0.00000, 1.00000);
	AVSconnect_widget(param, "dial");
        param = AVSadd_float_parameter("Min scale", 1.00000, 0.00000, 2.00000);
        AVSconnect_widget(param, "dial");
        param = AVSadd_float_parameter("Max scale", 1.00000, 0.00000, 2.00000);
        AVSconnect_widget(param, "dial");

	AVSset_compute_proc(field_params_compute);
/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int field_params_compute( Input, X_size, Y_size, Min, Max,
                          X_scale, Y_scale, Min_scale, Max_scale)
	AVSfield *Input;
	int *X_size;
	int *Y_size;
        float **Min;
        float **Max;
	float *X_scale;
	float *Y_scale;
        float *Min_scale;
        float *Max_scale;
{
/* ----> START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */
	int i, status, dims[10], size;
        float minval, maxval, meanval;

/* let output parameters default to 1 if field is 2_D or 1_D */
	for (i=0; i<10; i++) dims[i] = 1;

	status = AVSfield_get_dimensions(Input, dims);
        if ((status == 1) && AVSinput_changed("Input",0)) {
           for (i=0, size=1; i<10; i++) size *= dims[i];
	   *X_size = dims[0] * *X_scale;
	   *Y_size = dims[1] * *Y_scale;
          switch(Input->type) {
           case AVS_TYPE_REAL:
              get_stats_real(Input, size, &minval, &maxval, &meanval);
              break;
           case AVS_TYPE_INTEGER:
              get_stats_int(Input, size, &minval, &maxval, &meanval);
              break;
           default:
              return(0);
              break;
           }
	}

        if (*Min) FREE_LOCAL( *Min );
        if (*Max) FREE_LOCAL( *Max );
        *Min = (float *)ALLOC_LOCAL(sizeof(float));
        *Max = (float *)ALLOC_LOCAL(sizeof(float));

        **Min = minval * *Min_scale;
        **Max = maxval * *Max_scale;

/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	field_params_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/
        get_stats_real(input,size,min,max,mean)
        AVSfield_float *input;
        int     size;
        float   *min, *max, *mean;
{
        int     i;
        float   total;

        if (size <= 1)
           return;

        total = 0.0;
        *min = *max = input->data[0];
        for (i=0; i<size; i++) {
           total += input->data[i];
           if (input->data[i] < *min)   *min = input->data[i];
           else if (input->data[i] > *max)  *max = input->data[i];
        }
        *mean = total/(float)size;
}
        get_stats_int(input,size,min,max,mean)
        AVSfield_int *input;
        int     size;
        float   *min, *max, *mean;
{
        int     i;
        float   total;

        if (size <= 1)
           return;

        total = 0.0;
        *min = *max = input->data[0];
        for (i=0; i<size; i++) {
           total += input->data[i];
           if (input->data[i] < *min)   *min = input->data[i];
           else if (input->data[i] > *max)  *max = input->data[i];
        }
        *mean = total/(float)size;
}

/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */
