/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <string.h>
#include <avs/flow.h>
#include <avs/avs_data.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/colormap.h>

/* 
 * This is a C program to print out the mapping mesh at any i, j, or k level
 * selected by a combination of switches and a level slider
 *
 *  copyright 1991 by Michael J. Rangitsch   u35018@u2.ncsa.uiuc.edu
 *                                           (504) 389-1752
 *
 *     revision history:
 *  
 *          12/4/91  initial version
 */

/* 
 * The function AVSinit_modules is called from the main() routine supplied
 * by AVS.  In it, we call AVSmodule_from_desc with the name of our 
 * description routine.
 */

AVSinit_modules()
{
	void grid_mesh();

	AVSmodule_from_desc(grid_mesh);
}

/*  
 * The routine "grid_mesh" is the description routine.  It provides
 * AVS some necessary information such as: name, input and output ports, 
 * parameters etc. 
 */
grid_mesh()
{
	int grid_mesh_compute();	/* declare the compute function (below) */
	int out_port,in_port;	/* temporaries to hold the port numbers */
        int param1,param2,param3;  /* temporaries to hold the parameter indices */

	/* Set the module name and type */
	AVSset_module_name("grid mesh", MODULE_MAPPER);

	/* Create a colormap input port */
        in_port=AVScreate_input_port("data set","field 3D",REQUIRED);

	/* Create an output port for the result */
	out_port = AVScreate_output_port(/*name*/ "Geometry", /*type*/"geom");

        /* Create a parameter for the plane choice */
        param1=AVSadd_parameter("Plane choice","choice","NONE",
	                                       "NONE!I!J!K","!");
        AVSconnect_widget(param1,"radio_buttons");

        /* Create a parameter for the plane number */
        param2 = AVSadd_parameter("Plane number","integer",0,0,50);
        /* Create a text input widget for the text string */
        AVSconnect_widget(param2,"islider"); 

        /* Create a parameter for drawing the grid rather than the outline */
        param3 = AVSadd_parameter("Draw Mesh","boolean",0,0,0);
        /* Create a text input widget for the text string */
        AVSconnect_widget(param3,"toggle"); 

	/* Tell avs what subroutine to call to do the compute */
	AVSset_compute_proc(grid_mesh_compute);
}

/*
 * grid_mesh_compute is the compute routine.  The arguments are: the 
 * input field, output geometry (passed by reference), the plane index choice
 * and the plane number
 */

typedef float FLOAT3[3];

grid_mesh_compute(input_field, output, plane_choice, plane_number, draw_mesh)

AVSfield_float *input_field;
GEOMedit_list *output;
char *plane_choice;
int plane_number;
int draw_mesh;


{
   int i, j, k, ni, nj, nk, new_maximum;
   char choice;

   FLOAT3 verts[2];

   GEOMobj *obj = NULL;

  /* Pick off the first character in the plane choice array */

   choice = plane_choice[0];


  /* Create our GEOM object to add polygons to */

   if (obj) GEOMdestroy_obj(obj);

   obj = GEOMcreate_obj(GEOM_POLYTRI,NULL);

   /* set up the case based on the i, j or k direction specification */

   ni = MAXX(input_field)-1;
   nj = MAXY(input_field)-1;
   nk = MAXZ(input_field)-1;

   switch( choice )
   {
     case 'N' :      /*  no grid specified */
        new_maximum = 50;
	break;
     case 'I' :      /*  grid in the i direction */
        new_maximum = MAXX(input_field) - 1;   /* reset the maximum plane numbe
r */
	plane_number = (new_maximum < plane_number) ? new_maximum : plane_number;
	if(draw_mesh == 0)     /* draw the mesh, if asked */
	{
	    for(j = 0; j < MAXY(input_field) - 1; j++)
	      { 
	        verts[0][0] = COORD_X_3D(input_field,plane_number,j,0);
	        verts[0][1] = COORD_Y_3D(input_field,plane_number,j,0);
	        verts[0][2] = COORD_Z_3D(input_field,plane_number,j,0);

	        verts[1][0] = COORD_X_3D(input_field,plane_number,j+1,0);
	        verts[1][1] = COORD_Y_3D(input_field,plane_number,j+1,0);
	        verts[1][2] = COORD_Z_3D(input_field,plane_number,j+1,0);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      }

	    for(k = 0; k < MAXZ(input_field) - 1; k++)
              {
	        verts[0][0] = COORD_X_3D(input_field,plane_number,nj,k);
	        verts[0][1] = COORD_Y_3D(input_field,plane_number,nj,k);
	        verts[0][2] = COORD_Z_3D(input_field,plane_number,nj,k);

	        verts[1][0] = COORD_X_3D(input_field,plane_number,nj,k+1);
	        verts[1][1] = COORD_Y_3D(input_field,plane_number,nj,k+1);
	        verts[1][2] = COORD_Z_3D(input_field,plane_number,nj,k+1);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      }

	    for(j = 0; j < MAXY(input_field) - 1;  j++)
	      { 
	        verts[0][0] = COORD_X_3D(input_field,plane_number,j,nk);
	        verts[0][1] = COORD_Y_3D(input_field,plane_number,j,nk);
	        verts[0][2] = COORD_Z_3D(input_field,plane_number,j,nk);

	        verts[1][0] = COORD_X_3D(input_field,plane_number,j+1,nk);
	        verts[1][1] = COORD_Y_3D(input_field,plane_number,j+1,nk);
	        verts[1][2] = COORD_Z_3D(input_field,plane_number,j+1,nk);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      }

	    for(k = 0; k < MAXZ(input_field) - 1; k++)
              {
	        verts[0][0] = COORD_X_3D(input_field,plane_number,0,k);
	        verts[0][1] = COORD_Y_3D(input_field,plane_number,0,k);
	        verts[0][2] = COORD_Z_3D(input_field,plane_number,0,k);

	        verts[1][0] = COORD_X_3D(input_field,plane_number,0,k+1);
	        verts[1][1] = COORD_Y_3D(input_field,plane_number,0,k+1);
	        verts[1][2] = COORD_Z_3D(input_field,plane_number,0,k+1);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      } 
	}
	else
	{
	   for(k = 0; k < MAXZ(input_field); k++)
	    for(j = 0; j < MAXY(input_field) - 1; j++)
	      { 
	        verts[0][0] = COORD_X_3D(input_field,plane_number,j,k);
	        verts[0][1] = COORD_Y_3D(input_field,plane_number,j,k);
	        verts[0][2] = COORD_Z_3D(input_field,plane_number,j,k);

	        verts[1][0] = COORD_X_3D(input_field,plane_number,j+1,k);
	        verts[1][1] = COORD_Y_3D(input_field,plane_number,j+1,k);
	        verts[1][2] = COORD_Z_3D(input_field,plane_number,j+1,k);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      }

           for(j = 0; j < MAXY(input_field); j++)
	    for(k = 0; k < MAXZ(input_field) - 1; k++)
              {
	        verts[0][0] = COORD_X_3D(input_field,plane_number,j,k);
	        verts[0][1] = COORD_Y_3D(input_field,plane_number,j,k);
	        verts[0][2] = COORD_Z_3D(input_field,plane_number,j,k);

	        verts[1][0] = COORD_X_3D(input_field,plane_number,j,k+1);
	        verts[1][1] = COORD_Y_3D(input_field,plane_number,j,k+1);
	        verts[1][2] = COORD_Z_3D(input_field,plane_number,j,k+1);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      }
       	 }    
     	break;

     case 'J' :
        new_maximum = MAXY(input_field) - 1;
	plane_number = (new_maximum < plane_number) ? new_maximum : plane_number;
	if(draw_mesh == 0)
	{
	    for(i = 0; i < MAXX(input_field) - 1; i++)
	      { 
	        verts[0][0] = COORD_X_3D(input_field,i,plane_number,0);
	        verts[0][1] = COORD_Y_3D(input_field,i,plane_number,0);
	        verts[0][2] = COORD_Z_3D(input_field,i,plane_number,0);

	        verts[1][0] = COORD_X_3D(input_field,i+1,plane_number,0);
	        verts[1][1] = COORD_Y_3D(input_field,i+1,plane_number,0);
	        verts[1][2] = COORD_Z_3D(input_field,i+1,plane_number,0);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      }

	    for(k = 0; k < MAXZ(input_field) - 1; k++)
              {
	        verts[0][0] = COORD_X_3D(input_field,ni,plane_number,k);
	        verts[0][1] = COORD_Y_3D(input_field,ni,plane_number,k);
	        verts[0][2] = COORD_Z_3D(input_field,ni,plane_number,k);

	        verts[1][0] = COORD_X_3D(input_field,ni,plane_number,k+1);
	        verts[1][1] = COORD_Y_3D(input_field,ni,plane_number,k+1);
	        verts[1][2] = COORD_Z_3D(input_field,ni,plane_number,k+1);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      }

	    for(i = 0; i < MAXX(input_field) - 1;  i++)
	      { 
	        verts[0][0] = COORD_X_3D(input_field,i,plane_number,nk);
	        verts[0][1] = COORD_Y_3D(input_field,i,plane_number,nk);
	        verts[0][2] = COORD_Z_3D(input_field,i,plane_number,nk);

	        verts[1][0] = COORD_X_3D(input_field,i+1,plane_number,nk);
	        verts[1][1] = COORD_Y_3D(input_field,i+1,plane_number,nk);
	        verts[1][2] = COORD_Z_3D(input_field,i+1,plane_number,nk);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      }

	    for(k = 0; k < MAXZ(input_field) - 1; k++)
              {
	        verts[0][0] = COORD_X_3D(input_field,0,plane_number,k);
	        verts[0][1] = COORD_Y_3D(input_field,0,plane_number,k);
	        verts[0][2] = COORD_Z_3D(input_field,0,plane_number,k);

	        verts[1][0] = COORD_X_3D(input_field,0,plane_number,k+1);
	        verts[1][1] = COORD_Y_3D(input_field,0,plane_number,k+1);
	        verts[1][2] = COORD_Z_3D(input_field,0,plane_number,k+1);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      } 
	}    
	else
	{
	   for(k = 0; k < MAXZ(input_field); k++)
	    for(i = 0; i < MAXX(input_field) - 1; i++)
	      { 
	        verts[0][0] = COORD_X_3D(input_field,i,plane_number,k);
	        verts[0][1] = COORD_Y_3D(input_field,i,plane_number,k);
	        verts[0][2] = COORD_Z_3D(input_field,i,plane_number,k);

	        verts[1][0] = COORD_X_3D(input_field,i+1,plane_number,k);
	        verts[1][1] = COORD_Y_3D(input_field,i+1,plane_number,k);
	        verts[1][2] = COORD_Z_3D(input_field,i+1,plane_number,k);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      }

	   for(i = 0; i < MAXX(input_field); i++)
	    for(k = 0; k < MAXZ(input_field) - 1; k++)
              {
	        verts[0][0] = COORD_X_3D(input_field,i,plane_number,k);
	        verts[0][1] = COORD_Y_3D(input_field,i,plane_number,k);
	        verts[0][2] = COORD_Z_3D(input_field,i,plane_number,k);

	        verts[1][0] = COORD_X_3D(input_field,i,plane_number,k+1);
	        verts[1][1] = COORD_Y_3D(input_field,i,plane_number,k+1);
	        verts[1][2] = COORD_Z_3D(input_field,i,plane_number,k+1);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      }
          }

	break;

     case 'K' :
        new_maximum = MAXZ(input_field) - 1;
	plane_number = (new_maximum < plane_number) ? new_maximum : plane_number;
	if(draw_mesh == 0)
	{
	    for(i = 0; i < MAXX(input_field) - 1; i++)
	      { 
	        verts[0][0] = COORD_X_3D(input_field,i,0,plane_number);
	        verts[0][1] = COORD_Y_3D(input_field,i,0,plane_number);
	        verts[0][2] = COORD_Z_3D(input_field,i,0,plane_number);

	        verts[1][0] = COORD_X_3D(input_field,i+1,0,plane_number);
	        verts[1][1] = COORD_Y_3D(input_field,i+1,0,plane_number);
	        verts[1][2] = COORD_Z_3D(input_field,i+1,0,plane_number);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      }

	    for(j = 0; j < MAXY(input_field) - 1; j++)
              {
	        verts[0][0] = COORD_X_3D(input_field,ni,j,plane_number);
	        verts[0][1] = COORD_Y_3D(input_field,ni,j,plane_number);
	        verts[0][2] = COORD_Z_3D(input_field,ni,j,plane_number);

	        verts[1][0] = COORD_X_3D(input_field,ni,j+1,plane_number);
	        verts[1][1] = COORD_Y_3D(input_field,ni,j+1,plane_number);
	        verts[1][2] = COORD_Z_3D(input_field,ni,j+1,plane_number);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      }

	    for(i = 0; i < MAXX(input_field) - 1;  i++)
	      { 
	        verts[0][0] = COORD_X_3D(input_field,i,nj,plane_number);
	        verts[0][1] = COORD_Y_3D(input_field,i,nj,plane_number);
	        verts[0][2] = COORD_Z_3D(input_field,i,nj,plane_number);

	        verts[1][0] = COORD_X_3D(input_field,i+1,nj,plane_number);
	        verts[1][1] = COORD_Y_3D(input_field,i+1,nj,plane_number);
	        verts[1][2] = COORD_Z_3D(input_field,i+1,nj,plane_number);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      }

	    for(j = 0; j < MAXY(input_field) - 1; j++)
              {
	        verts[0][0] = COORD_X_3D(input_field,0,j,plane_number);
	        verts[0][1] = COORD_Y_3D(input_field,0,j,plane_number);
	        verts[0][2] = COORD_Z_3D(input_field,0,j,plane_number);

	        verts[1][0] = COORD_X_3D(input_field,0,j+1,plane_number);
	        verts[1][1] = COORD_Y_3D(input_field,0,j+1,plane_number);
	        verts[1][2] = COORD_Z_3D(input_field,0,j+1,plane_number);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      } 
	}    
	else
	{
	   for(j = 0; j < MAXY(input_field); j++)
	    for(i = 0; i < MAXX(input_field) - 1; i++)
	      { 
	        verts[0][0] = COORD_X_3D(input_field,i,j,plane_number);
	        verts[0][1] = COORD_Y_3D(input_field,i,j,plane_number);
	        verts[0][2] = COORD_Z_3D(input_field,i,j,plane_number);

	        verts[1][0] = COORD_X_3D(input_field,i+1,j,plane_number);
	        verts[1][1] = COORD_Y_3D(input_field,i+1,j,plane_number);
	        verts[1][2] = COORD_Z_3D(input_field,i+1,j,plane_number);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      }

	   for(i = 0; i < MAXX(input_field); i++)
	    for(j = 0; j < MAXY(input_field) - 1; j++)
              {
	        verts[0][0] = COORD_X_3D(input_field,i,j,plane_number);
	        verts[0][1] = COORD_Y_3D(input_field,i,j,plane_number);
	        verts[0][2] = COORD_Z_3D(input_field,i,j,plane_number);

	        verts[1][0] = COORD_X_3D(input_field,i,j+1,plane_number);
	        verts[1][1] = COORD_Y_3D(input_field,i,j+1,plane_number);
	        verts[1][2] = COORD_Z_3D(input_field,i,j+1,plane_number);

		GEOMadd_disjoint_line(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	      }
	   }

	break;
   }

  /*   now modify the maximum value of the plane number in the widget */

   AVSmodify_parameter("Plane number",AVS_MAXVAL|AVS_VALUE,plane_number,
                                                       NULL,new_maximum);

   *output = GEOMinit_edit_list(*output);

   /* Now we replace the geometry for the object named "grid_mesh" 
      to this obj */

   GEOMedit_geometry(*output,"grid_mesh",obj);

   /* Then we free up our reference to this object */
   GEOMdestroy_obj(obj);
 
   /* 
    * Make sure that module returns success when finished (otherwise
    * AVS might think that it failed and won't execute downstream modules) 
    */
   return(1);
}
