/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/*
 * Voici "hog_2D" module de AVS
 *
 * ce module calcule un champ de vecteurs
 *  dans un field 2D 2-vector real
 *
 * This module draws vector arrows on the lattice
 * of a 2D field, at the node positions.
 * It draws arrows in the 2D plane, given X-Y
 * vector components.
 * The downsize dial subsamples the mesh, so
 * not all nodes get arrows, for clarity.
 *
 * Note: even if the input field is 3-vector or more,
 * it only draws arrows assuming 2D vectors in first two
 * vector components.
 *
 * Revision:
 *  March, 92, E&S France, Original
 *  8 June 93 ianc Cleanup, portability
 *  9 June 93, fixed nasty array index bug, trashing memory.
 * 26 Aug  93  fixed pointer indirection prob on geom
 */

/******************************************************/

#include <stdio.h>

#define MEM_DEFS_ENABLE 1

#include <avs/avs.h>
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/colormap.h>

/* debug printing */
/*
#define PRINT(a) printf( a )
 */
#define PRINT(a) ;

static float *vdata=NULL, *vpoints=NULL;

/******************************************************/
/* Description Routine */
/******************************************************/

hog_2D_desc()
{
  int hog_2D_compute();

  AVSset_module_name ("hog 2D", MODULE_MAPPER);

  AVScreate_input_port ("field input",
       "field 2D float", REQUIRED);

  AVScreate_output_port ("Vector Output", "geom");

  AVSadd_float_parameter ("scale", 1.0,
           FLOAT_UNBOUND,FLOAT_UNBOUND);

  AVSadd_parameter ("downsize", "integer", 1, 1, 16);

  AVSadd_parameter ("arrows", "boolean", 0, 0, 1);

  AVSset_compute_proc (hog_2D_compute);
}

/******************************************************/
/* Compute Routine */
/******************************************************/

int hog_2D_compute (vinput, voutput, vscale, 
                    downsize, arrows)

  AVSfield_float *vinput;
  GEOMedit_list *voutput;
  float *vscale;
  int downsize;
  int arrows;

{

  GEOMobj *obj;

  int i, j, k, l, z, size, size2d;
  int max_size,icpt, width, height, var;
  int veclen;
    
 /**************
  ***  body  ***
  **************/

  width  = MAXX(vinput);
  height = MAXY(vinput);
  veclen = vinput->veclen;
  size2d = width * height;

  /* local space allocation */

/* IAC CODE CHANGE :   if ( vdata   != NULL ) free ( vdata ); */
  if ( vdata   != NULL )  free(vdata );

/* IAC CODE CHANGE :   if ( vpoints != NULL ) free ( vpoints ); */
  if ( vpoints != NULL )  free(vpoints );
  vdata   = (float *)malloc(sizeof(float) * 2 * size2d + 8);
  vpoints = (float *)malloc(sizeof(float) * 2 * size2d + 8);

  /* check vector length */
  if ( veclen < 2 )
  {
      AVSerror("Hog 2D:this module needs at least 2-vector data");
      return(0);
  } 

  /*  copy data.  */
  k = 0;
  for (i = 0; i < height; i++) {
    for (j = 0; j < width; j++) {
      for (var = 0; var < 2; var++) {
        vdata[k] = vinput->data[ (i*width+j)*veclen+var];
        k = k+1;
      }
    }
  }
 

  /*  copy vpoints.  */
  switch (vinput->uniform) {
    case IRREGULAR:
          PRINT("irregular\n");
	  for (i = 0; i < size2d; i++) {
	    /* voir si bon en AVS 3*/
	    vpoints[i] = vinput->points[i];
	    vpoints[i + size2d] = vinput->points[i + size2d];
          }
    break;

    case RECTILINEAR:
         PRINT("rectilinear\n");
         for (i =0; i < height; i++) {
           for (j=0; j < width; j++) {
	      icpt = (i*width) + j;
	      vpoints[icpt] = vinput->points[j];
	      vpoints[icpt + size2d] = vinput->points[MAXX(vinput)];
	    }
          }
    break;

    default:
      case UNIFORM:
         PRINT("uniform\n");
         for (i =0; i < height; i++) {
           for (j=0; j < width; j++) {
	     icpt = (i*width) + j;
	     vpoints[icpt] = (float)j;
	     vpoints[icpt + size2d] = (float)i;
           }
         }
      break;
    }


    /*  create a geom object for the vectors.   */
    *voutput = GEOMinit_edit_list(*voutput);
					   
    obj = GEOMcreate_obj (GEOM_POLYTRI, NULL);

    /*
     * create the geometric representation
     */
    create_vectors (vpoints, vdata,
                    width, height,
                    obj, *vscale, 
		    downsize, arrows);

    GEOMedit_geometry (*voutput, "hog_2D", obj);
    GEOMdestroy_obj (obj);

    return(1);
}

/******************************************************/
/* Drawing  Routine, walk mesh and draw arrows */
/******************************************************/
create_vectors (vpoints, vdata,
                width, height,
                obj, scale,
                downsize, arrows) 

  float vpoints[], vdata[][2], scale;

  GEOMobj *obj;

  int width, height, downsize, arrows;

{

  float verts[40][3], x, y, z;
  int nverts, size, i, j, k;
  float vec[3];

 /**************
  ***  body  ***
  **************/

  size = width * height;
  nverts = 2;

  for (i = 0; i < height; i += downsize)
  {
     for (j = 0; j < width; j += downsize)
     {
	k = (width * i) + j;
        x = vpoints[k];
        y = vpoints[k + size];
	z = 0;
        vec[0] = vdata[k][0];
        vec[1] = vdata[k][1];
        vec[2] = 0.0;

	if (arrows) 
	  create_arrow (x, y, z, vec, scale, &nverts, verts);
	else
        { 
          verts[0][0] = x;
          verts[0][1] = y;
	  verts[0][2] = 0;
  
          verts[1][0] = x + scale * vec[0];
          verts[1][1] = y + scale * vec[1];
	  verts[1][2] = 0;
        }

        GEOMadd_disjoint_line (obj, verts, NULL, nverts, GEOM_COPY_DATA);
     }
  }
}


/******************************************************/
/* Draw an Arrow */
/******************************************************/
create_arrow (x, y, z, v1, scale, nverts, verts)
  
  float x, y, z, v1[3], scale, verts[][3];

  int *nverts;
{

/*
  double sqrt();
 */

  float mag, s1, x1, y1, z1, nx, ny, nz, s, vt[3], v2[3], v3[3], vx, vy, vz;

  int i, n, m;

  /* ratio of arrow head to length */
  static float arrow_scale = 0.4;

 /**************
  ***  body  ***
  **************/

  v1[2] = 0;
  nx = scale * v1[0];
  ny = scale * v1[1];
  nz = scale * v1[2];
  mag = sqrt(nx * nx + ny * ny + nz * nz);

  if (mag == 0.0) {
    n = 0;
    verts[n][0] = x;
    verts[n][1] = y;
    verts[n++][2] = z;
    verts[n][0] = x;
    verts[n][1] = y;
    verts[n++][2] = z;
    }
  else {
    s = 0.9;
    s1 = arrow_scale * (1.0 - s) * mag;
    vx = x + s * nx;
    vy = y + s * ny;
    vz = z + s * nz;


    /*  compute v2[] and v3[], which will be 
        the sides of the arrow head.          */

    vt[0] = -v1[1];
    vt[1] = v1[0];
    vt[2] = 0.0;

    if ((vt[0] == 0.0) && (vt[1] == 0.0))
      vt[0] = 1.0;

    vcross_prod (v1, vt, v2);
    vcross_prod (v1, v2, v3);

    vnorm (v2);
    vnorm (v3);

    n = 0;
    verts[n][0] = x;
    verts[n][1] = y;
    verts[n++][2] = z;
    verts[n][0] = x1 = x + nx;
    verts[n][1] = y1 = y + ny;
    verts[n++][2] = z1 = z + nz;

    verts[n][0] = x1;  
    verts[n][1] = y1;  
    verts[n++][2] = z1;  

    verts[n][0] = vx + s1 * v2[0];
    verts[n][1] = vy + s1 * v2[1]; 
    verts[n++][2] = vz + s1 * v2[2];

    verts[n][0] = x1;  
    verts[n][1] = y1;  
    verts[n++][2] = z1;  
    verts[n][0] = vx + s1 * v3[0]; 
    verts[n][1] = vy + s1 * v3[1];
    verts[n++][2] = vz + s1 * v3[2];

    verts[n][0] = x1;  
    verts[n][1] = y1;  
    verts[n++][2] = z1;  
    verts[n][0] = vx - s1 * v2[0];  
    verts[n][1] = vy - s1 * v2[1];
    verts[n++][2] = vz - s1 * v2[2]; 

    verts[n][0] = x1;  
    verts[n][1] = y1;  
    verts[n++][2] = z1;  
    verts[n][0] = vx - s1 * v3[0]; 
    verts[n][1] = vy - s1 * v3[1];
    verts[n++][2] = vz - s1 * v3[2]; 


    /*  form the base of the arrow head.  */

    for (m = n, i = 3; i < m; i += 2) {
      verts[n][0] = verts[i][0];  
      verts[n][1] = verts[i][1];  
      verts[n++][2] = verts[i][2];  

      if (i == 9) {
        verts[n][0] = verts[3][0];  
        verts[n][1] = verts[3][1];  
        verts[n++][2] = verts[3][2];  
        }
      else {
        verts[n][0] = verts[i + 2][0];  
        verts[n][1] = verts[i + 2][1];  
        verts[n++][2] = verts[i + 2][2];  
        }
      }
    }

  *nverts = n;
}

/******************************************************/
/* Init the AVS Linkage */
/******************************************************/

AVSinit_modules()
  {
  AVSmodule_from_desc (hog_2D_desc);
  }


/******************************************************/
/* Vector Math Utilities */
/******************************************************/

vnorm (v)
  float v[];
{

  double mag;
/*
  double sqrt();
 */

 /**************
  ***  body  ***
  **************/

  mag = sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);

  if (mag == 0.0) {
    v[0] = 0.0;
    v[1] = 0.0;
    v[2] = 0.0;
    return (0);
    }
  else {
    v[0] = v[0] / mag;
    v[1] = v[1] / mag;
    v[2] = v[2] / mag;
    }

  return (1);
}


/******************************************************/

vcross_prod (v1, v2, v3)
  float *v1, *v2, *v3;
{

 /**************
  ***  body  ***
  **************/

  v3[0] = v1[1] * v2[2] - v1[2] * v2[1];
  v3[1] = v1[2] * v2[0] - v1[0] * v2[2];
  v3[2] = v1[0] * v2[1] - v1[1] * v2[0];
}


