/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*   
     This software is copyright (C) 1992,  Regents  of  the
University  of  California.   Anyone may reproduce i_slicer.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  i_slicer.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  i_slicer.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     i_slicer.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
i_slicer.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov

    13 may 1992

    the purpose of interpolating slicer is similar to that of orthogonal
    slicer.  orthogonal slices are extracted from the dataset (which may
    be 4d/3d/2d).  however, non-integral valued slice numbers are allowed,
    in which case the output data is computed as a linear combination of
    the two slices which bound the indicated value.

    for example, if the slice number selected is 25.4, then the output data
    is weighted to be 40% of slice 26 and 60% of slice 25.

    a few permutations of fields have not been tested, notably four
    dimensional fields with coordinates.

    it is a straightforward thing to fill in the routines which process
    byte, integer and double precision fields.  the interpolating routines
    are present in this source code.  early versions of this code had
    the non-float field's routines in place.  they have been removed for
    the first submission to the AVS center, but will be filled in for the
    next iteration.
    
*/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>

AVSinit_modules()
{
    int i_slicer();
    AVSmodule_from_desc(i_slicer);
}

i_slicer()
{
    int i_slicer_p(),init_func();
    int inp,outp,p;

    AVSset_module_name("interpolating slicer",MODULE_MAPPER);
    inp = AVScreate_input_port("Input Field","field",REQUIRED);
    outp = AVScreate_output_port("Output Field","field");

    p = AVSadd_float_parameter("Slice number",0.,0.,65536.);
    AVSconnect_widget(p,"dial");
    p = AVSadd_parameter("Logical Plane","choice","k","i!j!k!l","!");
    AVSconnect_widget(p,"radio_buttons");
    AVSset_compute_proc(i_slicer_p);
}

i_slicer_p(inf,outf,slice_number,logical_plane)
AVSfield *inf,**outf;
float *slice_number;
char *logical_plane;
{
    double t;
    int num_slices;
    int choice_value = AVSchoice_number("Logical Plane",logical_plane) - 1;
    AVSfield template;
    int dims[4],i;
    float *t1,*t2;
    char work[256],delim,work2[256];

    if (!(inf->ndim == 2 || inf->ndim == 3 || inf->ndim == 4))
    {
	AVSwarning(" Only 2d/3d/4d input fields are allowed.");
	return(0);
    }

    if (inf->type != AVS_TYPE_REAL)
    {
	AVSwarning(" At present, only FLOAT fields are supported. \n Please use the \"field to float\" module.");
	return(0);
    }

    /* if not here before OR new logical plane, set extents
       on the dial, create new output field and exit */

    if (AVSinput_changed("Input Field",0) || AVSparameter_changed("Logical Plane"))
    {
	if (*outf)
	    AVSfield_free(*outf);
	if (AVSinput_changed("Input Field",0))
	{
	    if (inf->ndim == 2)
	    {
		AVSmodify_parameter("Logical Plane",AVS_VALUE,"j",0,0);
		AVSmodify_parameter("Logical Plane",AVS_MINVAL,"","i!j","");
		num_slices = inf->dimensions[1] - 1;
		choice_value = 1;
	    }
	    else if (inf->ndim == 3)
	    {
		choice_value = 2;
		num_slices = inf->dimensions[choice_value] - 1;
		AVSmodify_parameter("Logical Plane",AVS_VALUE,"k",0,0);
		AVSmodify_parameter("Logical Plane",AVS_MINVAL,"","i!j!k","");
	    }
	    else
	    {
		choice_value = 3;
		num_slices = inf->dimensions[choice_value] - 1;
		AVSmodify_parameter("Logical Plane",AVS_MINVAL,"","i!j!k!l","");
		AVSmodify_parameter("Logical Plane",AVS_VALUE,"l",0,0);
	    }
	    t = num_slices;
	    AVSmodify_float_parameter("Slice number",AVS_MAXVAL,t,t,t);
	}
	if (AVSparameter_changed("Logical Plane"))
	{
	    num_slices = inf->dimensions[choice_value] - 1;
	    t = num_slices;
	    AVSmodify_float_parameter("Slice number",AVS_MAXVAL,t,t,t);
	}
	
	if (*slice_number < 0.)
	{
	    AVSmodify_float_parameter("Slice number",AVS_VALUE,0.,0.,0.);
	}
	else if (*slice_number > (float)num_slices)
	{
	    t = num_slices;
	    AVSmodify_float_parameter("Slice number",AVS_VALUE,t,t,t);
	}

	memset((char *)&template,0,sizeof(AVSfield));
	
	template.ndim = inf->ndim - 1;
	template.nspace = inf->nspace;
	template.veclen = inf->veclen;
	template.type = inf->type;
	template.size = inf->size;

	/**
	  * for rectilinear fields, we could have the output field
	  * be rectilinear.  one of the ndim's (in the dimensions[]
	  * array) would be "1", which causes many of the Supported
	  * AVS modules to barf.  i.e., we start with an ndim=3
	  * rectilinear field, and take a slice.  what should we have
	  * then?  we could get by with an ndim=3 rectilinear field
	  * where the length of one of the dimensions is 1.  instead,
	  * what we'll do is create an irregular field.
	**/
	if (inf->uniform == RECTILINEAR)
	    template.uniform = IRREGULAR;
	else
	    template.uniform = inf->uniform;

	if (choice_value == 3) /* l plane, copy over i,j,k dimensions */
	{
	    dims[0] = inf->dimensions[0];
	    if (inf->ndim > 2)
	    {
		dims[1] = inf->dimensions[1];
		if (inf->ndim > 3)
		    dims[2] = inf->dimensions[2];
	    }
	}
	else if (choice_value == 2) /* k plane, copy over i,j,l dimensions */
	{
	    dims[0] = inf->dimensions[0];
	    if (inf->ndim > 2)
	    {
		dims[1] = inf->dimensions[1];
		if (inf->ndim > 3)
		    dims[2] = inf->dimensions[3];
	    }
	}
	else if (choice_value == 1) /* j plane, copy over i,k,l dimensions */
	{
	    dims[0] = inf->dimensions[0];
	    if (inf->ndim > 2)
	    {
		dims[1] = inf->dimensions[2];
		if (inf->ndim > 3)
		    dims[2] = inf->dimensions[3];
	    }
	}
	else /* assume i plane, copy over j,k,l dimensions */
	{
	    dims[0] = inf->dimensions[1];
	    if (inf->ndim > 2)
	    {
		dims[1] = inf->dimensions[2];
		if (inf->ndim > 3)
		    dims[2] = inf->dimensions[3];
	    }
	}
	*outf = (AVSfield *)AVSfield_alloc(&template,dims);
	
	/**
	  * handle transferring over min/max extents, labels, etc.
	**/
	t1 = (float *)malloc(sizeof(float)*inf->nspace);
	t2 = (float *)malloc(sizeof(float)*inf->nspace);

	if (AVSfield_get_extent(inf,t1,t2))
	    AVSfield_set_extent(*outf,t1,t2);

	free(t1);
	free(t2);
	
	for (i=0;i<inf->veclen;i++)  /* copy over field labels */
	{
	    if (AVSfield_get_labels(inf,work,&delim))
		AVSfield_set_labels(*outf,work,&delim);
	}

	if (AVSfield_get_minmax(inf,work,work2))
	    AVSfield_set_minmax(*outf,work,work2);
    }

    /* if made it here, then we're actually going to copy a slice
       over. start off by copying the data itself */

    switch(inf->type)
    {
    case AVS_TYPE_BYTE: slice_byte_data(inf,*outf,choice_value,slice_number);
	break;
    case AVS_TYPE_INTEGER: slice_int_data(inf,*outf,choice_value,slice_number);
	break;
    case AVS_TYPE_REAL: slice_real_data(inf,*outf,choice_value,slice_number);
	break;
    case AVS_TYPE_DOUBLE: slice_d_data(inf,*outf,choice_value,slice_number);
	break;
    }
    
    /* now copy over the coords, if any. */

    switch(inf->uniform)
    {
    case UNIFORM:
	do_uniform_extents(inf,*outf,choice_value,slice_number);
	break;
    case RECTILINEAR: copy_rect_points(inf,*outf,choice_value,slice_number);
	break;
    case IRREGULAR: copy_irreg_points(inf,*outf,choice_value,slice_number);
	break;
    }
	    
    return(1);
}

int
compute_count(f,p)
AVSfield *f;
int p;
{
    int i,count;

    for (i=0,count=1;i<f->ndim;i++)
    {
	if (i != p)
	    count *= f->dimensions[i];
    }
    return(count);
}


do_uniform_extents(inf,outf,plane,t)
AVSfield *inf,*outf;
int plane;
float *t;
{
    int i;
    float *d,*s,tt;

    d = outf->points;
    s = inf->points;
    
    for (i=0;i<inf->nspace;i++)
    {
	if (plane == i)
	{
	    tt = *s + *t *(*(s+1) - *s)/(inf->dimensions[i]-1);
	    *d++ = tt;
	    *d++ = tt;
	    s+=2;
	}
	else
	{
	    *d++ = *s++;
	    *d++ = *s++;
	}
    }
}

copy_rect_points(inf,outf,plane,slice_number)
AVSfield *inf,*outf;
int plane;
float *slice_number;
{
    /* no allowance need be made here for 2d data fields -- it is
       not the case that a rectilinear field can have 2d data with
       3d coordinates. */
    register float *src,*dst;
    float *s,*d;
    int count,i,j,nspace,runs,blocks,k;
    int dims[24]; /* max number of dimensions allowed: 24 is arbitrary */
    float *b1,*b2,*b3;
    float t0,t1;
    int n0,n1;

    count = compute_count(inf,plane);
    b1 = (float *)malloc(sizeof(float)*count*3);
    b2 = b1 + count;
    b3 = b2 + count;
    
    if ((int)(*slice_number) == (*slice_number))
    {
	n0 = (int)*slice_number;
	n1 = n0;
    }
    else
    {
	n0 = (int) *slice_number;
	n1 = n0+1;
    }
    
    t0 = 1. - (*slice_number - (int) *slice_number);
    t1 = 1. - t0;
    
    /* compute total number of points in output field */
    for (i=0,count=1;i<inf->nspace;i++)
    {
	if (i != plane)
	{
	    dims[i] = inf->dimensions[i];
	    count *= inf->dimensions[i];
	}
	else
	    dims[i] = 1;
    }

    d = dst = outf->points;
    s = src = inf->points;
    
    for (nspace=0;nspace < inf->nspace;nspace++)
    {
	if (plane == nspace)
	{
	    dst = d;
	    src = s + n0;
	    for (i=0;i<count;i++)
		b1[i] = *src;
	    src = s + n1;
	    for (i=0;i<count;i++)
		b2[i] = *src;
	    float_vec_weight(b1,b2,d,&t0,&t1,count);
	    d += count;
	    s += inf->dimensions[nspace];
	}
	else
	{
	    for (j=0,runs=1,blocks=1;j<inf->ndim;j++)
	    {
		if ((j != nspace) && (j != plane))
	        {
		    if (j > nspace)
			blocks *= inf->dimensions[j];
		    else
			runs *= inf->dimensions[j];
		}
	    }
	    src = s;
	    dst = d;
	    for (j=0;j<blocks;j++)
	    {
		for (k=0;k<inf->dimensions[nspace];k++)
		{
		    for (i=0;i<runs;i++)
			*dst++ =  *(src+k);
		}
	    }
	    d += count;
	    s += inf->dimensions[nspace];
	}
    }

      free(b1)  ;
}

copy_irreg_points(inf,outf,plane,slice_number)
AVSfield *inf,*outf;
int plane;
float *slice_number;
{
    register float *src,*dst;
    int count,i,j,k;
    int total_num_points;
    int plane_offset;
    int xy_plane_count,xyz_block_count;
    float *s0,*s1,*d,*s;
    float *b1,*b2,*b3,t0,t1;
    int n0,n1;
    int index;

    count = compute_count(inf,plane);
    b1 = (float *)malloc(sizeof(float)*count*3);
    b2 = b1 + count;
    b3 = b2 + count;
    
    if ((int)(*slice_number) == (*slice_number))
    {
	n0 = (int)*slice_number;
	n1 = n0;
    }
    else
    {
	n0 = (int) *slice_number;
	n1 = n0+1;
    }
    
    t0 = 1. - (*slice_number - (int) *slice_number);
    t1 = 1. - t0;
    
    if (inf->ndim == 4)
    {
	if (plane == 3) /* block of constant l */
	{
	    /** THIS CODE IS UNTESTED **/
	    count = inf->dimensions[0]*inf->dimensions[1]*inf->dimensions[2];
	    total_num_points = count*inf->dimensions[3];
	    s0 = inf->points + n0*count;
	    s1 = inf->points + n1*count;
	    d = outf->points;
	    for (j=0;j<inf->nspace;j++)
	    {
		memcpy((char *)b1,(char *)s0,count*sizeof(float));
		memcpy((char *)b2,(char *)s1,count*sizeof(float));
		float_vec_weight(b1,b2,d,&t0,&t1,count);
		s0 += total_num_points;
		s1 += total_num_points;
		d += count;
	    }
	}
	else if (plane == 2) /* block of constant k */
	{
	    /* THIS CODE IS UNTESTED. */
	    count = inf->dimensions[0]*inf->dimensions[1];
	    total_num_points = count*inf->dimensions[2]*inf->dimensions[3];
	    d = outf->points;
	    for (j=0;j<inf->nspace;j++)
	    {
		s0 = inf->points + n0*count + j*total_num_points;
		s1 = inf->points + n1*count + j*total_num_points;
		for (i=0;i<inf->dimensions[3];i++)
	        {
		    memcpy((char *)b1,(char *)s0,count*sizeof(float));
		    memcpy((char *)b2,(char *)s1,count*sizeof(float));
		    float_vec_weight(b1,b2,d,&t0,&t1,count);
		    d += count;
		    s0 += count*inf->dimensions[2];
		    s1 += count*inf->dimensions[2];
		}
	    }
	}
	else if (plane == 1) /* block of constant j */
	{
	    /* THIS CODE IS UNTESTED. */
	    count = inf->dimensions[0];
	    total_num_points = count*inf->dimensions[1]*inf->dimensions[2]*inf->dimensions[3];
	    xy_plane_count = count*inf->dimensions[1];
	    d = outf->points;
	    for (j=0;j<inf->nspace;j++)
	    {
		s0 = inf->points + j*total_num_points + n0*count;
		s1 = inf->points + j*total_num_points + n1*count;
		for (k=0;k<inf->dimensions[3];k++)
		{
		    for (i=0;i<inf->dimensions[2];i++)
		    {
			memcpy((char *)b1,(char *)s0,count*sizeof(float));
			memcpy((char *)b2,(char *)s1,count*sizeof(float));
			float_vec_weight(b1,b2,d,&t0,&t1,count);
			d += count;
			s0 += xy_plane_count;
			s1 += xy_plane_count;
		    }
		}
	    }
	}
	else /* block of constant i */
	{
	    /* THIS CODE IS UNTESTED. */
	    total_num_points = inf->dimensions[0]*inf->dimensions[1]*inf->dimensions[2]*inf->dimensions[3];
	    dst = outf->points;
	    xy_plane_count = inf->dimensions[0]*inf->dimensions[1];
	    xyz_block_count = xy_plane_count*inf->dimensions[2];

	    for (count=0;count<inf->nspace;count++)
	    {
		for (j=0;j<inf->dimensions[3];j++)
		{
		    for (k=0;k<inf->dimensions[2];k++)
		    {
			s0 = inf->points + k*xy_plane_count + n0 + j*xyz_block_count + count*total_num_points;
			s1 = inf->points + k*xy_plane_count + n1 + j*xyz_block_count + count*total_num_points;
			/** note: this loop could be abbreviated. **/
			for (j=0;j<inf->dimensions[1];j++)
			{
			    float_vec_weight(s0,s1,dst,&t0,&t1,1);
			    dst++;
			    s0++;
			    s1++;
			}
		    }
		}
	    }
	}
    }
    else if (inf->ndim == 3)
    {
	if (plane == 2) /* block of constant k */
	{
	    count = inf->dimensions[0]*inf->dimensions[1];
	    total_num_points = count*inf->dimensions[2];
	    s = inf->points + n0*count;
	    d = outf->points;
	    for (j=0;j<inf->nspace;j++)
	    {
		memcpy((char *)b1,(char *)s,count*sizeof(float));
		memcpy((char *)b2,(char *)(s + (n1-n0)*count),count*sizeof(float));
		float_vec_weight(b1,b2,b3,&t0,&t1,count);

		memcpy((char *)d,b3,sizeof(float)*count);
		
		s += total_num_points;
		d += count;
	    }
	}
	else if (plane == 1) /* block of constant j */
	{
	    count = inf->dimensions[0]*inf->dimensions[2];
	    total_num_points = count*inf->dimensions[1];
	    d = outf->points;
	    xy_plane_count = inf->dimensions[0]*inf->dimensions[1];
	    for (j=0;j<inf->nspace;j++)
	    {
		s0 = inf->points + n0*inf->dimensions[0] + j*total_num_points;
		s1 = inf->points + n1*inf->dimensions[0] + j*total_num_points;
		
		for (i=0;i<inf->dimensions[2];i++)
		{
		    memcpy((char *)b1,(char *)s0,inf->dimensions[0]*sizeof(float));
		    memcpy((char *)b2,(char *)s1,inf->dimensions[0]*sizeof(float));
		    float_vec_weight(b1,b2,d,&t0,&t1,inf->dimensions[0]);
			  
		    s0+= xy_plane_count;
		    s1+= xy_plane_count;
		    d+= inf->dimensions[0];
		}
	    }
	}
	else /* block of constant i */
	{
	    count = inf->dimensions[1]*inf->dimensions[2];
	    total_num_points = count*inf->dimensions[0];
	    dst = outf->points;
	    xy_plane_count = inf->dimensions[0]*inf->dimensions[1];
	    for (j=0;j<inf->nspace;j++,dst+=count)
	    {
		src = inf->points + n0 + j*total_num_points;
		for (k=0,index=0;k<inf->dimensions[2];k++)
		{
		    for (i=0;i<inf->dimensions[1];i++,src+=inf->dimensions[0])
			b1[index++] = *src;
		}
		
		src = inf->points + n1 + j*total_num_points;
		for (k=0,index=0;k<inf->dimensions[2];k++)
		{
		    for (i=0;i<inf->dimensions[1];i++,src+=inf->dimensions[0])
			b2[index++] = *src;
		}
		float_vec_weight(b1,b2,dst,&t0,&t1,inf->dimensions[2]*inf->dimensions[1]);
	    }
	}
    }
    else /* inf->ndim == 2 */
    {
	if (plane == 1) /* block of constant j */
	{
	    count = inf->dimensions[0];
	    plane_offset = inf->dimensions[0]*inf->dimensions[1];
	    s0 = inf->points + n0 * count;
	    s1 = inf->points + n1 * count;
	    d = outf->points;
	    for (j=0;j<inf->nspace;j++)
	    {
		memcpy((char *)b1,(char *)s0,count*sizeof(float));
		memcpy((char *)b2,(char *)s1,count*sizeof(float));
		float_vec_weight(b1,b2,d,&t0,&t1,count);
		
		s0 += plane_offset;
		s1 += plane_offset;
		d += count;
	    }
	}
	else /* block of constant i */
	{
	    count = inf->dimensions[1];
	    plane_offset = inf->dimensions[0];
	    dst = outf->points;
	    for (j=0;j<inf->nspace;j++)
	    {
		s0 = inf->points + n0 + j*inf->dimensions[0]*inf->dimensions[1];
		s1 = inf->points + n1 + j*inf->dimensions[0]*inf->dimensions[1];
		for (i=0;i<count;i++)
		{
		    b1[i] = *s0;
		    b2[i] = *s1;
		    s0 += plane_offset;
		    s1 += plane_offset;
		}
		
		float_vec_weight(b1,b2,dst,&t0,&t1,count);
		dst += count;
	    }
	}
    }

      free(b1)  ;
}

slice_byte_data(inf,outf,plane,slice_number)
AVSfield *inf,*outf;
int plane;
float *slice_number;
{
}

slice_int_data(inf,outf,plane,slice_number)
AVSfield *inf,*outf;
int plane,slice_number;
{
}

slice_real_data(inf,outf,plane,slice_number)
AVSfield *inf,*outf;
int plane;
float *slice_number;
{
    register float *src,*dst;
    register int offset;
    float *s,*d;
    float *s0,*s1;
    float *p1,*p2;
    int block_offset;
    int count,i,j,k;
    int xy_plane_byte_count,y_offset;
    int n0,n1;
    float t0,t1;
    float *b0,*b1,*b2;
    int n = *slice_number;
    int index;

    count = compute_count(inf,plane);
    
    /* malloc space for work arrays.  malloc just one big array,
       chop it in half. */
	
    b0 = (float *)malloc(sizeof(float)*count*inf->veclen * 3);
    b1 = b0 + count*inf->veclen;
    b2 = b1 + count*inf->veclen;

    t0 = 1. - (*slice_number - (int) *slice_number);
    t1 = 1. - t0;

    if (n == inf->dimensions[plane]-1)
    {
	n0 = n;
	n1 = n0;
    }
    else
    {
	n0 = n;
	n1 = n+1;
    }

    if (inf->ndim == 2)
    {
	if (plane == 1) /* copy over an x-row */
	{
	    count = inf->dimensions[0];
	    count *= inf->veclen;
	    s = inf->field_data_float + count*n0;
	    memcpy((char *)b0,(char *)s,count*sizeof(float));
	    
	    s = inf->field_data_float + count*n1;
	    memcpy((char *)b1,(char *)s,count*sizeof(float));

	    float_vec_weight(b0,b1,b2,&t0,&t1,count);
	    
	    d = outf->field_data_float;
	    memcpy((char *)d,(char *)b2,count*sizeof(float));
	}
	else /* copy over a y-column */
	{
	    count = inf->dimensions[1];
	    count *= inf->veclen;
	    offset = inf->dimensions[0]*inf->veclen;
	    src = inf->field_data_float + count*n0;

	    for (i=0,index=0;i<inf->dimensions[1];i++)
	    {
		src = inf->field_data_float + i*inf->dimensions[0]*inf->veclen + n*inf->veclen;
		for (j=0;j<inf->veclen;j++)
		    b0[index++] = *src++;
	    }
	    
	    src = inf->field_data_float + count*n1;
	    for (i=0,index=0;i<inf->dimensions[1];i++)
	    {
		src = inf->field_data_float + i*inf->dimensions[0]*inf->veclen + n*inf->veclen;
		for (j=0;j<inf->veclen;j++)
		    b1[index++] = *src++;
	    }

	    float_vec_weight(b0,b1,b2,&t0,&t1,count);

	    dst = outf->field_data_float;
	    memcpy((char *)dst,(char *)b2,inf->dimensions[1]*inf->veclen*sizeof(float));
	}
    }
    else if (inf->ndim == 3) /* 3d data */
    {
	if (plane == 2) /* constant z, xy-plane */
	{
	    count = inf->dimensions[0] * inf->dimensions[1];
	    count *= inf->veclen;
	    s = inf->field_data_float + count*n0;
	    memcpy((char *)b0,(char *)s,count*sizeof(float));

	    s = inf->field_data_float + count*n1;
	    memcpy((char *)b1,(char *)s,count*sizeof(float));
	    
	    float_vec_weight(b0,b1,b2,&t0,&t1,count);
	    
	    d = outf->field_data_float;
	    memcpy((char *)d,(char *)b2,count*sizeof(float));
	}
	else if (plane == 0) /* constant x, yz-plane */
	{
	    count = inf->dimensions[2] * inf->dimensions[1];
	    src = inf->field_data_float + n0*inf->veclen;
	    offset = inf->dimensions[0]*inf->veclen;
	    
	    src = inf->field_data_float + n0*inf->veclen;
	    for (i=0,index=0;i<count;i++,src += offset)
		for (j=0;j<inf->veclen;j++)
		    b0[index++] = *(src+j);
	    
	    src = inf->field_data_float + n1*inf->veclen;
	    index = 0;
	    for (i=0;i<count;i++,src += offset)
		for (j=0;j<inf->veclen;j++)
		    b1[index++] = *(src+j);
	    
	    float_vec_weight(b0,b1,b2,&t0,&t1,count*inf->veclen);
	    
	    dst = outf->field_data_float;
	    memcpy((char *)dst,(char *)b2,count*sizeof(float)*inf->veclen);
	}
	else if (plane == 1) /* constant y, xz-plane */
	{
	    xy_plane_byte_count = inf->dimensions[0]*inf->dimensions[1]*
		inf->veclen;
	    y_offset = n0*inf->dimensions[0]*inf->veclen;
	    d = outf->field_data_float;
	    
	    for (i=0,index=0;i<inf->dimensions[2];i++)
	    {
		s0 = inf->field_data_float + i*xy_plane_byte_count + n0*inf->dimensions[0]*inf->veclen;
		memcpy((char *)b0,(char *)s0,inf->dimensions[0]*inf->veclen*sizeof(float));
		s1 = inf->field_data_float + i*xy_plane_byte_count + n1*inf->dimensions[0]*inf->veclen;
		memcpy((char *)b1,(char *)s0,inf->dimensions[0]*inf->veclen*sizeof(float));
		float_vec_weight(b0,b1,d,&t0,&t1,inf->dimensions[0]*inf->veclen);

		d += inf->dimensions[0]*inf->veclen;
	    }
	}
    }
    else /* 4d data */
    {
	block_offset = inf->dimensions[0]*inf->dimensions[1]*inf->dimensions[2]*inf->veclen;  /* element count to next i,j,k block */
	
	if (plane == 3) /* constant l, want i,j,k blocks. */
	{
	    s0 = inf->field_data_float + n0*block_offset;
	    s1 = inf->field_data_float + n1*block_offset;
	    d = outf->field_data_float;
	    memcpy((char *)b1,(char *)s0,block_offset*sizeof(float));
	    memcpy((char *)b2,(char *)s1,block_offset*sizeof(float));
	    float_vec_weight(b1,b2,d,&t0,&t1,block_offset);
	}
	else if (plane == 2) /* constant k, want i,j,l blocks */
	{
	    xy_plane_byte_count = inf->dimensions[0]*inf->dimensions[1]*
		inf->veclen;
	    d = outf->field_data_float;
	    s0 = inf->field_data_float + n0*xy_plane_byte_count;
	    s1 = inf->field_data_float + n1*xy_plane_byte_count;
	    for(i=0;i<inf->dimensions[3];i++,s0+=block_offset,s1+=block_offset)  /* copy all i,j slices */
	    {
		memcpy((char *)b1,(char *)s0,xy_plane_byte_count*sizeof(float));
		memcpy((char *)b2,(char *)s1,xy_plane_byte_count*sizeof(float));
		float_vec_weight(b1,b2,d,&t0,&t1,xy_plane_byte_count);
		d += xy_plane_byte_count;
	    }
	}
	else if (plane == 1) /* constant j, want i,k,l blocks */
	{
	    d = outf->field_data_float;
	    xy_plane_byte_count = inf->dimensions[0] * inf->dimensions[1] * inf->veclen;
	    
	    for (i=0;i<inf->dimensions[3];i++) /* do all ik slices */
	    {
		
		s0 = inf->field_data_float + n0*(inf->dimensions[0]*inf->veclen) +
		    i*block_offset;
		s1 = inf->field_data_float + n1*(inf->dimensions[0]*inf->veclen) +
		    i*block_offset;
		
		for (j=0;j<inf->dimensions[2];j++,s0+=xy_plane_byte_count,s1+=xy_plane_byte_count) /* do all i rows */
		{
		    memcpy((char *)b1,(char *)s0,inf->dimensions[0]*inf->veclen*sizeof(float));
		    memcpy((char *)b2,(char *)s1,inf->dimensions[0]*inf->veclen*sizeof(float));
		    float_vec_weight(b1,b2,d,&t0,&t1,inf->dimensions[0]*inf->veclen);
		    
		    d += inf->dimensions[0]*inf->veclen;
		}
	    }
	}
	else /* plane == 0, constant i, want j,k,l blocks */
	{
	    dst = outf->field_data_float;
	    xy_plane_byte_count = inf->dimensions[0]*inf->dimensions[1]*
		inf->veclen;
	    
	    for (i=0;i<inf->dimensions[3];i++) /* do all jk slices */
	    {
		p1 = inf->field_data_float + i*block_offset + n0*inf->veclen;
		p2 = inf->field_data_float + i*block_offset + n1*inf->veclen;
		for (j=0;j<inf->dimensions[2];j++) /* do all j columns */
		{
		    s0 = p1 + xy_plane_byte_count*j;
		    s1 = p2 + xy_plane_byte_count*j;
		    for (k=0;k<inf->dimensions[1];k++,s0+=inf->veclen*inf->dimensions[0],s1+=inf->veclen*inf->dimensions[0])
			for (count=0;count<inf->veclen;count++,dst++)
			    float_vec_weight(s0+count,s1+count,dst,&t0,&t1,1);
/*			    *dst++ = *(src+count); */
		}
	    }
	}
    }


/* IAC CODE CHANGE :     free((char *)b0); */

/* IAC CODE CHANGE :      free(b0) ; */
      free(b0)  ;
}

slice_d_data(inf,outf,plane,slice_number)
AVSfield *inf,*outf;
int plane,slice_number;
{
}


float_vec_weight(b0,b1,dest,t0,t1,count)
float *b0,*b1,*t0,*t1,*dest;
int count;
{
    register float *d,*s0,*s1;
    register float w0,w1;
    register int i;

    d = dest;
    s0 = b0;
    s1 = b1;
    w0 = *t0;
    w1 = *t1;

    for (i=0;i<count;i++)
	d[i] = s0[i]*w0 + s1[i]*w1;
}

char_vec_weight(b0,b1,dest,t0,t1,count)
unsigned char *b0,*b1,*dest;
float *t0,*t1;
int count;
{
    register unsigned char *d,*s0,*s1;
    register float w0,w1;
    register int i;

    d = dest;
    s0 = b0;
    s1 = b1;
    w0 = *t0;
    w1 = *t1;

    for (i=0;i<count;i++)
	d[i] = (unsigned char)((float)(s0[i])*w0 + (float)(s1[i])*w1);
}
