/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/******************************************************************************/
/*
 *  Labeller produces label geometry objects from field data values.
 *
 */



#include "avs_utils.h"



typedef struct	{
		float		lo, hi;
		char		*str;
		} trans_table;



char		in_field_port[]		= "Input Field";
char		in_cmap_port[]		= "Input Colormap";
char		in_upstream_xform[]	= "Transform Info";
char		out_geom_port[]		= "Output Geom";
char		parm_safety[]		= "safety";
char		parm_offsets[]		= "label offsets       ";
char		parm_font[]		= "label font            ";
char		parm_height[]		= "label height         ";
char		parm_prec[]		= "label precision     ";
char		parm_factor[]		= "label value factor";
char		parm_align[]		= "alignment";
char		parm_background[]	= "background";
char		parm_dropshadow[]	= "drop-shadow";
char		parm_stroke[]		= "stroke";
char		parm_title[]		= "title";
char		parm_show_pins[]	= "show pins";
char		parm_freeze_aspect[]	= "freeze aspect";
char		parm_uni_color[]	= "uniform color     ";
char		parm_trans_file[]	= "value translation file";
char		parm_title_str[]	= "title string          ";
char		parm_title_file[]	= "title file";

char		align_choices[]		= "left!cent!right";



labeler_desc ()

{
    int		labeler_compute ();
    int		in_port, out_port, iparm;

    AVSset_module_name ("labeler", MODULE_MAPPER);

    AVScreate_input_port (in_field_port, "field", OPTIONAL);
    AVScreate_input_port (in_cmap_port, "colormap", OPTIONAL);
    in_port = AVScreate_input_port (in_upstream_xform,
                                    "struct upstream_transform",
                                    OPTIONAL | INVISIBLE);
    AVSset_input_class (in_port, "upstream_transform");


    out_port = AVScreate_output_port (out_geom_port, "geom");
    AVSautofree_output (out_port);


    AVSadd_parameter (parm_safety, "boolean", TRUE, FALSE, TRUE);

    AVSadd_parameter (parm_offsets, "string", "0 0 0", NULL, NULL);
    iparm = AVSadd_parameter (parm_font, "integer", 1, 0, 20);
    AVSconnect_widget (iparm, "typein_integer");
    iparm = AVSadd_float_parameter (parm_height, 0.03, 0.0, FLOAT_UNBOUND);
    AVSconnect_widget (iparm, "typein_real");
    iparm = AVSadd_float_parameter (parm_prec, 1.0, 0.0, FLOAT_UNBOUND);
    AVSconnect_widget (iparm, "typein_real");
    iparm = AVSadd_float_parameter (parm_factor, 1.0, 0.0, FLOAT_UNBOUND);
    AVSconnect_widget (iparm, "typein_real");

    iparm = AVSadd_parameter (parm_align, "choice", "cent",
                              align_choices, CHOICE_DELIMITER_STR);
    AVSadd_parameter_prop (iparm, "width", "integer", 1);
    AVSadd_parameter_prop (iparm, "columns", "integer", 3);
    AVSadd_parameter (parm_background, "boolean", FALSE, FALSE, TRUE);
    AVSadd_parameter (parm_dropshadow, "boolean", FALSE, FALSE, TRUE);
    AVSadd_parameter (parm_stroke, "boolean", FALSE, FALSE, TRUE);
    AVSadd_parameter (parm_title, "boolean", TRUE, FALSE, TRUE);
    AVSadd_parameter (parm_show_pins, "boolean", TRUE, FALSE, TRUE);
    AVSadd_parameter (parm_freeze_aspect, "boolean", FALSE, FALSE, TRUE);
    AVSadd_parameter (parm_uni_color, "string", NULL_STR, NULL, NULL);

    iparm = AVSadd_parameter (parm_trans_file, "string", NULL_STR, NULL, NULL);
    AVSconnect_widget (iparm, "browser");
    AVSadd_parameter (parm_title_str, "string", NULL_STR, NULL, NULL);
    iparm = AVSadd_parameter (parm_title_file, "string", NULL_STR, NULL, NULL);
    AVSconnect_widget (iparm, "browser");

    AVSset_compute_proc (labeler_compute);

    return;
}



/******************************************************************************/
/*
 *  Inform AVS of the name of the description procedure for this module.
 *
 */


AVSinit_modules()
{
    AVSmodule_from_desc (labeler_desc);
    return ;
}



labeler_compute (in_field, in_cmap, in_ups_xform, out_geom, 
                 safety, label_offstr, i_label_font, p_label_ht,
                 p_label_prec, p_label_factor,
                 align_choice, background, dropshadow, stroke, title,
                 show_pins, freeze, uni_color,
                 trans_file, title_str, title_file)

AVSfield		*in_field;
AVScolormap		*in_cmap;
upstream_transform	*in_ups_xform;
GEOMedit_list		*out_geom;
int			safety;
char			*label_offstr;
int			i_label_font;
float			*p_label_ht, *p_label_prec, *p_label_factor;
char			*align_choice;
int			background, dropshadow, stroke, title;
int			show_pins, freeze;
char			*uni_color;
char			*trans_file, *title_str, *title_file;
{
    static char		labl_obj_name[]	= "labeler_labels";
    static char		pins_obj_name[]	= "labeler_label_pins";

    static char		labl_fm1[]	= "%.0f";
    static char		labl_fm2[]	= ", %.0f";

    static trans_table	*table		= NULL;
    static int		n_table		= 0;

    register int	i, j, k, n, iv;
    register int	nx, ny, nz, nv, istr;
    register float	x;
    char		str[256];
    char		*labl_str;
    int			ndim, dim[3], nn, use_titles;
    int			labl_flags, labl_align, labl_title;
    int			labl_font, labl_bgflg, labl_dsflg, labl_stflg;
    float		labl_fac, labl_prec, labl_ht;
    float		*labl_vec;
    FLOAT3		labl_off, labl_adj, labl_xyz, *labl_clrs;
    FLOAT3		colors[2];
    GEOMobj		*labl_obj, *pins_obj;
    FILE		*file;



    if (safety)
    {
        AVSmark_output_unchanged (out_geom_port);
        return (1);
    }


    *out_geom = GEOMinit_edit_list (*out_geom);


    UTILS_geom_freeze_check (freeze, in_ups_xform, *out_geom);


    label_str_check (&uni_color);
    label_str_check (&title_str);
    label_str_check (&title_file);
    label_str_check (&label_offstr);

    UTILS_float3_from_str (label_offstr, labl_off);

    labl_clrs = GEOM_NULL;
    if (uni_color != NULL)
    {
        if (label_color (uni_color, in_cmap, colors) <= 0)
            uni_color = NULL;
        else
        {
            UTILS_float3_copy (colors, (colors+1));
            labl_clrs = colors;
        }
    }

    file = UTILS_file_name_check (&title_file, "r", "The labeler title file");

    use_titles = (title_str != NULL) || (file != NULL);

    labl_title = (title) && (use_titles);

    labl_ht    = *p_label_ht;
    labl_font  = (i_label_font > 0) ? i_label_font : 0;
    labl_bgflg = background;
    labl_dsflg = dropshadow;
    labl_stflg = stroke;

    labl_align = AVSchoice_number (parm_align, align_choice);
    labl_align = (labl_align < 2) ? GEOM_LABEL_LEFT :
                 (labl_align > 2) ? GEOM_LABEL_RIGHT : GEOM_LABEL_CENTER;

    labl_flags = GEOMcreate_label_flags (labl_font, labl_title,
                                         labl_bgflg, labl_dsflg,
                                         labl_align, labl_stflg);


    labl_obj   = GEOMcreate_label (GEOM_NULL, 0);
    pins_obj   = GEOM_NULL;


    if (use_titles)
    {
        UTILS_float3_set (0.0, 0.0, 0.0, labl_adj);
        UTILS_float3_copy (labl_off, labl_xyz);

        if (title_str != NULL)
        {
            label_add (labl_obj, title_str, labl_xyz, labl_adj, labl_ht,
                       labl_clrs, labl_flags, NULL, NULL);
        }

        if (file != NULL)
        {
            UTILS_float3_set (0.0, 0.0, 0.0, labl_off);

            while ((labl_str = UTILS_file_rec_read (file)) != NULL)
            {
                i = j = n = 0;
                while (labl_str[i] != '\0')
                    if (labl_str[i++] == '"') j = i, n++;

                if (n % 2)
                {
                    labl_str[j-1] = '\0';

                    nn = 0;
                    sscanf ((labl_str+j), "%f%f%f%n",
                            &labl_xyz[0], &labl_xyz[1], &labl_xyz[2], &nn);
                    j += nn;

                    while (isspace (labl_str[++j]));

                    if (labl_str[j] == '(')
                    {
                        while (isspace (labl_str[++j]));

                        if (labl_str[j] == '*')
                        {
                            UTILS_float3_from_str (label_offstr, labl_off);
                            j++;
                        }
                        else
                        {
                            sscanf ((labl_str+j), "%f%f%f%n",
                                    &labl_off[0], &labl_off[1], &labl_off[2],
                                    &nn);
                            j += nn;
                        }

                        while (labl_str[j++] != ')');

                        if (freeze) UTILS_geom_freeze_xyz (labl_off, NULL);

                        if ((show_pins) && (pins_obj == NULL))
                            pins_obj = GEOMcreate_obj (GEOM_POLYTRI, GEOM_NULL);

                        labl_title = FALSE;
                    }

                    sscanf ((labl_str+j), "%d%f%d%d%d%d%n",
                            &labl_font, &labl_ht, &labl_align,
                            &labl_bgflg, &labl_dsflg, &labl_stflg, &nn);
                    j += nn;

                    labl_align = (labl_align < 0) ? GEOM_LABEL_LEFT :
                                 (labl_align > 0) ? GEOM_LABEL_RIGHT :
                                 GEOM_LABEL_CENTER;

                    labl_flags = GEOMcreate_label_flags (labl_font,
                                                         labl_title,
                                                         labl_bgflg,
                                                         labl_dsflg,
                                                         labl_align,
                                                         labl_stflg);

                    if (label_color ((labl_str+j), in_cmap, colors) > 0)
                    {
                        if (labl_clrs == GEOM_NULL)
                        {
                            UTILS_float3_set (1.0, 1.0, 1.0, (colors+1));
                            for (i = 0; i < labl_obj->d.la.labels.n; i++)
                                GEOMadd_float_colors (labl_obj, (colors+1), 1,
                                                      GEOM_COPY_DATA);

                            labl_clrs = colors;
                        }
                        UTILS_float3_copy (colors, (colors+1));
                    }
               }

               label_add (labl_obj, labl_str, labl_xyz, labl_adj, labl_ht,
                          labl_clrs, labl_flags, pins_obj, labl_off);

            }
            fclose (file);
        }
    }

    else
    {
        UTILS_field_dims_get (in_field, &ndim, &dim[0], &dim[1], &dim[2]);
        nx = dim[0], ny = dim[1], nz = dim[2];
        nv = in_field->veclen;

        if (uni_color == NULL)
        {
            labl_clrs = colors;
            if ((in_cmap == NULL) || (nv > 1))
            {
                uni_color = (char *) -1L;
                labl_clrs = GEOM_NULL;
            }
        }

        labl_fac    = (*p_label_factor == 0.0) ? 1.0 : 1.0 / *p_label_factor;

        labl_prec   = (*p_label_prec <= 0.0) ? 1.0 :
                      (*p_label_prec >= 1.0) ? 1.0 : *p_label_prec;
        x           = log10 ((double) labl_prec);
        i           = -x;
        i           = (i < 0) ? 0 : (i > 9) ? 9 : i;
        labl_fm1[2] = labl_fm2[4] = i + 48;

        labl_vec    = (float *) malloc (nv * sizeof (float));


        if (AVSparameter_changed (parm_trans_file))
        {
            file = UTILS_file_name_check (&trans_file, "r",
                                          "The label value translation file");
            if (file != NULL)
            {
                n_table = UTILS_file_rec_count (file);
                table   = (trans_table *) malloc (n_table *
                                                  sizeof (trans_table));

                for (i = 0; i < n_table; i++)
                {
                    fscanf (file, "%f%f", &(table[i].lo), &(table[i].hi));
                    table[i].str = UTILS_file_rec_read (file);
                }
                fclose (file);
            }
            else
            {
                if (table != NULL)
                {
                    for (i = 0; i < n_table; i++)
                    {

/* IAC CODE CHANGE :                         if (table[i].str != NULL) free (table[i].str); */
                        if (table[i].str != NULL)  free(table[i].str);
                    }

/* IAC CODE CHANGE :                     free (table); */
                     free(table);
                    table   = NULL;
                    n_table = 0;
                }
            }
        }
        if (table == NULL) labl_str = str;

        if (freeze) UTILS_geom_freeze_xyz (labl_off, NULL);

        if ((show_pins) && (pins_obj == NULL))
            pins_obj = GEOMcreate_obj (GEOM_POLYTRI, GEOM_NULL);



        UTILS_field_pt_init (in_field);

        for (k = 0; k < nz; k++)
        {
            for (j = 0; j < ny; j++)
            {
                for (i = 0; i < nx; i++)
                {
                    UTILS_field_pt_xyz (i, j, k, labl_xyz);
                    UTILS_field_pt_vec (i, j, k, labl_vec);


                    x = labl_vec[0];

                    if (uni_color == NULL)
                    {
                        UTILS_color_rgb_from_value (in_cmap, x, labl_clrs);
                        UTILS_float3_copy (labl_clrs, (labl_clrs+1));
                    }

                    if (table != NULL)
                    {
                        labl_str = NULL;
                        for (iv = 0; iv < n_table; iv++)
                        {
                            if ((x >= table[iv].lo) && (x <= table[iv].hi))
                            {
                                labl_str = table[iv].str;
                                iv       = n_table;
                            }
                        }
                    }
                    else
                    {
                        x    = labl_vec[0] * labl_fac;
                        istr = 0;
                        istr += sprintf ((labl_str+istr), labl_fm1, x);
                        for (iv = 1; iv < nv; iv++)
                        {
                            x    = labl_vec[iv] * labl_fac;
                            istr += sprintf ((labl_str+istr), labl_fm2, x);
                        }
                    }

                    label_add (labl_obj, labl_str, labl_xyz, labl_adj, labl_ht,
                               labl_clrs, labl_flags, pins_obj, labl_off);
                }
            }
        }


/* IAC CODE CHANGE :         free (labl_vec); */
         free(labl_vec);
    }


    GEOMedit_geometry (*out_geom, labl_obj_name, labl_obj);
    GEOMdestroy_obj (labl_obj);

    if (pins_obj == NULL)
        GEOMedit_visibility (*out_geom, pins_obj_name, GEOM_EDIT_DELETE);
    else
    {
        GEOMedit_geometry (*out_geom, pins_obj_name, pins_obj);
        GEOMedit_parent (*out_geom, pins_obj_name, labl_obj_name);
        GEOMdestroy_obj (pins_obj);
    }



    return (1);
}



int		label_add (labl_obj, labl_str, labl_xyz, labl_adj, labl_ht,
                           labl_clrs, labl_flags, pins_obj, pins_off)

GEOMobj		*labl_obj;
char		*labl_str;
float		*labl_xyz, *labl_adj, labl_ht, *labl_clrs;
int		labl_flags;
GEOMobj		*pins_obj;
float		*pins_off;
{
    float	x;
    FLOAT3	pins_pts[2];

    if (labl_str ==     NULL) return (FALSE);
    if (labl_str[0] ==  '\0') return (FALSE);
    if (!(labl_flags & 0xff)) return (FALSE);
    if (labl_ht <=       0.0) return (FALSE);

    if (pins_off != NULL)
    {
        UTILS_float3_add (labl_xyz, pins_off);

        x           = labl_ht * 0.25;
        labl_adj[0] = (labl_flags & GEOM_LABEL_LEFT  ) ?  x :
                      (labl_flags & GEOM_LABEL_RIGHT ) ? -x : 0.0;
        x          *= 1.25;
        labl_adj[1] = (labl_flags & GEOM_LABEL_CENTER) ? x : -x;
        labl_adj[2] = 0.0;
    }

    GEOMadd_label (labl_obj, labl_str, labl_xyz, labl_adj, labl_ht, labl_clrs,
                   labl_flags);


    if (pins_obj != NULL)
    {
        if ((pins_off[0] != 0.0) ||
            (pins_off[1] != 0.0) ||
            (pins_off[2] != 0.0))
        {
            UTILS_float3_copy (labl_xyz, pins_pts);
            UTILS_float3_sub  (labl_xyz, pins_off);
            UTILS_float3_copy (labl_xyz, (pins_pts+1));

            GEOMadd_disjoint_line (pins_obj, pins_pts, labl_clrs, 2,
                                   GEOM_COPY_DATA);
        }
    }


    labl_xyz[1] -= labl_ht;


    return (TRUE);
}



int		label_color (str, cmap, color)

char		*str;
AVScolormap	*cmap;
float		*color;
{
    register int	n;
    register FLOAT3	rgb;

    if ((n = UTILS_float3_from_str (str, rgb)) > 0)
    {
        if (n == 3)
            UTILS_float3_copy (rgb, color);
        else
        {
            if (cmap == NULL)
                n = 0;
            else
                UTILS_color_rgb_from_value (cmap, rgb[0], color);
        }
    }

    return (n);
}



int		label_str_check (p_str)

char		**p_str;
{

    if (*p_str != NULL)
    {
        if ((*p_str)[0] == '\0') *p_str = NULL;
    }

    return (*p_str != NULL);
}
