/*******************************************************************************
 *
 *  These are a set of utility LAPS routines that can be used by 
 *  user-written AVS modules.
 *
 *	11 Dec 91  Phil McDonald, NOAA/ERL/FSL	Original version.
 *
 *	22 Sep 92  Phil McDonald		Added date/time string.
 *
 ******************************************************************************/



#include	"avs_utils.h"
#include	"laps_read.h"




/*******************************************************************************
 *
 *  Create a field from a LAPS file
 *
 */

AVSfield	*UTILS_laps_file_to_field (laps_file_name, p_p_datime)

char		*laps_file_name, **p_p_datime;
{
    register int	ierr, ivar;
    int			ndim, dims[3], nvar;
    char		**p_p_labels, **p_p_units;
    char		labels[AVS_FIELD_LABEL_LEN];
    char		units[AVS_FIELD_UNIT_LEN];
    float		*p_data;
    AVSfield		*field;

    ierr = laps_read (laps_file_name, &dims[0], &dims[1], &dims[2], &nvar,
                      &p_data, &p_p_labels, &p_p_units, p_p_datime);

    if (ierr != LAPS_READ_OK)
    {
        if (ierr == LAPS_READ_FORMAT_ERROR)
            AVSerror ("%s%s%s", "A format error occurred while reading ",
                      "LAPS product file\n\n", laps_file_name);
        else
            AVSerror ("%s%s%s", "An error occurred while reading ",
                      "LAPS product file\n\n", laps_file_name);
        return (NULL);
    }

    ndim = 3;
    while ((ndim > 0) && (dims[ndim-1] <= 1)) ndim--;

    field = UTILS_field_create (ndim, dims, 3, nvar, AVS_TYPE_REAL, UNIFORM);

    if (field == NULL) return (NULL);

    UTILS_field_copy_mem (field, p_data, NULL);
    free (p_data);

    UTILS_field_extents_find (field);

    if (p_p_labels != NULL)
    {
        labels[0] = '\0';
        for (ivar = 0; ivar < nvar; ivar++)
        {
            strcat (labels, p_p_labels[ivar]);
            if (ivar != nvar) strcat (labels, FIELD_LABELS_DELIMITER_STR);
        }
        AVSfield_set_labels (field, labels, FIELD_LABELS_DELIMITER_STR);
    }

    if (p_p_units != NULL)
    {
        units[0] = '\0';
        for (ivar = 0; ivar < nvar; ivar++)
        {
            strcat (units, p_p_units[ivar]);
            if (ivar != nvar) strcat (units, FIELD_UNITS_DELIMITER_STR);
        }
        AVSfield_set_units (field, units, FIELD_UNITS_DELIMITER_STR);
    }

    return (field);
}
