/*******************************************************************************
 *
 *  These are a set of utility mesh routines that can be used by 
 *  user-written AVS modules.
 *
 *	10 Apr 91  Phil McDonald, NOAA/ERL/FSL	Original version.
 *
 ******************************************************************************/



#include	"avs_utils.h"



/*******************************************************************************
 *
 *  Return the index (offset) to a point in a mesh.
 *
 */

int	UTILS_mesh_pt_index_get (nx, ix, jy)

int		nx, ix, jy;
{
    return ((jy * nx) + ix);
}



/*******************************************************************************
 *
 *  Return the 3D coordinates of a point in a mesh.
 *
 */

void	UTILS_mesh_pt_xyz_get (p_mesh_verts, nx, ix, jy, xyz)

FLOAT3		*p_mesh_verts;
int		nx, ix, jy;
FLOAT3		xyz;
{
    register int	i;

    i = UTILS_mesh_pt_index_get (nx, ix, jy);

    UTILS_float3_copy ((p_mesh_verts+i), xyz);

    return;
}



/*******************************************************************************
 *
 *  Add to a geometry object those polygons that make up an X-plane cross
 *  section of a mesh.  The top or bottom of these polygons will be on 
 *  the surface of the mesh; the opposite end will have z values of ZBASE. 
 *
 */

void	UTILS_mesh_xsectx_add (p_mesh_verts, p_colors, nx, ixplane, iy1, iy2, 
                               norm, zbase, geom_obj)

FLOAT3		*p_mesh_verts, *p_colors;
int		nx, ixplane, iy1, iy2, norm;
float		zbase;
GEOMobj		*geom_obj;
{
    register FLOAT3	pt1, pt2, verts[4];
    register int	ix, iy, iylast, iyinc, i1, i2;

    ix     = ixplane;
    iy     = iy1;
    iylast = iy2;
    iyinc  = (iy2 < iy1) ? -1 : 1;

    if (norm > 0)
        i1 = 1, i2 = 3;
    else
        i1 = 3, i2 = 1;

    UTILS_mesh_pt_xyz_get (p_mesh_verts, nx, ix, iy, pt1);
    while (iy != iylast)
    {
        iy += iyinc;
        UTILS_mesh_pt_xyz_get (p_mesh_verts, nx, ix, iy, pt2);
        UTILS_float3_copy (pt1, (verts));
        UTILS_float3_set (pt2[0], pt2[1], zbase, (verts+2));
        if (pt2[2] <= zbase)
        {
            UTILS_float3_copy (pt2, (verts+i1));
            UTILS_float3_set (pt1[0], pt1[1], zbase, (verts+i2));
        }
        else
        {
            UTILS_float3_set (pt1[0], pt1[1], zbase, (verts+i1));
            UTILS_float3_copy (pt2, (verts+i2));
        }
        GEOMadd_disjoint_polygon (geom_obj, verts, GEOM_NULL, p_colors, 4, 
                                  GEOM_NOT_SHARED | GEOM_CONVEX,
                                  GEOM_COPY_DATA);
        UTILS_float3_copy (pt2, pt1);
    }

    return;
}




/*******************************************************************************
 *
 *  Add to a geometry object those polygons that make up a Y-plane cross
 *  section of a mesh.  The top or bottom of these polygons will be on 
 *  the surface of the mesh; the opposite end will have z values of ZBASE. 
 *
 */

void	UTILS_mesh_xsecty_add (p_mesh_verts, p_colors, nx, iyplane, ix1, ix2, 
                               norm, zbase, geom_obj)

FLOAT3		*p_mesh_verts, *p_colors;
int		nx, iyplane, ix1, ix2, norm;
float		zbase;
GEOMobj		*geom_obj;
{
    register FLOAT3	pt1, pt2, verts[4];
    register int	iy, ix, ixlast, ixinc, i1, i2;

    iy     = iyplane;
    ix     = ix1;
    ixlast = ix2;
    ixinc  = (ix2 < ix1) ? -1 : 1;

    if (norm > 0)
        i1 = 1, i2 = 3;
    else
        i1 = 3, i2 = 1;

    UTILS_mesh_pt_xyz_get (p_mesh_verts, nx, ix, iy, pt1);
    while (ix != ixlast)
    {
        ix += ixinc;
        UTILS_mesh_pt_xyz_get (p_mesh_verts, nx, ix, iy, pt2);
        UTILS_float3_copy (pt1, (verts));
        UTILS_float3_set (pt2[0], pt2[1], zbase, (verts+2));
        if (pt2[2] <= zbase)
        {
            UTILS_float3_copy (pt2, (verts+i1));
            UTILS_float3_set (pt1[0], pt1[1], zbase, (verts+i2));
        }
        else
        {
            UTILS_float3_set (pt1[0], pt1[1], zbase, (verts+i1));
            UTILS_float3_copy (pt2, (verts+i2));
        }
        GEOMadd_disjoint_polygon (geom_obj, verts, GEOM_NULL, p_colors, 4, 
                                  GEOM_NOT_SHARED | GEOM_CONVEX,
                                  GEOM_COPY_DATA);
        UTILS_float3_copy (pt2, pt1);
    }

    return;
}
