/*******************************************************************************
 *
 *  These are a set of utility vertex chain routines that can be used by 
 *  user-written AVS modules.
 *
 *	13 Mar 92  Phil McDonald, NOAA/ERL/FSL	Original version.
 *
 *	05 Apr 93  Phil McDonald		Rehab everything.
 *
 ******************************************************************************/



#include	"avs_utils.h"



/*******************************************************************************
 *
 *  Add a vertex to the chain.
 *
 */

int	UTILS_vchain_add (xyz, rgb)

FLOAT3		*xyz, *rgb;
{
    UTILS_float3_copy (xyz, (vchain_pts+vchain_npts));
    if (vchain_rgb != NULL)
        UTILS_float3_copy (rgb, (vchain_rgb+vchain_npts));

    vchain_npts++;

    return (vchain_npts);
}



/*******************************************************************************
 *
 *  Copy the vertices from the chain list into the chain hunk.
 *
 */

int	UTILS_vchain_copy (p_pts, p_rgb, n)

FLOAT3		*p_pts, *p_rgb;
int		n;
{

    register int		n_bytes, n_copy, n_left;
    register FLOAT3		*p_data;

    if (p_pts == NULL)
    {
        p_pts = vchain_pts;
        p_rgb = vchain_rgb;
        n     = vchain_npts;
    }

    while (n > 0)
    {
        if (vchain_nhunk == VCHAIN_HUNK_SIZE)
        {
            vchain_ptot->next = (CHAIN *) calloc (1, sizeof (CHAIN));
            vchain_ptot       = vchain_ptot->next;
            vchain_ptot->data = malloc (VCHAIN_HUNK_SIZE * sizeof (FLOAT3));
            vchain_ptot->next = NULL;

            if (vchain_ctot != NULL)
            {
               vchain_ctot->next = (CHAIN *) calloc (1, sizeof (CHAIN));
               vchain_ctot       = vchain_ctot->next;
               vchain_ctot->data = malloc (VCHAIN_HUNK_SIZE * sizeof (FLOAT3));
               vchain_ctot->next = NULL;
            }

            vchain_nhunk = 0;
        }

        n_left = VCHAIN_HUNK_SIZE - vchain_nhunk;
        n_copy = (n <= n_left) ? n : n_left;
        n_bytes = n_copy * sizeof (FLOAT3);

        p_data = ((FLOAT3 *)(vchain_ptot->data)) + vchain_nhunk;
        memcpy (p_data, p_pts, n_bytes);
        p_pts += n_copy;

        if (vchain_ctot != NULL)
        {
            p_data = ((FLOAT3 *)(vchain_ctot->data)) + vchain_nhunk;
            memcpy (p_data, p_rgb, n_bytes);
            p_rgb += n_copy;
        }

        vchain_nhunk += n_copy;
        vchain_ntot  += n_copy;

        n -= n_copy;
    }

    vchain_npts = 0;
    vchain_pts  = vchain_pts1;
    vchain_rgb  = vchain_rgb1;


    return (vchain_ntot);
}



/*******************************************************************************
 *
 *  Convert a vertex chain to chain of disjoint line vertices.
 *
 */

int	UTILS_vchain_disjoint ()

{

    register int		n_pts, i;
    register FLOAT3		*p_pts, *p_rgb;

    if (vchain_npts <  2) vchain_npts = 0;
    if (vchain_npts <= 2) return (vchain_npts);

    p_pts = vchain_pts1;
    p_rgb = vchain_rgb1;
    n_pts = vchain_npts;

    vchain_pts  = vchain_pts2;
    vchain_rgb  = vchain_rgb2;
    vchain_npts = 0;

    n_pts--;

    if (p_rgb == NULL)
    {
        for (i = 0; i < n_pts; )
        {
            UTILS_vchain_add (p_pts, p_rgb);
            i++, p_pts++;
            UTILS_vchain_add (p_pts, p_rgb);
        }
    }
    else
    {
        for (i = 0; i < n_pts; )
        {
            UTILS_vchain_add (p_pts, p_rgb);
            i++, p_pts++, p_rgb++;
            UTILS_vchain_add (p_pts, p_rgb);
        }
    }


    return (vchain_npts);
}



/*******************************************************************************
 *
 *  Initialize a vertex chain.
 *
 */

int	UTILS_vchain_init (n_pts, p_colors)

int		n_pts;
float		*p_colors;
{
    int		n_bytes;

    n_bytes = n_pts * sizeof (FLOAT3);

    vchain_pts1 = (FLOAT3 *) malloc (n_bytes);
    vchain_pts2 = (FLOAT3 *) malloc (n_bytes);
    vchain_pts  = vchain_pts1;

    vchain_ptot       = (CHAIN *) calloc (1, sizeof (CHAIN));
    vchain_ptot->data = malloc (VCHAIN_HUNK_SIZE * sizeof (FLOAT3));
    vchain_ptot->next = NULL;

    vchain_rgb  = vchain_rgb1 = vchain_rgb2 = NULL;
    vchain_ctot = NULL;
    if (p_colors != NULL)
    {
        vchain_rgb1 = (FLOAT3 *) malloc (n_bytes);
        vchain_rgb2 = (FLOAT3 *) malloc (n_bytes);
        vchain_rgb  = vchain_rgb1;

        vchain_ctot       = (CHAIN *) calloc (1, sizeof (CHAIN));
        vchain_ctot->data = malloc (VCHAIN_HUNK_SIZE * sizeof (FLOAT3));
        vchain_ctot->next = NULL;
    }

    vchain_pbeg = vchain_ptot;
    vchain_cbeg = vchain_ctot;

    vchain_npts = vchain_ntot = vchain_nhunk = 0;


    return (vchain_npts);
}



/*******************************************************************************
 *
 *  Sort the vertices in a vertex chain.
 *
 */

int	UTILS_vchain_sort (xyz1, xyz2, i_coord)

FLOAT3		xyz1, xyz2;
int		i_coord;
{

    register int		i, j, n_pts, m_pts, ixy, jxy;
    register float		dixy, djxy;
    register FLOAT3		*p_pts, *p_rgb;

    p_pts = vchain_pts;
    p_rgb = vchain_rgb;
    n_pts = vchain_npts;
    m_pts = n_pts - 1;

    if (p_pts == NULL) return (vchain_npts);
    if (n_pts <=    1) return (vchain_npts);

    ixy = i_coord, jxy = 1 - ixy;

    if (xyz1[ixy] == xyz2[ixy]) return (vchain_npts);

    if (xyz1[ixy] < xyz2[ixy])
    {
        for (i = 0; i < m_pts; i++)
        {
            for (j = i + 1; j < n_pts; j++)
            {
                dixy = p_pts[j][ixy] - p_pts[i][ixy];
                djxy = p_pts[j][jxy] - p_pts[i][jxy];

                if ((fabs ((double) dixy) < VCHAIN_PT_FUZZ) &&
                    (fabs ((double) djxy) < VCHAIN_PT_FUZZ))
                {
                    n_pts--, m_pts--;
                    UTILS_float3_copy ((p_pts+n_pts), (p_pts+j));
                    if (p_rgb != NULL)
                        UTILS_float3_copy ((p_rgb+n_pts), (p_rgb+j));
                    j--;
                }
                else if (dixy < 0.0)
                {
                    UTILS_float3_swap ((p_pts+i), (p_pts+j));
                    if (p_rgb != NULL)
                        UTILS_float3_swap ((p_rgb+i), (p_rgb+j));
                }
            }
        }
    }
    else
    {
        for (i = 0; i < m_pts; i++)
        {
            for (j = i + 1; j < n_pts; j++)
            {
                dixy = p_pts[j][ixy] - p_pts[i][ixy];
                djxy = p_pts[j][jxy] - p_pts[i][jxy];

                if ((fabs ((double) dixy) < VCHAIN_PT_FUZZ) &&
                    (fabs ((double) djxy) < VCHAIN_PT_FUZZ))
                {
                    n_pts--, m_pts--;
                    UTILS_float3_copy ((p_pts+n_pts), (p_pts+j));
                    if (p_rgb != NULL)
                        UTILS_float3_copy ((p_rgb+n_pts), (p_rgb+j));
                    j--;
                }
                else if (dixy > 0.0)
                {
                    UTILS_float3_swap ((p_pts+i), (p_pts+j));
                    if (p_rgb != NULL)
                        UTILS_float3_swap ((p_rgb+i), (p_rgb+j));
                }
            }
        }
    }

    vchain_npts = n_pts;


    return (vchain_npts);
}



/*******************************************************************************
 *
 *  Copy a vertex chain from the hunk into the specified vertex list.
 *
 */

int	UTILS_vchain_to_vlist (p_vlist, p_colors)

GEOMvert_list	*p_vlist, *p_colors;
{
    register int	n_bytes, n_copy;
    register FLOAT3	*p_v, *p_c;

    n_bytes = vchain_ntot * sizeof (FLOAT3);

    free (p_vlist->l);
    p_vlist->l = (float *) malloc (n_bytes);
    p_vlist->n = vchain_ntot;
    p_v        = (FLOAT3 *) p_vlist->l;
    p_c        = NULL;

    if (p_colors != NULL)
    {
        free (p_colors->l);
        p_colors->l = (float *) malloc (n_bytes);
        p_colors->n = vchain_ntot;
        p_c         = (FLOAT3 *) p_colors->l;
    }

    vchain_ptot = vchain_pbeg;
    vchain_ctot = vchain_cbeg;
    while (vchain_ntot > 0)
    {
        n_copy  = (vchain_ntot < VCHAIN_HUNK_SIZE) ? vchain_ntot :
                                                     VCHAIN_HUNK_SIZE;
        n_bytes = n_copy * sizeof (FLOAT3);

        memcpy (p_v, vchain_ptot->data, n_bytes);
        p_v += n_copy;

        free (vchain_ptot->data);
        vchain_pbeg = vchain_ptot->next;
        free (vchain_ptot);
        vchain_ptot = vchain_pbeg;

        if (vchain_ctot != NULL)
        {
            memcpy (p_c, vchain_ctot->data, n_bytes);
            p_c += n_copy;

            free (vchain_ctot->data);
            vchain_cbeg = vchain_ctot->next;
            free (vchain_ctot);
            vchain_ctot = vchain_cbeg;
        }

        vchain_ntot -= n_copy;
    }


    free (vchain_pts1), free (vchain_pts2);
    vchain_pts  = vchain_pts1 = vchain_pts2 = NULL;
    vchain_ptot = vchain_pbeg = NULL;

    if (vchain_ctot != NULL)
    {
        free (vchain_rgb1), free (vchain_rgb2);
        vchain_rgb = vchain_rgb1 = vchain_rgb2 = NULL;
        vchain_ctot = vchain_cbeg = NULL;
    }

    vchain_ntot = vchain_npts = vchain_nhunk = 0;


    return (vchain_ntot);
}
