/****************************************************************************/
/*
 *  These functions convert values from VAX (VMS) values.
 */



#include	"vax_convert.h"



/****************************************************************************/
/*
 *  Convert VAX FORTRAN INTEGER*2 to short int
 */

short int	vax_i2_to_int (p_vax_i2)

short int	*p_vax_i2;
{
    register unsigned char	*byte, btmp;

    byte = (unsigned char *) p_vax_i2;

    btmp = byte[0], byte[0] = byte[1], byte[1] = btmp;


    return (*p_vax_i2);
}



/****************************************************************************/
/*
 *  Convert VAX FORTRAN INTEGER*4 to long int
 */

long int	vax_i4_to_int (p_vax_i4)

long int	*p_vax_i4;
{
    register unsigned char	*byte, btmp;

    byte = (unsigned char *) p_vax_i4;

    btmp = byte[0], byte[0] = byte[3], byte[3] = btmp;
    btmp = byte[1], byte[1] = byte[2], byte[2] = btmp;


    return (*p_vax_i4);
}



/****************************************************************************/
/*
 *  Convert VAX FORTRAN REAL*4 to IEEE 754 float
 */

float		vax_r4_to_float (p_vax_r4)

float		*p_vax_r4;
{
    register unsigned char	*byte, btmp;
    register int		exp;

    byte = (unsigned char *) p_vax_r4;

    btmp = byte[0], byte[0] = byte[1], byte[1] = btmp;
    btmp = byte[2], byte[2] = byte[3], byte[3] = btmp;

    exp = ((byte[0] & 0x7f) << 1) | ((byte[1] & 0x80) >> 7);
    if (exp != 0) exp -= 2;

    byte[0] = (byte[0] & 0x80) | ((exp >> 1) & 0x7f);
    byte[1] = (byte[1] & 0x7f) | ((exp << 7) & 0x80);


    return (*p_vax_r4);
}



/****************************************************************************/
/*
 *  Convert VAX FORTRAN G format REAL*8 to IEEE 754 double
 */

double		vax_g8_to_double (p_vax_g8)

double		*p_vax_g8;
{
    register unsigned char	*byte, btmp;
    register int		exp;

    byte = (unsigned char *) p_vax_g8;

    btmp = byte[0], byte[0] = byte[1], byte[1] = btmp;
    btmp = byte[2], byte[2] = byte[3], byte[3] = btmp;
    btmp = byte[4], byte[4] = byte[5], byte[5] = btmp;
    btmp = byte[6], byte[6] = byte[7], byte[7] = btmp;

    exp = ((byte[0] & 0x7f) << 4) | ((byte[1] & 0xf0) >> 4);
    if (exp != 0) exp -= 2;

    byte[0] = (byte[0] & 0x80) | ((exp >> 4) & 0x7f);
    byte[1] = (byte[1] & 0x0f) | ((exp << 4) & 0xf0);


    return (*p_vax_g8);
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN INTEGER*2 to short int
 */

void		vax_i2_to_int_blk (p_vax_i2, n_i2)

short int	*p_vax_i2;
long int	n_i2;
{
    register short int	*p_int;
    register long int	n;

    p_int = p_vax_i2;
    n     = n_i2;

    while (n-- > 0) vax_i2_to_int (p_int++);


    return;
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN INTEGER*4 to long int
 */

void		vax_i4_to_int_blk (p_vax_i4, n_i4)

long int	*p_vax_i4;
long int	n_i4;
{
    register long int	*p_int;
    register long int	n;

    p_int = p_vax_i4;
    n     = n_i4;

    while (n-- > 0) vax_i4_to_int (p_int++);


    return;
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN REAL*4 to IEEE 754 float
 */

void		vax_r4_to_float_blk (p_vax_r4, n_r4)

float		*p_vax_r4;
long int	n_r4;
{
    register float	*p_flt;
    register int long	n;

    p_flt = p_vax_r4;
    n     = n_r4;

    while (n-- > 0) vax_r4_to_float (p_flt++);


    return;
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN G format REAL*8 to IEEE 754 double
 */

void		vax_g8_to_double_blk (p_vax_g8, n_g8)

double		*p_vax_g8;
long int	n_g8;
{
    register double	*p_dbl;
    register long int	n;

    p_dbl = p_vax_g8;
    n     = n_g8;

    while (n-- > 0) vax_g8_to_double (p_dbl++);


    return;
}



/****************************************************************************/
/*
 *  Convert VAX FORTRAN INTEGER*2 from short int
 */

short int	vax_i2_from_int (p_vax_i2)

short int	*p_vax_i2;
{
    register unsigned char	*byte, btmp;

    byte = (unsigned char *) p_vax_i2;

    btmp = byte[0], byte[0] = byte[1], byte[1] = btmp;


    return (*p_vax_i2);
}



/****************************************************************************/
/*
 *  Convert VAX FORTRAN INTEGER*4 from long int
 */

long int	vax_i4_from_int (p_vax_i4)

long int	*p_vax_i4;
{
    register unsigned char	*byte, btmp;

    byte = (unsigned char *) p_vax_i4;

    btmp = byte[0], byte[0] = byte[3], byte[3] = btmp;
    btmp = byte[1], byte[1] = byte[2], byte[2] = btmp;


    return (*p_vax_i4);
}



/****************************************************************************/
/*
 *  Convert VAX FORTRAN REAL*4 from IEEE 754 float
 */

float		vax_r4_from_float (p_vax_r4)

float		*p_vax_r4;
{
    register unsigned char	*byte, btmp;
    register int		exp;

    byte = (unsigned char *) p_vax_r4;

    exp = ((byte[0] & 0x7f) << 1) | ((byte[1] & 0x80) >> 7);
    if (exp < 0xfe) exp += 2;

    byte[0] = (byte[0] & 0x80) | ((exp >> 1) & 0x7f);
    byte[1] = (byte[1] & 0x7f) | ((exp << 7) & 0x80);

    btmp = byte[0], byte[0] = byte[1], byte[1] = btmp;
    btmp = byte[2], byte[2] = byte[3], byte[3] = btmp;


    return (*p_vax_r4);
}



/****************************************************************************/
/*
 *  Convert VAX FORTRAN G format REAL*8 from IEEE 754 double
 */

double		vax_g8_from_double (p_vax_g8)

double		*p_vax_g8;
{
    register unsigned char	*byte, btmp;
    register int		exp;

    byte = (unsigned char *) p_vax_g8;

    btmp = byte[0], byte[0] = byte[1], byte[1] = btmp;
    btmp = byte[2], byte[2] = byte[3], byte[3] = btmp;
    btmp = byte[4], byte[4] = byte[5], byte[5] = btmp;
    btmp = byte[6], byte[6] = byte[7], byte[7] = btmp;

    exp = ((byte[0] & 0x7f) << 4) | ((byte[1] & 0xf0) >> 4);
    if (exp != 0) exp -= 2;

    byte[0] = (byte[0] & 0x80) | ((exp >> 4) & 0x7f);
    byte[1] = (byte[1] & 0x0f) | ((exp << 4) & 0xf0);


    return (*p_vax_g8);
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN INTEGER*2 from short int
 */

void		vax_i2_from_int_blk (p_vax_i2, n_i2)

short int	*p_vax_i2;
long int	n_i2;
{
    register short int	*p_int;
    register long int	n;

    p_int = p_vax_i2;
    n     = n_i2;

    while (n-- > 0) vax_i2_from_int (p_int++);


    return;
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN INTEGER*4 from long int
 */

void		vax_i4_from_int_blk (p_vax_i4, n_i4)

long int	*p_vax_i4;
long int	n_i4;
{
    register long int	*p_int;
    register long int	n;

    p_int = p_vax_i4;
    n     = n_i4;

    while (n-- > 0) vax_i4_from_int (p_int++);


    return;
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN REAL*4 from IEEE 754 float
 */

void		vax_r4_from_float_blk (p_vax_r4, n_r4)

float		*p_vax_r4;
long int	n_r4;
{
    register float	*p_flt;
    register int long	n;

    p_flt = p_vax_r4;
    n     = n_r4;

    while (n-- > 0) vax_r4_from_float (p_flt++);


    return;
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN G format REAL*8 from IEEE 754 double
 */

void		vax_g8_from_double_blk (p_vax_g8, n_g8)

double		*p_vax_g8;
long int	n_g8;
{
    register double	*p_dbl;
    register long int	n;

    p_dbl = p_vax_g8;
    n     = n_g8;

    while (n-- > 0) vax_g8_from_double (p_dbl++);


    return;
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN INTEGER*2 to short int
 *  (FORTRAN-callable)
 */

void		vax_i2_to_int_blk_ (p_vax_i2, p_n_i2)

short int	*p_vax_i2;
long int	*p_n_i2;
{
    vax_i2_to_int_blk (p_vax_i2, *p_n_i2);

    return;
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN INTEGER*4 to long int
 *  (FORTRAN-callable)
 */

void		vax_i4_to_int_blk_ (p_vax_i4, p_n_i4)

long int	*p_vax_i4;
long int	*p_n_i4;
{
    vax_i4_to_int_blk (p_vax_i4, *p_n_i4);

    return;
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN REAL*4 to IEEE 754 float
 *  (FORTRAN-callable)
 */

void		vax_r4_to_float_blk_ (p_vax_r4, p_n_r4)

float		*p_vax_r4;
long int	*p_n_r4;
{
    vax_r4_to_float_blk (p_vax_r4, *p_n_r4);

    return;
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN G format REAL*8 to IEEE 754 double
 *  (FORTRAN-callable)
 */

void		vax_g8_to_double_blk_ (p_vax_g8, p_n_g8)

double		*p_vax_g8;
long int	*p_n_g8;
{
    vax_g8_to_double_blk (p_vax_g8, *p_n_g8);

    return;
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN INTEGER*2 from short int
 *  (FORTRAN-callable)
 */

void		vax_i2_from_int_blk_ (p_vax_i2, p_n_i2)

short int	*p_vax_i2;
long int	*p_n_i2;
{
    vax_i2_from_int_blk (p_vax_i2, *p_n_i2);

    return;
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN INTEGER*4 from long int
 *  (FORTRAN-callable)
 */

void		vax_i4_from_int_blk_ (p_vax_i4, p_n_i4)

long int	*p_vax_i4;
long int	*p_n_i4;
{
    vax_i4_from_int_blk (p_vax_i4, *p_n_i4);

    return;
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN REAL*4 from IEEE 754 float
 *  (FORTRAN-callable)
 */

void		vax_r4_from_float_blk_ (p_vax_r4, p_n_r4)

float		*p_vax_r4;
long int	*p_n_r4;
{
    vax_r4_from_float_blk (p_vax_r4, *p_n_r4);

    return;
}



/****************************************************************************/
/*
 *  Convert a block of VAX FORTRAN G format REAL*8 from IEEE 754 double
 *  (FORTRAN-callable)
 */

void		vax_g8_from_double_blk_ (p_vax_g8, p_n_g8)

double		*p_vax_g8;
long int	*p_n_g8;
{
    vax_g8_from_double_blk (p_vax_g8, *p_n_g8);

    return;
}
