/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

Author:  "insert name" (if users state on release form that they wish to
remain anonymous, a control number will be placed at this location)
Modifications:  Who modified, date modified ( so donor does not receive blame
if modifications made and passed on to others do not work as described)
******************************************************************************/
/*
################################################################################

                               DISCLAIMER
                             
This source was prepared as an account of work sponsored by an agency of the
United States Government. Neither the United States Government nor the 
University of California nor any of their employees, makes any warrenty,
expressed or implied, or assumes any liability or responsibility for the
accuracy, completeness, or usefulness of any information, apparatus, product,
or process disclosed, or represents that its specific commercial products,
process, or service by trade name, trademark, manufacturer, or otherwise, does
not necessarily constitute or imply its endorsement, recommendation, or favoring
by the United States Government or the University of California, and shall not
be used for advertising or product endorsement purposes.


################################################################################
*/

/*  
Module name: line 1D 

  Author:  Kathleen M. Dyer, Lawrence Livermore National Laboratory
  
This file contains the source for the module "line 1D".
It reads in a "field 1D 2-space or 3-space irregular" and produces a "line".
The line is a GEOM object composed of disjoint lines, the vertices of which
are determined from the grid points of the field.

This module was written so that an orthogonal slice of a 2D field could be
shown.

*/

#include <stdio.h>
#include "avs.h"
#include "field.h"
#include "geom.h"
/* #include "flow.h" */
#include "avs_data.h"

/**********************************************************************/

AVSinit_modules()
{
  int line_1D();

  AVSmodule_from_desc(line_1D);
	 
}
/**********************************************************************/

line_1D()
{
  int line_1D_compute();
  int in_port, out_port;

  /* Set the module name and type */
  AVSset_module_name("line 1D",MODULE_MAPPER);
	 
  /* Create input and output ports */
  in_port = AVScreate_input_port("Input Field","field 1D irregular", REQUIRED);
  out_port = AVScreate_output_port("geometry","geom");
  
  /* Call this subroutine to do the computation */
  AVSset_compute_proc(line_1D_compute);
}
/**********************************************************************/

line_1D_compute(input,output)
AVSfield *input;
GEOMedit_list **output;
{
  GEOMobj *line_obj;
  float pt_start[3], pt_end[3];
  float line_color[2][3], line_verts[2][3];
  int i, j, len;

  if (input->nspace != 2 && input->nspace != 3) {
    AVSerror("line 1D: must be 2-space or 3-space irregular field.");
    return(0);
  }

  *output     = (GEOMedit_list *)GEOMinit_edit_list(*output);
  line_obj    = GEOMcreate_obj(GEOM_POLYTRI, NULL);
  
  len = input->dimensions[0];

  line_color[0][0] = 1.0;
  line_color[0][1] = 1.0;
  line_color[0][2] = 1.0;

  line_color[1][0] = 1.0;
  line_color[1][1] = 1.0;
  line_color[1][2] = 1.0;

  switch(input->nspace) {
    case 2:
      for (i = 0; i < len - 1; i++) {
        line_verts[0][0] = input->points[i];         /* start */
        line_verts[0][1] = input->points[i + len];
        line_verts[0][2] = 0.0;

        line_verts[1][0] = input->points[i + 1];     /* end */
        line_verts[1][1] = input->points[i + len + 1];
        line_verts[1][2] = 0.0;

        GEOMadd_disjoint_line(line_obj,line_verts,line_color,2,GEOM_COPY_DATA);
      }

      break;
      
    
    case 3:
      for (i = 0; i < len - 1; i++) {
        line_verts[0][0] = input->points[i];         /* start */
        line_verts[0][1] = input->points[i + len];
        line_verts[0][2] = input->points[i + 2 * len];

        line_verts[1][0] = input->points[i + 1];     /* end */
        line_verts[1][1] = input->points[i + 1 + len];
        line_verts[1][2] = input->points[i + 1 + 2 * len];

        GEOMadd_disjoint_line(line_obj,line_verts,line_color,2,GEOM_COPY_DATA);
      }

      break;
    
    default : break;
    
  } /* end of switch */

  /* Add into the edit list */
  GEOMedit_geometry(*output, "line", line_obj);

  /* Now kill it all. */
  GEOMdestroy_obj(line_obj);


  return(1);
}

