/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/******************************************************************************/
/*
 *
 *  The Loop_Objects provides the capability of looping through, or animating,
 *  a number of objects.
 */



#include "avs_utils.h"



char		*loop_obj_name_make ();



typedef struct	_loop_obj {
			   int			first;
			   GEOMedit_list	edlist;
			   GEOMobj		*par_obj;
			   char			*par_name;
			   struct _loop_obj	*next, *prev;
			  } loop_obj;



char		in_geom_port[]   = "Input Geom";
char		out_geom_port[]  = "Output Geom";
char		parm_loop[]      = "loop";
char		parm_direction[] = "direction";
char		parm_object[]    = "current object ";
char		parm_num_obj[]   = "num of objects";
char		parm_speed[]     = "speed";
char		parm_dwell[]     = "dwell";
char		parm_clear[]     = "clear";

char		choice_separator[]  = "!";
char		direction_choices[] = "forward!reverse";



/******************************************************************************/

loop_objects_desc ()

{
    int		out_port, iparm;

    AVSset_module_name ("loop objects", MODULE_MAPPER);

    AVScreate_input_port (in_geom_port, "geom", MULTIPLE);

    out_port = AVScreate_output_port (out_geom_port, "geom");
    AVSautofree_output (out_port);

    AVSadd_parameter (parm_loop, "boolean", FALSE, FALSE, TRUE);

    iparm = AVSadd_parameter (parm_direction, "choice", "forward", 
                              direction_choices, choice_separator);
    AVSadd_parameter_prop (iparm, "width", "integer", 2);
    AVSadd_parameter_prop (iparm, "columns", "integer", 2);

    iparm = AVSadd_parameter (parm_object, "string", NULL_STR, NULL, NULL);
    AVSadd_parameter_prop (iparm, "width", "integer", 4);

    iparm = AVSadd_parameter (parm_num_obj, "integer", 0, 0, INT_UNBOUND);
    AVSconnect_widget (iparm, "typein_integer");
    AVSadd_parameter_prop (iparm, "width", "integer", 4);

    iparm = AVSadd_float_parameter (parm_speed, 1.0, 0.0, 1.0);
    AVSconnect_widget (iparm, "slider");
    AVSadd_parameter_prop (iparm, "immediate", "boolean", TRUE);

    iparm = AVSadd_float_parameter (parm_dwell, 0.0, 0.0, 1.0);
    AVSconnect_widget (iparm, "slider");

    AVSadd_parameter (parm_clear, "oneshot", 0, 0, 0);

    return;
}



/******************************************************************************/
/*
 *  Inform AVS of the name of the description procedure for this module.
 *
 */


AVSinit_modules()
{
    AVSmodule_from_desc (loop_objects_desc);
    return ;
}



/******************************************************************************/
/*
 *  This is the main program for the Loop_Objects coroutine.
 */



main (argc, argv)

int	argc;
char	*argv[];

{
    int			loop_objects_desc();
    static char		loop_obj_name[] = "loop_objects" ;

    register int	i;
    int			i_obj, n_obj, m_obj;
    int			clear, loop, step, num_obj, i_int;
    int			forward;
    char		*dir_choice, *obj_choice, *name, *confirm;
    float		*p_speed, *p_dwell;
    GEOMedit_list	in_geom, out_geom;
    GEOMobj		*dummy_obj;

    loop_obj		*curr_obj, *frst_obj, *last_obj, *disp_obj;



    AVScorout_init (argc, argv, loop_objects_desc);
    AVScorout_wait ();



    forward   = TRUE;
    clear     = FALSE;
    loop      = FALSE;
    i_obj     = n_obj = m_obj = 0;
    curr_obj  = disp_obj = frst_obj = last_obj = NULL;

    dummy_obj = GEOMcreate_obj (GEOM_POLYTRI, GEOM_NULL);

    out_geom  = GEOM_NULL;


    FOREVER
    {

        curr_obj = NULL;
        step     = FALSE;


        if (!loop) AVScorout_wait ();

        AVScorout_input (&in_geom,
                         &loop,
                         &dir_choice,
                         &obj_choice,
                         &num_obj,
                         &p_speed,
                         &p_dwell,
                         &clear
                        );

        if (AVSinput_changed (in_geom_port, 0))
        {

            if ((in_geom != GEOM_NULL) && (in_geom->l != GEOM_NULL))
            {

                curr_obj = (loop_obj *) malloc (sizeof (loop_obj));

                if (curr_obj == NULL)

                    AVSerror ("%s%s", "Memory could not be allocated ",
                              "for another loop object.");

                else
                {

                    i_obj = ++n_obj;

                    AVSmodify_parameter (parm_num_obj, AVS_VALUE, n_obj,
                                         NULL, NULL);

                    m_obj++;    /* Num of obj input since last init */

                    curr_obj->first = TRUE;

                    curr_obj->par_obj  = GEOMcreate_obj (GEOM_POLYTRI,
                                                         GEOM_NULL);
                    curr_obj->par_name = loop_obj_name_make (loop_obj_name, 8,
                                                             m_obj);

                    curr_obj->edlist    = GEOMinit_edit_list (GEOM_NULL);
                    curr_obj->edlist->l = in_geom->l;
                    name = loop_obj_name_make (in_geom->l->name, 0, m_obj);

/* IAC CODE CHANGE :                     free (curr_obj->edlist->l->name); */

/* IAC CODE CHANGE :                      free(curr_obj->edlist->l->name); */
                      free(curr_obj->edlist->l->name);
                    curr_obj->edlist->l->name = name;
                    in_geom->l = GEOM_NULL;

                    if (frst_obj == NULL) frst_obj = curr_obj;
                    if (last_obj != NULL)
                    {
                        last_obj->next = curr_obj;
                        curr_obj->prev = last_obj;
                    }
                    last_obj       = curr_obj;
                    last_obj->next = frst_obj;
                    frst_obj->prev = last_obj;
                }
            }

        }    /* if in_geom changed */


        if (AVSparameter_changed (parm_loop))
        {

            if ((loop) && (n_obj < 2))
            {
                loop = FALSE;
                AVSmodify_parameter (parm_loop,  AVS_VALUE, loop, NULL, NULL);
            }

            i = (i_obj == 0) ? CHOICE_NONE_INT : i_obj;
            loop_obj_index_set (i);

        }    /* if loop changed */



        if (AVSparameter_changed (parm_direction))
        {

            i = AVSchoice_number (parm_direction, dir_choice);
            AVSmodify_parameter (parm_direction, AVS_VALUE,
                                 NULL_STR, NULL, NULL);

            if (i == 1)
            {
                forward = TRUE;
                AVSmodify_parameter (parm_direction, AVS_VALUE,
                                     "forward", NULL, NULL);
            }
            else
            {
                forward = FALSE;
                AVSmodify_parameter (parm_direction, AVS_VALUE,
                                     "reverse", NULL, NULL);
            }

            step = !loop;

        }    /* if direction changed */


        if (AVSparameter_changed (parm_object))
        {

            i_int = 0;
            if (obj_choice != NULL) sscanf (obj_choice, "%d", &i_int);
            if ((i_int > 0) && (i_int <= n_obj))
            {
                curr_obj = frst_obj;
                i_obj    = 0;
                while ((++i_obj) != i_int) curr_obj = curr_obj->next;
            }
            loop_obj_index_set (i_obj);

        }    /* if object changed */


        if (AVSparameter_changed (parm_num_obj))
        {

            AVSmodify_parameter (parm_num_obj, AVS_VALUE, n_obj, NULL, NULL);

        }    /* if num of objects changed */


        if (AVSparameter_changed (parm_clear))
        {

            if (loop)
            {
                confirm = AVSmessage (NULL, AVS_Warning, NULL,
                                      "Loop_Objects compute function",
                                      "No!Yes", "%s%s",
                                      "Do you really want to clear all ",
                                      "of the loop objects ?");
                if (strcmp (confirm, "Yes") != 0) clear = FALSE;
            }

            if (clear)
            {

                if ((loop) || (n_obj == 1))
                {
                    disp_obj = frst_obj;
                    while (n_obj > 0)
                    {
                        curr_obj = disp_obj->next;
                        loop_obj_destroy (disp_obj);
                        disp_obj = curr_obj;
                        n_obj--;
                    }
                    curr_obj = disp_obj = frst_obj = last_obj = NULL;
                    m_obj    = 0;

                    loop_obj_index_set (CHOICE_NONE_INT);

                    loop = FALSE;
                    AVSmodify_parameter (parm_loop, AVS_VALUE, loop,
                                         NULL, NULL);
                }
                else
                {
                    if (n_obj > 1)
                    {
                        n_obj--;

                        curr_obj = disp_obj;
                        loop_obj_next_obj (&curr_obj, &i_obj, n_obj, forward);
                        if ((forward) && (i_obj > 1)) i_obj--;

                        if (disp_obj == frst_obj) frst_obj = frst_obj->next;
                        if (disp_obj == last_obj) last_obj = last_obj->prev;

                        disp_obj->next->prev = disp_obj->prev;
                        disp_obj->prev->next = disp_obj->next;

                        loop_obj_index_set (i_obj);
                    }
                }

                AVSmodify_parameter (parm_num_obj, AVS_VALUE, n_obj,
                                     NULL, NULL);
            }

        }    /* if clear changed */






        if (n_obj > 0)
        {
            if (curr_obj == NULL)
            {
                curr_obj = disp_obj;
                if (loop || step)
                {
                    loop_obj_next_obj (&curr_obj, &i_obj, n_obj, forward);
                    loop_obj_index_set (i_obj);

                }

            }
            else
            {
                loop_obj_index_set (i_obj);
            }
        }


        if ((curr_obj != disp_obj) || (clear))
        {

            out_geom  = GEOMinit_edit_list (out_geom);
            GEOMedit_geometry (out_geom, loop_obj_name, dummy_obj);

            if ((clear) && (n_obj == 0))
                GEOMedit_visibility (out_geom, loop_obj_name, 
                                     GEOM_EDIT_DELETE);

            if (disp_obj != NULL)
            {
                GEOMedit_geometry (out_geom, disp_obj->par_name,
                                   disp_obj->par_obj);
                if (clear)
                {
                    GEOMedit_visibility (out_geom, disp_obj->par_name,
                                         GEOM_EDIT_DELETE);
                    loop_obj_destroy (disp_obj);
                }
                else
                    GEOMedit_visibility (out_geom, disp_obj->par_name,
                                         GEOM_EDIT_INVIS);
            }

            if (curr_obj != NULL)
            {
                GEOMedit_geometry (out_geom, curr_obj->par_name,
                                   curr_obj->par_obj);
                GEOMedit_visibility (out_geom, curr_obj->par_name,
                                     GEOM_EDIT_VIS);
                GEOMedit_parent (out_geom, curr_obj->par_name, loop_obj_name);
                if (curr_obj->first)
                {
                    curr_obj->first = FALSE;

                    GEOMedit_geometry (out_geom, curr_obj->edlist->l->name,
                                       curr_obj->edlist->l->data);
                    GEOMedit_parent (out_geom, curr_obj->edlist->l->name,
                                     curr_obj->par_name);
                }
            }

            if (loop) AVScorout_exec ();

            AVScorout_output (out_geom);


            if (loop)
            {
                loop_obj_pause ((1.0 - (*p_speed)));

                if ((( forward) && (curr_obj == last_obj)) ||
                    ((!forward) && (curr_obj == frst_obj)))
                    loop_obj_pause ((*p_dwell));
            }

            disp_obj = curr_obj;

            clear = FALSE;

        }    /* if (curr_obj != disp_obj) */

    }    /* FOREVER */


/*
    return;
*/

}



/******************************************************************************/

loop_obj_destroy (p_obj)

loop_obj	*p_obj;
{

    GEOMdestroy_edit_list (p_obj->edlist);
    GEOMdestroy_obj (p_obj->par_obj);

/* IAC CODE CHANGE :     free (p_obj->par_name); */

/* IAC CODE CHANGE :      free(p_obj->par_name); */
      free(p_obj->par_name);

/* IAC CODE CHANGE :     free (p_obj); */

/* IAC CODE CHANGE :      free(p_obj); */
      free(p_obj);


    return;
}



/******************************************************************************/

loop_obj_index_set (i_obj)

int	i_obj;
{
    char	index_str[11];

    if (i_obj == CHOICE_NONE_INT)
        index_str[0] = '\0';
    else
        sprintf (index_str, "%d", i_obj);

    AVSmodify_parameter (parm_object, AVS_VALUE, index_str, NULL, NULL);

    return;
}



/******************************************************************************/

char	*loop_obj_name_make (name_base, n, i_obj)

char		*name_base;
int		n;
int		i_obj;
{
    char		*name;

    if (n <= 0) n = strlen (name_base);
    name = (char *) malloc (n + 5);
    strncpy (name, name_base, n);
    sprintf (&name[n], "_%d\0", i_obj);
    return (name);
}



/******************************************************************************/

loop_obj_next_obj (p_p_obj, p_i_obj, n_obj, forward)

loop_obj	**p_p_obj;
int		*p_i_obj, n_obj, forward;
{
    if (forward)
    {
        *p_p_obj = (*p_p_obj)->next;
        (*p_i_obj)++;
        if (*p_i_obj > n_obj) *p_i_obj = 1;
    }
    else
    {
        *p_p_obj = (*p_p_obj)->prev;
        (*p_i_obj)--;
        if (*p_i_obj < 1) *p_i_obj = n_obj;
    }

    return;
}



/******************************************************************************/

loop_obj_pause (count)

float		count;
{
    float		time_factor = 5.0e+6;
    register int	i;

    for (i = 0; i < (count * time_factor); i++);

    return;
}
