/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/**********************************************************************
 *
 *	file name: 	mesh_slicer.c
 *
 *	description:	create mesh lines in a slice plane to show
 *			the grid of the field.
 *
 *     			Copyright (c) 1991 by 
 *			KUBOTA COMPUTER INC.
 *			All Rights Reserved
 *
 **********************************************************************/

#include <stdio.h>
#include <avs/field.h>
#include <avs/avs.h>
#include <avs/avs_math.h>
#include <avs/field.h>
#include <avs/geom.h>

typedef float   FLOAT3[3];


/**********************************************************************
 *
 *	function name: 	AVSinit_modules
 *
 *	description:	initialize
 *
 **********************************************************************/

AVSinit_modules()
{
    int             mesh_desc();


    AVSmodule_from_desc(mesh_desc);
}



/**********************************************************************
 *
 *	function name: 	mesh_desc
 *
 *	description:	description function
 *
 **********************************************************************/

mesh_desc()
{
    int             mesh_slicer();
    int             param1, param2, param3;


    AVSset_module_name("mesh slicer", MODULE_MAPPER);
    AVScreate_input_port("INPUT", "field 3D", REQUIRED);
    AVScreate_output_port("Geom", "geom");
    AVSadd_parameter("I", "boolean", 1, 0, 1);
    AVSadd_parameter("J", "boolean", 0, 0, 1);
    AVSadd_parameter("K", "boolean", 0, 0, 1);
    param1 = AVSadd_parameter("I Slice Plane", "integer", 0, 0, 100);
    param2 = AVSadd_parameter("J Slice Plane", "integer", 0, 0, 100);
    param3 = AVSadd_parameter("K Slice Plane", "integer", 0, 0, 100);
    AVSadd_parameter_prop(param1, "immediate", "boolean", 1);
    AVSadd_parameter_prop(param2, "immediate", "boolean", 1);
    AVSadd_parameter_prop(param3, "immediate", "boolean", 1);

    AVSset_compute_proc(mesh_slicer);
}



/**********************************************************************
 *
 *	function name: 	mesh_slicer
 *
 *	description:	computation function
 *
 *	input:	input			    field structure
 *		i_flag, j_flag, k_flag	    display or not
 *		planei, planej, planek      plane number	
 *
 *	output:	output
 *
 *	return:	0/1
 *
 **********************************************************************/
static
mesh_slicer(input, output, i_flag, j_flag, k_flag, planei, planej, planek)
    AVSfield       *input;
    GEOMedit_list  *output;
    int             planei, planej, planek, i_flag, j_flag, k_flag;
{
    int             i, j, k, l, iz, jz, kz;
    int             start;
    int             size3id;
    int             size3jd;
    int             size2kd, size3kd;

    int             sliceix, sliceiy;
    int             slicejx, slicejy;
    int             slicekx, sliceky;

    static float    rcolor[3] = {1.0, 0.0, 0.0};
    static float    gcolor[3] = {0.0, 1.0, 0.0};
    static float    bcolor[3] = {0.0, 0.0, 1.0};

    static int      i_st = 1;
    static int      j_st = 0;
    static int      k_st = 0;

    float           extent[6];

    register FLOAT3 *points1, *points2, *points3;
    GEOMobj        *obj1, *obj2, *obj3;


    *output = NULL;

    sliceix = MAXZ(input);
    sliceiy = MAXY(input);
    iz = MAXX(input) - 1;
    size3id = MAXX(input) * MAXY(input) * MAXZ(input);

    slicejx = MAXX(input);
    slicejy = MAXZ(input);
    jz = MAXY(input) - 1;
    size3jd = MAXX(input) * MAXY(input) * MAXZ(input);

    slicekx = MAXX(input);
    sliceky = MAXY(input);
    kz = MAXZ(input) - 1;
    size2kd = slicekx * sliceky;
    size3kd = MAXX(input) * MAXY(input) * MAXZ(input);

    if (i_flag)
	AVSmodify_parameter("I Slice Plane", AVS_VALUE | AVS_MAXVAL, 
					planei, 0, iz);
    if (j_flag)
	AVSmodify_parameter("J Slice Plane", AVS_VALUE | AVS_MAXVAL, 
					planej, 0, jz);
    if (k_flag)
	AVSmodify_parameter("K Slice Plane", AVS_VALUE | AVS_MAXVAL, 
					planek, 0, kz);

    if (planei > iz)
	planei = iz;
    if (planej > jz)
	planej = jz;
    if (planek > kz)
	planek = kz;

    /* Modify the slice plane widter to match the new incoming data */
    if (AVSparameter_changed("I Slice Plane") != 0) {
	if (i_flag)
	    AVSmodify_parameter("I Slice Plane", AVS_MAXVAL | AVS_VALUE, 					planei, 0, iz);
    }
    if (AVSparameter_changed("J Slice Plane") != 0) {
	if (j_flag)
	    AVSmodify_parameter("J Slice Plane", AVS_MAXVAL | AVS_VALUE, 
			planej, 0, jz);
    }
    if (AVSparameter_changed("K Slice Plane") != 0) {
	if (k_flag)
	    AVSmodify_parameter("K Slice Plane", AVS_MAXVAL | AVS_VALUE, 	
			planek, 0, kz);
    }

    *output = GEOMinit_edit_list(*output);

    /* copy points */
    switch (input->uniform) {
    case IRREGULAR:
	if (i_flag) {
	    i = planei;
	    points1 = (FLOAT3 *) malloc(size3id * 3 * sizeof(float));
	    for (j = 0; j < sliceiy; j++) {
		for (k = 0; k < sliceix; k++) {
		    l = (MAXX(input) * ((MAXY(input) * k) + j)) + i;
		    points1[j * sliceix + k][0] = input->points[l];
		    points1[j * sliceix + k][1] 
					= input->points[l + size3id];
		    points1[j * sliceix + k][2] 
					= input->points[l + size3id * 2];
		}
	    }
	    obj1 = GEOMcreate_mesh_with_data(NULL, points1, NULL, NULL, 
			sliceix, sliceiy, GEOM_COPY_DATA);
	    GEOMgen_normals(obj1, 0);
	    GEOMedit_geometry(*output, "mesh1", obj1);
	    GEOMedit_render_mode(*output, "mesh1", "lines");
	    GEOMedit_color(*output, "mesh1", rcolor);
	    GEOMdestroy_obj(obj1);
	    i_st = 1;
	}
	if (j_flag) {
	    j = planej;
	    points2 = (FLOAT3 *) malloc(size3jd * 3 * sizeof(float));
	    for (k = 0; k < slicejy; k++) {
		for (i = 0; i < slicejx; i++) {
		    points2[k * slicejx + i][0] 
					= COORD_X_3D(input, i, j, k);
		    points2[k * slicejx + i][1] 
					= COORD_Y_3D(input, i, j, k);
		    points2[k * slicejx + i][2] 
					= COORD_Z_3D(input, i, j, k);
		}
	    }
	    obj2 = GEOMcreate_mesh_with_data(NULL, points2, NULL, NULL, 
			slicejx, slicejy, GEOM_COPY_DATA);
	    GEOMgen_normals(obj2, 0);
	    GEOMedit_geometry(*output, "mesh2", obj2);
	    GEOMedit_render_mode(*output, "mesh2", "lines");
	    GEOMedit_color(*output, "mesh2", gcolor);
	    GEOMdestroy_obj(obj2);
	    j_st = 1;
	}
	if (k_flag) {
	    points3 = (FLOAT3 *) malloc(size3kd * 3 * sizeof(float));
	    start = planek * MAXX(input) * MAXY(input);
	    for (i = 0; i < size2kd; i++) {
		points3[i][0] = input->points[start + i];
		points3[i][1] = input->points[start + i + size3kd];
		points3[i][2] = input->points[start + i + 2 * size3kd];
	    }
	    obj3 = GEOMcreate_mesh_with_data(NULL, points3, NULL, NULL, 
			slicekx, sliceky, GEOM_COPY_DATA);
	    GEOMgen_normals(obj3, 0);
	    GEOMedit_geometry(*output, "mesh3", obj3);
	    GEOMedit_render_mode(*output, "mesh3", "lines");
	    GEOMedit_color(*output, "mesh3", bcolor);
	    GEOMdestroy_obj(obj3);
	    k_st = 1;
	}
	break;

    case RECTILINEAR:
	if (i_flag) {
	    i = planei;
	    points1 = (FLOAT3 *) malloc(size3id * 3 * sizeof(float));
	    for (k = 0; k < sliceiy; k++) {
		for (j = 0; j < sliceix; j++) {
		    l = (MAXX(input) * ((MAXY(input) * k) + j)) + i;
		    points1[k * sliceix + j][0] = input->points[i];
		    points1[k * sliceix + j][1] 
					= input->points[MAXX(input) + k];
		    points1[k * sliceix + j][2] =
			input->points[MAXX(input) + MAXY(input) + j];
		}
	    }
	    obj1 = GEOMcreate_mesh_with_data(NULL, points1, NULL, NULL, 
			sliceix, sliceiy, GEOM_COPY_DATA);
	    GEOMgen_normals(obj1, 0);
	    GEOMedit_geometry(*output, "mesh1", obj1);
	    GEOMedit_render_mode(*output, "mesh1", "lines");
	    GEOMedit_color(*output, "mesh1", rcolor);
	    GEOMdestroy_obj(obj1);
	    i_st = 1;
	}
	if (j_flag) {
	    j = planej;
	    points2 = (FLOAT3 *) malloc(size3jd * 3 * sizeof(float));
	    for (k = 0; k < slicejy; k++) {
		for (i = 0; i < slicejx; i++) {
		    points2[k * slicejx + i][0] = input->points[i];
		    points2[k * slicejx + i][1] 
			= input->points[MAXX(input) + j];
		    points2[k * slicejx + i][2] 
			= input->points[MAXX(input) + MAXY(input) + k];
		}
	    }
	    obj2 = GEOMcreate_mesh_with_data(NULL, points2, NULL, NULL, 
			slicejx, slicejy, GEOM_COPY_DATA);
	    GEOMgen_normals(obj2, 0);
	    GEOMedit_geometry(*output, "mesh2", obj2);
	    GEOMedit_render_mode(*output, "mesh2", "lines");
	    GEOMedit_color(*output, "mesh2", gcolor);
	    GEOMdestroy_obj(obj2);
	    j_st = 1;
	}
	if (k_flag) {
	    k = planek;
	    points3 = (FLOAT3 *) malloc(size3kd * 3 * sizeof(float));
	    for (j = 0; j < sliceky; j++) {
		for (i = 0; i < slicekx; i++) {
		    points3[j * slicekx + i][0] = input->points[i];
		    points3[j * slicekx + i][1] 
			= input->points[MAXX(input) + j];
		    points3[j * slicekx + i][2] 
			= input->points[MAXX(input) + MAXY(input) + k];
		}
	    }
	    obj3 = GEOMcreate_mesh_with_data(NULL, points3, NULL, NULL,
			slicekx, sliceky, GEOM_COPY_DATA);
	    GEOMgen_normals(obj3, 0);
	    GEOMedit_geometry(*output, "mesh3", obj3);
	    GEOMedit_render_mode(*output, "mesh3", "lines");
	    GEOMedit_color(*output, "mesh3", bcolor);
	    GEOMdestroy_obj(obj3);
	    k_st = 1;
	}
	break;

    case UNIFORM:
	UTILget_world_coords(&extent[0], &extent[2], &extent[4],
			     0, 0, 0, input);
	UTILget_world_coords(&extent[1], &extent[3], &extent[5],
		MAXX(input) - 1, MAXY(input) - 1, MAXZ(input) - 1, input);
	if (i_flag) {
	    i = planei;
	    points1 = (FLOAT3 *) malloc(size3id * 3 * sizeof(float));

	    for (j = 0; j < sliceiy; j++) {
		for (k = 0; k < sliceix; k++) {
		    points1[j * sliceix + k][0] = extent[0] +
			((extent[1] - extent[0]) / (MAXX(input) - 1)) * i;
		    points1[j * sliceix + k][1] = extent[2] +
			((extent[3] - extent[2]) / (MAXY(input) - 1)) * j;
		    points1[j * sliceix + k][2] = extent[4] +
			((extent[5] - extent[4]) / (MAXZ(input) - 1)) * k;
		}
	    }
	    obj1 = GEOMcreate_mesh_with_data(NULL, points1, NULL, NULL, 
			sliceix, sliceiy, GEOM_COPY_DATA);
	    GEOMgen_normals(obj1, 0);
	    GEOMedit_geometry(*output, "mesh1", obj1);
	    GEOMedit_render_mode(*output, "mesh1", "lines");
	    GEOMedit_color(*output, "mesh1", rcolor);
	    GEOMdestroy_obj(obj1);
	    i_st = 1;
	}
	if (j_flag) {
	    j = planej;
	    points2 = (FLOAT3 *) malloc(size3jd * 3 * sizeof(float));
	    for (k = 0; k < slicejy; k++) {
		for (i = 0; i < slicejx; i++) {
		    points2[k * slicejx + i][0] = extent[0] +
			((extent[1] - extent[0]) / (MAXX(input) - 1)) * i;
		    points2[k * slicejx + i][1] = extent[2] +
			((extent[3] - extent[2]) / (MAXY(input) - 1)) * j;
		    points2[k * slicejx + i][2] = extent[4] +
			((extent[5] - extent[4]) / (MAXZ(input) - 1)) * k;
		}
	    }
	    obj2 =
		GEOMcreate_mesh_with_data(NULL, points2, NULL, NULL, 
			slicejx, slicejy, GEOM_COPY_DATA);
	    GEOMgen_normals(obj2, 0);
	    GEOMedit_geometry(*output, "mesh2", obj2);
	    GEOMedit_render_mode(*output, "mesh2", "lines");
	    GEOMedit_color(*output, "mesh2", gcolor);
	    GEOMdestroy_obj(obj2);
	    j_st = 1;
	}
	if (k_flag) {
	    k = planek;
	    points3 = (FLOAT3 *) malloc(size3kd * 3 * sizeof(float));
	    for (j = 0; j < sliceky; j++) {
		for (i = 0; i < slicekx; i++) {
		    points3[j * slicekx + i][0] = extent[0] +
			((extent[1] - extent[0]) / (MAXX(input) - 1)) * i;
		    points3[j * slicekx + i][1] = extent[2] +
			((extent[3] - extent[2]) / (MAXY(input) - 1)) * j;
		    points3[j * slicekx + i][2] = extent[4] +
			((extent[5] - extent[4]) / (MAXZ(input) - 1)) * k;
		}
	    }
	    obj3 = GEOMcreate_mesh_with_data(NULL, points3, NULL, NULL, 
			slicekx, sliceky, GEOM_COPY_DATA);
	    GEOMgen_normals(obj3, 0);
	    GEOMedit_geometry(*output, "mesh3", obj3);
	    GEOMedit_render_mode(*output, "mesh3", "lines");
	    GEOMedit_color(*output, "mesh3", bcolor);
	    GEOMdestroy_obj(obj3);
	    k_st = 1;
	}
	break;

    default:
	break;
    }

    if ((i_flag == 0) && (j_flag == 0) && (k_flag == 0)
	&& (i_st == 0) && (j_st == 0) && (k_st == 0))
	return (0);
    if ((i_flag == 0) && (i_st == 1)) {
	GEOMedit_visibility(*output, "mesh1", -1);
	i_st = 0;
    }
    if ((j_flag == 0) && (j_st == 1)) {
	GEOMedit_visibility(*output, "mesh2", -1);
	j_st = 0;
    }
    if ((k_flag == 0) && (k_st == 1)) {
	GEOMedit_visibility(*output, "mesh3", -1);
	k_st = 0;
    }
    if (obj1)
	free(obj1);
    if (obj2)
	free(obj2);
    if (obj3)
	free(obj3);
    if (points1)
	free(points1);
    if (points2)
	free(points2);
    if (points3)
	free(points3);
    return (1);
}



/**********************************************************************
 *
 *	function name: 	UTILget_world_coords
 *
 *	description:	calculate world coordinates
 *
 *	input:	i, j, k		index of array of the field
 *		field		field structure
 *
 *	output:	world_x, world_y, world_z	world coordinates
 *
 *	return:
 *
 **********************************************************************/
UTILget_world_coords(world_x, world_y, world_z, i, j, k, field)
    float          *world_x, *world_y, *world_z;
    int             i, j, k;
    AVSfield       *field;
{
    float           ext[6];
    int             cnt;


    switch (field->uniform) {
    case RECTILINEAR:
    case IRREGULAR:
	*world_x = COORD_X_3D(field, i, j, k);
	*world_y = COORD_Y_3D(field, i, j, k);
	*world_z = COORD_Z_3D(field, i, j, k);
	break;

    case UNIFORM:
	if (field->nspace == 2) {
	    if ((field->points[0] == 0) && (field->points[1] == 0) &&
		(field->points[2] == 0) && (field->points[3] == 1)) {
		ext[0] = ext[2] = 0.0;
		ext[1] = (float) field->dimensions[0];
		ext[3] = (float) field->dimensions[1];
	    } else if ((field->points[0] == field->points[1]) &&
		       (field->points[2] == field->points[3])) {
		ext[0] = ext[2] = 0.0;
		ext[1] = (float) field->dimensions[0];
		ext[3] = (float) field->dimensions[1];
	    } else {
		for (cnt = 0; cnt < 4; cnt++)
		    ext[cnt] = field->points[cnt];
	    }

	    *world_x = ((float) i * (ext[1] - ext[0] + 1.0) /
			(float) field->dimensions[0]) + ext[0];
	    *world_y = ((float) j * (ext[3] - ext[2] + 1.0) /
			(float) field->dimensions[1]) + ext[2];
	    *world_z = (float) k;

	} else if (field->nspace == 3) {
	    if ((		/* first, test for old style settings */
		 (field->points[0] == 0) && (field->points[1] == 0) &&
		 (field->points[2] == 0) && (field->points[3] == 1) &&
		 (field->points[4] == 1) && (field->points[5] == 1)
		 ) || (		/* then, test for not set at all */
		       (field->points[0] == field->points[1]) &&
		       (field->points[2] == field->points[3]) &&
		       (field->points[4] == field->points[5]))
		) {
		ext[0] = ext[2] = ext[4] = 0.0;
		ext[1] = (float) field->dimensions[0];
		ext[3] = (float) field->dimensions[1];
		ext[5] = (float) field->dimensions[2];

	    } else {
		for (cnt = 0; cnt < 6; cnt++)
		    ext[cnt] = field->points[cnt];
	    }

	    if (ext[0] == ext[1]) {
		*world_x = ext[0];
		*world_y = ((float) j * (ext[3] - ext[2] + 1.0) /
			    (float) field->dimensions[1]) + ext[2];
		*world_z = ((float) k * (ext[5] - ext[4] + 1.0) /
			    (float) field->dimensions[0]) + ext[4];
	    } else if (ext[2] == ext[3]) {
		*world_x = ((float) i * (ext[1] - ext[0] + 1.0) /
			    (float) field->dimensions[0]) + ext[0];
		*world_y = ext[2];
		*world_z = ((float) k * (ext[5] - ext[4] + 1.0) /
			    (float) field->dimensions[1]) + ext[4];
	    } else if (ext[4] == ext[5]) {
		*world_x = ((float) i * (ext[1] - ext[0] + 1.0) /
			    (float) field->dimensions[0]) + ext[0];
		*world_y = ((float) j * (ext[3] - ext[2] + 1.0) /
			    (float) field->dimensions[1]) + ext[2];
		*world_z = ext[4];
	    } else {
		*world_x = ((float) i * (ext[1] - ext[0] + 1.0) /
			    (float) field->dimensions[0]) + ext[0];
		*world_y = ((float) j * (ext[3] - ext[2] + 1.0) /
			    (float) field->dimensions[1]) + ext[2];
		*world_z = ((float) k * (ext[5] - ext[4] + 1.0) /
			    (float) field->dimensions[2]) + ext[4];
	    }

	} else {
	    *world_x = COORD_X_3D(field, i, j, k);
	    *world_y = COORD_Y_3D(field, i, j, k);
	    *world_z = COORD_Z_3D(field, i, j, k);
	}
	break;
    }
}
