/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/******************************************************************************/
/*
 *  The Mesh_With_Base function will create a mesh surface from a 2D field
 *  and then add side and "bottom" planes to this mesh.  The result appears
 *  to be a solid volume.
 *
 */



#include "avs_utils.h"


char		parm_create_mesh[] = "create mesh";
char		parm_zscale[]      = "z scale factor";
char		parm_create_base[] = "create base";
char		parm_base_zval[]   = "base z value";
char		parm_base_color[]  = "base color";





mesh_with_base_desc ()
{
    int		mesh_with_base_compute ();
    int		out_port, iparm;

    AVSset_module_name ("mesh with base", MODULE_MAPPER);

    AVScreate_input_port ("Input Field", "field scalar", REQUIRED);

    AVScreate_input_port ("Input colormap", "colormap", OPTIONAL);

    out_port = AVScreate_output_port ("Output Geom", "geom");

    iparm = AVSadd_parameter (parm_create_mesh, "boolean", 1, 0, 1);
    AVSadd_parameter_prop (iparm, "width", "integer", 3);

    AVSadd_float_parameter (parm_zscale, 1.0, FLOAT_UNBOUND, FLOAT_UNBOUND);

    iparm = AVSadd_parameter (parm_create_base, "boolean", 1, 0, 1);
    AVSadd_parameter_prop (iparm, "width", "integer", 3);

    AVSadd_float_parameter (parm_base_zval, -1.0, FLOAT_UNBOUND, FLOAT_UNBOUND);

    AVSadd_parameter (parm_base_color, "integer", -1, -1, 255);

    AVSautofree_output (out_port);

    AVSset_compute_proc (mesh_with_base_compute);

    return;
}



/******************************************************************************/
/*
 *  Inform AVS of the name of the description procedure for this module.
 *
 */


AVSinit_modules()
{
    AVSmodule_from_desc (mesh_with_base_desc);
    return ;
}



mesh_with_base_compute (in_field, in_colormap, out_geom,
                        create_mesh, p_zscale, create_base, p_zbase, base_color)

AVSfield	*in_field;
AVScolormap	*in_colormap;
GEOMedit_list	*out_geom;
int		create_mesh;
float		*p_zscale;
int		create_base;
float		*p_zbase;
int		base_color;
{
    static char		mesh_obj_name[] = "mesh";
    static char		base_obj_name[] = "mesh base";

    register int	i, j, n;
    register int	nx, ny, nxy, mx, my, norm, nbase;
    register float	z, zscale, zbase, zmin, zmax;
    register FLOAT3	*p_verts;
    int			ndim, n0, n1, n2;
    FLOAT3		*verts, *colors, *base_pts;
    GEOMobj		*mesh_obj, *base_obj;



    *out_geom = NULL;

    if (in_field == NULL) return (1);

    zscale = *p_zscale;
    zbase  = *p_zbase;


    *out_geom = GEOMinit_edit_list (*out_geom);


    UTILS_field_dims_get (in_field, &ndim, &n0, &n1, &n2);
    nx  = n0;
    ny  = n1;
    nxy = nx * ny;
    mx  = nx - 1;
    my  = ny - 1;

    nbase = (ndim < 2) ? 0 :
            (in_field->uniform == UNIFORM) ? 4 : (nx + ny) * 2;

    n      = (nxy > nbase) ? nxy : nbase;
    verts  = (FLOAT3 *) malloc (n * sizeof(FLOAT3));
    colors = (in_colormap == GEOM_NULL) ? GEOM_NULL :
             (FLOAT3 *) malloc (n * sizeof(FLOAT3));



    UTILS_field_pt_init (in_field);

    zmin    = 1.0e+30, zmax = -1.0e+30;
    p_verts = verts;
    for (j = 0; j < ny; j++)
    {
        for (i = 0; i < nx; i++)
        {
            UTILS_field_pt_xyz (i, j, 0, p_verts);
            z = (*p_verts)[2] *= zscale;
            if (z < zmin) zmin = z;
            if (z > zmax) zmax = z;
            p_verts++;
        }
    }


    norm = 1;
    if (create_base)
    {
        if (zbase > zmin)
        {
            norm = -1;
            if (zbase >= zmax) mirror_y (verts, nx, ny);
        }
    }


    mesh_obj = GEOMcreate_mesh (GEOM_NULL, verts, nx, ny, GEOM_COPY_DATA);


    if (!create_mesh)
    {
        GEOMedit_geometry (*out_geom, mesh_obj_name, mesh_obj);
        GEOMedit_visibility (*out_geom, mesh_obj_name, GEOM_EDIT_DELETE);
    }

    else		/* Create mesh */
    {
        UTILS_color_rgb_from_field (in_colormap, in_field, &colors);
        if (zbase >= zmax) mirror_y (colors, nx, ny);
        GEOMadd_float_colors (mesh_obj, colors, nxy, GEOM_COPY_DATA);

        GEOMgen_normals (mesh_obj, 0);

        GEOMcvt_mesh_to_polytri (mesh_obj, GEOM_SURFACE | GEOM_WIREFRAME);


        GEOMedit_geometry (*out_geom, mesh_obj_name, mesh_obj);
    }
    GEOMdestroy_obj (mesh_obj);



    base_obj = GEOMcreate_obj (GEOM_POLYHEDRON, GEOM_NULL);


    if (!create_base)
    {
        GEOMedit_geometry (*out_geom, base_obj_name, base_obj);
        GEOMedit_visibility (*out_geom, base_obj_name, GEOM_EDIT_DELETE);
    }

    else		/* Create base */
    {
        if (base_color < 0)
        {

/* IAC CODE CHANGE :             if (colors != GEOM_NULL) free (colors); */
            if (colors != GEOM_NULL)  free(colors);
            colors = GEOM_NULL;
        }

        if (colors != GEOM_NULL)
        {
            n = (nxy > nbase) ? nxy : nbase;
            for (i = 0; i < n; i++)
                UTILS_color_rgb_from_index (in_colormap, base_color,
                                            (colors+i));
        }


        if (nbase > 0)
        {

            if ((zbase > zmin) && (zbase < zmax)) mirror_y (verts, nx, ny);

            base_pts = (FLOAT3 *) malloc (nbase * sizeof (FLOAT3));

            if (in_field->uniform == UNIFORM)
            {
                UTILS_mesh_pt_xyz_get (verts, nx,  0,  0, (base_pts));
                UTILS_mesh_pt_xyz_get (verts, nx,  0, my, (base_pts+1));
                UTILS_mesh_pt_xyz_get (verts, nx, mx, my, (base_pts+2));
                UTILS_mesh_pt_xyz_get (verts, nx, mx,  0, (base_pts+3));
            }
            else		/* RECTILINEAR or IRREGULAR */
            {
                n = 0;
                for (j = 0; j < ny; j++, n++)
                    UTILS_mesh_pt_xyz_get (verts, nx,  0,  j, (base_pts+n));
                for (i = 0; i < nx; i++, n++)
                    UTILS_mesh_pt_xyz_get (verts, nx,  i, my, (base_pts+n));
                for (j = my; j >= 0; j--, n++)
                    UTILS_mesh_pt_xyz_get (verts, nx, mx,  j, (base_pts+n));
                for (i = mx; i >= 0; i--, n++)
                    UTILS_mesh_pt_xyz_get (verts, nx,  i,  0, (base_pts+n));
            }

            for (i = 0; i < nbase; i++) base_pts[i][2] = zbase;

            GEOMadd_disjoint_polygon (base_obj, base_pts, GEOM_NULL,
                                      colors, nbase,
                                      GEOM_COMPLEX | GEOM_NOT_SHARED,
                                      GEOM_COPY_DATA);

/* IAC CODE CHANGE :             free (base_pts); */
             free(base_pts);
        }


        UTILS_mesh_xsecty_add (verts, colors, nx, 0, 0, mx, norm, zbase,
                               base_obj);
        UTILS_mesh_xsecty_add (verts, colors, nx, my, mx, 0, norm, zbase,
                               base_obj);
        UTILS_mesh_xsectx_add (verts, colors, nx, 0, my, 0, norm, zbase,
                               base_obj);
        UTILS_mesh_xsectx_add (verts, colors, nx, mx, 0, my, norm, zbase,
                               base_obj);


        GEOMgen_normals (base_obj, 0);

        GEOMcvt_polyh_to_polytri (base_obj, GEOM_SURFACE | GEOM_WIREFRAME);

        GEOMedit_geometry (*out_geom, base_obj_name, base_obj);
    }
    GEOMdestroy_obj (base_obj);


    return (1);
}



mirror_y (xyz, nx, ny)

FLOAT3		*xyz;
int		nx, ny;
{
    register FLOAT3	*p_xyz, *p_tmp, tmp3;
    register int	i, n, n1, n2;

    p_xyz = xyz;
    n1    = nx, n2 = nx + nx;
    n     = (ny - 1) * nx;
    while (n > 0)
    {
        p_tmp = p_xyz + n;
        for (i = 0; i < n1; i++)
        {
            UTILS_float3_copy (p_tmp, tmp3);
            UTILS_float3_copy (p_xyz, p_tmp);
            UTILS_float3_copy (tmp3, p_xyz);
            p_xyz++, p_tmp++;
        }
        n -= n2;
    }


    return;
}
