/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

 AUTHOR : Lawrence Berkeley Laboratory
******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce polygon.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  polygon.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  polygon.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     polygon.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
polygon.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/

#include <stdio.h>
#include "defs.h"
#include "stuff.h"


typedef struct Poly
{			
   int npoints;
   Point *ptslist;
   Point Normal;
   Flt D;		/* the D in Ax + By + Cz + D = 0 */
} Poly;

static double scratch[8][2];   /* polygons may have at most 8 sides!!!!! */

#ifdef LINT_ARGS
char *PolyName(Prim *);
void PolyPrint(Prim *);
Prim *PolyRead(FILE *);
int PolyIntersect(Ray *, Prim *, Isect *);
void PolyNormal(Prim *, Point, Point);
void PolyUV(Prim *, Ray *, Isect *, Flt);
#else
char *PolyName();
void PolyPrint();
Prim *PolyRead();
int PolyIntersect();
void PolyNormal();
void PolyUV();
#endif

#define UNDEFINED -1234567.89

static PrimProcs PolyProcs = 
{ PolyName, PolyPrint, PolyRead, PolyIntersect, PolyNormal, PolyUV };

void PolyUV(prim,ray,isect,T)
Prim *prim;
Ray *ray;
Isect *isect;
Flt T;
{
    Flt X,Y,Z;
    Poly *p;
    Point *ptlist;
    Point P0,P1,P2,P3;
    extern int xRes;  /* resolution of image */
    double U,V;
    
    p = (Poly *)prim->info;
    ptlist = p->ptslist;
    VecCopy(*ptlist,P0);
    VecCopy(*(ptlist+1),P1);
    VecCopy(*(ptlist+2),P2);
    VecCopy(*(ptlist+3),P3);
    X = ray->P[0] + ray->D[0] * T;
    Y = ray->P[1] + ray->D[1] * T;

    find_uv(&X,&Y,&U,&V,P0,P1,P2,P3);

    isect->U = U;
    isect->V = V;
}

find_uv(X,Y,U,V,p0,p1,p2,p3)
double *X,*Y,*U,*V;
Point p0,p1,p2,p3;
{
    double a,b,c,d,e,f,g,h;
    double A,B,C;
    double u,v;
    extern double sqrt();

    a = p1[0]-p0[0];
    b = p0[0];
    c = p2[0]-p3[0];
    d = p3[0];
    e = p1[1]-p0[1];
    f = p0[1];
    g = p2[1]-p3[1];
    h = p3[1];
    A = (g-e)*(b-d) - (c-a)*(f-h);
    B = e*(b-d) + *X*(g-e) - b*(g-e) - a*(f-h) - *Y*(c-a) + f*(c-a);
    C = e*(*X-b) - a*(*Y-f);

    if (ABS(A) < 0.001)
	A = 0.0;
    if (A == 0.0)
    {
	v = -1.0*C/B;
    }
    else
    {
	v = B*B - 4.0*A*C;
	v = sqrt(v);
	u = (-1.0*B - v)/(2.0*A);
	if ((u < 0.0) || (u > 1.0))
	    u = (-1.0*B + v)/(2.0*A);
	v = u;
    }
    if ((a+v*(c-a)) == 0.0)
	u = (*Y + v*(f-h) - f)/(e+v*(g-e));
    else
	u = (*X + v*(b-d) - b)/(a+v*(c-a));

    /* the following deals with precision issues.  */
    if (u<0.0)
	u = 0.0;
    else if (u > 1.0)
	u = 1.0;

    if (v<0.0)
	v = 0.0;
    else if (v > 1.0)
	v = 1.0;

    *U = u;
    *V = v;
}


char *PolyName(prim)
Prim *prim;
{
   return("polygon");
}

void
PolyPrint(prim)
Prim *prim;
{
}

void
PolyNormal(prim, P, N)
Prim *prim;
Point P, N;
{
   VecCopy(((Poly *)prim->info)->Normal,N);
}

int
PolyIntersect(ray, prim,hit)
Ray *ray;
Prim *prim;
Isect **hit;
{
   Flt Vprd, Vpro, T;
   Poly *p;
   static int inside();
   Flt znot;
   Isect *Hit;
   int backside = 0;

   Hit = *hit;

   p = (Poly *)prim->info;

   Vprd = ray->D[0]*p->Normal[0] + ray->D[1]*p->Normal[1] + ray->D[2]*p->Normal[2];
   if (Vprd == 0.0)
      return(0);   /* ray and plane are parallel, don't intersect */
       Vpro = ray->P[0]*p->Normal[0] + ray->P[1]*p->Normal[1] + ray->P[2]*p->Normal[2];
   
   Vpro += p->D; 
   Vpro *= -1.0;
   T = Vpro / Vprd;
   if (T < 0.)
      return(0);   /* intersection behind ray origin. can't see it */
   if (T <= rayeps)
      return(0);   /* intersection at eye -- not a good thing */

/* calculate Z intersection point. */
   znot = ray->D[2]*T + ray->P[2];

   if (inside(T,ray,p->ptslist,p->npoints))
   {
       IsectAdd(Hit,T,prim,1,0,ray);
       Hit->backside = backside;
       Hit++;
       IsectAdd(Hit,T,prim,0,prim->surf,ray);
       Hit->backside = backside;
       Hit++;
       *hit = Hit;
       return(2);
   }
   *hit = Hit;
   return(0);
}

#define PARANOID(a) ((double)((int)((a)*1e3))/1e3)

static int
inside(T,ray,ptslist,npoints)
Flt T;
Ray *ray;
int npoints;
Point *ptslist;
{
   int nc=0, sh, nsh;
   int i,j;
   Point P;
   Point point;
   double xnot, ynot;

   /* calculate intersection point of ray with plane */

   P[0] = ray->P[0] + T*ray->D[0];
   P[1] = ray->P[1] + T*ray->D[1];

   /* project polygon into xy plane, translate by -P */

   for (i=0;i<npoints;i++)
   {
      VecCopy(*ptslist,point);
      xnot = point[0];
      ynot = point[1];
      scratch[i][0] = xnot - P[0] ;
      scratch[i][1] = ynot - P[1];
      if (scratch[i][1] == 0.0)
	  scratch[i][1] = 0.001;  /* some small nonzero value */
      ptslist++;
   }

   sh = (scratch[0][1] < 0.0) ? -1 : 1; 

   /* count edge intersections */

   for (i=0;i<npoints;i++)
   {
      j =  (i==npoints-1) ? 0 : i+1;
      nsh = (scratch[j][1] < 0.0) ? -1 : 1; 
/*      nsh = (scratch[j][1] <= 0.0) ? -1 : 1; */

      if (sh != nsh)
      {
         if ((scratch[i][0] > 0.0) && (scratch[j][0] > 0.0))
	    nc++;
         else if ((scratch[i][0] > 0.) || (scratch[j][0] > 0.))
         {
	     if ((scratch[i][0] - 
		 (scratch[i][1]*(scratch[j][0]-scratch[i][0])/
	         (scratch[j][1]-scratch[i][1]))) > 0.)
	        nc++;
         }
      }
      sh = nsh;
   }
   return(nc & 1);  
}



Prim *
PolyRead(f)
FILE *f;
{
   Prim *p, *getprim();
   char *getpoly();
   char buffer[256];
   Poly *s;
   Point *point, P1, P2, P3, t;
   int number_of_vertices,i;

   if ((p = getprim("polygon")) == NULL)
      return(NULL);

   if ((p->info = getpoly()) == NULL)
      return(NULL);

   make_identity_matrix(p->mat);

   s = (Poly *)p->info;
   fscanf(f,"%d",&number_of_vertices);
   if ((point = (Point *)malloc(sizeof(Point)*number_of_vertices)) == NULL)
   {
      printf(" Fatal error reading a polygon. out of memory. \n");
      return(NULL);
   }
   s->ptslist = point;
   s->npoints = number_of_vertices;
   fgets(buffer,256,f);
   for (i=0;i<number_of_vertices;i++)
   {
      fgets(buffer,256,f);
      sscanf(buffer,"%lf %lf %lf",&P1[0],&P1[1],&P1[2]);
      VecCopy(P1,*point);
      point++;
   }
/*   fgets(buffer,256,f);
   sscanf(buffer,"%lf %lf %lf %lf %lf %lf %lf",&p->surf->kdiff,&p->surf->kspec,&p->surf->ktran,&p->surf->color[0],&p->surf->color[1],&p->surf->color[2],&p->surf->refrindx); */
   p->procs = &PolyProcs;
   p->compflag = 0;

   /* compute polygon's normal*/

   point = s->ptslist;
   VecCopy(*point++,P1);
   VecCopy(*point++,P2);
   VecCopy(*point++,P3);

   VecCopy(P1,t);
  
   for (i=0;i<3;i++)
   {
       P1[i] = (P1[i]+P2[i])*0.5;
       P2[i] = (P2[i]+P3[i])*0.5;
       P3[i] = (t[i]+P3[i])*0.5;
   }


   for (i=0;i<3;i++)
   {
      P1[i] = P2[i] - P1[i];
      P2[i] = P3[i] - P2[i];
   }
   VecCrossProd(P1,P2,P3);
   VecUnit(P3,P3);
   VecCopy(P3,s->Normal);
   VecCopy(s->ptslist,P1);
   s->D = P1[0]*P3[0] + P1[1]*P3[1] + P1[2]*P3[2];
   s->D *= -1.0; 
   return(p);
}

char *
getpoly()
{
   char *c;

   if ((c = (char *)malloc(sizeof(struct Poly))) == NULL)
      printf(" ERROR -- malloc in getpoly() failed. \n");
   return(c);
}

void    print_info(X,Y,P0,P1,P2,P3,iumin,ivmin,iumax,ivmax)
double *X,*Y;
double iumin,ivmin,iumax,ivmax;
Point P0,P1,P2,P3;
{
    int i;
    fprintf(stderr," X,Y : %g %g \n",*X,*Y);
    fprintf(stderr," umin,vmin umax,vmax : %g %g %g %g\n",iumin,ivmin,iumax,ivmax);
    fprintf(stderr,"P0:\n");
    for (i=0;i<3;i++)
	fprintf(stderr," %g ",P0[i]);
    fprintf(stderr,"\nP1:\n");
    for (i=0;i<3;i++)
	fprintf(stderr," %g ",P1[i]);
    fprintf(stderr,"\nP2:\n");
    for (i=0;i<3;i++)
	fprintf(stderr," %g ",P2[i]);
    fprintf(stderr,"\nP3:\n");
    for (i=0;i<3;i++)
	fprintf(stderr," %g ",P3[i]);
}

void
vec_unit_2(p)
Point p;
{
    extern double sqrt();
    double mag;

    mag = sqrt((p[0]*p[0])+(p[1]*p[1]));
    mag = 1./mag;
    p[0] *= mag;
    p[1] *= mag;

}
