/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce raymain.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  raymain.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  raymain.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     raymain.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
raymain.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/

#include <stdio.h>
#include "defs.h"
#include "stuff.h"

Prim *modelroot;	/* root of the csg tree, contains entire scene */
int  xRes=Xres, yRes = Yres, halfXres;
#define DEFAULT_ANTIALIAS_LEVEL 8
unsigned char *Vdata;
int Xwidth,Yheight,Zdepth,totalsize,XYsize,Xsize;

raytrace_volume(vdata,imgdata,antialias_toggle,imgdims,voldims,f)
unsigned char *vdata;
IMAGE_TYPE *imgdata;
int antialias_toggle;
int *imgdims,*voldims;
FILE *f;
{
   Prim *readobjs();
   void screen();
   void Load_Scene_Lights();
   DISPLAY d;
   extern void srandrom();
   short s_width,s_height;
   int anti;

   modelroot = readobjs(f);

   xRes = *imgdims++;
   yRes = *imgdims;
   
   if (antialias_toggle != 0)
   {
       anti = DEFAULT_ANTIALIAS_LEVEL;
       srandom(255);  /* initialize random number gen. w seed=255 */
   }
   else
       anti = 0;
   
   d.xres = xRes;
   d.yres = yRes;
   s_width = (short)xRes;
   s_height = (short)yRes;
   Vdata = vdata;
   Xwidth= *voldims++;
   Yheight= *voldims++;
   Zdepth= *voldims;;
   XYsize = Xwidth*Yheight*4;
   Xsize=Xwidth*4;
   totalsize = Xwidth*Yheight*Zdepth;

   halfXres = xRes >> 1;
   
   screen(imgdata,&d,anti);   /* all other vars are global */

   free_objs();
}

IsectAdd(hit,t,prim,enterexit,s,r)
Isect *hit;
Flt t;
Prim *prim;
int enterexit;
Surf *s;
Ray *r;
{
    extern double sqrt();
    double x,y,z;
    
    hit->t = t;
    hit->prim = prim;
    hit->enter = enterexit;
    hit->medium = s;
    hit->backside = 0;

    x = r->P[0] + t*r->D[0];
    y = r->P[1] + t*r->D[1];
    z = r->P[2] + t*r->D[2];
    (*(prim->procs->uv))(prim, r, hit, t);  
}

/* 
   misc stuff for reading scene file 
*/
Prim *PolyRead();
Prim *UndefObj();
#define MAXOBJTYPES 2 
static Prim *(*fptr[MAXOBJTYPES])() =
{  
   PolyRead,
   UndefObj
};
Prim *list[MAXOBJECTS];


free_objs()
{
    int i;

    i=0;
    for(i=0;i<MAXOBJECTS;i++)
    {
	if (list[i] == NULL)
	    break;

/* IAC CODE CHANGE : 	free((char *)list[i]); */

/* IAC CODE CHANGE : 	 free(list[i]); */

/* IAC CODE CHANGE : 	  free(list[i]); */
	   free(list[i]);
    }
}

/**
  * the strategy for dealing with the volume data is to define a
  * six-faced parallelpiped which defines the boundaries of the
  * volume of data.  all ray intersections will occur initially with
  * this hull.
  *
  * the rotations, translations and scalings of the volume occur
  * external to this code.
**/
Prim *
readobjs(f)
FILE *f;
{
   int i, opcode,junk;
   Prim *temp;
   char junkbuf[80];

   for (i=0;i<MAXOBJECTS;i++)
      list[i++] = NULL;

   i = 0;

   while (!(feof(f)))
   {
      fscanf(f,"%d",&opcode);
      if (opcode < 0)
	 return(list[0]);
      if ((temp = (*fptr[opcode])(f)) != NULL)
	 list[i++] = temp;
      else
	 printf(" Fatal error reading, etc. object type %d \n",opcode);
   }
   return(list[0]);
}

Prim *
UndefObj(f)
FILE *f;
{
   char c, s[255];

   printf(" An undefined object type encountered in input file. Skipping line.\n");
   while ((!feof(f)) && ((c=getc(f))!='\n'))
      ;
   fscanf(f,"\n");

}
