/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

 AUTHOR : Lawrence Berkeley Laboratory
******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce hull.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  hull.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  hull.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     hull.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
hull.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/

#include <stdio.h>
#include <math.h>
#include <avs/avs.h>
#include <avs/field.h>
#include "gmatrix.h"
#include "defs.h"

static double xscale,yscale;
static double LIMIT;
vector4 verts[4];

#define RENDER_MODE_COMPOSITE 0
#define RENDER_MODE_DESTRUCTIVE 1

/**
  * NOTE: this routine assumes the ordering of the points as defined
  * in volfaces.c.  Changing something there will necessitate a change
  * here.  The problem is that a couple of faces are defined using
  * a reverse ordering of the vertices.  This routine will try to
  * figure out which faces "face away" from the viewer, and will
  * composite the hull defined by those faces rather than by
  * destructively rendering it.
**/
render_hull(img,f,anti)
AVS_IMAGE_FIELD *img;
FILE *f;
int anti;
{
    int type,num_verts,i,j;
    Point v,w;
    Point a0,a1,a2;
    int render_mode;
    int num_faces,k;

    if (anti)
	LIMIT = 0.5;
    else
	LIMIT = 1.0;

    setup_view_xform(img);

    fscanf(f,"%d",&type);
    
    num_faces = 6;  /* test -- max of 6 faces. */
    
    for (k=0;k<num_faces;k++)
    {
	if (type == 0) /* polygon */
	{
	    fscanf(f,"%d",&num_verts);
	    for (i=0;i<num_verts;i++)
	    {
		for (j=0;j<3;j++)
		    fscanf(f,"%lf",&(verts[i].v[j]));
		verts[i].v[3] = 1.0;
	    }
	    /**
	      * the following hack is designed to align the
	      * volume hull with the volume as "seen" by the
	      * ray tracer.  this is accomplished by translating
	      * the entire hull by the distance between the
	      * ray origin and the volume origin.  in our
	      * case, this is hard coded in some other file to
	      * 0 0 -3.
	    **/

	    for (i=0;i<num_verts;i++)
	    {
		verts[i].v[2] = verts[i].v[2] - 1.0;
	    }

	    /* compute polygon normal.  if it's facing away,
	       then we'll composite it into the image.  if it's
	       facing the viewer, then we'll destructively render
	       it into the image */

	    for (i=0;i<2;i++)
	    {
		a0[i] = verts[0].v[i];
		a1[i] = verts[1].v[i];
		a2[i] = verts[2].v[i];
	    }

	    v[0] = a1[0] - a0[0];
	    v[1] = a1[1] - a0[1];
	    w[0] = a2[0] - a1[0];
	    w[1] = a2[1] - a1[1];
	    vec_unit_2(w);
	    vec_unit_2(v);

	    if ((k!=3)&&(k!=4)&&(k!=5))
	    {
		if (v[0]*w[1] - v[1]*w[0] >= 0.0)  /* facing us */
		{
/*		    fprintf(stderr," polygon facing viewer.\n"); */
		    render_mode = RENDER_MODE_DESTRUCTIVE;
		}
		else
		{
/*		    fprintf(stderr," polygon facing away from viewer.\n"); */
		    render_mode = RENDER_MODE_COMPOSITE;
		}
	    }
	    else
	    {
		if (v[0]*w[1] - v[1]*w[0] <= 0.0)  /* facing us */
		{
/*		    fprintf(stderr," polygon facing viewer.\n"); */
		    render_mode = RENDER_MODE_DESTRUCTIVE;
		}
		else
		{
/*		    fprintf(stderr," polygon facing away from viewer.\n"); */
		    render_mode = RENDER_MODE_COMPOSITE;
		}
	    }
	    
	    render_line(&(verts[0]),&(verts[1]),img,render_mode,anti);
	    render_line(&(verts[1]),&(verts[2]),img,render_mode,anti);
	    render_line(&(verts[2]),&(verts[3]),img,render_mode,anti);
	    render_line(&(verts[0]),&(verts[3]),img,render_mode,anti);
	}
	fscanf(f,"%d",&type);
    }
}

render_line(v1,v2,img,render_mode,anti)
vector4 *v1,*v2;
AVS_IMAGE_FIELD *img;
int render_mode,anti;
{
    double x1,y1,z1,x2,y2,z2;
    /* input points in range of -1..1 in x,y.  want to
       produce screen pixel values. */
    
    x1 = ((v1->v[0] * 0.25)+0.5)*xscale;
    y1 = ((v1->v[1] * 0.25)+0.5)*yscale;
    z1 = v1->v[2];

    x2 = ((v2->v[0] *0.25)+0.5)*xscale;
    y2 = ((v2->v[1] *0.25)+0.5)*yscale;
    z2 = v2->v[2];

    show_seg(&x1,&y1,&z1,&x2,&y2,&z2,img,render_mode,anti);
}

static int
clip_pixel(x1,y1,size)
double *x1,*y1;
int size;
{
    if ((*x1 > size-1) || (*y1 > size-1))
	return(1);

    if ((*x1 < 0.0) || (*y1 < 0.0))
	return(1);
    return(0);

}

show_seg(x1,y1,z1,x2,y2,z2,img,render_mode,anti)
double *x1,*y1,*x2,*y2,*z1,*z2;
AVS_IMAGE_FIELD *img;
int anti;
{
    double lx1,lx2,ly1,ly2,lz1,lz2;
    if (renderable(x1,y1,x2,y2))
    {
	lx1 = (*x1 + *x2) * 0.5;
	ly1 = (*y1 + *y2) * 0.5;
	lz1 = (*z1 + *z2) * 0.5;
	composite_pixel(&lx1,&ly1,&lz1,img,render_mode,anti);
    }
    else
    {
	/* left portion of line seg. */
	lx1 = *x1;
	ly1 = *y1;
	lz1 = *z1;
	lx2 = (*x1 + *x2) * 0.5;
	ly2 = (*y1 + *y2) * 0.5;
	lz2 = (*z1 + *z2) * 0.5;
	show_seg(&lx1,&ly1,&lz1,&lx2,&ly2,&lz2,img,render_mode,anti);

	/* right portion of line. */
	lx1 = (*x1 + *x2) * 0.5;
	ly1 = (*y1 + *y2) * 0.5;
	lz1 = (*z1 + *z2) * 0.5;
	lx2 = *x2;
	ly2 = *y2;
	lz2 = *z2;
	show_seg(&lx1,&ly1,&lz1,&lx2,&ly2,&lz2,img,render_mode,anti);
    }
}

composite_pixel(x,y,z,img,render_mode,anti)
double *x,*y,*z;
AVS_IMAGE_FIELD *img;
int anti;
{
    int offset;
    IMAGE_TYPE *p;
    double r,g,b,a;
    double red,green,blue,alpha;
    int y_coord;
    red = green = blue = 0.8;  /* default gray shade for the hull outline */

    if (anti)
    {
	/* calculate how near the center of the pixel we are,
	   set the alpha component to that weight.  this doesn't
	   produce exactly the desired results, but seems to work
	   good enough.  I encourage you to substitute your favorite
`	   antialiased-line renderer here, and mail me the code :-)
	   w.bethel  ewbethel@lbl.gov, 10 may 1991 */
	
	alpha = fabs(*x - (floor(*x)+0.5)) *
	    fabs(*y - (floor(*y)+0.5));
    }
    else
	alpha = 1.0;

    /* we render the image upside down. */
    y_coord = (int)(*y);
    y_coord = (img->dimensions[1]-1)-y_coord;

    if (clip_pixel(x,y,img->dimensions[0]))
	return;
    
    offset = (int)(*x) + y_coord*img->dimensions[0];
    p = img->data + (int)(*x)*4 + y_coord*img->dimensions[0]*4;
    
    if (render_mode == RENDER_MODE_DESTRUCTIVE)
    {
	*p = alpha;
	*(p+1) = red;
	*(p+2) = green;
	*(p+3) = blue;
    }
    else /* normal composite */
    {
	if (*p == 1.0)
	    return;
    
	a = *p;
    
	r = *(p+1);
	r = r*a + red*(1.-a);
	*(p+1) = r;
	
	g = *(p+2);
	g = g*a + green*(1.-a);
	*(p+2) = g;
	
	b = *(p+3);
	b = b*a + blue*(1.-a);
	*(p+3) = b;

	a = a+(1.-a)*alpha;
	if (a > 1.0)
	a = 1.0;
	*p = a;
    }
}


setup_view_xform(img)
AVS_IMAGE_FIELD *img;
{
    xscale = img->dimensions[0];
    yscale = img->dimensions[1];
}

int
renderable(x1,y1,x2,y2)
double *x1,*y1,*x2,*y2;
{
    double dx,dy;
    
    dx = *x2 - *x1;
    dy = *y2 - *y1;
    if (dx <= 0.)
	dx *= -1.;
    if (dy <= 0.)
	dy *= -1.;
    if ((dx <= LIMIT) && (dy <= LIMIT))
	return(1);
    else
	return(0);
}
