/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

 AUTHOR : Lawrence Berkeley Laboratory
******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce inter.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  inter.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  inter.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     inter.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
inter.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/

#include <stdio.h>
#include "defs.h"
#include "stuff.h"

int
Intersect(ray, solid, hit)
Ray *ray;
Prim *solid[];
/*Isect **hit; */
Isect *hit;
{
   int nhits, i;
   Prim *p;
   Ray new_ray;
   Isect *temp;
   int limit=10,nloops;

   temp = hit;
   i = nhits = 0;
   while (solid[i] != NULL)
   {
      p = solid[i++];
      nhits += (*(p->procs->intersect))(ray, p, &hit);
   }

   /**
     * next, we're going to check for a case which is specific to
     * the volume renderer.
     * what has happened is that we've grazed the edge of the bounding
     * volume with a ray.  what we want to do is to perturb the ray
     * a bit and rerun the intersection calculation.  this repeats
     * until we pass through at least two bounding faces.
     * we will give up after 10 iterations of this loop, and
     * an error message is later generated in the code, and this
     * pixel is colored red.
   **/

   nloops=0;
   while ((nhits == 2) && (nloops < limit))
   {
       perturb_ray(ray,&new_ray);
       i =  nhits = 0;
       hit = temp;
       while (solid[i] != NULL)
       {
	   p = solid[i++];
	   nhits += (*(p->procs->intersect))(&new_ray, p, &hit);
       }
       nloops++;
   }

   return(nhits);
}
