#ifdef LINT_ARGS
Flt VecLen(Vec);
Flt VecDot(Vec,Vec);
void VecCopy(Vec,Vec);
void VecAdd(Vec, Vec, Vec);
void VecSub(Vec, Vec, Vec);
void VecComb(Flt,Vec,Flt,Vec,Vec);
void VecAddS(Flt,Vec,Vec,Vec);
Flt VecUnit(Vec,Vec);
void VecNegate(Vec, Vec);
void make_identity_matrix(Matrix);
#else
Flt VecLen();
Flt VecDot();
void VecCopy();
void VecAdd();
void VecSub();
void VecComb();
void VecAddS();
Flt VecUnit();
void make_identity_matrix();
void VecNegate();
#endif

typedef struct Ray
{
   Point P, D;
} Ray;

#define RayPoint(ray,t,point) VecAddS(t,(ray)->D,(ray)->P, point)

typedef struct Comp
{
   int compflag;
   int op;
   struct Comp *left;
   struct Comp *right;
} Comp;

typedef struct Prim
{
   int compflag;
   char *info;
   struct PrimProcs *procs;
   Matrix mat;
   struct Surf *surf;
} Prim;

typedef struct PrimProcs
{
   char *(*name)();
   void (*print)();
   Prim *(*read)();
   int (*intersect)();
   void (*normal)();
   void (*uv)();
} PrimProcs;

typedef struct Surf
{
   Flt kdiff;
   Flt kspec;
   Flt ktran;
   Color color;
   Flt refrindx;
} Surf;

typedef struct Isect
{
   Flt t;
   Prim *prim;
   int enter;
   Surf *medium;
   double distance_from_viewpoint;
   int backside;
   double V,U;
} Isect;

typedef struct display
{
   int xres, yres;
} DISPLAY;

typedef  struct LightSource
{
   Vec position;
   Color color;
} LightSource;

#define ABS(a)	(((a) < 0.) ? (-1.*(a)) : (a))
