/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

 AUTHOR : Lawrence Berkeley Laboratory
******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce trace.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  trace.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  trace.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     trace.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
trace.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/

#include <stdio.h>
#include "defs.h"
#include "stuff.h"

extern Prim *modelroot;
extern Prim *list[];
static int Hit=0;

void
trace (level,weight, ray, col,anti)
int level;
Flt weight;
Ray *ray;
Color col;
int anti;  /* antialias flag; 0==don't, 1==do */
{
   Prim *prim;
   Point P,N;
   Isect hit[ISECTMAX], *h;
   int Intersect();
   void ShadeBackground();
   static void sort_hits();
   int nhits;

   h = hit;
   
   if (nhits=Intersect(ray,list,h))
   {
       sort_hits(hit,nhits);
       prim = hit[0].prim;
       Shade(level, weight, P, N, ray->D, hit, col,prim->surf,nhits,anti);
   }
   else
       ShadeBackground(ray,col);
}

void
ShadeBackground(r,c)
Ray *r;
Color c;
{
#if 0
   c[0] = 0.1; /* r */  /* this triple is for "carolina blue" */
   c[1] = 0.35;
   c[2] = 0.75;  /*b */
#endif
#if 0   
   c[0] = 0.05;
   c[1] = 0.175;
   c[2] = 0.375;
#endif
   c[0] = 0.0;
   c[1] = 0.;
   c[2] = 0.;
   c[3] = 0.;
}

void
sort_hits(h,n)
Isect *h;
int n;
{
    int i,j;
    Isect temp;
    int no_change;
    int xfer_size = sizeof(Isect);

    no_change = 1;
    for (i=1;i<n && no_change==1;i++)
    {
	no_change = 0;
	for (j=1;j<n;j++)
	{
	    if ((h+j)->t < (h+j-1)->t)  /* swap j and j-1  */
	    {
		no_change = 1;
		memcpy((char *)&temp,(char *)(h+j),xfer_size); /* j to temp*/
		memcpy((char *)(h+j),(char *)(h+j-1),xfer_size);
		memcpy((char *)(h+j-1),(char *)&temp,xfer_size);
	    }
	}
    }
}
