/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*   

Copyright (C) 1994, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus it is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

  January 1994 - preliminary support for irregular fields is included.
     the algorithm used is a brute-force space search, which is O(n^3)
     with respect to the size of the input field, and produces point
     sampled output.  it is very slow.  it will one day be replaced
     with something more intelligent.

*/

#define BIGNUM  1e10
#define SMALLNUM -1e10
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#define MAX(a,b) ((a) > (b) ? (a) : (b))


#include <stdio.h>
#include <math.h>
#include <avs/avs.h>
#include <avs/geom.h>
#include <avs/field.h>
#include "gmatrix.h"

#include <avs/udata.h>

AVSinit_modules()
{
    int abslice();
    AVSmodule_from_desc(abslice);
}

int
abslice()
{
    int abslice_p();
    int p;

    AVSset_module_name("new arbitrary slicer",MODULE_MAPPER);

    AVScreate_input_port("Input Field","field 3D scalar",REQUIRED);
#if 0
    p=AVScreate_input_port("XformInfo","struct upstream_transform",
			      OPTIONAL | INVISIBLE);
    p = AVSset_input_class(p,"upstream transform");
#endif
    
    AVScreate_output_port("Output Field","field 2D irregular scalar");

    p=AVSadd_float_parameter("X Rotate",0.,-360.0,360.0);
    AVSconnect_widget(p,"dial");
    p=AVSadd_float_parameter("Y Rotate",0.,-360.0,360.0);
    AVSconnect_widget(p,"dial");
    p=AVSadd_float_parameter("Z Rotate",0.,-360.0,360.0);
    AVSconnect_widget(p,"dial");
    
    p=AVSadd_float_parameter("X Translate",0.,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"dial");
    p=AVSadd_float_parameter("Y Translate",0.,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"dial");
    p=AVSadd_float_parameter("Z Translate",0.,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"dial");
    
    p=AVSadd_float_parameter("X Scale",1.,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"dial");
    p=AVSadd_float_parameter("Y Scale",1.,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"dial");
    
    p=AVSadd_parameter("Mesh U Resolution","integer",20,10,500);
    AVSconnect_widget(p,"islider");
    p=AVSadd_parameter("Mesh V Resolution","integer",20,10,500);
    AVSconnect_widget(p,"islider");

    p=AVSadd_float_parameter("Undefined Value",-1.,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"dial");
    
    AVSset_compute_proc(abslice_p);
}

#if 0
abslice_p(inf,xform,outf,xr,yr,zr,xt,yt,zt,xs,ys,zs,xres,yres)
#endif
abslice_p(inf,outf,xr,yr,zr,xt,yt,zt,xs,ys,xres,yres,undef)
AVSfield *inf,**outf;
#if 0
struct upstream_transform *xform;
#endif
float *xr,*yr,*zr,*xt,*yt,*zt,*xs,*ys,*undef;
int xres,yres;
{
    AVSfield template;
    int dims[2],i,status;
    matrix4x4 xfm;
    float lxr,lyr,lzr,lxt,lyt,lzt,lxs,lys;

    memset((char *)&template,0,sizeof(AVSfield));
    
    /* make local copies of parameters which could change...*/
    lxr = *xr;
    lyr = *yr;
    lzr = *zr;
    lxt = *xt;
    lyt = *yt;
    lzt = *zt;
    lxs = *xs;
    lys = *ys;

#if 0
    if (inf->uniform == IRREGULAR)
    {
	AVSwarning(" Irregular fields aren't yet supported.");
	return(0);
    }
#endif

    template.ndim = 2;
    template.nspace = 3;
    template.veclen = 1;
    template.type = inf->type;
    template.size = inf->size;
    template.uniform = IRREGULAR;
    dims[0] = xres;
    dims[1] = yres;

    if (*outf)
	AVSfield_free(*outf);
    
    *outf = (AVSfield *)AVSfield_alloc(&template,dims);
    if (*outf == NULL)
    {
	AVSerror("malloc error in abslice");
	return(0);
    }

    /* do the initial settings for this module, set slice plane parameters
       to something sane for this field. */
    
    if (AVSinput_changed("Input Field",0))
    {
	switch(inf->uniform)
	{
	case UNIFORM:
	    lxs = (0.5 * (inf->dimensions[0])) - 0.5;
	    lys = (0.5 * (inf->dimensions[1])) - 0.5;
	    lxt = (0.5 * (float)(inf->dimensions[0])) - 0.5;
	    lyt = (0.5 * (float)(inf->dimensions[1])) - 0.5;
	    lzt = (0.5 * (float)(inf->dimensions[2])) - 0.5;
	    AVSmodify_float_parameter("X Scale",AVS_VALUE,(double)lxs,
				      (double)lxs,(double)lxs);
	    AVSmodify_float_parameter("Y Scale",AVS_VALUE,(double)lys,
				      (double)lys,(double)lys);
	    AVSmodify_float_parameter("X Translate",AVS_VALUE,(double)lxt,
				      (double)lxt,(double)lxt);
	    AVSmodify_float_parameter("Y Translate",AVS_VALUE,(double)lyt,
				      (double)lyt,(double)lyt);
	    AVSmodify_float_parameter("Z Translate",AVS_VALUE,(double)lzt,
				      (double)lzt,(double)lzt);
	    break;
	case IRREGULAR:
	case RECTILINEAR:
	    lxs = (0.5 * (inf->max_extent[0] - inf->min_extent[0]));
	    lys = (0.5 * (inf->max_extent[1] - inf->min_extent[1]));
	    lxt = (0.5 * (inf->max_extent[0] - inf->min_extent[0])) + inf->min_extent[0];
	    lyt = (0.5 * (inf->max_extent[1] - inf->min_extent[1])) + inf->min_extent[1];;
	    lzt = (0.5 * (inf->max_extent[2] - inf->min_extent[2])) + inf->min_extent[2];
	    AVSmodify_float_parameter("X Scale",AVS_VALUE,(double)lxs,
				      (double)lxs,(double)lxs);
	    AVSmodify_float_parameter("Y Scale",AVS_VALUE,(double)lys,
				      (double)lys,(double)lys);
	    AVSmodify_float_parameter("X Translate",AVS_VALUE,(double)lxt,
				      (double)lxt,(double)lxt);
	    AVSmodify_float_parameter("Y Translate",AVS_VALUE,(double)lyt,
				      (double)lyt,(double)lyt);
	    AVSmodify_float_parameter("Z Translate",AVS_VALUE,(double)lzt,
				      (double)lzt,(double)lzt);
	    break;
	    
	}
    }

    make_global_xfrm(&xfm,&lxr,&lyr,&lzr,&lxt,&lyt,&lzt,&lxs,&lys);

    build_coords(*outf,&xfm);

    switch(inf->uniform)
    {
    case UNIFORM:
	status = interp_uniform_data(*outf,inf,undef);
	break;
    case RECTILINEAR:
	status = interp_rectilinear_data(*outf,inf,undef);
	break;
    case IRREGULAR:
	status = interp_data(*outf,inf,undef);
	break;
    }

    return(status);
}

#define PI 3.14159
#define DEGREES_TO_RADIANS(a) ((a)/180.*PI)

make_global_xfrm(xfm,xr,yr,zr,xt,yt,zt,xs,ys,zs)
matrix4x4 *xfm;
float *xr,*yr,*zr,*xt,*yt,*zt,*xs,*ys,*zs;
{
    matrix4x4 rotx,roty,rotz,translate,scale;
    extern double cos(),sin();
    double d,t;

    identity_4x4(&scale);
    scale.m[0][0] = *xs;
    scale.m[1][1] = *ys;

    identity_4x4(&translate);
    translate.m[3][0] = *xt;
    translate.m[3][1] = *yt;
    translate.m[3][2] = *zt;

    identity_4x4(&rotx);
    d = DEGREES_TO_RADIANS(*xr);
    t = cos(d);
    rotx.m[1][1] = rotx.m[2][2] = t;
    t = sin(d);
    rotx.m[1][2] = t;
    rotx.m[2][1] = -1. * t;
	
    identity_4x4(&roty);
    d = DEGREES_TO_RADIANS(*yr);
    roty.m[0][0] = roty.m[2][2] = cos(d);
    roty.m[2][0] = sin(d);
    roty.m[0][2] = -1. * sin(d);
	
    identity_4x4(&rotz);
    d = DEGREES_TO_RADIANS(*zr);
    rotz.m[0][0] = rotz.m[1][1] = cos(d);
    rotz.m[0][1] = sin(d);
    rotz.m[1][0] = -1. * sin(d);

    identity_4x4(xfm);
    mmul_4x4(xfm,&scale);
    
    mmul_4x4(xfm,&rotx);
    mmul_4x4(xfm,&roty);
    mmul_4x4(xfm,&rotz);
    
    mmul_4x4(xfm,&translate);
}

/**
  * in building the coordinate list for the output irregular field,
  * what we will do is step through a predefined range in each of
  * the U&V parametric spaces, and pass that coordinate vector through
  * the xformation matrix.
  * since we have only U&V to construct a 3-d coordinate, we assume
  * an initial Z value of 0.0.
**/
build_coords(outf,xfm)
AVSfield *outf;
matrix4x4 *xfm;
{
    int i,j;
    double x,dx,y,dy,z;
    vector4 v,r;
    float *dest_x,*dest_y,*dest_z;

    dest_x = outf->points;
    dest_y = dest_x + (outf->dimensions[0]*outf->dimensions[1]);
    dest_z = dest_y + (outf->dimensions[0]*outf->dimensions[1]);

    x = -1.;
    dx = 2./(double)(outf->dimensions[0]-1);  /* increment to x=1.0 */
    y = -1.;
    dy = 2./(double)(outf->dimensions[1]-1); /* increment to y=1.0 */
    z = 0.0;

    for (j=0;j<outf->dimensions[1];j++,y+=dy)
    {
	x = -1;
	for (i=0;i<outf->dimensions[0];i++,x+=dx)
        {
	    v.v[0] = x;
	    v.v[1] = y;
	    v.v[2] = z;
	    v.v[3] = 1.0;
	    vector_matrix_mult_4(&v,xfm,&r);
	    *dest_x++ = r.v[0];
	    *dest_y++ = r.v[1];
	    *dest_z++ = r.v[2];
	}
    }
}

#define IN_BOUNDS 0
#define OUT_OF_BOUNDS 1

int
interp_data(outf,inf,undef)
AVSfield_float *outf,*inf;
float *undef;
{
    int i,num_pts,num_in_pts;
    float zero=0.0;
    float *srcx,*srcy,*srcz;
    float *destx,*desty,*destz,*destd;
    int bracket_indeces[3];
    int get_nearest();
    int boundary_point();
    float c_extents[6];
    double percent,dp;
    int ip;
    
    num_pts = outf->dimensions[0]*outf->dimensions[1];
    num_in_pts = inf->dimensions[0]*inf->dimensions[1]*inf->dimensions[2];

    srcx = inf->points;
    srcy = srcx + num_in_pts;
    srcz = srcy + num_in_pts;
    
    destx = outf->points;
    desty = destx + num_pts;
    destz = desty + num_pts;
    destd = outf->data;

    dp = 100./num_pts;
    percent = 0.;
    ip = 0;
    AVSmodule_status("arbitrary slicer",ip);
    
    for (i=0;i<num_pts;i++)
    {
	if (get_nearest_irreg(destx+i,desty+i,destz+i,
			      srcx,srcy,srcz,bracket_indeces,
			      num_in_pts,inf,c_extents) == IN_BOUNDS)
	{
	    if (boundary_point(bracket_indeces,inf->dimensions) == 1)
		;
	    else
		weight_points(destd+i,bracket_indeces,inf,srcx,srcy,srcz,
			      destx+i,desty+i,destz+i);
	}
	else
	    set_to_undefined(destd+i,undef);
	percent += dp;
	ip = percent;
	AVSmodule_status("arbitrary slicer",ip);
    }
    return(1);
}

set_to_undefined(outf,i,undef)
float *undef;
AVSfield *outf;
int i;
{
    switch (outf->type)
    {
    case AVS_TYPE_BYTE:
	*(outf->field_union.field_data_char+i) = (unsigned char) *undef;
	break;
    case AVS_TYPE_INTEGER:
	*(outf->field_union.field_data_int_u+i) = (int) *undef;
	break;
    case AVS_TYPE_REAL:
	*(outf->field_union.field_data_float_u+i) = *undef;
	break;
    case AVS_TYPE_DOUBLE:
	*(outf->field_union.field_data_double_u+i) = *undef; 
	break;
    }
}

#define ABS(a) ((a) > 0.0 ? (a) : (-1. * (a)))

weight_points(d,bi,inf,srcx,srcy,srcz,dx,dy,dz)
float *d;
int *bi;
AVSfield_float *inf;
float *srcx,*srcy,*srcz,*dx,*dy,*dz;
{

    *d = *(inf->data + bi[2]*inf->dimensions[0]*inf->dimensions[1] +
	   bi[1]*inf->dimensions[0] + bi[0]);
    
#if 0
    double u,v,w;  /* the parametric location within the voxel */
    double xf,xf1,yf,yf1,zf,zf1;
    float numer,denom,t1,t2;
    extern double fabs();
    int offset;
    float p000,p100,p010,p001,p011,p110,p111,p101;
    float *data;

    data = inf->data;

    *d = *(inf->data + bi[2]*inf->dimensions[0]*inf->dimensions[1] +
	   bi[1]*inf->dimensions[0] + bi[0]);
    

    /**
      * what we really want here is some u,v,w parametric indication of
      * where the destination point lies within this voxel to get an
      * "accurate" trilinear interpolated result.
      *
      * as it is, we will make do using quick and dirty approximation
      * techniques.  to get better results (for now), make the grid
      * finer in resolution.
      *
      * we will assume that the voxel is rectilinear in shape.
    **/

    t1 = *dx;
    t2 = *(srcx+bi[0]);
    numer = t1 - t2;
/*    numer = *dx - *(srcx+bi[0]); */
    denom = *(srcx+bi[0]+1) - *(srcx+bi[0]);
    if (denom = 0.0)
    {
	xf = xf1 = 0.5;
    }
    else
    {
	xf = numer/denom;
	xf = ABS(xf);
	xf1 = 1. - xf;
    }

    numer = *dy - *(srcy+bi[1]);
    denom = *(srcy+bi[1]+1) - *(srcy+bi[1]);
    yf = numer/denom;
    yf = ABS(yf);
    yf1 = 1. - yf;

    numer = *dz - *(srcz+bi[2]);
    denom = *(srcz+bi[2]+1) - *(srcz+bi[2]);
    zf = numer/denom;
    zf = ABS(zf);
    zf1 = 1. - zf;

    offset = bi[2]*(inf->dimensions[1]*inf->dimensions[0]) +
	bi[1]*inf->dimensions[1] + bi[0];
    
    p000 = *(data+offset);
    p100 = *(data+offset+1);
    p010 = *(data + inf->dimensions[0] + offset);
    p110 = *(data + inf->dimensions[0] + 1 + offset);

    offset = (bi[2]+1)*(inf->dimensions[1]*inf->dimensions[0]) +
	bi[1]*inf->dimensions[1] + bi[0];
    
    p001 = *(data+offset);
    p101 = *(data+offset+1);
    p011 = *(data + inf->dimensions[0] + offset);
    p111 = *(data + inf->dimensions[0] + 1 + offset);

    *d = zf1*(yf1*(xf1*p000 + xf*p100) + yf*(xf1*p010 + xf*p110)) +
	zf*(yf1*(xf1*p001 + xf*p101) + yf*(xf1*p011 + xf*p111));

    *d = 0.0;
#endif
}

int
get_nearest(dx,dy,dz,sx,sy,sz,bi,ni,inf,cextents)
float *dx,*dy,*dz;  /* target x,y,z point */
float *sx,*sy,*sz;  /* source array of coordinates */
int *bi; /* bracket indeces */
int ni;  /* number of input points */
AVSfield *inf;
float *cextents;
{
    /**
      * in this routine, we want to find the 8 locations in the input
      * field which bracket the x,y,z location in the output field.
    **/
    int i,j,k,indx;
    int bracket();
    int num_xy_pts,corner_offset;

    /* first, check to see if it lies out of bounds to begin with. */
    if ((inf->min_extent != NULL) && (inf->max_extent != NULL))
    {
	if ((bracket(dx,dy,dz,
		     inf->min_extent,inf->min_extent+1,inf->min_extent+2,
		     inf->max_extent,inf->max_extent+1,inf->max_extent+2) == OUT_OF_BOUNDS))
	    return(OUT_OF_BOUNDS);
    }

    num_xy_pts = inf->dimensions[1]*inf->dimensions[0];
    
    for (k=0;k<inf->dimensions[2]-1;k++)
    {
	for (j=0;j<inf->dimensions[1]-1;j++)
	{
	    for (i=0;i<inf->dimensions[0]-1;i++)
	    {
		set_extents(cextents,i,j,k,sx,sy,sz,inf);
		if ((bracket(dx,dy,dz,cextents,cextents+1,cextents+2,
			     cextents+3,cextents+4,cextents+5) == IN_BOUNDS))
		{
		    bi[0] = i;
		    bi[1] = j;
		    bi[2] = k;
		    return(IN_BOUNDS);
		}
	    }
	}
    }
    return(OUT_OF_BOUNDS);
}

int
get_nearest_irreg(dx,dy,dz,sx,sy,sz,bi,ni,inf,cextents)
float *dx,*dy,*dz;  /* target x,y,z point */
float *sx,*sy,*sz;  /* source array of coordinates */
int *bi; /* bracket indeces */
int ni;  /* number of input points */
AVSfield *inf;
float *cextents;
{
    /**
      * in this routine, we want to find the indeces of the input grid
      * point which is "closest" to the output grid point.
      *
      * we avoid using a square root by the observation that for
      * two numbers, a and b, that if sqrt(a) < sqrt(b), then, for
      * positive a & b (of which we're guaranteed), then a < b.
      *
      * this is still a painfully slow n**3 algorithm.  ugh.
    **/
    
    register float *inx,*iny,*inz;
    register float fdx,fdy,fdz;
    float t[3];
    int i,j,k,l,indx;
    int num_xy_pts,corner_offset;
    double min_d,td;

    /* first, check to see if it lies out of bounds to begin with. */
    if ((inf->min_extent != NULL) && (inf->max_extent != NULL))
    {
	if ((bracket(dx,dy,dz,
		     inf->min_extent,inf->min_extent+1,inf->min_extent+2,
		     inf->max_extent,inf->max_extent+1,inf->max_extent+2) == OUT_OF_BOUNDS))
	    return(OUT_OF_BOUNDS);
    }

    num_xy_pts = inf->dimensions[1]*inf->dimensions[0];

    inx = sx;
    iny = sy;
    inz = sz;

    fdx = *dx;
    fdy = *dy;
    fdz = *dz;

    min_d = BIGNUM;

    bi[0] = bi[1] = bi[2] = -1;
    
    for (k=0;k<inf->dimensions[2];k++)
    {
	for (j=0;j<inf->dimensions[1];j++)
	{
	    for (i=0;i<inf->dimensions[0];i++)
	    {
		t[0] = *inx++ - fdx;
		t[1] = *iny++ - fdy;
		t[2] = *inz++ - fdz;

		td = t[0]*t[0] + t[1]*t[1] + t[2]*t[2];
		td = sqrt(td);
		if (td < min_d)
	        {
		    min_d = td;
		    bi[0] = i;
		    bi[1] = j;
		    bi[2] = k;
		}
	    }
	}
    }

    if (bi[0] != -1 && bi[1] != -1 && bi[2] != -1)
	return(IN_BOUNDS);
    else
	return(OUT_OF_BOUNDS);
}

/**
  * bracket checks the input x,y,z to see if the point thus formed
  * lies within the cube formed by the points d1 and d2.
**/
int
bracket(x,y,z,d1x,d1y,d1z,d2x,d2y,d2z)
float *x,*y,*z,*d1x,*d1y,*d1z,*d2x,*d2y,*d2z;
{
    /* we will assume that d1x (xmin) is always < d2x (xmax), and
       similarly for y and z */

    if ((*d1x <= *x) && (*x <= *d2x))
	if ((*d1y <= *y) && (*y <= *d2y))
	    if ((*d1z <= *z ) && (*z <= *d2z))
		return(IN_BOUNDS);

    return(OUT_OF_BOUNDS);
#if 0
    int x_ok,y_ok,z_ok;
    
    if (*d1x < *d2x)
    {
	if ((*d1x <= *x) && (*x <= *d2x))
	    x_ok = 1;
	else
	    return(OUT_OF_BOUNDS);
    }
    else
    {
	if ((*d2x <= *x) && (*x <= *d1x))
	    x_ok = 1;
	else
	    return(OUT_OF_BOUNDS);
    }
    
    if (*d1y < *d2y)
    {
	if ((*d1y <= *y) && (*y <= *d2y))
	    y_ok = 1;
	else
	    return(OUT_OF_BOUNDS);
    }
    else
    {
	if ((*d2y <= *y) && (*y <= *d1y))
	    y_ok = 1;
	else
	    return(OUT_OF_BOUNDS);
    }
    
    if (*d1z < *d2z)
    {
	if ((*d1z <= *z) && (*z <= *d2z))
	    z_ok = 1;
	else
	    return(OUT_OF_BOUNDS);
    }
    else
    {
	if ((*d2z <= *z) && (*z <= *d1z))
	    z_ok = 1;
	else
	    return(OUT_OF_BOUNDS);
    }
#endif    
/*    return(IN_BOUNDS);*/
}


set_extents(extents,i,j,k,sx,sy,sz,inf)
float *extents;
int i,j,k;
float *sx,*sy,*sz;
AVSfield *inf;
{
    int index,num_xy_pts,l;
    int indeces[8];

    num_xy_pts = inf->dimensions[0]*inf->dimensions[1];
    indeces[0] = num_xy_pts*k + j*inf->dimensions[0] + i;
    indeces[1] = indeces[0] + 1;

    indeces[2] = num_xy_pts*k + (j+1)*inf->dimensions[0] + i;
    indeces[3] = indeces[2] + 1;

    indeces[4] = num_xy_pts*(k+1) + j*inf->dimensions[0] + i;
    indeces[5] = indeces[4]+1;

    indeces[6] = num_xy_pts*(k+1) + (j+1)*inf->dimensions[0] + i;
    indeces[7] = indeces[6] + 1;

    extents[0] = extents[1] = extents[2] = BIGNUM;
    extents[3] = extents[4] = extents[5] = SMALLNUM;
    
    for (l=0;l<8;l++)
    {
	extents[0] = MIN(extents[0],*(sx+indeces[l]));
	extents[1] = MIN(extents[1],*(sy+indeces[l]));
	extents[2] = MIN(extents[2],*(sz+indeces[l]));
	extents[3] = MAX(extents[3],*(sx+indeces[l]));
	extents[4] = MAX(extents[4],*(sy+indeces[l]));
	extents[5] = MAX(extents[5],*(sz+indeces[l]));
    }
}


/**
  * NOTE: the following routine WILL NOT WORK RIGHT in AVS 2.0 !!
  * as such, there are no ifdef's for AVS 3.
**/
int
interp_uniform_data(outf,inf,undef)
AVSfield *outf,*inf;
float *undef;
{
    float extents[6];  /* the coordinate extents of the entire field */
    float *srcx,*srcy,*srcz;
    int num_out_pts,i,num_in_points;
    static weight_uniform_points();

    extents[0] = extents[1] = extents[2] = 0.0;
    extents[3] = inf->dimensions[0]-1;
    extents[4] = inf->dimensions[1]-1;
    extents[5] = inf->dimensions[2]-1;

    num_out_pts = outf->dimensions[0] * outf->dimensions[1];
    srcx = outf->points;
    srcy = srcx + num_out_pts;
    srcz = srcy + num_out_pts;

    num_in_points = inf->dimensions[0]*inf->dimensions[1]*inf->dimensions[2];

    for (i=0;i<num_out_pts;i++)
    {
	if (bracket(srcx+i,srcy+i,srcz+i,extents,extents+1,extents+2,
		    extents+3,extents+4,extents+5) == IN_BOUNDS)
		weight_uniform_points(srcx+i,srcy+i,srcz+i,inf,
				      num_in_points,outf,i);
	else
	    set_to_undefined(outf,i,undef);
    }
    return(1);
}

int
interp_rectilinear_data(outf,inf,undef)
AVSfield *outf,*inf;
float *undef;
{
    float extents[6];  /* the coordinate extents of the entire field */
    float *srcx,*srcy,*srcz;
    int num_out_pts,i,num_in_points;
    static int weight_uniform_points();

    for (i=0;i<3;i++)
	extents[i] = inf->min_extent[i];
    for (i=0;i<3;i++)
	extents[i+3] = inf->max_extent[i];
    
    num_out_pts = outf->dimensions[0] * outf->dimensions[1];
    srcx = outf->points;
    srcy = srcx + num_out_pts;
    srcz = srcy + num_out_pts;

    num_in_points = inf->dimensions[0]*inf->dimensions[1]*inf->dimensions[2];

    for (i=0;i<num_out_pts;i++)
    {
	if (bracket(srcx+i,srcy+i,srcz+i,extents,extents+1,extents+2,
		    extents+3,extents+4,extents+5) == IN_BOUNDS)
	{
	    if (weight_uniform_points(srcx+i,srcy+i,srcz+i,inf,
				      num_in_points,outf,i) != 1)
		set_to_undefined(outf,i,undef);
	}
	else
	    set_to_undefined(outf,i,undef);
    }
    return(1);
}

static int
weight_uniform_points(x, y, z,inf,n_ip,outf,o_offset)
float *x, *y, *z;
AVSfield *inf,*outf;
int n_ip,o_offset;
{
    int i, ii, j, jj, k, kk;
    double p, p1, p2;
    double p000, p001, p010, p011, p100, p101, p110, p111;
    double xf, yf, zf, xf1, yf1, zf1, val;
    int xypts;

    xypts = inf->dimensions[1]*inf->dimensions[0];

    switch(inf->uniform)
    {
    case UNIFORM:
	i = *x; /* the (int`d) value of the coord is the index. */
	j = *y;
	k = *z;
	break;
    case RECTILINEAR:
	if (get_rectilinear_ijk(&i,&j,&k,inf,x,y,z) != 1)
	    return(0);
	break;
    }

    ii = MIN((i+1),(inf->dimensions[0] - 1));
    jj = MIN((j+1),(inf->dimensions[1] - 1));
    kk = MIN((k+1),(inf->dimensions[2] - 1));
    
    p  = *x;

    switch(inf->uniform)
    {
    case UNIFORM:
	p1 =  i;
	p2 = ii;
	break;
    case RECTILINEAR:
	p1 = *(inf->points + i);
	p2 = *(inf->points + ii);
	break;
    }
    if (p2 == p1)
	xf = 1.0;
    else
	xf = (p - p1) / (p2 - p1);

    p  = *y;
    switch(inf->uniform)
    {
    case UNIFORM:
	p1 =  j;
	p2 = jj;
	break;
    case RECTILINEAR:
	p1 = *(inf->points + inf->dimensions[0] + j);
	p2 = *(inf->points + inf->dimensions[0] + jj);
	break;
    }
    if (p1 == p2)
	yf = 1.0;
    else
	yf = (p - p1) / (p2 - p1);

    p  = *z;
    switch(inf->uniform)
    {
    case UNIFORM:
	p1 =  k;
	p2 = kk;
	break;
    case RECTILINEAR:
	p1 = *(inf->points + inf->dimensions[0] + inf->dimensions[1] + k);
	p2 = *(inf->points + inf->dimensions[0] + inf->dimensions[1] + kk);
	break;
    }
    if (p1 == p2)
	zf = 1.0;
    else
	zf = (p - p1) / (p2 - p1);

    xf1 = 1. - xf;
    yf1 = 1. - yf;
    zf1 = 1. - zf;


    switch (outf->type)
    {
    case AVS_TYPE_BYTE:
	p000 = *(inf->field_union.field_data_char + k*xypts + j*inf->dimensions[0] + i);
	p001 = *(inf->field_union.field_data_char + kk*xypts + j*inf->dimensions[0] + i);
	p010 = *(inf->field_union.field_data_char + k*xypts + jj*inf->dimensions[0] + i);
	p011 = *(inf->field_union.field_data_char + kk*xypts + jj*inf->dimensions[0] + i);
	p100 = *(inf->field_union.field_data_char + k*xypts + j*inf->dimensions[0] + ii);
	p101 = *(inf->field_union.field_data_char + kk*xypts + j*inf->dimensions[0] + ii);
	p110 = *(inf->field_union.field_data_char + k*xypts + jj*inf->dimensions[0] + ii);
	p111 = *(inf->field_union.field_data_char + kk*xypts + jj*inf->dimensions[0] + ii);
	break;
    case AVS_TYPE_REAL:
	p000 = *(inf->field_union.field_data_float_u + k*xypts + j*inf->dimensions[0] + i);
	p001 = *(inf->field_union.field_data_float_u + kk*xypts + j*inf->dimensions[0] + i);
	p010 = *(inf->field_union.field_data_float_u + k*xypts + jj*inf->dimensions[0] + i);
	p011 = *(inf->field_union.field_data_float_u + kk*xypts + jj*inf->dimensions[0] + i);
	p100 = *(inf->field_union.field_data_float_u + k*xypts + j*inf->dimensions[0] + ii);
	p101 = *(inf->field_union.field_data_float_u + kk*xypts + j*inf->dimensions[0] + ii);
	p110 = *(inf->field_union.field_data_float_u + k*xypts + jj*inf->dimensions[0] + ii);
	p111 = *(inf->field_union.field_data_float_u + kk*xypts + jj*inf->dimensions[0] + ii);
	break;
    case AVS_TYPE_INTEGER:
	p000 = *(inf->field_union.field_data_int_u + k*xypts + j*inf->dimensions[0] + i);
	p001 = *(inf->field_union.field_data_int_u + kk*xypts + j*inf->dimensions[0] + i);
	p010 = *(inf->field_union.field_data_int_u + k*xypts + jj*inf->dimensions[0] + i);
	p011 = *(inf->field_union.field_data_int_u + kk*xypts + jj*inf->dimensions[0] + i);
	p100 = *(inf->field_union.field_data_int_u + k*xypts + j*inf->dimensions[0] + ii);
	p101 = *(inf->field_union.field_data_int_u + kk*xypts + j*inf->dimensions[0] + ii);
	p110 = *(inf->field_union.field_data_int_u + k*xypts + jj*inf->dimensions[0] + ii);
	p111 = *(inf->field_union.field_data_int_u + kk*xypts + jj*inf->dimensions[0] + ii);
	break;
    case AVS_TYPE_DOUBLE:
	p000 = *(inf->field_union.field_data_double_u + k*xypts + j*inf->dimensions[0] + i);
	p001 = *(inf->field_union.field_data_double_u + kk*xypts + j*inf->dimensions[0] + i);
	p010 = *(inf->field_union.field_data_double_u + k*xypts + jj*inf->dimensions[0] + i);
	p011 = *(inf->field_union.field_data_double_u + kk*xypts + jj*inf->dimensions[0] + i);
	p100 = *(inf->field_union.field_data_double_u + k*xypts + j*inf->dimensions[0] + ii);
	p101 = *(inf->field_union.field_data_double_u + kk*xypts + j*inf->dimensions[0] + ii);
	p110 = *(inf->field_union.field_data_double_u + k*xypts + jj*inf->dimensions[0] + ii);
	p111 = *(inf->field_union.field_data_double_u + kk*xypts + jj*inf->dimensions[0] + ii);
	break;
    } /* end switch */
    
    val = zf1 * (yf1 * (xf1 * p000 + xf * p100) + yf * (xf1 * p010 + xf * p110)) +
	zf  * (yf1 * (xf1 * p001 + xf * p101) + yf * (xf1 * p011 + xf * p111));

    switch (outf->type) /* should be same as input field type */
    {
    case AVS_TYPE_BYTE:
	*(outf->field_union.field_data_char + o_offset) = (unsigned char)val;
	break;
    case AVS_TYPE_REAL:
	*(outf->field_union.field_data_float_u + o_offset) = (float)val;
	break;
    case AVS_TYPE_DOUBLE:
	*(outf->field_union.field_data_double_u + o_offset) = val;
	break;
    case AVS_TYPE_INTEGER:
	*(outf->field_union.field_data_int_u + o_offset) = (int)val;
	break;
    }
    return(1);
}


/** misc matrix stuff. **/

identity_4x4(m)
matrix4x4 *m;
{
    int i,j;
    for (i=0;i<4;i++)
	for (j=0;j<4;j++)
	    m->m[i][j] = ((i==j) ? 1. : 0.);
}

mmul_4x4(a,b)
matrix4x4 *a,*b;  /* take product of a and b, put result in a */
{
    matrix4x4 tmp;
    int row,col;

    clear_4x4(&tmp);

    for (row=0;row<4;row++)
    {
	for (col=0;col<4;col++)
	    tmp.m[row][col] = a->m[row][0]*b->m[0][col] +
		a->m[row][1]*b->m[1][col] + a->m[row][2]*b->m[2][col] +
		    a->m[row][3]*b->m[3][col];
    }
    for (row=0;row<4;row++)
	for (col=0;col<4;col++)
	    a->m[row][col] = tmp.m[row][col];
}

vector_matrix_mult_4(v,m,result)
vector4 *v,*result;
matrix4x4 *m;
{
    int i,j;

    for (j=0;j<4;j++)
    {
	result->v[j] = 0.;
	for (i=0;i<4;i++)
	    result->v[j] += v->v[i] * m->m[i][j];
    }
}
clear_4x4(m)
matrix4x4 *m;
{
    int i,j;
    for (i=0;i<4;i++)
	for (j=0;j<4;j++)
	    m->m[i][j] = 0.;
}

static int last_i= -1,last_j= -1,last_k= -1;
static int deja_vu=0;

get_rectilinear_ijk(i,j,k,inf,x,y,z)
int *i,*j,*k;
AVSfield *inf;
float *x,*y,*z;
{
    register float *f1,*f2;
    register int l;
    
    /* find the index which bounds the input x,y,z point. */
    /* do x coords first */
    
    f1 = inf->points;
    f2 = f1+1;
    if (deja_vu == 0)
    {
	for (l=0;l<inf->dimensions[0]-1;l++,f1++,f2++)
	    if ((*x >= *f1) && (*x <= *f2))
		break;
	if (l == inf->dimensions[0])
	    return(0);
	else
	    *i = last_i = l;
    }
    else
    {
	f1 = f1 + last_i;
	f2 = f1+1;
	/* see if the last one we looked at is still valid. */
	if ((*x >= *f1) && (*x <= *f2))
	    *i = last_i;
	else
	{
	    if (*x < *f1) /* search downward in list */
	    {
		f2 = f1;
		f1 = f1 - 1;
		for (l=last_i - 1;l >= 0;l--,f1--,f2--)
		    if ((*x >= *f1) && (*x <= *f2))
			break;
		if (l == -1)
		    return(0);
	    }
	    else /* search upward in list */
	    {
		f1 = f2;
		f2 = f2+1;
		for (l=last_i+1;l<inf->dimensions[0];l++,f1++,f2++)
		    if ((*x >= *f1) && (*x <= *f2))
			break;
		if (l == inf->dimensions[0])
		    return(0);
	    }
	    *i = last_i = l;
	}
    }
	
    /* do y coords next. */
    f1 = inf->points + inf->dimensions[0];
    f2 = f1+1;
    if (deja_vu == 0)
    {
	for (l=0;l<inf->dimensions[1]-1;l++,f1++,f2++)
	    if ((*y >= *f1) && (*y <= *f2))
		break;
	if (l == inf->dimensions[1])
	    return(0);
	else
	    *j = last_j = l;
    }
    else
    {
	f1 = f1 + last_j;
	f2 = f1+1;
	/* see if the last one we looked at is still valid. */
	if ((*y >= *f1) && (*y <= *f2))
	    *j = last_j;
	else
	{
	    if (*y < *f1) /* search downward in list */
	    {
		f2 = f1;
		f1 = f1 - 1;
		for (l=last_j - 1;l >= 0;l--,f1--,f2--)
		    if ((*y >= *f1) && (*y <= *f2))
			break;
		if (l == -1)
		    return(0);
	    }
	    else /* search upward in list */
	    {
		f1 = f2;
		f2 = f2+1;
		for (l=last_j+1;l<inf->dimensions[1];l++,f1++,f2++)
		    if ((*y >= *f1) && (*y <= *f2))
			break;
		if (l == inf->dimensions[1])
		    return(0);
	    }
	    *j = last_j = l;
	}
    }

    /* do z coords last. */
    f1 = inf->points + inf->dimensions[0] + inf->dimensions[1];
    f2 = f1+1;

    if (deja_vu == 0)
    {
	for (l=0;l<inf->dimensions[2]-1;l++,f1++,f2++)
	    if ((*z >= *f1) && (*z <= *f2))
		break;
	if (l == inf->dimensions[2])
	    return(0);
	else
	    *k = last_k = l;
    }
    else
    {
	f1 = f1 + last_k;
	f2 = f1+1;
	/* see if the last one we looked at is still valid. */
	if ((*z >= *f1) && (*z <= *f2))
	    *k = last_k;
	else
	{
	    if (*z < *f1) /* search downward in list */
	    {
		f2 = f1;
		f1 = f1 - 1;
		for (l=last_k - 1;l >= 0;l--,f1--,f2--)
		    if ((*z >= *f1) && (*z <= *f2))
			break;
		if (l == -1)
		    return(0);
	    }
	    else /* search upward in list */
	    {
		f1 = f2;
		f2 = f2+1;
		for (l=last_k+1;l<inf->dimensions[2];l++,f1++,f2++)
		    if ((*z >= *f1) && (*z <= *f2))
			break;
		if (l == inf->dimensions[2])
		    return(0);
	    }
	    *k = last_k = l;
	}
    }
    
    deja_vu = 1;
    
    return(1);
}

int
boundary_point(b,d)
int *b,*d;
{
    int status = 0;
    int i;

    for (i=0;i<3;i++)
    {
	if (b[i] == 0)
	    status |= 1;
	else if (b[i] == (d[i] - 1))
	    status |= 1;
    }
    return(status);
    
}

