/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

AUTHOR : Stardent Computer, Inc.
******************************************************************************/
/*--------------------------------------------------------------*
 |                                                              |
 |                      ****  ov_slice  ****                    |
 |                                                              |
 | display a slice of a 3D field together with a slice of a     |
 | vector field. the slice of the vector field is displayed     |
 | using the hedgehog method.                                   |
 |                                                              |
 | the 'scale' dial scales the length of the vectors.           |
 |                                                              |
 | the 'downsize' dial reduces the number of vectors displayed. |
 | a downsize value of two displays every other vector; a value |
 | of three every third vector.                                 |
 |                                                              |
 | the 'arrows' button selects the display of arrow heads for   |
 | the hedgehog display.                                        |
 |                                                              |
 | ov_slice.c                                      2 April 1990 |
 *--------------------------------------------------------------*/

#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/colormap.h>

extern char *AVSstatic;

#define ORTHO_INPUT "ortho_vslice input"
#define ORTHO_SLICE "slice plane"

ortho_vslice_desc()
  {
  int ortho_vslice_compute(), ortho_vslice_init(), param;

  AVSset_module_name ("ov slicer", MODULE_MAPPER);

  AVScreate_input_port (ORTHO_INPUT, "field 3D ", REQUIRED);
  AVScreate_input_port ("vector input", "field 3D 3-vector real", OPTIONAL);

  AVScreate_output_port ("Vector Output", "geom");
  AVScreate_output_port ("Image Output", "field 2D");

  param = AVSadd_parameter (ORTHO_SLICE, "integer", 0, 0, 255);

  AVSadd_parameter_prop (param, "immediate", "boolean", 1);

  AVSadd_parameter ("axis", "choice", "K", "I J K", " ");

  AVSadd_float_parameter ("scale", 0.2, 0.0, 10.0);

  AVSadd_parameter ("downsize", "integer", 1, 1, 16);

  AVSadd_parameter ("arrows", "boolean", 0, 0, 1);

  AVSset_init_proc (ortho_vslice_init);

  AVSset_compute_proc (ortho_vslice_compute);
  }


ortho_vslice_init() {
  AVSstatic = (char *)0;
  }


#define copy_data(TYPE) \
for (j = 0; j < slicey; j++) \
  for (k = 0; k < slicex; k++) \
    for (l = 0; l < vlen; l++) \
      output->TYPE[vlen * (j*slicex + k) + l] = \
        input->TYPE[vlen * (width * (k*height + j) + i) + l];
 

#define mcopy_data(TYPE) \
	for (k = 0; k < slicey; k++) \
        memcpy (&(output->TYPE[input->veclen * k * slicex]), \
        &(input->TYPE[vlen*((MAXX(input) * ((k * MAXY(input)) + j)))]), \
        size * slicex);


ortho_vslice_compute (input, vinput, voutput, outputp, plane, choice, vscale, 
		      downsize, arrows)

  AVSfield *input, **outputp;

  AVSfield_float *vinput;

  char *choice;

  float *vscale;

  GEOMedit_list **voutput;

  int plane, downsize, arrows;
  {

  AVSfield *output = 0, template;

  float vx, vy, vz, xc, yc, zc, *vdata;

  GEOMobj *obj;

  int dims[2], i, j, k, l, z, size, location, start, size2d, size3d,
      index, vlen, width, height, slicex, slicey, axis, offset, vloc, depth;
    
 /**************
  ***  body  ***
  **************/

  if (*outputp) {
    if (MAXX(*outputp) == MAXX(input) && MAXY(*outputp) == MAXY(input)) 
      output = *outputp;
    else
      free(*outputp);
    }
    
  if (!strcmp(choice, "I")) {
    axis = 0;
    slicex = MAXZ(input);
    slicey = MAXY(input);
    z = MAXX(input) - 1;
    }
  else if (!strcmp(choice, "J")) {
    axis = 1;
    slicex = MAXX(input);
    slicey = MAXZ(input);
    z = MAXY(input) - 1;
    } 
  else {
    axis = 2;
    slicex = MAXX(input);
    slicey = MAXY(input);
    z = MAXZ(input) - 1;
    }
   

  if (!AVSstatic || ((char *)z != AVSstatic)) {
    AVSstatic = (char *)z;
    AVSmodify_parameter (ORTHO_SLICE, AVS_MAXVAL | AVS_VALUE, z / 2, 0, z);
    }

  dims[0] = slicex;
  dims[1] = slicey;

  AVSfield_make_template (input, &template);

  template.ndim = 2;

  if (input->uniform == UNIFORM)
    template.nspace = 2;

  template.dimensions[0] = slicex;
  template.dimensions[1] = slicey;
  template.dimensions[2] = 1;

  output = (AVSfield *) AVSfield_alloc (&template, dims);

  if (plane < 0)
    plane = 0;
  else if (plane > z)
    plane = z;
    
  size = input->veclen * input->size;
  size2d = slicex * slicey;
  size3d = MAXX(input) * MAXY(input) * MAXZ(input);

  start = plane * MAXX(input) * MAXY(input);
  location = start * size;
  vloc = start * 4;

  vlen = input->veclen;
  width = MAXX(input);
  height = MAXY(input);
  depth = MAXZ(input);
  vdata = (float *)malloc(sizeof(float) * 3 * size2d);


  /*  copy data.  */

  switch (axis) {
    case 0:
      i = plane;

      switch (input->type) {
        case  AVS_TYPE_BYTE:
	  copy_data(field_data);
	break;

        case  AVS_TYPE_REAL:
	  copy_data(field_data_float);
	break;

        case  AVS_TYPE_DOUBLE:
	  copy_data(field_data_double);
	break;

        case  AVS_TYPE_INTEGER:
	  copy_data(field_data_int);
	break;
        }


    /*  copy vector data.  */

    if (vinput != NULL) {
      for (k = 0; k < depth; k++) {
        for (j = 0; j < height; j++) {
	  index = i + (width * (k * height + j));
          vdata[3*(j * slicex + k)] = vinput->data[index*3];
          vdata[3*(j * slicex + k) + 1] = vinput->data[index*3 + 1]; 
          vdata[3*(j * slicex + k) + 2] = vinput->data[index*3 + 2];
	}
      }
    }
    break;

    case 1:
      j = plane;

      switch (input->type) {
        case  AVS_TYPE_BYTE:
	  mcopy_data(field_data);
        break;

        case  AVS_TYPE_REAL:
	  mcopy_data(field_data_float);
	break;

        case  AVS_TYPE_DOUBLE:
	  mcopy_data(field_data_double);
	break;

        case  AVS_TYPE_INTEGER:
	  mcopy_data(field_data_int);
	break;
        }


      if (vinput != NULL) {
	for (k = 0; k < slicey; k++) 
          memcpy (&(vdata[3 * k * slicex]), 
		  &(vinput->data[3 * (width * (k * height) + j)]), 
                  3*4*slicex);
        }
    break;

    case 2:
      memcpy (output->field_data, &(input->field_data[location]), size*size2d);

      if (vinput != NULL) {
        memcpy (&(vdata[0]), &(vinput->data[3*start]), 3 * 4 * size2d);
        }
    break;
    }


  /*  copy points.  */

  switch (input->uniform) {
    case IRREGULAR:

      switch (axis) {
        case 0:
	  i = plane;

	  for (j = 0; j < slicey; j++) {
	    for (k = 0; k < slicex; k++) {
	      l = (MAXX(input) * ((MAXY(input)*k) + j)) + i;
	      output->points[j*slicex + k] = input->points[l];
	      output->points[j*slicex + k + size2d] = input->points[l + size3d];
	      output->points[j*slicex+ k + 2*size2d]=input->points[l + size3d*2];
              }
            }
	break;

        case 1:
  	  j = plane;

	  for (k = 0; k < slicey; k++) {
	    for(i = 0; i < slicex; i++) {
	      output->points[k*slicex + i] = COORD_X_3D(input, i, j, k);
	      output->points[k*slicex + i + size2d] = COORD_Y_3D(input, i, j, k);
	      output->points[k*slicex + i + 2*size2d]=COORD_Z_3D(input, i, j, k);
	      }
            }
	break;

        case 2:
	  for (i = 0; i < size2d; i++) {
	    output->points[i] = input->points[start + i];
	    output->points[i + size2d] = input->points[start + i + size3d];
	    output->points[i + 2*size2d] = input->points[start + i + 2*size3d];
            }
	break;
        }
    break;

    case RECTILINEAR:
      switch (axis) {
        case 0:
	  memcpy (output->points, &(input->points[MAXX(input)]), 
	          sizeof(float) * (MAXY(input) + MAXZ(input)));
	break;

        case 1:
	  memcpy(output->points, input->points, sizeof(float) * (MAXX(input)));
	  memcpy(&(output->points[MAXX(input)]), 
	         &(input->points[MAXX(input) + MAXY(input)]), 
	         sizeof(float) * (MAXZ(input)));
	break;

        case 2:
	  memcpy(output->points, input->points, 
		 sizeof(float) * (MAXX(input) + MAXY(input)));
	break;
        }
    break;

    default:
      case UNIFORM:
      break;
    }


  /*   create a geom object for the vectors.   */

  if (vinput != NULL) {
    *voutput = (GEOMedit_list *)GEOMinit_edit_list(*voutput);
					   
    obj = GEOMcreate_obj (GEOM_POLYTRI, NULL);

    create_vectors (output->points, vdata, slicex, slicey, &obj, *vscale, 
		    downsize, arrows);

    GEOMedit_geometry (*voutput, "vectors", obj);

    GEOMdestroy_obj (obj);
    }

  *outputp = output;

  return(1);
  }


create_vectors (points, vdata, width, height, obj, scale, downsize, arrows) 
  float points[], vdata[][3], scale;

  GEOMobj **obj;

  int width, height, downsize, arrows;
  {

  float verts[20][3], x, y, z;

  int nverts, size, skip, i, j, k;

 /**************
  ***  body  ***
  **************/

  size = width * height;
  nverts = 2;

  if (downsize == 1) {
    for (i = 0, k = 0; i < height; i++) {
      for (j = 0; j < width; j++, k++) {
        x = points[k];
        y = points[k + size];
        z = points[k + 2*size];

	if (arrows) 
	  create_arrow (x, y, z, vdata[k], scale, &nverts, verts);
	else {
          verts[0][0] = x;
          verts[0][1] = y;
          verts[0][2] = z;

          verts[1][0] = x + scale * vdata[k][0];
          verts[1][1] = y + scale * vdata[k][1];
          verts[1][2] = z + scale * vdata[k][2];
          }

        GEOMadd_disjoint_line (*obj, verts, NULL, nverts, GEOM_COPY_DATA);
	}
      }
    }
  else {
    for (i = 0; i < height; i += downsize) {
      for (j = 0; j < width; j += downsize) {
	k = width * i + j;
        x = points[k];
        y = points[k + size];
        z = points[k + 2*size];

	if (arrows) 
	  create_arrow (x, y, z, vdata[k], scale, &nverts, verts);
	else { 
          verts[0][0] = x;
          verts[0][1] = y;
          verts[0][2] = z;
  
          verts[1][0] = x + scale * vdata[k][0];
          verts[1][1] = y + scale * vdata[k][1];
          verts[1][2] = z + scale * vdata[k][2];
	  }

        GEOMadd_disjoint_line (*obj, verts, NULL, nverts, GEOM_COPY_DATA);
        }
      }
    }
  }


create_arrow (x, y, z, v1, scale, nverts, verts)
  
  float x, y, z, v1[3], scale, verts[][3];

  int *nverts;
  {

  double sqrt();

  float mag, s1, x1, y1, z1, nx, ny, nz, s, vt[3], v2[3], v3[3], vx, vy, vz;

  int i, n, m;

  static float arrow_scale = 0.4;

 /**************
  ***  body  ***
  **************/

  nx = scale * v1[0];
  ny = scale * v1[1];
  nz = scale * v1[2];
  mag = sqrt(nx * nx + ny * ny + nz * nz);

  if (mag == 0.0) {
    n = 0;
    verts[n][0] = x;
    verts[n][1] = y;
    verts[n++][2] = z;
    verts[n][0] = x;
    verts[n][1] = y;
    verts[n++][2] = z;
    }
  else {
    s = 0.9;
    s1 = arrow_scale * (1.0 - s) * mag;
    vx = x + s * nx;
    vy = y + s * ny;
    vz = z + s * nz;


    /*  compute v2[] and v3[], which will be 
        the sides of the arrow head.          */

    vt[0] = -v1[1];
    vt[1] = v1[0];
    vt[2] = 0.0;

    if ((vt[0] == 0.0) && (vt[1] == 0.0))
      vt[0] = 1.0;

    vcross_prod (v1, vt, v2);
    vcross_prod (v1, v2, v3);

    vnorm (v2);
    vnorm (v3);

    n = 0;
    verts[n][0] = x;
    verts[n][1] = y;
    verts[n++][2] = z;
    verts[n][0] = x1 = x + nx;
    verts[n][1] = y1 = y + ny;
    verts[n++][2] = z1 = z + nz;

    verts[n][0] = x1;  
    verts[n][1] = y1;  
    verts[n++][2] = z1;  

    verts[n][0] = vx + s1 * v2[0];
    verts[n][1] = vy + s1 * v2[1]; 
    verts[n++][2] = vz + s1 * v2[2];

    verts[n][0] = x1;  
    verts[n][1] = y1;  
    verts[n++][2] = z1;  
    verts[n][0] = vx + s1 * v3[0]; 
    verts[n][1] = vy + s1 * v3[1];
    verts[n++][2] = vz + s1 * v3[2];

    verts[n][0] = x1;  
    verts[n][1] = y1;  
    verts[n++][2] = z1;  
    verts[n][0] = vx - s1 * v2[0];  
    verts[n][1] = vy - s1 * v2[1];
    verts[n++][2] = vz - s1 * v2[2]; 

    verts[n][0] = x1;  
    verts[n][1] = y1;  
    verts[n++][2] = z1;  
    verts[n][0] = vx - s1 * v3[0]; 
    verts[n][1] = vy - s1 * v3[1];
    verts[n++][2] = vz - s1 * v3[2]; 


    /*  form the base of the arrow head.  */

    for (m = n, i = 3; i < m; i += 2) {
      verts[n][0] = verts[i][0];  
      verts[n][1] = verts[i][1];  
      verts[n++][2] = verts[i][2];  

      if (i == 9) {
        verts[n][0] = verts[3][0];  
        verts[n][1] = verts[3][1];  
        verts[n++][2] = verts[3][2];  
        }
      else {
        verts[n][0] = verts[i + 2][0];  
        verts[n][1] = verts[i + 2][1];  
        verts[n++][2] = verts[i + 2][2];  
        }
      }
    }

  *nverts = n;
  }


AVSinit_modules()
  {
  AVSmodule_from_desc (ortho_vslice_desc);
  }


vnorm (v)
  float v[];
  {

  double mag, sqrt();

 /**************
  ***  body  ***
  **************/

  mag = sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);

  if (mag == 0.0) {
    v[0] = 0.0;
    v[1] = 0.0;
    v[2] = 0.0;
    return (0);
    }
  else {
    v[0] = v[0] / mag;
    v[1] = v[1] / mag;
    v[2] = v[2] / mag;
    }

  return (1);
  }



vcross_prod (v1, v2, v3)
  float *v1, *v2, *v3;
  {

 /**************
  ***  body  ***
  **************/

  v3[0] = v1[1] * v2[2] - v1[2] * v2[1];
  v3[1] = v1[2] * v2[0] - v1[0] * v2[2];
  v3[2] = v1[0] * v2[1] - v1[1] * v2[0];
  }


