/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/*
 * plumb_line
 *
 * Plumb Line Field sampler,
 * puts a vertical line (Z-axis) through a 3D irregular field,
 * allows "picking" of icons at the top or dials for x-y position.
 *
 * Author: I. Curington, AVS Inc., UK
 *
 * Revision:
 * 17 Mar 93 ianc - Original
 * 26 Aug 93 ianc - fixed pointer indirection prob
 */
#ifdef SCCS
static char sccsid[]="@(#)plumb_line.c	7.1 AVS 92/02/25";
#endif
/*
			Copyright (c) 1989,1990 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
*/

#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/udata.h>

/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>

/******************************************************************************/

#define X_3D(field, i, j, k) \
         ((field)->points[ ( dx * ( dy * k + j)) + i ])

#define Y_3D(field, i, j, k) \
         ((field)->points[ ( dx * (( dy * ( dz + k)) + j)) + i])

#define Z_3D(field, i, j, k) \
         ((field)->points[ ( dx * (( dy * ( dz*2 + k)) + j)) + i])


/******************************************************************************/

/* 
 * Drop a plumb line down one vert line of an irreg field
 *
 * Author: I. Curington, AVS Inc., UK
 */  

/* 
 * The function AVSinit_modules is called from the main() routine supplied
 * by AVS.  In it, we call AVSmodule_from_desc with the name of our 
 * description routine.
 */

AVSinit_modules()
{
	int plumb_line();

	AVSmodule_from_desc(plumb_line);
}

/*  
 * The routine "plumb_line" is the description routine.  It provides
 * AVS some necessary information such as: name, input and output ports, 
 * parameters etc. 
 */
plumb_line()
{
	int plumb_line_compute();	/* declare the compute function (below) */
	int out_port;	/* temporaries to hold the port numbers */
	int in_port;	/* temporaries to hold the port numbers */
	int parm;

	/* Set the module name and type */
	AVSset_module_name("plumb_line", MODULE_MAPPER);

	/* There is one input port for this module */
	in_port =
           AVScreate_input_port(/*name*/ "Vel-Field",
                   /*type*/"field 3D scalar 3-space irregular float", REQUIRED);

        in_port = AVScreate_input_port("pick",
              "struct upstream_geom", OPTIONAL | INVISIBLE);
        AVSset_input_class(in_port,"upstream_geom");

	/* Create an output port for the result */
	out_port =
           AVScreate_output_port(/*name*/ "LineIcon",
                   /*type*/"geom");

	out_port =
           AVScreate_output_port(/*name*/ "X-Index", /*type*/"integer");

	out_port =
           AVScreate_output_port(/*name*/ "Y-Index", /*type*/"integer");

        /* set up some interactive parameters */
        parm = AVSadd_parameter("Dx","integer",1,0,1000);
        parm = AVSadd_parameter("Dy","integer",1,0,1000);

	/* Tell avs what subroutine to call to do the compute */
	AVSset_compute_proc(plumb_line_compute);
}

/******************************************************************************/

/*
 * plumb_line_compute is the compute routine.  It is called whenever AVS 
 * is given a new filename for us to compute.  The arguments are: the 
 * output geometry (passed by reference), and the filename parameter.  
 * Note that the order is always inputs, outputs, parameters.
 */

plumb_line_compute(input, xgeom, output, x_index, y_index, ix, iy )
    AVSfield_float *input;
    upstream_geom *xgeom;
    GEOMedit_list *output;
    int *x_index;
    int *y_index;
    int ix, iy;
{
   int i, j, k;
   int dx, dy, dz;
   float verts[2][3];
   int vdata[2];
   static float vcolor_white[2][3] = { .9, .9, .9, .9, .9, .9 };
   static float vcolor_red[2][3]   = { .9, 0., 0., .9, 0., 0. };
   GEOMobj *obj;
   float size;
   int index[2][100000];
   static int iix, iiy;
   
   /***********
    * Body    *
    ***********/

   dx = input->dimensions[0];
   dy = input->dimensions[1];
   dz = input->dimensions[2];

   AVSmodify_parameter("Dx",AVS_MAXVAL,0,0,dx);
   AVSmodify_parameter("Dy",AVS_MAXVAL,0,0,dy);

   size = 0.25 * ( X_3D(input,dx-1,0,0) - X_3D(input,0,0,0) )/(float)dx;

    /* establish the geometry output object */
    *output = GEOMinit_edit_list(*output);
    obj    =  GEOMcreate_obj ( GEOM_POLYTRI, NULL);


   /* fill index array */
   for (i = 0; i < dx; i++)
     for (j = 0; j < dy; j++)
     {
         k = j * dx + i;
         index[0][ k ] = i;
         index[1][ k ] = j;
     }


    /* Pick Mode */
    if ( xgeom != NULL &&
         AVSinput_changed( "pick", 0) &&
         xgeom->vdata >= 0 )
    {
        ix = index[0][ xgeom->vdata ];
        iy = index[1][ xgeom->vdata ];
        AVSmodify_parameter("Dx",AVS_VALUE,ix,0,dx);
        AVSmodify_parameter("Dy",AVS_VALUE,iy,0,dy);
    }


   /* cross hair markers */
   k = 0;
   for (i = 0; i < dx; i++)
     for (j = 0; j < dy; j++)
     {
         verts[0][0] = X_3D(input, i, j, k)-size;
         verts[0][1] = Y_3D(input, i, j, k);
         verts[0][2] = Z_3D(input, i, j, k)-4.0*size ;
         verts[1][0] = X_3D(input, i, j, k)+size;
         verts[1][1] = Y_3D(input, i, j, k);
         verts[1][2] = Z_3D(input, i, j, k)-4.0*size;
         if ( i==ix && j==iy )
           GEOMadd_disjoint_line (obj, verts, vcolor_white, 2, GEOM_COPY_DATA);
         else
           GEOMadd_disjoint_line (obj, verts, vcolor_red, 2, GEOM_COPY_DATA);
         vdata[0] = vdata[1] = j * dx + i;
         GEOMadd_disjoint_vertex_data (obj, vdata, 2, GEOM_COPY_DATA);

         verts[0][0] = X_3D(input, i, j, k);
         verts[0][1] = Y_3D(input, i, j, k)-size;
         verts[0][2] = Z_3D(input, i, j, k)-4.0*size ;
         verts[1][0] = X_3D(input, i, j, k);
         verts[1][1] = Y_3D(input, i, j, k)+size;
         verts[1][2] = Z_3D(input, i, j, k)-4.0*size;
         if ( i==ix && j==iy )
           GEOMadd_disjoint_line (obj, verts, vcolor_white, 2, GEOM_COPY_DATA);
         else
           GEOMadd_disjoint_line (obj, verts, vcolor_red, 2, GEOM_COPY_DATA);
         vdata[0] = vdata[1] = j * dx + i;
         GEOMadd_disjoint_vertex_data (obj, vdata, 2, GEOM_COPY_DATA);
     }


   /* drop line */
   i = ix; j = iy;
   for (k = 0; k < dz-1; k++)
   {
         verts[0][0] = X_3D(input, i, j, k);
         verts[0][1] = Y_3D(input, i, j, k);
         verts[0][2] = Z_3D(input, i, j, k);
         verts[1][0] = X_3D(input, i, j, k+1);
         verts[1][1] = Y_3D(input, i, j, k+1);
         verts[1][2] = Z_3D(input, i, j, k+1);
         GEOMadd_disjoint_line (obj, verts, vcolor_white, 2, GEOM_COPY_DATA);
         vdata[0] = vdata[1] = j * dx + i;
         GEOMadd_disjoint_vertex_data (obj, vdata, 2, GEOM_COPY_DATA);
   }


    /* complete the geometry to output port process */
    GEOMedit_geometry (*output, "plumb_line", obj);
    GEOMdestroy_obj (obj);
    GEOMedit_transform_mode (*output, "plumb_line", "parent");
    GEOMedit_selection_mode(*output,"plumb_line",
                   "notify", BUTTON_MOVING | BUTTON_DOWN );

    /* integer output ports */

    iix = ix; iiy = iy;
    *x_index = iix;  /* return pointer */
    *y_index = iiy;

   /* 
    * Make sure that module returns success when finished (otherwise
    * AVS might think that it failed and won't execute downstream modules) 
    */
   return(1);
}
/******************************************************************************/

