/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce rgbtogray.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  rgbtogray.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  rgbtogray.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     rgbtogray.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
rgbtogray.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/


#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>
#include <avs/flow.h>

AVSinit_modules()
{
    int avs_rgbtogray_desc();
    AVSmodule_from_desc(avs_rgbtogray_desc);
}

int avs_rgbtogray_desc()
{
    int rgbtogray_compute();
    int in_port,out_port;

    AVSset_module_name("rgbtogray", MODULE_MAPPER);
    in_port  = AVScreate_input_port("Input Field", "field 4-vector byte", REQUIRED);
    out_port = AVScreate_output_port("Output Field","field scalar byte");
    AVSset_compute_proc(rgbtogray_compute);
}

int rgbtogray_compute(input,output)
AVSfield *input,**output;
{
    switch (input->type) {
	case AVS_TYPE_BYTE    : rgbtogray_byte(input,output);
				break;
	default               :
	    AVSwarning(" Input ARGB image(s) must be in BYTE format.");
	    break;
    }

    return(1); /* success */
}

int
rgbtogray_byte(in,out)
AVSfield_char *in,**out;
{
    register unsigned char *id,*od;
    AVSfield_char template;
    int dims[3];
    int i,j,k,frames;
    double t;

    memset((char *)&template,0,sizeof(AVSfield_char));
    
    template.ndim = in->ndim;
    template.nspace = 0;
    template.veclen = 1;
    template.type = in->type;
    template.size = sizeof(char);
    template.uniform = UNIFORM;

    dims[0] = in->dimensions[0];
    dims[1] = in->dimensions[1];
    if (in->ndim == 3)
    {
	frames = dims[2] = in->dimensions[2];
    }
    else
	frames = 1;

    if (*out)
	AVSfield_free((char *)(*out));
    *out = (AVSfield_char *)AVSfield_alloc(&template,dims);
    if (*out == NULL)
    {
	AVSwarning(" Malloc error in rgbtogray. ");
	return;
    }

    id = in->data;
    od = (*out)->data;
    for (k=0;k<frames;k++)
    {
	for (j=0;j<dims[1];j++)
	{
	    for (i=0;i<dims[0];i++)
	    {
		id++; /* skip alpha component */
		t = 0.299 * (double)*id++;  /* red weight */
		t += 0.587 * (double)*id++;  /* green weight */
		t += 0.144 * (double)*id++;  /* blue weight */
		if (t > 255.0)
		    t = 255.0;
		*od++ = (unsigned char)t;
	    }
	}
    }
}

