/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* AVS Mapper: Rubberbonds

	(C) 1993 by Nihar Gokhale, Argonne Natl. Labs, gokhale@mcs.anl.gov
*/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/geom.h>
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
#define CHEM_APPL
#include <avs/chemistry/CHEMmol.h>
#define DO_ROTATION
#define MAXCYL 7000

/* IAC CODE CHANGE : CHEMatom *NIHARatom_of_index(CHEMatom **,int); */

CHEMatom *NIHARatom_of_index(rootatom, conn)
	CHEMatom **rootatom;
	int conn;
{
	CHEMatom *atom;
	int i;

	for (atom = *rootatom, i=1; i < conn; i++, atom = CHEMatom_get_next(&atom));

	/*CHEMatom_get_inumber(atom,&inum);
	fprintf(stderr,"nihar-atom-of-index %d returns %d\n",conn,inum);*/

	return atom;
}

/****************************************/
/* main 				*/
/****************************************/

int rubberbonds_compute(mol,geo_out,min_radius,equil_radius,max_radius)
	CHEMmolecule *mol;
	GEOMedit_list *geo_out;
	float *min_radius, *equil_radius, *max_radius;
{
  int i, idx, num_vert, icyl, nsides,
	cyl, *plist, *itmp, conn = 0, inum, clr[MAXCYL];
  static float *theta, *verts,  mat[4][4], center[3],mattmp[4][4],flt_clr[3];
  static double xc[MAXCYL], yc[MAXCYL], zc[MAXCYL], r[MAXCYL], h[MAXCYL],
	x2[MAXCYL], y2[MAXCYL], z2[MAXCYL], dz,dx,dy, xrot[MAXCYL],
	zrot[MAXCYL], proj, equil_dist, min_dist, max_dist,slope;

 static double last_xrot[MAXCYL]=0.0, last_zrot[MAXCYL]=0.0;
  static char objname[MAXCYL][80],*firstatom,*secondatom;
  static GEOMobj *obj[MAXCYL];
  static CHEMatom *atom = NULL, *atom2 = NULL, *rootatom = NULL;
  static CHEMcandb *cnb = NULL;



  CHEMmolecule_get_atom(mol,&atom);

  for (cyl=0, rootatom=atom; atom; atom = CHEMatom_get_next(&atom))
  {
	CHEMatom_get_candb(atom,&cnb);

	for ( ; cnb ; cnb = CHEMcandb_get_next(&cnb))
	{
		if (cyl >= MAXCYL)
			AVSerror("exceeded MAXCYL");

		sprintf(objname[cyl],"cyl%i\0",cyl);
		sprintf(objname[cyl+1],"cyl%i\0",cyl+1);

		CHEMatom_get_xyz(atom,&xc[cyl],&yc[cyl],&zc[cyl]);
		CHEMatom_get_inumber(atom,&inum);
		CHEMcandb_get_conn(cnb,&conn);

		if (inum < conn)
		{

		atom2 = NIHARatom_of_index(&rootatom,conn);

		CHEMatom_get_xyz(atom2,&x2[cyl],&y2[cyl],&z2[cyl]);

#ifdef DEBUG_RUBBERBONDS
fprintf(stderr,"from (%f,%f,%f) to (%f,%f,%f)\n",xc[cyl],yc[cyl],zc[cyl],x2[cyl],y2[cyl],z2[cyl]);
#endif


      dz = z2[cyl] - zc[cyl];
      dx = x2[cyl] - xc[cyl];
      dy = y2[cyl] - yc[cyl];

	h[cyl] = sqrt( dx*dx +dy*dy +dz*dz);

	CHEMatom_get_color(atom,&clr[cyl]);
	CHEMatom_get_color(atom2,&clr[cyl+1]);

	CHEMatom_get_name(atom, &firstatom);
	CHEMatom_get_name(atom2, &secondatom);

	if (*firstatom=='H' || *secondatom=='H')
	{
		min_dist = 0.7;
		equil_dist = 1.0;
		max_dist = 1.3;
	}
	else if (*firstatom == 'N' || *secondatom=='N')
	{
		min_dist = 0.9;
		equil_dist = 1.4;
		max_dist = 1.9;
	}
	else if (*firstatom=='O' || *secondatom=='O')
	{
		min_dist = 0.7;
		equil_dist = 1.25;
		max_dist = 1.8;
	}
	else
	{
		min_dist = 1.0;
		equil_dist = 1.5;
		max_dist = 2.0;
	}

	if (h[cyl] >= min_dist && h[cyl] <= equil_dist)
	{
		slope = (*equil_radius - *max_radius) / (equil_dist - min_dist);
		r[cyl] = slope * (h[cyl]-min_dist) + *max_radius;
	}
	else if (h[cyl] > equil_dist && h[cyl] <= max_dist)
	{
		slope = (*min_radius - *equil_radius) / (max_dist -equil_dist);
		r[cyl] = slope * (h[cyl]-equil_dist) + *equil_radius;
	}
	else if (h[cyl] < min_dist)
		r[cyl] = *max_radius;
	else
		r[cyl] = *min_radius;


#ifdef DEBUG_RUBBERBONDS
fprintf(stderr,"%c - %c bond, eq. dist=%f, r[cyl]=%f\n",*firstatom,*secondatom,
		equil_dist, r[cyl]);
#endif

#ifdef DO_ROTATION
	proj = sqrt( h[cyl]*h[cyl] - dz*dz);
	xrot[cyl] = -1 *sacos(dz/h[cyl])* 180.0/M_PI;
	zrot[cyl] = sacos(dy/proj) *180.0/M_PI;

	if (dx<0)
		zrot[cyl] *= -1;

#endif


	xrot[cyl+1] = xrot[cyl];
	zrot[cyl+1] = zrot[cyl];
	r[cyl+1] = r[cyl];
	h[cyl] *= 0.5;
	h[cyl+1] = h[cyl];

	xc[cyl+1] = (xc[cyl] + x2[cyl])/2;
	yc[cyl+1] = (yc[cyl] + y2[cyl])/2;
	zc[cyl+1] = (zc[cyl] + z2[cyl])/2;

	x2[cyl+1] = x2[cyl];
	y2[cyl+1] = y2[cyl];
	z2[cyl+1] = z2[cyl];

	x2[cyl] = xc[cyl+1];
	y2[cyl] = yc[cyl+1];
	z2[cyl] = zc[cyl+1];

	cyl+=2;

#ifdef DEBUG_RUBBERBONDS
	fprintf(stderr,"xrot=%f, zrot=%f, dx=%f,dy=%f,dz=%f \n",xrot[cyl],zrot[cyl],dx,dy,dz);
#endif
		}/*if*/
	}/*for*/
  }


 nsides = 5;


/* Create the geo_out object                                             */

      theta = (float *) ALLOC_LOCAL(nsides*sizeof(float));
      for (i = 0; i < nsides; i++)
	theta[i] = (2*M_PI*i)/nsides;

      num_vert = 4*nsides;
      verts = (float *) ALLOC_LOCAL(3*num_vert*sizeof(float));

      plist = (int *) ALLOC_LOCAL((nsides*5 +  1)*sizeof(int)); 

  for (icyl = 0; icyl < cyl-2; icyl++)
    {

      for (i = 0; i < nsides; i++)
	{
	  idx= 3*i;
	  verts[idx] = r[icyl] * cos(theta[i]) + xc[icyl];
	  verts[idx+1] = r[icyl] * sin(theta[i]) + yc[icyl];
	  verts[idx+2] =  zc[icyl];
	}

      for (i = 0; i < nsides; i++)
	{
	  idx = 3*(i + nsides);
	  verts[idx] = r[icyl] * cos(theta[i]) + xc[icyl];
	  verts[idx+1] = r[icyl] * sin(theta[i]) + yc[icyl];
	  verts[idx+2] = h[icyl] + zc[icyl];
	}

      itmp = plist;
      for (i = 1; i < nsides; i++)
	{
		*itmp = 4;
		++itmp;
		*itmp = i;
		++itmp;
		*itmp = nsides + i;
		++itmp;
		*itmp = nsides + i + 1;
		++itmp;
		*itmp = i + 1;
		++itmp;
	}
    
		*itmp = 4;
		++itmp;
		*itmp = i;
		++itmp;
		*itmp = nsides + i;
		++itmp;
		*itmp = nsides + 1;
		++itmp;
		*itmp =  1;
		++itmp;

      *itmp = 0;

/* create a GEOM_POLYHEDRON                                              */
      obj[icyl] = GEOMcreate_polyh(GEOM_NULL, verts, num_vert, plist, 
				      GEOM_CONVEX, GEOM_COPY_DATA);



/* Create the GEOM Edit List for geo_out                                 */
      if (icyl == 0)
	*geo_out = GEOMinit_edit_list(*geo_out);


      GEOMedit_geometry(*geo_out, objname[icyl], obj[icyl]);

	flt_clr[0] = AVS_RED_MASK & clr[icyl];
	flt_clr[1] = AVS_GREEN_MASK & clr[icyl];
	flt_clr[2] = AVS_BLUE_MASK & clr[icyl];

	GEOMedit_color(*geo_out, objname[icyl], flt_clr);

#ifdef DO_ROTATION

    /* set the center for rotation with GEOMedit_center p.G-40 in dev.guide*/
	center[0]=xc[icyl];
	center[1]=yc[icyl];
	center[2]=zc[icyl] ;
	GEOMedit_center(*geo_out,objname[icyl],center);


      mat_identity(mat);
      mat_x_rotate( xrot[icyl]-last_xrot[icyl] ,mattmp);
      mat_multiply(mat,mattmp,mat);

      mat_z_rotate( zrot[icyl]-last_zrot[icyl],mattmp);
      mat_multiply(mat,mattmp,mat);

      GEOMedit_concat_matrix(*geo_out,objname[icyl],mat);

	last_xrot[icyl] = xrot[icyl];
	last_zrot[icyl] = zrot[icyl];
#endif


      GEOMdestroy_obj(obj[icyl]); 


/* free locally allocated data */

    }/*for*/
      FREE_LOCAL(theta);
      FREE_LOCAL(verts);
      FREE_LOCAL(plist);
	return(1);
}
 




/****************************************/
/*  AVS stuff . . . 			*/
/****************************************/
int rubberbonds_desc()
{

	int in_port, out_port, param;
	extern int rubberbonds_compute();
	AVSset_module_name("rubberbonds", MODULE_MAPPER);
	in_port = AVScreate_input_port("huge_molecule","molecule",REQUIRED);
	out_port = AVScreate_output_port("rubber bonding", "geom");

	param = AVSadd_float_parameter("min thickness",0.2,0.0,0.9);
	AVSconnect_widget(param, "slider");

	param = AVSadd_float_parameter("equil. thickness",0.01,0.0,0.9);
	AVSconnect_widget(param, "slider");

	param = AVSadd_float_parameter("max thickness",0.5,0.0,0.9);
	AVSconnect_widget(param, "slider");

	AVSset_compute_proc(rubberbonds_compute);
	return(1);
}

/************************************************************************/
/* Initialization for modules contained in this file.                   */
/************************************************************************/
int ((*mod_list[])()) = { rubberbonds_desc, };
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}


