/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <string.h>
#include <avs/flow.h>
#include <avs/avs_data.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/colormap.h>

#define COORD_X_1D(field, i) \
        ((field)->uniform == UNIFORM ? (i) : \
         (field)->uniform == RECTILINEAR ? (field)->points[(i)] : \
         (((field)->points)[(i)]))

#define COORD_Y_1D(field, i) \
        ((field)->uniform == UNIFORM ? (i) : \
         (field)->uniform == RECTILINEAR ? \
            (field)->points[(field)->dimensions[0] + (i)] : \
         (((field)->points)[(field)->dimensions[0] + (i)]))

#define COORD_Z_1D(field, i) \
        ((field)->uniform == UNIFORM ? (i) : \
         (field)->uniform == RECTILINEAR ? \
            (field)->points[(field)->dimensions[0]*2 + (i)] : \
         (((field)->points)[(field)->dimensions[0]*2 + (i)] ))


/******************************************************************************/

/* 
 * This is a C program to create a sphere rendition of a scatter field
 * using a color map to color the spheres.
 *
 *  module created by Michael Rangitsch  
 *
 *     revision history:
 *  
 *          3/5/92  initial version
 */

/* 
 * The function AVSinit_modules is called from the main() routine supplied
 * by AVS.  In it, we call AVSmodule_from_desc with the name of our 
 * description routine.
 */

AVSinit_modules()
{
	int scat_bub();

	AVSmodule_from_desc(scat_bub);
}

/*  
 * The routine "scat_bub" is the description routine.  It provides
 * AVS some necessary information such as: name, input and output ports, 
 * parameters etc. 
 */
scat_bub()
{
	int scat_bub_compute();  /* declare the compute function (below) */
	int out_port,in_port1,in_port2;/* temps to hold the port numbers */
        int param1,param2,param3,param4;  /* temps to hold the parameter indices */

	/* Set the module name and type */
	AVSset_module_name("scat_bub", MODULE_MAPPER);

	/* Create a scatter input port */
        in_port1=AVScreate_input_port("scatter field",
                    "field 1D real 3-space irregular",REQUIRED);

	/* Create a colormap input port */
        in_port2=AVScreate_input_port("colormap","colormap",OPTIONAL);

	/* Create an output port for the geometry result */
	out_port = AVScreate_output_port(/*name*/ "Spheres", /*type*/"geom");

        /* Create a parameter for the radius scaling */
        param4=AVSadd_float_parameter("radius scaling",1.0,0.0,2.0);
        AVSconnect_widget(param4,"slider");

        /* Create a parameter for the line drop */ 
        param1=AVSadd_parameter("drop x","boolean",0,0,0);
        AVSconnect_widget(param1,"toggle");

        /* Create a parameter for the line drop */
        param2=AVSadd_parameter("drop y","boolean",0,0,0);
        AVSconnect_widget(param2,"toggle");

        /* Create a parameter for the line drop */
        param3=AVSadd_parameter("drop z","boolean",0,0,0);
        AVSconnect_widget(param3,"toggle");

	/* Tell avs what subroutine to call to do the compute */
	AVSset_compute_proc(scat_bub_compute);
}

/*
 *   The compute function creates the spheres and drop lines, if wanted 
 */


scat_bub_compute(input, colmap, output, radius_scale, x_drop, y_drop, z_drop)
AVSfield_float *input;
AVScolormap *colmap;
GEOMedit_list *output;
float *radius_scale;
int x_drop, y_drop, z_drop;
{
   int i, j, k, n_spheres, map_value, index;
   float *vertices;
   float *radii;
   float *colors;
   float drop_verts[2][3];
   float line_color[2][3];
   float data_min, data_max, val_range, radius;
   GEOMobj *obj_sphere, *obj_drops;

   n_spheres = MAXX(input);

   vertices = (float *)malloc(sizeof(float) * n_spheres * 3);
   radii = (float *)malloc(sizeof(float) * n_spheres);
   colors = (float *)malloc(sizeof(float) * n_spheres * 3); 

   obj_drops = GEOMcreate_obj(GEOM_POLYTRI,GEOM_NULL);

   index = 0;
   for(i = 0; i < n_spheres; i++)
    {
     vertices[index] = COORD_X_1D(input,i); 
     vertices[index+1] = COORD_Y_1D(input,i); 
     vertices[index+2] = COORD_Z_1D(input,i); 
     radii[i] = *radius_scale; /* (input)->data[i]; */
     index = index + 3;
    }  

    obj_sphere = GEOMcreate_sphere(GEOM_NULL,vertices,radii,GEOM_NULL,
                    GEOM_NULL,n_spheres,GEOM_COPY_DATA);  

   /* now assign the colors, based on colors from the color map */
     if(colmap) 
     {
     index = 0;
     for (i = 0; i < n_spheres; i++)
      {
       map_value =  AVScmap_index(colmap, (input)->data[i]);
       FILTERhsv_to_rgb(&colors[index],&colors[index+1],
                        &colors[index+2],
             colmap->hue[map_value],colmap->saturation[map_value],
             colmap->value[map_value]);
       index = index + 3;
      }
     
      GEOMadd_float_colors(obj_sphere,colors,n_spheres,GEOM_COPY_DATA); 
     }
     

  /*  now create the drop lines (if desired) */

  if(x_drop == 1)
  {
    index = 0;
    for(i = 0; i < n_spheres; i++)
    {
     drop_verts[0][0] = vertices[index];
     drop_verts[0][1] = vertices[index+1];
     drop_verts[0][2] = vertices[index+2];

     drop_verts[1][0] = 0.0;
     drop_verts[1][1] = vertices[index+1]; 
     drop_verts[1][2] = vertices[index+2]; 

     line_color[0][0] = colors[index];
     line_color[0][1] = colors[index+1];
     line_color[0][2] = colors[index+2];

     line_color[1][0] = colors[index];
     line_color[1][1] = colors[index+1];
     line_color[1][2] = colors[index+2];

     GEOMadd_disjoint_line(obj_drops,drop_verts,line_color,2,GEOM_COPY_DATA);
     index = index + 3;
    }
   }  
  if(y_drop == 1)
  {
    index = 0;
    for(i = 0; i < n_spheres; i++)
    {
     drop_verts[0][0] = vertices[index];
     drop_verts[0][1] = vertices[index+1];
     drop_verts[0][2] = vertices[index+2];

     drop_verts[1][0] = vertices[index];
     drop_verts[1][1] = 0.0;
     drop_verts[1][2] = vertices[index+2];

     line_color[0][0] = colors[index];
     line_color[0][1] = colors[index+1];
     line_color[0][2] = colors[index+2];

     line_color[1][0] = colors[index];
     line_color[1][1] = colors[index+1];
     line_color[1][2] = colors[index+2];

     GEOMadd_disjoint_line(obj_drops,drop_verts,line_color,2,GEOM_COPY_DATA);
     index = index + 3;
    }
   }
  if(z_drop == 1)
  {
    index = 0;
    for(i = 0; i < n_spheres; i++)
    {
     drop_verts[0][0] = vertices[index];
     drop_verts[0][1] = vertices[index+1];
     drop_verts[0][2] = vertices[index+2];

     drop_verts[1][0] = vertices[index];
     drop_verts[1][1] = vertices[index+1];
     drop_verts[1][2] = 0.0;

     line_color[0][0] = colors[index];
     line_color[0][1] = colors[index+1];
     line_color[0][2] = colors[index+2];

     line_color[1][0] = colors[index];
     line_color[1][1] = colors[index+1];
     line_color[1][2] = colors[index+2];

     GEOMadd_disjoint_line(obj_drops,drop_verts,line_color,2,GEOM_COPY_DATA);
     index = index + 3;
    }
   }
  
   /* 
    * Now we communicate this object to AVS: 
    * first we initialize the list of changes for this time to NULL 
    */

   *output = GEOMinit_edit_list(*output);

   /* Now we replace the geometry for the object named "scat_bub" 
      to this obj */

   GEOMedit_geometry(*output,"scat_bub",obj_sphere);

   if(x_drop + y_drop + z_drop >= 1) {
     GEOMedit_geometry(*output,"scat_bub",obj_drops);}

   /* Then we free up our reference to this object */

   GEOMdestroy_obj(obj_sphere);

   if(x_drop + y_drop + z_drop >= 1) {
     GEOMdestroy_obj(obj_drops); }
 
   free(radii); 
   free(vertices); 
   free(colors);
   /* 
    * Make sure that module returns success when finished (otherwise
    * AVS might think that it failed and won't execute downstream modules) 
    */
   return(1);
}
