/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 * scatter_cubes
 *
 * draw geometric representation of scatter input
 *
 * If your vector data is 1D 1-vector or 4-vector irregular,
 * this module will draw cubes from the
 * specified positions in the scatter field coord
 * array.
 *
 * Author: I. Curington, AVS Inc, UK
 *
 * Revision:
 * 31 March 92  Original (from ucd_cell_cubes, cell data)
 * 14 July  92  Conversion to scatter fields
 * 15 July  92  bug fix in positioning
 * 15 Aug   92  conversion of scatter_arrows to scatter_cubes
 *
 */

/*-----------------------------------------------------*
 *                                                     *
 *     ****  scatter_cubes   module  ****            *
 *                                                     *
 *                                                     *
 *-----------------------------------------------------*/

#include <stdio.h>


#include <avs/avs.h>
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
#include <avs/geom.h>
#include <avs/field.h>


/* =============== compute routine ============== */

static scatter_cubes (input, output, scale, variable )

  AVSfield_float *input;
  GEOMedit_list **output;
  float         *scale;
  char          *variable;
{
    char model_name[80];
    GEOMobj *obj, *lobj;
    float *xc, *yc, *zc, *cell_data;
    int cell, i, name_flag, util_flag, data_len, cell_len, node_len,
        n, num_nodes, num_cells;
    int mode;
    int num_cubes;

    num_cubes = input->dimensions[0];  /* number of vectors to draw */
    mode = AVSchoice_number("Mode",variable)-1;


    /* establish the geometry output object */
    *output = (GEOMedit_list *)GEOMinit_edit_list(*output);
    obj    =  GEOMcreate_obj ( GEOM_POLYHEDRON, NULL);

    /* draw the geometry from the scatter list */
    display_cubes (input, num_cubes, obj, *scale, mode );


    /* complete the geometry to output port process */
    GEOMgen_normals(obj,0);
    GEOMcvt_polyh_to_polytri(obj,
        GEOM_NO_CONNECTIVITY | GEOM_SURFACE | GEOM_WIREFRAME);

    GEOMedit_geometry (*output, "scatter_cubes", obj);
    GEOMdestroy_obj (obj);
    GEOMedit_transform_mode (*output, "scatter_cubes", "parent");

    return(1);
}


/*-----------------------------------------------------*
 *                                                     *
 *          ****  display_cubes  ****                 *
 *                                                     *
 *-----------------------------------------------------*/

static display_cubes (input, num_cells, obj, scale, mode )

  AVSfield_float *input;  /* scatter input port */
  int num_cells;          /* how many cells */
  GEOMobj *obj;           /* add polygons to this object */
  float scale;            /* length of cubes */
  int   mode;             /* variable or uniform mode */

{
      float colour[3], cx, cy, cz;
      int cell, cell_len;
      float *xc, *yc, *zc;    /* node position arrays */
      float radius;           /* size of cube */

      /*********************************************/
      /**** loop over ALL cell  surfaces        ****/
      /*********************************************/
    
      cell_len = input->veclen;

      for (cell = 0; cell < num_cells; cell++)
      {

        cx = input->points[ 0 * num_cells + cell ]; 
        cy = input->points[ 1 * num_cells + cell ];
        cz = input->points[ 2 * num_cells + cell ];

        if ( mode )
          radius    = scale;
        else
          radius    =(input->data[ cell_len * cell +0 ]) * scale;

        if ( cell_len == 4 )
        {
            colour[0] = input->data[ cell_len * cell +1 ];
            colour[1] = input->data[ cell_len * cell +2 ];
            colour[2] = input->data[ cell_len * cell +3 ];
        }
        else
        {
            colour[0]=colour[1]=colour[2]= 0.95; /* white default */
        }

        create_cubes (obj, cx-radius, cx+radius,
                           cy-radius, cy+radius,
                           cz-radius, cz+radius, colour );

      }  /* end of cell loop */
    
}

/*-----------------------------------------------------*
 *                                                     *
 *        ****  create_cubes  ****                     *
 *                                                     *
 *-----------------------------------------------------*/
/* routine to draw one box of certain size and position */

create_cubes (obj, xs, xe, ys, ye, zs, ze, color )
    GEOMobj *obj;
    float xs, xe, ys, ye, zs, ze;
    float *color;
{
         float verts[ 4 * 3 ];
         float cols [ 4 ][ 3 ];  
         int   i;

         /* copy the same colour to all sides */
         for ( i=0; i<4; i++ )
         {
	     cols [ i ][ 0 ]         = color[ 0 ];
	     cols [ i ][ 1 ]         = color[ 1 ];
	     cols [ i ][ 2 ]         = color[ 2 ];
         }

         /* draw top quad */
         verts[ 0 * 3 + 0 ] = xs;
	 verts[ 0 * 3 + 1 ] = ys;
	 verts[ 0 * 3 + 2 ] = ze;

         verts[ 1 * 3 + 0 ] = xs;
	 verts[ 1 * 3 + 1 ] = ye;
	 verts[ 1 * 3 + 2 ] = ze;

         verts[ 2 * 3 + 0 ] = xe;
	 verts[ 2 * 3 + 1 ] = ye;
	 verts[ 2 * 3 + 2 ] = ze;

         verts[ 3 * 3 + 0 ] = xe;
	 verts[ 3 * 3 + 1 ] = ys;
	 verts[ 3 * 3 + 2 ] = ze;
         GEOMadd_disjoint_polygon ( obj, verts, NULL, NULL, 4,
				   GEOM_NOT_SHARED, GEOM_COPY_DATA);
         GEOMadd_float_colors(obj,cols,4,GEOM_COPY_DATA);

         /* draw bottom quad */
         verts[ 0 * 3 + 0 ] = xs;
	 verts[ 0 * 3 + 1 ] = ys;
	 verts[ 0 * 3 + 2 ] = zs;

         verts[ 1 * 3 + 0 ] = xe;
	 verts[ 1 * 3 + 1 ] = ys;
	 verts[ 1 * 3 + 2 ] = zs;

         verts[ 2 * 3 + 0 ] = xe;
	 verts[ 2 * 3 + 1 ] = ye;
	 verts[ 2 * 3 + 2 ] = zs;

         verts[ 3 * 3 + 0 ] = xs;
	 verts[ 3 * 3 + 1 ] = ye;
	 verts[ 3 * 3 + 2 ] = zs;
         GEOMadd_disjoint_polygon ( obj, verts, NULL, NULL, 4,
				   GEOM_NOT_SHARED, GEOM_COPY_DATA);
         GEOMadd_float_colors(obj,cols,4,GEOM_COPY_DATA);

         /* draw back quad */
         verts[ 0 * 3 + 0 ] = xs;
	 verts[ 0 * 3 + 1 ] = ys;
	 verts[ 0 * 3 + 2 ] = zs;

         verts[ 1 * 3 + 0 ] = xs;
	 verts[ 1 * 3 + 1 ] = ys;
	 verts[ 1 * 3 + 2 ] = ze;

         verts[ 2 * 3 + 0 ] = xs;
	 verts[ 2 * 3 + 1 ] = ye;
	 verts[ 2 * 3 + 2 ] = ze;

         verts[ 3 * 3 + 0 ] = xs;
	 verts[ 3 * 3 + 1 ] = ye;
	 verts[ 3 * 3 + 2 ] = zs;
         GEOMadd_disjoint_polygon ( obj, verts, NULL, NULL, 4,
				   GEOM_NOT_SHARED, GEOM_COPY_DATA);
         GEOMadd_float_colors(obj,cols,4,GEOM_COPY_DATA);

         /* draw front quad */
         verts[ 0 * 3 + 0 ] = xs;
	 verts[ 0 * 3 + 1 ] = ye;
	 verts[ 0 * 3 + 2 ] = zs;

         verts[ 1 * 3 + 0 ] = xs;
	 verts[ 1 * 3 + 1 ] = ye;
	 verts[ 1 * 3 + 2 ] = ze;

         verts[ 2 * 3 + 0 ] = xe;
	 verts[ 2 * 3 + 1 ] = ye;
	 verts[ 2 * 3 + 2 ] = ze;

         verts[ 3 * 3 + 0 ] = xe;
	 verts[ 3 * 3 + 1 ] = ye;
	 verts[ 3 * 3 + 2 ] = zs;
         GEOMadd_disjoint_polygon ( obj, verts, NULL, NULL, 4,
				   GEOM_NOT_SHARED, GEOM_COPY_DATA);
         GEOMadd_float_colors(obj,cols,4,GEOM_COPY_DATA);

         /* draw left side quad */
         verts[ 0 * 3 + 0 ] = xs;
	 verts[ 0 * 3 + 1 ] = ys;
	 verts[ 0 * 3 + 2 ] = zs;

         verts[ 1 * 3 + 0 ] = xs;
	 verts[ 1 * 3 + 1 ] = ys;
	 verts[ 1 * 3 + 2 ] = ze;

         verts[ 2 * 3 + 0 ] = xe;
	 verts[ 2 * 3 + 1 ] = ys;
	 verts[ 2 * 3 + 2 ] = ze;

         verts[ 3 * 3 + 0 ] = xe;
	 verts[ 3 * 3 + 1 ] = ys;
	 verts[ 3 * 3 + 2 ] = zs;
         GEOMadd_disjoint_polygon ( obj, verts, NULL, NULL, 4,
				   GEOM_NOT_SHARED, GEOM_COPY_DATA);
         GEOMadd_float_colors(obj,cols,4,GEOM_COPY_DATA);

         /* draw right side  quad */
         verts[ 0 * 3 + 0 ] = xe;
	 verts[ 0 * 3 + 1 ] = ys;
	 verts[ 0 * 3 + 2 ] = zs;

         verts[ 1 * 3 + 0 ] = xe;
	 verts[ 1 * 3 + 1 ] = ys;
	 verts[ 1 * 3 + 2 ] = ze;

         verts[ 2 * 3 + 0 ] = xe;
	 verts[ 2 * 3 + 1 ] = ye;
	 verts[ 2 * 3 + 2 ] = ze;

         verts[ 3 * 3 + 0 ] = xe;
	 verts[ 3 * 3 + 1 ] = ye;
	 verts[ 3 * 3 + 2 ] = zs;
         GEOMadd_disjoint_polygon ( obj, verts, NULL, NULL, 4,
				   GEOM_NOT_SHARED, GEOM_COPY_DATA);
         GEOMadd_float_colors(obj,cols,4,GEOM_COPY_DATA);
} 


/*-----------------------------------------------------*
 *                                                     *
 *        ****  scatter_cubes_desc  ****               *
 *                                                     *
 *-----------------------------------------------------*/
scatter_cubes_desc()
{
  int scatter_cubes(), param;

  /* name on the box */
  AVSset_module_name ("scatter cubes", MODULE_MAPPER);

  /* input ucd structure to draw */
  AVScreate_input_port ("Input",
     "field 1D 3-space irregular float", REQUIRED);

  /* output geomerty to draw */
  AVScreate_output_port ("scatter_cubes", "geom");

  param = AVSadd_float_parameter("Scale", 1.0, FLOAT_UNBOUND, FLOAT_UNBOUND);

  param = AVSadd_parameter("Mode", "choice",
          "Variable", "Variable#Uniform", "#" );

  /* routine pointers */
  AVSset_compute_proc (scatter_cubes);

}  /* end of description routine */

AVSinit_modules()
{
        AVSmodule_from_desc(scatter_cubes_desc);
}

