/****************************************************************************
                  INTERNATIONAL AVS CENTER
        (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/

/******************************************************************************/
/*
 *  Show_Flow produces a geometry object which depicts the flow in a field.
 *  Flow symbols may be arrows, wind barbs, etc.
 *
 */



#include	"avs_utils.h"
#include	"sta_data.h"



#define		FLOW_SYMBOL_ARROWS	1
#define		FLOW_SYMBOL_BARBS	2

#define		FLOW_SCALE_MAX		1
#define		FLOW_SCALE_AVG		2
#define		FLOW_SCALE_MAN		3



static char	in_field_port[]		= "Input Field";
static char	in_cmap_port[]		= "Input Colormap";
static char	in_color_fld_port[]	= "Input Color Field";
static char	in_upstream_xform[]	= "Transform Info";
static char	out_geom_port[]		= "Output Geom";
static char	parm_symbol[]		= "symbol type";
static char	parm_sample_int[]	= "sample int";
static char	parm_sym_size[]		= "symbol size";
static char	parm_spd_fac[]		= "unit arrow spd";
static char	parm_scale_mode[]	= "arrow scale mode";
static char	parm_rotate_sym[]	= "rotate symbols";
static char	parm_x_rotate[]		= "X rotate";
static char	parm_y_rotate[]		= "Y rotate";
static char	parm_z_rotate[]		= "Z rotate";
static char	parm_x_freeze[]		= "freeze X aspect";
static char	parm_y_freeze[]		= "freeze Y aspect";
static char	parm_z_freeze[]		= "freeze Z aspect";

static char	choices_symbol[]	= "arrows!barbs";
static char	choices_scale_mode[]	=
                    "scale by max!scale by avg!scale manually";



show_flow_desc ()

{
    int		show_flow_compute ();
    int		iparm, in_port, out_port;
    int		i;
    char	layout[8192];

    AVSset_module_name ("show flow", MODULE_MAPPER);

    AVScreate_input_port (in_field_port, "field", REQUIRED);
    AVScreate_input_port (in_cmap_port, "colormap", OPTIONAL);
    AVScreate_input_port (in_color_fld_port, "field scalar float", OPTIONAL);
    in_port = AVScreate_input_port (in_upstream_xform,
                                    "struct upstream_transform",
                                    OPTIONAL | INVISIBLE);
    AVSset_input_class (in_port, "upstream_transform");

    out_port = AVScreate_output_port (out_geom_port, "geom");
    AVSautofree_output (out_port);

    iparm = AVSadd_parameter (parm_symbol, "choice", "arrows", choices_symbol,
                              CHOICE_DELIMITER_STR);
    AVSadd_parameter_prop (iparm, "columns", "integer", 1);
    AVSadd_parameter_prop (iparm, "width", "integer", 3);
    AVSadd_parameter (parm_sample_int, "integer", 1, 1, 100);
    AVSadd_float_parameter (parm_sym_size, 1.0, 0.0, FLOAT_UNBOUND);

    AVSadd_float_parameter (parm_spd_fac, 1.0, 0.0, FLOAT_UNBOUND);
    iparm = AVSadd_parameter (parm_scale_mode, "choice", "scale by max",
                              choices_scale_mode, CHOICE_DELIMITER_STR);
    AVSadd_parameter_prop (iparm, "columns", "integer", 1);

    AVSadd_parameter (parm_rotate_sym, "boolean", FALSE, FALSE, TRUE);
    iparm = AVSadd_float_parameter (parm_x_rotate, 0.0,
                                    FLOAT_UNBOUND, FLOAT_UNBOUND);
    AVSconnect_widget (iparm, "typein_real");
    iparm = AVSadd_float_parameter (parm_y_rotate, 0.0,
                                    FLOAT_UNBOUND, FLOAT_UNBOUND);
    AVSconnect_widget (iparm, "typein_real");
    iparm = AVSadd_float_parameter (parm_z_rotate, 0.0,
                                    FLOAT_UNBOUND, FLOAT_UNBOUND);
    AVSconnect_widget (iparm, "typein_real");
    i = 0;
    AVSadd_parameter (parm_x_freeze, "boolean", FALSE, FALSE, TRUE);
    i += layout_toggle ((layout+i), parm_x_freeze, 129, 336, 118, 22); 
    AVSadd_parameter (parm_y_freeze, "boolean", FALSE, FALSE, TRUE);
    i += layout_toggle ((layout+i), parm_y_freeze, 129, 358, 118, 22); 
    iparm = AVSadd_parameter (parm_z_freeze, "boolean", FALSE, FALSE, TRUE);
    i += layout_toggle ((layout+i), parm_z_freeze, 129, 380, 118, 22); 
    AVSadd_parameter_prop (iparm, "layout", "string_block", layout);

    AVSset_compute_proc (show_flow_compute);

    return;
}



int	layout_toggle (layout_txt, name, ix, iy, iw, ih)

char	*layout_txt, *name;
int	ix, iy, iw, ih;
{

    sprintf (layout_txt, "%s%s%s%s%d,%d%s%d,%d\n\0",
             "    manipulator $Module:\"", name, "\" -w toggle -p $Module \\\n",
             "        -xy ", ix, iy, " -wh ", iw, ih);


    return (strlen (layout_txt));
}



/******************************************************************************/
/*
 *  Inform AVS of the name of the description procedure for this module.
 *
 */


AVSinit_modules()
{
    AVSmodule_from_desc (show_flow_desc);
    return ;
}



show_flow_compute (in_field, in_cmap, in_color_fld, in_ups_xform, out_geom,
                   symbol_choice, int_sample, p_sym_size,
                   p_spd_fac, choice_scale_mode,
                   rotate_sym, p_x_rotate, p_y_rotate, p_z_rotate,
                   freeze_x, freeze_y, freeze_z)

AVSfield		*in_field;
AVScolormap		*in_cmap;
AVSfield		*in_color_fld;
upstream_transform	*in_ups_xform;
GEOMedit_list		*out_geom;
char			*symbol_choice;
int			int_sample;
float			*p_sym_size, *p_spd_fac;
char			*choice_scale_mode;
int			rotate_sym;
float			*p_x_rotate, *p_y_rotate, *p_z_rotate;
int			freeze_x, freeze_y, freeze_z;
{

    static char		flow_obj_name[] = "flow_symbols";

    void		(*draw_sym) ();

    register int	i, j, k, inc, itmp;
    register int	nx, ny, nz;
    register float	size, spd_fac, spd_max, spd_avg, xtmp, *uvw;
    int			isymbol, freeze, scale_mode;
    float		*facs, *rgb, *rot, mat[4][4];
    FLOAT3		xyz, fac_dat, rgb_dat, rot_dat;
    GEOMobj		*flow_obj;



    *out_geom = GEOMinit_edit_list (*out_geom);



    AVSparameter_visible (parm_x_rotate, rotate_sym);
    AVSparameter_visible (parm_y_rotate, rotate_sym);
    AVSparameter_visible (parm_z_rotate, rotate_sym);

    AVSparameter_visible (parm_x_freeze, rotate_sym);
    AVSparameter_visible (parm_y_freeze, rotate_sym);
    AVSparameter_visible (parm_z_freeze, rotate_sym);


    inc     = int_sample;
    size    = *p_sym_size;
    spd_fac = *p_spd_fac;

    if (in_field == NULL) return (1);
    if (size == 0.0) return (1);

    flow_obj = GEOMcreate_obj (GEOM_POLYTRI, GEOM_NULL);
    if (flow_obj == GEOM_NULL) return (1);


    isymbol = AVSchoice_number (parm_symbol, symbol_choice);


    UTILS_field_pt_init (in_field);

    nx = (in_field->ndim > 0) ? in_field->dimensions[0] : 1;
    ny = (in_field->ndim > 1) ? in_field->dimensions[1] : 1;
    nz = (in_field->ndim > 2) ? in_field->dimensions[2] : 1;

    i      = (in_field->veclen > 3) ? in_field->veclen : 3;
    uvw    = (float *) calloc (i, sizeof (float));



    rgb  = (in_cmap == NULL) ? NULL : rgb_dat;


    rot    = NULL;
    if (rotate_sym)
    {
        rot = rot_dat;
        UTILS_float3_set (*p_x_rotate, *p_y_rotate, *p_z_rotate, rot);
    }


    freeze = freeze_x | freeze_y | freeze_z;
    UTILS_geom_freeze_check (freeze, in_ups_xform, *out_geom);

    if (freeze)
    {
        if (freeze_xform != NULL)
        {
            if (rot == NULL)
            {
                rot = rot_dat;
                UTILS_float3_set (0.0, 0.0, 0.0, rot);
            }

            xtmp = 45.0 / atan (1.0);
            if (freeze_x)
            {
                UTILS_float3_set (0.0, 1.0, 0.0, xyz);
                UTILS_geom_freeze_xyz (xyz, NULL);
                rot[0] += atan2 (xyz[2], xyz[1]) * xtmp;
            }
            if (freeze_y)
            {
                UTILS_float3_set (0.0, 0.0, 1.0, xyz);
                UTILS_geom_freeze_xyz (xyz, NULL);
                rot[1] += atan2 (xyz[0], xyz[2]) * xtmp;
            }
            if (freeze_z)
            {
                UTILS_float3_set (1.0, 0.0, 0.0, xyz);
                UTILS_geom_freeze_xyz (xyz, NULL);
                rot[2] += atan2 (xyz[1], xyz[0]) * xtmp;
            }
        }
    }


    facs = NULL;

    if (isymbol == FLOW_SYMBOL_ARROWS)
    {
        scale_mode = AVSchoice_number (parm_scale_mode, choice_scale_mode);

        if (scale_mode != FLOW_SCALE_MAN)
        {
            spd_max = spd_avg = 0.0;

            for (k = 0; k < nz; k++)
            {
                for (j = 0; j < ny; j++)
                {
                    for (i = 0; i < nx; i++)
                    {
                        UTILS_field_pt_vec (i, j, k, uvw);
                        if ((uvw[0] > STA_DATA_MISSING_WIND) &&
                            (uvw[1] > STA_DATA_MISSING_WIND) &&
                            (uvw[2] > STA_DATA_MISSING_WIND))
                        {
                            xtmp = UTILS_float3_sqrt (uvw);
                            if (xtmp > spd_max) spd_max = xtmp;

                            spd_avg += xtmp;
                        }
                    }
                }
            }

            spd_fac = (scale_mode == FLOW_SCALE_MAX) ? spd_max :
                       spd_avg / (float) (nx * ny * nz);

            AVSmodify_float_parameter (parm_spd_fac, AVS_VALUE, spd_fac,
                                       0.0, 0.0);
        }

        if (spd_fac > 0.0)
        {
            if (facs == NULL)
            {
                facs = fac_dat;
                UTILS_float3_set (1.0, 1.0, 1.0, facs);
            }
            facs[0] /= spd_fac, facs[1] /= spd_fac, facs[2] /= spd_fac;
        }
    }




    draw_sym = (isymbol == FLOW_SYMBOL_BARBS) ? UTILS_draw_barb :
                                                UTILS_draw_arrow ;


    for (k = 0; k < nz; k += inc)
    {
        for (j = 0; j < ny; j += inc)
        {
            for (i = 0; i < nx; i += inc)
            {
                UTILS_field_pt_vec (i, j, k, uvw);

                if ((uvw[0] > STA_DATA_MISSING_WIND) &&
                    (uvw[1] > STA_DATA_MISSING_WIND) &&
                    (uvw[2] > STA_DATA_MISSING_WIND))
                {

                    if (rgb != NULL)
                    {
                        if (in_color_fld == NULL)
                            xtmp = UTILS_float3_sqrt (uvw);
                        else
                        {
                            itmp = UTILS_field_pt_index (i, j, k);
                            xtmp = in_color_fld->field_data_float[itmp];
                        }
                        UTILS_color_rgb_from_value (in_cmap, xtmp, rgb);
                    }

                    UTILS_field_pt_xyz (i, j, k, xyz);

                    draw_sym (uvw, xyz, size, facs, rot, rgb, flow_obj);
                }
            }
        }
    }

    free (uvw);


    GEOMedit_geometry (*out_geom, flow_obj_name, flow_obj);
    GEOMdestroy_obj (flow_obj);


    return (1);
}
