#include	<math.h>



int	line_2d_eqn (p_xy1, p_xy2, p_abc)

float		*p_xy1, *p_xy2, *p_abc;
{
    register float	x1, y1, x2, y2, dx, dy, d;

    x1 = p_xy1[0], y1 = p_xy1[1];
    x2 = p_xy2[0], y2 = p_xy2[1];

    dx = x2 - x1, dy = y2 - y1;

    if ((d = sqrt ((double) (dx * dx) + (double) (dy * dy))) == 0.0)
    {
        p_abc[0] = p_abc[1] = p_abc[2] = 0.0;
        return (0);
    }

    p_abc[0] =  dy / d;
    p_abc[1] = -dx / d;
    p_abc[2] = ((y1 * dx) - (x1 * dy)) / d;


    return (1);
}



int	line_2d_int (p_abc1, p_abc2, p_xy)

float		*p_abc1, *p_abc2, *p_xy;
{

    register float	a1, b1, c1, a2, b2, c2, ab, ba, bc, cb;

    a1 = p_abc1[0], b1 = p_abc1[1], c1 = p_abc1[2];
    a2 = p_abc2[0], b2 = p_abc2[1], c2 = p_abc2[2];

    ab = a1 * b2;
    ba = b1 * a2;

    if (ab == ba)
    {
        p_xy[0] = p_xy[1] = 0.0;
        return (0);
    }

    bc = b1 * c2;
    cb = c1 * b2;

    p_xy[0] = (bc - cb) / (ab - ba);
    p_xy[1] = (b1 != 0.0) ? ((p_xy[0] * a1) + c1) / (-b1) :
                            ((p_xy[0] * a2) + c2) / (-b2);


    return (1);
}
