/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "symmetrize" (Mapper) (Subroutine)                       */
/* Author:  Terry Myerson  International AVS Center			 */
/* Date Created: Mon Jan 27 03:43:38 1992                                */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/avs_math.h>
 
/* *****************************************/
/*  Module Specification                   */
/* *****************************************/
int symmetrize_spec()
{

	int in_port, out_port, param;
	extern int symmetrize_compute();

	AVSset_module_name("symmetrize", MODULE_MAPPER);

	in_port = AVScreate_input_port("input",
        	"field 1D 1-space 2-vector uniform float", REQUIRED);

	out_port = AVScreate_output_port("output", "geom");

	param = AVSadd_parameter("divisions", "integer",8, 4, 100 );
        AVSconnect_widget(param,"islider");

	AVSset_compute_proc(symmetrize_compute);

	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int symmetrize_compute( input, output, divisions)
	AVSfield_float *input;
	GEOMedit_list *output;
	int divisions;
{
   int i,j,num_verts,nodes;
   float *theta,*verts,*tmp;
   int *con_list,*tmp2;
   GEOMobj *obj0;   

   nodes = (input->dimensions)[0];
   num_verts = nodes * divisions;

   theta=(float *)ALLOC_LOCAL(divisions*sizeof(float));
   for (i=0;i<divisions;i++)
   {
      theta[i] = (2*M_PI*i)/divisions; 
   }

   verts=(float *)ALLOC_LOCAL(3*num_verts*sizeof(float));
   tmp=verts;
   for (i=0;i<nodes;i++)
   {
      for (j=0;j<divisions;j++)
      {
         *tmp = (I1DV(input,i)[0]) * cos( theta[j] ); 
         tmp++;
         *tmp = (I1DV(input,i)[0]) * sin( theta[j] );
	 tmp++;
	 *tmp = (I1DV(input,i)[1]);
         tmp++;
      }
   }

   con_list=(int *)ALLOC_LOCAL(((divisions*(nodes-1)*5)+1)*sizeof(int) );
   tmp2=con_list;
   for (i=0;i<(nodes-1);i++)
   {
      for (j=0;j<(divisions);j++)
      {
         (tmp2)[0]=4;
         (tmp2)[1]=(divisions*i)+j+1;
         (tmp2)[2]=((tmp2)[1]) + divisions;
         (tmp2)[3]=((tmp2)[2]) + 1;
         (tmp2)[4]=((tmp2)[1]) + 1;
 	 if (j==(divisions-1))
	 {
	    (tmp2)[3] = ((tmp2)[3]) - divisions;
	    (tmp2)[4] = ((tmp2)[4]) - divisions;
	 }
         tmp2 = tmp2 + 5;
      }
   }
   *tmp2=0;

   obj0 = GEOMcreate_polyh(GEOM_NULL, verts, num_verts, con_list, 
			   GEOM_CONVEX, GEOM_COPY_DATA);

   *output = GEOMinit_edit_list(*output);      
   GEOMedit_geometry(*output, "output", obj0); 
   GEOMdestroy_obj(obj0);                     
 
   FREE_LOCAL(theta);
   FREE_LOCAL(verts);
   FREE_LOCAL(con_list);

   return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*filter_mod_list[])()) = {
	symmetrize_spec,
};
#define NMODS (sizeof(filter_mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(filter_mod_list, NMODS);
}
