#ifdef SCCS
static char sccsid[]="@(#)mat.c	5.4  Jonathan Cox 26/07/93";
#endif
/*
 * FILE: mat.c
 * 
 * DESCRIPTION
 * 
 * Matrix, vector and angle manipulation routines.
 * 
 * NOTICE
 *
 * (c) University of Manchester 1991, 1992.
 * Author:  Jonathan Cox.
 * Address: IT301, Department of Computer Science, University of Manchester,
 *          Oxford Road, Manchester.  M13 9PL.  England.
 * Email:   coxjp@cs.man.ac.uk
 *
 * No part of this software may be altered, incorporated in other programs or
 * given to third parties, except under the conditions of the license, if any,
 * with which it was distributed.  This notice may not be removed from the
 * source code with which it is associated.
 *
 * VERSION HISTORY
 *
 * 5.0 - Jonathan Cox.  First version for general release.
 * 5.1 - Jonathan Cox.  Fixed problem with dissapearing input ports.
 * 5.2 - Jonathan Cox.  Made modules cooperative and rentrant.
 * 5.3 - Jonathan Cox.  ANSI C.
 * 5.4 - Jonathan Cox.  Added code for the generation of contours.
 * 
 */

#include <math.h>
#include "mat.h"


/************************************************************************
 *
 * Matrix, vector and angle transformation routines.
 *
 */

float dot_product(float v1[3], float v2[3])
/*
 * Calculates the dot product of two vectors in 3 space.
 */
{
  register int i;
  float temp = 0.0;

  for (i=0; i<3; i++)
    temp += v1[i] * v2[i];

  return temp;
}


double vec_mag(float v[3])
/*
 * Calculates the magnitude of a vector.
 */
{
  register int i;
  double temp;

  temp = 0.0;
  
  for (i=0; i<3; i++)
    temp += v[i] * v[i];

  return sqrt(temp);
}


double mat_mag(float mat[4][4])
/*
 * Calculates the magnitude of first row in a transformation matrix.
 */
{
  register int i;
  double temp;

  temp = 0.0;

  for (i=0; i<3; i++)
    temp += mat[i][0] * mat[i][0];

  return sqrt(temp);
}


mat2_vecmul(float pos[3], float matrix[4][4])
/*
 * Apply the transformation matrix to the point pos.
 * Routine is optimised to map to plane z=0
 */
{
  float x, y;
  x = (matrix[0][0]*pos[0] + matrix[1][0]*pos[1] +
       matrix[2][0]*pos[2] + matrix[3][0]);
  y = (matrix[0][1]*pos[0] + matrix[1][1]*pos[1] +
       matrix[2][1]*pos[2] + matrix[3][1]);
  pos[0] = x;
  pos[1] = y;
  pos[2] = 0.0;
}


mat3_vecmul(float pos[3], float matrix[4][4])
/*
 * Apply the scale and rotation transformation in the given matrix to point pos
 */
{
  int i;
  float res[3], (*col)[4], *p;
  
  p = pos;
  col = matrix;
  for (i = 0; i < 3; i++)
    res[i] = (*col)[i] * *p;
  p++;
  col++;
  for (i = 0; i < 3; i++)
    res[i] += (*col)[i] * *p;
  p++;
  col++;
  for (i = 0; i < 3; i++)
    res[i] += (*col)[i] * *p;
  vec_copy(pos, res);
}
      

int different_quadrant(float a1, float a2)
/*
 * Returns 1 if a1 and a2 are not in the same quadrant.
 */
{
  float diff;

  diff = fabs(a1 - a2);
  return (diff > 90.0 && 360 - diff > 90.0);
}


float rot180(float a)
{
  return a >= 0.0 ? a - 180.0 : a + 180.0;
}

