/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#ifdef SCCS
static char sccsid[]="@(#)mat.c	5.0  Jonathan Cox 21/08/92";
#endif
/*
 * FILE: mat.c
 * 
 * DESCRIPTION
 * 
 * Matrix, vector and angle manipulation routines.
 * 
 * NOTICE
 *
 * (c) University of Manchester 1991, 1992.
 * Author:  Jonathan Cox.
 * Address: IT301, Department of Computer Science, University of Manchester,
 *          Oxford Road, Manchester.  M13 9PL.  England.
 * Email:   coxjp@cs.man.ac.uk
 *
 * No part of this software may be altered, incorporated in other programs or
 * given to third parties, except under the conditions of the license, if any,
 * with which it was distributed.  This notice may not be removed from the
 * source code with which it is associated.
 *
 * VERSION HISTORY
 *
 * 5.0 - Jonathan Cox.  First version for general release.
 * 
 */

/* IAC CODE CHANGE : #include <math.h> */
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
#include "mat.h"


/************************************************************************
 *
 * Matrix, vector and angle transformation routines.
 *
 */

float dot_product(v1, v2)
/*
 * Calculates the dot product of two vectors in 3 space.
 */
float v1[3];
float v2[3];

{
  register int i;
  float temp = 0.0;

  for (i=0; i<3; i++)
    temp += v1[i] * v2[i];

  return temp;
}


double vec_mag(v)
/*
 * Calculates the magnitude of a vector.
 */
float v[3];

{
  register int i;
  double temp;

  temp = 0.0;
  
  for (i=0; i<3; i++)
    temp += v[i] * v[i];

  return sqrt(temp);
}


double mat_mag(mat)
/*
 * Calculates the magnitude of first row in a transformation matrix.
 */
float mat[4][4];

{
  register int i;
  double temp;

  temp = 0.0;

  for (i=0; i<3; i++)
    temp += mat[i][0] * mat[i][0];

  return sqrt(temp);
}


mat2_vecmul(pos, matrix)
/*
 * Apply the transformation matrix to the point pos.
 * Routine is optimised to map to plane z=0
 */
float pos[3];
float matrix[4][4];

{
  float x, y;
  x = (matrix[0][0]*pos[0] + matrix[1][0]*pos[1] +
       matrix[2][0]*pos[2] + matrix[3][0]);
  y = (matrix[0][1]*pos[0] + matrix[1][1]*pos[1] +
       matrix[2][1]*pos[2] + matrix[3][1]);
  pos[0] = x;
  pos[1] = y;
  pos[2] = 0.0;
}


mat3_vecmul(pos, matrix)
/*
 * Apply the scale and rotation transformation in the given matrix to point pos
 */
float pos[3];
float matrix[4][4];
{
  int i;
  float res[3], (*col)[4], *p;
  
  p = pos;
  col = matrix;
  for (i = 0; i < 3; i++)
    res[i] = (*col)[i] * *p;
  p++;
  col++;
  for (i = 0; i < 3; i++)
    res[i] += (*col)[i] * *p;
  p++;
  col++;
  for (i = 0; i < 3; i++)
    res[i] += (*col)[i] * *p;
  vec_copy(pos, res);
}
      

int different_quadrant(a1, a2)
/*
 * Returns 1 if a1 and a2 are not in the same quadrant.
 */
float a1;
float a2;
{
  float diff;

  diff = fabs(a1 - a2);
  return (diff > 90.0 && 360 - diff > 90.0);
}


float rot180(a)
float a;
{
  return a >= 0.0 ? a - 180.0 : a + 180.0;
}

