/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/

/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 * ucd_profile
 *
 * draw geometric representation of UCD input
 * The boundary surface is sampled from the UCD structure,
 * where the boundary is the collection of cell faces not
 * sharing nodes with other cells, or of different material type.
 *
 * Surface normal vectors are shown with magnitude proportional
 * to the scalar values at the surface.
 *
 *
 * Author: I. Curington, AVS Inc, UK
 *         Advanced Visual Systems, Inc,
 *         Thames Mews, Portsmouth Road
 *         Esher, Surrey
 *         +44-372-471161
 *         ianc@avs.com
 *
 * Revision:
 * 31 March 92  Original (cell data) from ucd_cell_arrows
 *  8 Jan   93  Update for profile module
 * 12 Jan   93  Intersection code added.
 * 20 Jan   93  Normal vector bug fix
 *              Added Normalize and Absolute modes
 *              Fixed no color mode problem
 *              Added Centroid to Vertex mode
 * 25 Jan   93  Added base arrow control, surface line
 *  1 Feb   93  Added Property selection menu choices
 * 23 Feb   93  Update memory alloc, added output scatter port
 * 24 Feb   93  Added vector normal output to scatter
 *              Added picking and information panel
 * 26 Aug   93  Fixed pointer indirection bug
 *
 *
 */

/*-----------------------------------------------------*
 *                                                     *
 *           ****  ucd_profile module  ****            *
 *                                                     *
 *-----------------------------------------------------*/

#include <stdio.h>


#include <avs/avs.h>
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/ucd_defs.h>
#include <avs/colormap.h>
#include <avs/udata.h>

/* =============== local declarations  ============== */

extern char *AVSstatic;

static float *global_colors;   /* colour index table */
static int   global_cmap_size;

typedef struct   _UCD_Prof_List {
        float                 point[3];
        float                 vector[3];
        float                 value;
        int                   cell_id;
        int                   mat_id;
} UCD_Prof_List;

typedef struct   _UCD_Face_List {
        unsigned char         num_vtx;
        int                   vtx_index[4];
        int                   mat_id;
        int                   cell_id;
} UCD_Face_List;

typedef struct   _UCD_Line_List {
        int                   vtx_index[2];
        int                   mat_id;
        int                   cell_id;
} UCD_Line_List;

#define PROF_BUF_SIZE   10000 /* max size of output field */
#define INIT_MESH_ID   -27385

typedef struct _ucd_stats {
        int                faces_count;
        int                verts_count;
        int                lines_count;
        int                edges_count;
        int                prof_count;
        UCD_Face_List      *face_list;
        UCD_Line_List      *line_list;
        UCD_Line_List      *edge_list;
        UCD_Prof_List      *prof_list;
        int                mesh_id;
        float              profile_icon[5][3];
} Ucd_Stats_Type;


/* =============== compute routine ============== */

ucd_profile (input, cmap_input, xform, xgeom, output, scatter,
             scale, method_choice, color_mode, heads, base, flip,
             distance, n_percell, normalize, absolute, intersect,
             dummy1, comp_select, pick_status )

  UCD_structure *input;
  AVScolormap   *cmap_input;
  upstream_transform *xform;
  upstream_geom *xgeom;
  GEOMedit_list *output;
  AVSfield_float **scatter;
  float         *scale;
  char          *method_choice;
  int           color_mode;
  int           heads;
  int           base;
  int           flip;
  float         *distance;
  int           n_percell;
  int           normalize;
  int           absolute;
  int           intersect;
  char          *dummy1;
  char          *comp_select;
  char          *pick_status;
{
    char model_name[80];
    GEOMobj *obj;
    float *xc, *yc, *zc, *cell_data;
    float *node_data;
    int cell, i, name_flag, util_flag, data_len, cell_len, node_len,
        n, num_nodes, num_cells, method;
    Ucd_Stats_Type   *ucd_stats;
    int mesh_id;
    float         newmat[4][4], identity[4][4];
    float         tmp_vec[3], extent[6], min_extent[3], max_extent[3];
    float         width, height, depth, maxdim;
    float         cx, cy, cz;
    float         profile_icon[5][3]; /* local copy */
    int           select;
    int           dims[3];
    char          info_panel[800];

    /*
     * B O D Y
     */


    /* get general sizes */
    if (!UCDstructure_get_header (input, model_name, &data_len, &name_flag, 
			        &num_cells, &cell_len, &num_nodes, &node_len, 
			        &util_flag))
    {
      AVSerror ("Error in ucd_profile: can't get header.\n"); 
      return (0);
    }

    if (!UCDstructure_get_mesh_id (input, &mesh_id))
    {
         AVSerror ("Error in ucd_profile: can't get mesh id.\n");
         return (0);
    }

    UCDstructure_get_extent (input, min_extent, max_extent);

    extent[0] = min_extent[0], extent[1] = max_extent[0];
    extent[2] = min_extent[1], extent[3] = max_extent[1];
    extent[4] = min_extent[2], extent[5] = max_extent[2];

    cx = (extent[0] + extent[1]) / 2.0;
    cy = (extent[2] + extent[3]) / 2.0;
    cz = (extent[4] + extent[5]) / 2.0;

    width  = extent[1] - extent[0];
    height = extent[3] - extent[2];
    depth  = extent[5] - extent[4];

    maxdim = (width > height ? width : height);
    maxdim = (depth > maxdim ? depth : maxdim);

    select = AVSchoice_number("node data",comp_select)-1; 
    if ( select < 0 ) select=0;

    /* setup cache for external face list */
    ucd_stats = (Ucd_Stats_Type *)AVSstatic;

    if ( AVSinput_changed("Input", 0) ||
                ucd_stats == NULL ||
                ucd_stats->face_list == NULL ||
                ucd_stats->mesh_id == INIT_MESH_ID )
    {

         /* update node data choice list */
         select = update_menu( input, comp_select, node_len );
         if ( select < 0 ) select=0;


         if (ucd_stats == NULL)
         {
              ucd_stats = (Ucd_Stats_Type *)malloc(sizeof(Ucd_Stats_Type));
              ucd_stats->mesh_id = INIT_MESH_ID;
         }
         else
         {
              if (ucd_stats->mesh_id != mesh_id)
              {
                   if (ucd_stats->face_list)

/* IAC CODE CHANGE :                            free(ucd_stats->face_list); */
                            free(ucd_stats->face_list);
                   if (ucd_stats->line_list)

/* IAC CODE CHANGE :                            free(ucd_stats->line_list); */
                            free(ucd_stats->line_list);
                   if (ucd_stats->edge_list)

/* IAC CODE CHANGE :                            free(ucd_stats->edge_list); */
                            free(ucd_stats->edge_list);
                   if (ucd_stats->prof_list)

/* IAC CODE CHANGE :                            free(ucd_stats->prof_list); */
                            free(ucd_stats->prof_list);
                   ucd_stats->face_list = NULL;
                   ucd_stats->line_list = NULL;
                   ucd_stats->edge_list = NULL;
                   ucd_stats->prof_list = NULL;

                   ucd_stats->faces_count = 0;
                   ucd_stats->edges_count = 0;
                   ucd_stats->verts_count = 0;
                   ucd_stats->prof_count = 0;

                   /* Now Process New Face List */
                   /* 
                    * this scans the ucd model, builds a map
                    * of the exterior faces of cells,
                    * by analysis of material id, and
                    * the node connectivity, if nodes are shared
                    * by adjacent cells, then a homogeneous
                    * region is defined, if not, then the face
                    * will be returned as a boundary face.
                    * 2D cells, such as tri's or quads are always
                    * considered external faces.
                    * This is an internal undocumented AVS utility
                    * used by several modules including ucd_to_geom.
                    */
                   if ( ucd_rm_interior_polys
                          (input,                   /* input structure */
                           num_cells,               /* number of cells */
                           num_nodes,               /* number of nodes */
                           &ucd_stats->faces_count, /* RTN: num ext. faces */
                           &ucd_stats->verts_count, /* RTN: num verts */
                           &ucd_stats->face_list,   /* RTN: face list struct */
                           &ucd_stats->lines_count, /* RTN: num ext. lines */
                           &ucd_stats->line_list,   /* RTN: line list struct */
                           NULL) ==0 )              /* cell subset list */
                   {
                    /* don't call us, we'll call you */
                    AVSerror(
                 "ucd_profile: internal call=ucd_rm_interior_polys failed.\n");
                      return(0);
                   }

                   ucd_stats->mesh_id = mesh_id;

                   /* define the starting shape for icon */
                   for ( i=0; i<5; i++ )
                   {
                       ucd_stats->profile_icon[i][2] = cz;
                   }

                   ucd_stats->profile_icon[0][0] = cx - maxdim *0.5;
                   ucd_stats->profile_icon[0][1] = cy - maxdim *0.5;

                   ucd_stats->profile_icon[1][0] = cx + maxdim *0.5;
                   ucd_stats->profile_icon[1][1] = cy - maxdim *0.5;

                   ucd_stats->profile_icon[2][0] = cx + maxdim *0.5;
                   ucd_stats->profile_icon[2][1] = cy + maxdim *0.5;

                   ucd_stats->profile_icon[3][0] = cx - maxdim *0.5;
                   ucd_stats->profile_icon[3][1] = cy + maxdim *0.5;

                   ucd_stats->profile_icon[4][0] = cx - maxdim *0.5;
                   ucd_stats->profile_icon[4][1] = cy - maxdim *0.5;

                   /* make sure there is space for the list */
                   if ( ucd_stats->prof_list == NULL )
                   {
                       ucd_stats->prof_list = (UCD_Prof_List *)
                              malloc ( PROF_BUF_SIZE * sizeof(UCD_Prof_List));
                       if ( ucd_stats->prof_list == NULL )
                         AVSerror("ucd_profile: malloc failed on profile buffer");
                   }

              }
              AVSstatic = (char *)ucd_stats;
          }
          AVSmodify_float_parameter("Distance",
                      AVS_MINVAL | AVS_MAXVAL,
                      0.0, -maxdim , maxdim );
    }

    /************************/
    /* process a pick event */
    /************************/
    if ( xgeom != NULL &&
         AVSinput_changed( "pick", 0) && 
         xgeom->vdata != -1 &&
         ucd_stats->prof_count >= xgeom->vdata ) 
    {
        i = xgeom->vdata;
        strcpy( info_panel, "Pick Arrow with Left Mouse\n");
        strcat( info_panel, " - Picked Data Info:\n");
        sprintf(info_panel,
                "%s Surface Value %f\n",
                info_panel,
                ucd_stats->prof_list[i].value );
        sprintf(info_panel,
                "%s sample position:\n  x %f\n  y %f\n  z %f\n",
                info_panel,
                ucd_stats->prof_list[i].point[0],
                ucd_stats->prof_list[i].point[1],
                ucd_stats->prof_list[i].point[2]);
        sprintf(info_panel,
                "%s index %d, ",
                info_panel,
                i );
        sprintf(info_panel,
                "%s cell_id %d, ",
                info_panel,
                ucd_stats->prof_list[i].cell_id);
        sprintf(info_panel,
                "%s mat_id %d\n",
                info_panel,
                ucd_stats->prof_list[i].mat_id);
        sprintf(info_panel,
                "%s profile vector:\n  x %f\n  y %f\n  z %f\n",
                info_panel,
                ucd_stats->prof_list[i].vector[0],
                ucd_stats->prof_list[i].vector[1],
                ucd_stats->prof_list[i].vector[2]);

        AVSmodify_parameter( "Pick Result", AVS_VALUE,
                info_panel, "","");

        AVSmark_output_unchanged("ucd_profile");
        AVSmark_output_unchanged("scatter");
        return(1);  /* don't update output ports */
    }


    method = AVSchoice_number("Method", method_choice);

    /* set up the colour mapping table */
    global_colors = (float *)malloc(3 * sizeof(float) * cmap_input->size);
    global_cmap_size = cmap_input->size;

    for (i = 0; i < cmap_input->size; i++)
    FILTERhsv_to_rgb (&(global_colors[i*3+0]),
                      &(global_colors[i*3+1]),
                      &(global_colors[i*3+2]),
                      cmap_input->hue[i], cmap_input->saturation[i],
                      cmap_input->value[i]);


    if ( node_len < 1 )
    {
      AVSerror ("Error ucd_profile: no node data available\n"); 
      return (0);
    }

    /* find out where the nodes are */
    if (!UCDstructure_get_node_positions (input, &xc, &yc, &zc))
    {
      AVSerror ("Error in ucd_profile: can't get node coordinates.\n"); 
      return (0);
    }

    /* get a pointer to where the node data is stored */
    if (!UCDstructure_get_node_data (input, &node_data))
    {
      AVSerror ("Error in ucd_profile: can't get node data pointer.\n"); 
      return (0);
    }

    /* Slice Profile Plane Control */
    mat_identity( identity );
    if (xform != NULL &&
        !strncmp(xform->object_name,
        "ucd_profile", strlen("ucd_profile")))
        track_box_transform(newmat, min_extent, max_extent,
            xform->msxform, *distance);
    else
        track_box_transform(newmat, min_extent, max_extent,
            identity, *distance);
    for ( i=0; i<5; i++ )
    {
        profile_icon[i][0] = ucd_stats->profile_icon[i][0];
        profile_icon[i][1] = ucd_stats->profile_icon[i][1];
        profile_icon[i][2] = ucd_stats->profile_icon[i][2];
    }

    for ( i=0; i<5; i++ )
        mat_vecmul( &(profile_icon[i][0]) ,newmat);

    /* Clean Out Profile buffer from last time, make a fresh one */
    ucd_stats->prof_count=0;


    /* establish the geometry output object */
    *output = GEOMinit_edit_list(*output);
    obj    =  GEOMcreate_obj (GEOM_POLYTRI, NULL);


    /* draw the geometry from the cell list */
    if ( method == 1 )
        draw_profile_icon ( obj, profile_icon );


    display_arrows (input, num_cells, num_nodes, obj, 
                     xc, yc, zc, node_len, node_data,
                     *scale, color_mode, heads, base, cmap_input, flip,
                     ucd_stats->face_list, ucd_stats->faces_count,
                     method, profile_icon, n_percell,
                     normalize, absolute, intersect, select,
                     ucd_stats->prof_list, &(ucd_stats->prof_count) );


    /* complete the geometry to output port process */
    GEOMedit_geometry (*output, "ucd_profile", obj);
    GEOMdestroy_obj (obj);
    if ( method == 2 || method == 3 )
        GEOMedit_transform_mode (*output, "ucd_profile", "parent");
    else if ( method == 1 )
        GEOMedit_transform_mode(*output, "ucd_profile", "redirect",
                          BUTTON_MOVING | BUTTON_UP);
    GEOMedit_selection_mode(*output,"ucd_profile",
                   "notify", BUTTON_MOVING | BUTTON_DOWN );

    /* create and fill the scatter output field with sampled data */
    dims[0] = ucd_stats->prof_count;

/* IAC CODE CHANGE :     if ( *scatter ) free ( *scatter ); */
    if ( *scatter )  free(*scatter );
    if ( dims[0] > 0 )
    {
        *scatter =(AVSfield_float *)
             AVSdata_alloc("field 1D 3-space irregular 6-vector float", dims);
        if ( !(*scatter) )
             AVSerror("unable to allocate output field of size %d",dims[0]);
        build_scatter (*scatter, ucd_stats->prof_list, ucd_stats->prof_count );
        AVSfield_set_labels(*scatter,
         "Surface_Value#Cell_ID#Mat_ID#X-Normal#Y-Normal#Z-Normal","#");
    }
    else
        AVSmark_output_unchanged("scatter");

    return(1);
}


/*-----------------------------------------------------*
 *                                                     *
 *          ****  display_arrows  ****                 *
 *                                                     *
 *-----------------------------------------------------*/

display_arrows (input, num_cells, num_nodes, obj, 
		 xc, yc, zc, node_len, node_data,
                 scale, color_mode, heads, base, cmap, flip,
                 face_list, num_faces, method, profile,
                 n_percell, normalize, absolute, intersect,
                 node_vector, prof_list, prof_count )

  UCD_structure *input;   /* ucd input port */
  int num_cells;          /* how many cells */
  int num_nodes;          /* how many nodes */
  GEOMobj *obj;           /* add polygons to this object */
  float *xc, *yc, *zc;    /* node position arrays */
  int node_len;           /* node vector length */
  float *node_data;       /* data to use for arrows */
  float scale;            /* length of arrows */
  int   color_mode;       /* white or colored arrows control */
  int   heads;            /* simple lines or arrow heads */
  int   base;             /* simple lines only */
  AVScolormap *cmap;      /* color table */
  int   flip;             /* flip sign of arrow direction */
  UCD_Face_List   *face_list;  /* list of boundary faces */
  UCD_Prof_List   *prof_list;  /* list of sampled data */
  int   num_faces;        /* number of faces in list */
  int   method;           /* method of sampling */
  float profile[5][3];    /* plane vertex list */
  int   n_percell;        /* n samples per cell */
  int   normalize;        /* make arrows unit length or data dependent */
  int   absolute;         /* make direction always positive */
  int   intersect;        /* show intersection line */
  int   node_vector;      /* which of n-vector data to use for scalar */
  int   *prof_count;      /* profile data count */

{
      float vdot_prod();
      char ctype[40];
      float vector[3], cx, cy, cz, x, y, z;
      float planeq[4];
      float colors[3];
      float verts[5][3];
      float face_data[5];
      float face_normal[4];
      float value, t, length;
      float edge[2][3], edge_data[2];
      float vtemp[3];

      int cell, cell_id, mat_id, cell_type, me_flags, *node_list,
          node, count, face, v, numv, num_fv, 
          nnodes, i, k, j;

      colors[0] = colors[1] = colors[2] = 0.9;

      if ( method == 1 ) get_planeq ( profile, planeq );

      /*********************************************/
      /**** loop over exterior cell surfaces    ****/
      /*********************************************/
    
      for (face = 0; face < num_faces; face++ )
      {
        /* identify cell topology */
        nnodes = face_list[ face ].num_vtx;

        /* loop over face vertex list, get face centroid */
        cx = cy = cz = 0.0;
        for (j = 0; j < nnodes; j++)
        {
                v = face_list[ face ].vtx_index[ j ];
                cx += xc[v];
                cy += yc[v];
                cz += zc[v];
        }                          /* end of vertex loop */

        cx /= (float) nnodes;
        cy /= (float) nnodes;
        cz /= (float) nnodes;

        /*************************************************/
        /**** sample crowfoot from each vertex to ctr ****/
        /*************************************************/
    
        if (method == 2 || method == 3 )
        for (j = 0; j < nnodes; j++)
        {
                v = face_list[ face ].vtx_index[ j ];
                x = xc[v];  /* node position of face vertex */
                y = yc[v];
                z = zc[v];

                value = node_data[ node_vector*num_nodes + v];

                if ( normalize )
                    length = 1.0;
                else
                    length = value;

                if ( absolute && length < 0.0 )
                    length = -1.0 * length;

                if ( method == 2 )
                {
                    vector[0] = (cx - x) * length;  /* point to centroid */
                    vector[1] = (cy - y) * length;
                    vector[2] = (cz - z) * length;
                } else {
                    vector[0] = (x - cx) * length;  /* point to vertex */
                    vector[1] = (y - cy) * length;
                    vector[2] = (z - cz) * length;
                    x = cx; y = cy; z = cz;
                }
                if ( flip )
                {
                    vector[0] *= -1.0;
                    vector[1] *= -1.0;
                    vector[2] *= -1.0;
                }

                if ( color_mode )
                {
                    map_data_to_colours ( cmap->lower, cmap->upper,
                        value,
                        &colors[0],
                        &colors[1],
                        &colors[2] );
                }

                create_arrow (obj, x, y, z, vector,
                              scale, colors, color_mode,
                              heads, base, -1 );

        } /* end of vertex loop */

        /*************************************************/
        /**** sample profile intersection with face   ****/
        /*************************************************/
        else if (method == 1)
        for (j = 0; j < nnodes; j++)
        {
            /* load face into local array */
            v = face_list[ face ].vtx_index[ j ];
            verts[j][0] = xc[v];      /* node position of face vertex */
            verts[j][1] = yc[v];
            verts[j][2] = zc[v];
            face_data[j] = node_data[ node_vector*num_nodes + v];

        } /* end of vertex loop */
        verts[ nnodes ][0] = verts[0][0];  /* copy to 5th to close */
        verts[ nnodes ][1] = verts[0][1];
        verts[ nnodes ][2] = verts[0][2];
        face_data[ nnodes ] = face_data[0];

        /* intersection test */
        if ( check_overlap( verts, nnodes, planeq, face_data,
                            edge, edge_data ) == 1 )
        {
            /* find face normal vector */
            get_planeq ( verts, face_normal );

            /* draw the edge */
            if ( intersect )
                create_intersect( obj, edge );

            /* parametric path along edge */
          for( k=0; k < n_percell; k++ )
          {
            t = (float) (k+1) / (float)(n_percell+1);
            x = (1.0-t)*edge[0][0] + t*edge[1][0];
            y = (1.0-t)*edge[0][1] + t*edge[1][1];
            z = (1.0-t)*edge[0][2] + t*edge[1][2];
            value = (1.0-t)*edge_data[0] + t*edge_data[1];

            if ( normalize )
                    length = 1.0;
            else
                    length = value;

            if ( absolute && length < 0.0 )
                    length = -1.0 * length;


            /* create vector direction normal to edge, contained in plane */
            vtemp[0] = edge[1][0] - edge[0][0];
            vtemp[1] = edge[1][1] - edge[0][1];
            vtemp[2] = edge[1][2] - edge[0][2];
            vcross_prod (planeq, vtemp, vector);
            vnorm( vector );

            /* make sure edge order does not effect vector sign */
            if ( vdot_prod ( face_normal, vector ) < 0.0 )
            {
                vector[0] *= -1.0;
                vector[1] *= -1.0;
                vector[2] *= -1.0;
            }

            /* scale vector by data */
            if ( !flip )
            {
                vector[0] *= length;
                vector[1] *= length;
                vector[2] *= length;
            }
            else
            {
                vector[0] *= -1.0 * length;
                vector[1] *= -1.0 * length;
                vector[2] *= -1.0 * length;
            }

            if ( color_mode )
            {
                    map_data_to_colours ( cmap->lower, cmap->upper,
                        value,
                        &colors[0],
                        &colors[1],
                        &colors[2] );
            }

            create_arrow (obj, x, y, z, vector,
                          scale, colors, color_mode,
                          heads, base, *prof_count );

            add_to_profile( prof_list, prof_count,
                          x, y, z, vector, value,
                          face_list[ face ].cell_id,
                          face_list[ face ].mat_id );

          } /* k loop */
        }

      }  /* end of face loop */
    
}

/*-----------------------------------------------------*
 *                                                     *
 *        ****  create_intersect  ****                 *
 *                                                     *
 *-----------------------------------------------------*/

create_intersect (obj, edge )
            GEOMobj *obj;            /* output geom object */
            float edge[2][3];        /* edge endpoints */
{
    static float co[2][3] = { .3, .9, .3, .3, .9, .3 };
    static int   vdata[4] = { -1, -1, -1, -1 };

    GEOMadd_disjoint_line (obj, edge, co,
                           2, GEOM_COPY_DATA);
    GEOMadd_disjoint_vertex_data (obj, vdata,
                            2, GEOM_COPY_DATA);
}

/*-----------------------------------------------------*
 *                                                     *
 *        ****  create_arrow  ****                     *
 *                                                     *
 *-----------------------------------------------------*/

create_arrow (obj, x, y, z, v1, scale, colors,
                     color_mode, heads, base, tag )
            GEOMobj *obj;            /* output geom object */
            float         x, y, z;   /* arrow position */
            float         v1[3];     /* vector data */
            float         scale;     /* length scale */
            float         colors[3]; /* line color */
            int           color_mode; /* color or not */
            int           heads;     /* arrow heads or not */
            int           base;      /* arrow base or not */
            int           tag;       /* tag to attatch for picking */
{
  double sqrt();

  float mag, s1, x1, y1, z1, nx, ny, nz, s, vt[3], v2[3], v3[3], vx, vy, vz;
  float verts[20][3], vcolors[20][3], r, g, b;
  int   vdata[20];
  int i, n, nc, m, index;
  static float arrow_scale = 0.4;

  for ( nc=0; nc < 20; nc++ )
  {
    if ( color_mode )
    {
        vcolors[nc  ][0] = colors[0]; 
        vcolors[nc  ][1] = colors[1];
        vcolors[nc  ][2] = colors[2];
    }
    else
    {
        vcolors[nc  ][0] = 0.95;   /* white */
        vcolors[nc  ][1] = 0.95;
        vcolors[nc  ][2] = 0.95;
    }
    vdata[ nc ] = tag;               /* vertex data for picking */
  }


  index = -1;
  nx = scale * v1[0];
  ny = scale * v1[1];
  nz = scale * v1[2];
  mag = sqrt(nx * nx + ny * ny + nz * nz);

  if (mag == 0.0) {
    n = nc = 0;

    verts[n][0] = x;
    verts[n][1] = y;
    verts[n++][2] = z;

    verts[n][0] = x;
    verts[n][1] = y;
    verts[n++][2] = z;
    if ( !base ) n += -2;
  }
  else
  {
    s = 0.9;
    s1 = arrow_scale * (1.0 - s) * mag;
    vx = x + s * nx;
    vy = y + s * ny;
    vz = z + s * nz;

    /*  compute v2[] and v3[], which will be 
        the sides of the arrow head.          */

    vt[0] = -v1[1];
    vt[1] = v1[0];
    vt[2] = 0.0;

    if ((vt[0] == 0.0) && (vt[1] == 0.0))
      vt[0] = 1.0;

    vcross_prod (v1, vt, v2);
    vcross_prod (v1, v2, v3);

    vnorm (v2);
    vnorm (v3);

    n = nc = 0;
    /* ==== start with base line === */
    verts[n][0] = x, verts[n][1] = y, verts[n++][2] = z;
    verts[n][0] = x1 = x + nx; 
    verts[n][1] = y1 = y + ny;
    verts[n++][2] = z1 = z + nz;
    if ( !base ) n += -2;

  if ( heads )
  {
    /* now work on the head lines */
    verts[n][0] = x1,  verts[n][1] = y1,  verts[n++][2] = z1;  
    verts[n][0] = vx + s1 * v2[0];
    verts[n][1] = vy + s1 * v2[1]; 
    verts[n++][2] = vz + s1 * v2[2];

    verts[n][0] = x1,  verts[n][1] = y1,  verts[n++][2] = z1;  
    verts[n][0] = vx + s1 * v3[0]; 
    verts[n][1] = vy + s1 * v3[1];
    verts[n++][2] = vz + s1 * v3[2];

    verts[n][0] = x1,  verts[n][1] = y1,  verts[n++][2] = z1;  
    verts[n][0] = vx - s1 * v2[0];  
    verts[n][1] = vy - s1 * v2[1];
    verts[n++][2] = vz - s1 * v2[2]; 

    verts[n][0] = x1,  verts[n][1] = y1,  verts[n++][2] = z1;  
    verts[n][0] = vx - s1 * v3[0]; 
    verts[n][1] = vy - s1 * v3[1];
    verts[n++][2] = vz - s1 * v3[2]; 


    /*  form the base of the arrow head.  */

    for (m = n, i = 3; i < m; i += 2) {
      verts[n][0] = verts[i][0];  
      verts[n][1] = verts[i][1];  
      verts[n++][2] = verts[i][2];  

      if (i == 9) {
        verts[n][0] = verts[3][0];  
        verts[n][1] = verts[3][1];  
        verts[n++][2] = verts[3][2];  
        }
      else {
        verts[n][0] = verts[i + 2][0];  
        verts[n][1] = verts[i + 2][1];  
        verts[n++][2] = verts[i + 2][2];  
        }
      }
    }
  } /* end of head test */

  if ( heads || base )
  {
      GEOMadd_disjoint_line (obj, verts,
                         vcolors,
                         n, GEOM_COPY_DATA);
      GEOMadd_disjoint_vertex_data ( obj, vdata,
                         n,  GEOM_COPY_DATA );
  }
 

}

/*-----------------------------------------------------*/
/* normalize the length of a 3-vector */
int
vnorm (v)
        float v[];
{
  double mag, sqrt();

  mag = sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);

  if (mag == 0.0) {
    v[0] = 0.0;
    v[1] = 0.0;
    v[2] = 0.0;
    return (0);
    }
  else {
    v[0] = v[0] / mag;
    v[1] = v[1] / mag;
    v[2] = v[2] / mag;
    }
    return (1);
}

/*-----------------------------------------------------*/
/* 2-vector dot product */
float
vdot_prod (v1,  v2)
    float *v1, *v2;
{
  float    dot;

  dot = ( v1[0]*v2[0] + v1[1]*v2[1] + v1[2]*v2[2] );
  return ( dot );
}

/*-----------------------------------------------------*/
/* 3-vector cross product */
vcross_prod (v1,  v2,  v3)
             float *v1, *v2, *v3;
{
  v3[0] = v1[1] * v2[2] - v1[2] * v2[1];
  v3[1] = v1[2] * v2[0] - v1[0] * v2[2];
  v3[2] = v1[0] * v2[1] - v1[1] * v2[0];
}

/*-----------------------------------------------------*/
/* get plane equation from two edges */
get_planeq ( v, eq )
    float v[5][3], eq[4];
{

/* page 114 in Bowyer and Woodwark */

    float xkj, ykj, zkj, xlj, ylj, zlj;

    /* get difference vectors */
    xkj = v[1][0] - v[0][0];
    ykj = v[1][1] - v[0][1];
    zkj = v[1][2] - v[0][2];

    xlj = v[2][0] - v[0][0];
    ylj = v[2][1] - v[0][1];
    zlj = v[2][2] - v[0][2];

    /* cross product for plane normal */
    eq[0] = ykj * zlj - zkj * ylj;
    eq[1] = zkj * xlj - xkj * zlj;
    eq[2] = xkj * ylj - ykj * xlj;

    /* normalize vector */
    if ( vnorm( eq ) == 0 )
    {
        eq[0] = eq[1] = 0.0;
        eq[2] = 1.0;
    }

    /* use plane equation for distance offset */
    eq[3] = -1.0 * (v[1][0] * eq[0] +
                    v[1][1] * eq[1] +
                    v[1][2] * eq[2] );

}

/*--------------------------------------------------------*/
/* check if any overlap of face with plane equation.      */
/* verts is either a quad or a triangle, eq is normalized */
/* plane equation. This will return 1 if overlap exists,  */
/* otherwise zero. The edge intersection info is          */
/* returned in new_v and new_data..                       */

#define SSGN(a) (a >= 0.0 ? 1 : -1)

int
check_overlap( v, n, eq, data, new_v, new_data )
    float v[5][3], eq[4], data[5];
    int n;
    float new_v[2][3], new_data[2];
{
    float sr[5];
    int   sn[5];
    int   i, j;
    int   num_crosses, crosses[4];
    float denom, t[4];

    /* compute signed distance from plane to each vertex */
    for (i=0; i < n; i++ )
    {
        sr[i] = eq[0]*v[i][0] +
                eq[1]*v[i][1] +
                eq[2]*v[i][2] + eq[3];
        sn[i] = SSGN( sr[i] );
    }
    sr[n] = sr[0];
    sn[n] = sn[0];

    /* check sign of each dist, check for a cross */
    num_crosses = 0;
    for (i=0; i < n; i++ )
    {
       if ( sn[i] != sn[i+1] ) 
           crosses[ num_crosses++ ] = i;
    }

    /* early get out if no overlap found */
    if ( num_crosses != 2 )
        return(0);
    else
    {
      /* compute the explicit intersection of the edges and plane */
      for (j=0; j<2; j++ ) /* loop for both intersections */
      {
        denom = eq[0]*(v[crosses[j]+1][0]-v[crosses[j]][0]) +
                eq[1]*(v[crosses[j]+1][1]-v[crosses[j]][1]) +
                eq[2]*(v[crosses[j]+1][2]-v[crosses[j]][2]);
        if ( denom == 0.0 ) denom = 0.001;
        /* t is the parametric intersetion parm for the edge-plane */
        t[j] = -1.0 *
              ( eq[0]*v[crosses[j]][0] +
                eq[1]*v[crosses[j]][1] +
                eq[2]*v[crosses[j]][2] +
                eq[3] ) / denom;

        /* load outgoing array with the two intersection points */
        new_v[j][0] = v[crosses[j]][0] +
                     (v[crosses[j]+1][0]-v[crosses[j]][0]) * t[j];
        new_v[j][1] = v[crosses[j]][1] +
                     (v[crosses[j]+1][1]-v[crosses[j]][1]) * t[j];
        new_v[j][2] = v[crosses[j]][2] +
                     (v[crosses[j]+1][2]-v[crosses[j]][2]) * t[j];
        new_data[j] = data[crosses[j]] +
                     (data[crosses[j]+1]-data[crosses[j]]) * t[j];
      }
    }

    return(1);
}

/*-----------------------------------------------------*
 *                                                     *
 *             ****  map_data_to_colours  ****         *
 *                                                     *
 *-----------------------------------------------------*/

map_data_to_colours ( vmin, vmax, val, red, green, blue )

float vmin;   /* range min */
float vmax;   /* range max */
float val;    /* input value to color */
float *red;   /* output color for sample */
float *green; /* output color for sample */
float *blue;  /* output color for sample */

{

  int index;
  float scale, offset;

  if (vmax != vmin)
    scale =  (float)(global_cmap_size - 1) / (vmax - vmin);
  else
    scale = 0.0;

  index = (int)((val - vmin) * scale);

  if ( index < 0 ) index = 0;
  else if ( index >= global_cmap_size ) index = global_cmap_size -1;

  *red      = global_colors[index * 3];
  *green    = global_colors[index * 3 + 1];
  *blue     = global_colors[index * 3 + 2];

}

/*-----------------------------------------------------*
 *                                                     *
 *    ****  track_box_transform  ****                  *
 *                                                     *
 *-----------------------------------------------------*/

track_box_transform(out_matrix, ll, ur, addtl, distance)
    float out_matrix[4][4], addtl[4][4];
    float ll[3], ur[3], distance;
{
    float tx, ty, tz, tmpmat[4][4], hw, hh, hd;

    hw = (ll[0] + ur[0]) / 2.0;
    hh = (ll[1] + ur[1]) / 2.0;
    hd = (ll[2] + ur[2]) / 2.0;

    mat_identity(out_matrix);

    tx = out_matrix[3][0] * (ur[0] - ll[0]);
    ty = out_matrix[3][1] * (ur[1] - ll[1]);
    tz = out_matrix[3][2] * (ur[2] - ll[2]);
    out_matrix[0][3] = out_matrix[1][3] = out_matrix[2][3] = 0.0;

    mat_translate(tmpmat, -hw, -hh, -hd+distance);
    mat_multiply(tmpmat, out_matrix, out_matrix);

    mat_multiply(out_matrix, addtl, out_matrix);

    mat_translate(tmpmat,  tx+hw,  ty+hh,  tz+hd);
    mat_multiply(out_matrix, tmpmat, out_matrix);
}


/*-----------------------------------------------------*
 *                                                     *
 *       ****  draw_profile_icon   ****                *
 *                                                     *
 *-----------------------------------------------------*/
#define SCW  0.05
#define RCW  0.95

draw_profile_icon ( obj, pts )
    GEOMobj       *obj;
    float         pts[5][3];
{
    int i, j;
    float verts[2][3];
    static int vdata[ 4 ] = { -1, -1, -1, -1 };
    /* define light green */
    static float co[2][3] = { .3, .9, .3, .3, .9, .3 };

    /* primary outline of icon */
    for (i=0; i<4; i++)
    {
        GEOMadd_disjoint_line (obj, &pts[i][0], co,
                               2, GEOM_COPY_DATA);
        GEOMadd_disjoint_vertex_data (obj, vdata,
                               2, GEOM_COPY_DATA);
    }
    /* secondary lines */
    for (i=1; i<=3; i+=2)
    {
        for (j=0; j<3; j++)
        {
            verts[0][j] = (RCW * pts[i][j] + SCW * pts[i-1][j]);
            verts[1][j] = ((RCW * pts[i][j] + SCW * pts[i-1][j]) - pts[i][j]) +
                          ((RCW * pts[i][j] + SCW * pts[i+1][j]) );
        }
        GEOMadd_disjoint_line (obj, verts, co, 2, GEOM_COPY_DATA);
        GEOMadd_disjoint_vertex_data (obj, vdata,
                               2, GEOM_COPY_DATA);
        for (j=0; j<3; j++)
        {
            verts[0][j] = (RCW * pts[i][j] + SCW * pts[i+1][j]);
            verts[1][j] = ((RCW * pts[i][j] + SCW * pts[i-1][j]) - pts[i][j]) +
                          ((RCW * pts[i][j] + SCW * pts[i+1][j]) );
        }
        GEOMadd_disjoint_line (obj, verts, co, 2, GEOM_COPY_DATA);
        GEOMadd_disjoint_vertex_data (obj, vdata,
                               2, GEOM_COPY_DATA);
    }
}



/*-----------------------------------------------------*
 *                                                     *
 *       ****  Update Menu         ****                *
 *       re-paints the menu choices                    *
 *       returns node vector offset number             *
 *                                                     *
 *-----------------------------------------------------*/

int
update_menu( ucd_input, data_type, node_len )

  UCD_structure *ucd_input;  /* ucd input structure pointer */ 
  char       *data_type;     /* current choice selection string */
  int        node_len;       /* number of values per node */

{
    /* storage for scalar component names */
    char  scalar_comps[50][80];
    char  temp[100];
    int   i,j,k,t;
    char  string     [ UCD_LABEL_LEN ];
    char  data_labels[ UCD_LABEL_LEN ];
    char  delim[3];
    int   select;         /* selected scalar to return */
    int   num_comp;       /* number of components */
    int   *nd_comp_list;  /* component list */

    /* If UCD changed */

        /* if ucd input changes, redo the menu */
        UCDstructure_get_node_labels (ucd_input, data_labels, delim);
        UCDstructure_get_node_components (ucd_input, &nd_comp_list);
        
        /* compute (i), the number of components, and names */
        for(i=k=t=num_comp=0; i < node_len; num_comp++)
        {
            /* accumulate component size */
            i += nd_comp_list[num_comp];
            /* copy out component name */
            for ( j=0;
                  ( j < 100 ) &&
                  ( k < 600 ) &&
                  (data_labels[k] != delim[0]) &&
                  (data_labels[k] != '\0'    );
                  j++ )
            {
                temp[j] = data_labels[k++]; 
            }
            temp[j] = '\0';
            k++;             /* skip delimiter */
            for ( j=0; j<nd_comp_list[num_comp]; j++ )
            {
                if ( nd_comp_list[num_comp] == 1 )  /* copy scalar name */
                    sprintf( &scalar_comps[t][0],
                            "%s",temp); 
                else
                    sprintf( &scalar_comps[t][0],   /* add sub-numbers */
                            "%s-%d",temp,j+1); 

                t++;
            }
        }

        /* assemble menu choice string */
        if ( t != node_len )
            printf(" node_len = %d, num strings = %d\n",node_len, t);
        strcpy( string, &scalar_comps[0][0] );
        for( j=1; j < node_len; j++ )
        {
            strcat( string, delim );
            strcat( string, &scalar_comps[j][0] );
        }

        /* re-paint the menu list */
        AVSmodify_parameter ("node data",  AVS_VALUE | AVS_MINVAL | AVS_MAXVAL,
                             data_type,
                             string, delim);
        
        select = AVSchoice_number ("node data", data_type ) - 1;

        return( select ); 
    
}


/*-----------------------------------------------------*
 *                                                     *
 *         ****  add_to_profile    ****                *
 *                                                     *
 *-----------------------------------------------------*/
add_to_profile( prof_list, prof_count,
                x, y, z, vector, value, cell_id, mat_id )

    UCD_Prof_List *prof_list;
    int           *prof_count;
    float         x, y, z;
    float         vector[3];
    float         value;
    int           cell_id;
    int           mat_id;
{
    int           i;
    int           id;

    id = *prof_count;

    /* add the current data to the list */
    for ( i=0; i<3; i++ )
    {
        prof_list[id].vector[i] = vector[i];
    }
    prof_list[id].point[0]  = x;
    prof_list[id].point[1]  = y;
    prof_list[id].point[2]  = z;
    prof_list[id].value     = value;
    prof_list[id].cell_id   = cell_id;
    prof_list[id].mat_id    = mat_id;
    
    /* bump count for next time */
    *prof_count = id+1;

    /* buffer end detection */
    if ( id >= PROF_BUF_SIZE )
    {
            AVSerror("ucd_profile: profile buffer full, limit reachedk");
    }
}


/******************************************************/
/* Build Output Scatter Field    Function             */
/******************************************************/
 
build_scatter (output, prof_list, prof_count )

    AVSfield_float   *output;      /* output scatter field */
    UCD_Prof_List    *prof_list;   /* sample list structure */
    int              prof_count;   /* n-samples */

{

    int i;
    int veclen;

    veclen = 6;

    /* fill the field coords and data */
    for ( i = 0; i < prof_count; ++i)
    {
            (output)->data  [ i  * veclen + 0]  = prof_list[i].value;
            (output)->data  [ i  * veclen + 1]  = (float)prof_list[i].cell_id;
            (output)->data  [ i  * veclen + 2]  = (float)prof_list[i].mat_id;
            (output)->data  [ i  * veclen + 3]  = prof_list[i].vector[0];
            (output)->data  [ i  * veclen + 4]  = prof_list[i].vector[1];
            (output)->data  [ i  * veclen + 5]  = prof_list[i].vector[2];
            (output)->points[0*prof_count+ i ] = prof_list[i].point[0];
            (output)->points[1*prof_count+ i ] = prof_list[i].point[1];
            (output)->points[2*prof_count+ i ] = prof_list[i].point[2];
    }
    
}



/*-----------------------------------------------------*
 *                                                     *
 *       ****  ucd_profile_init  ****                *
 *                                                     *
 *-----------------------------------------------------*/
ucd_profile_init()
{
        Ucd_Stats_Type   *ucd_stats;

        ucd_stats = (Ucd_Stats_Type *)malloc(sizeof(Ucd_Stats_Type));
        AVSstatic = (char *)ucd_stats;
        ucd_stats->face_list = NULL;
        ucd_stats->line_list = NULL;
        ucd_stats->edge_list = NULL;
        ucd_stats->prof_list = NULL;
        ucd_stats->faces_count = 0;
        ucd_stats->verts_count = 0;
        ucd_stats->lines_count = 0;
        ucd_stats->edges_count = 0;
        ucd_stats->prof_count = 0;
        ucd_stats->mesh_id = INIT_MESH_ID;

}

/*-----------------------------------------------------*
 *                                                     *
 *       ****  ucd_profile_finis  ****               *
 *                                                     *
 *-----------------------------------------------------*/
ucd_profile_finis()
{
        Ucd_Stats_Type *ucd_stats;

        if (AVSstatic == NULL) return;

        ucd_stats = (Ucd_Stats_Type *)AVSstatic;
        if (ucd_stats->face_list)

/* IAC CODE CHANGE :                 free(ucd_stats->face_list); */
                 free(ucd_stats->face_list);
        if (ucd_stats->line_list)

/* IAC CODE CHANGE :                 free(ucd_stats->line_list); */
                 free(ucd_stats->line_list);
        if (ucd_stats->edge_list)

/* IAC CODE CHANGE :                 free(ucd_stats->edge_list); */
                 free(ucd_stats->edge_list);
        if (ucd_stats->prof_list)

/* IAC CODE CHANGE :                 free(ucd_stats->prof_list); */
                 free(ucd_stats->prof_list);

/* IAC CODE CHANGE :         free (ucd_stats); */
         free(ucd_stats);
        return;
}

/*-----------------------------------------------------*
 *                                                     *
 *        ****  ucd_profile_desc  ****               *
 *                                                     *
 *-----------------------------------------------------*/
ucd_profile_desc()
{
  int ucd_profile(), param, up_port;

  /* name on the box */
  AVSset_module_name ("ucd profile", MODULE_MAPPER);
  AVSset_module_flags( COOPERATIVE );


  /* input ucd structure to draw */
  AVScreate_input_port ("Input", "ucd", REQUIRED);

  /* colors for the faces */
  AVScreate_input_port ("Input Colourmap", "colormap", REQUIRED);

  /* interactive transformation and picking ports */
  up_port = AVScreate_input_port("upstream",
              "struct upstream_transform", INVISIBLE | OPTIONAL);
  AVSset_input_class(up_port, "Output:upstream_transform");

  up_port = AVScreate_input_port("pick",
              "struct upstream_geom", OPTIONAL | INVISIBLE);
  AVSset_input_class(up_port,"upstream_geom");

  /* output geomerty to draw */
  AVScreate_output_port ("ucd_profile", "geom");

  /* output sample positions for post processing */
  AVScreate_output_port ("scatter",
     "field 1D 3-space irregular 6-vector float");

  /* User Interface */
  param = AVSadd_float_parameter("Scale", 1.0, FLOAT_UNBOUND, FLOAT_UNBOUND);

  param = AVSadd_parameter("Method", "choice",
     "Profile Intersection Plane",
     "Profile Intersection Plane#Vertex to Centroid Crowfoot#Centroid to Vertex Crowfoot",
     "#" );
  AVSadd_parameter_prop (param, "width", "integer", 4);

  param = AVSadd_parameter("Color Arrows", "boolean", 1, 0, 1);
  param = AVSadd_parameter("Arrow Heads",  "boolean", 1, 0, 1);
  param = AVSadd_parameter("Arrow Base",   "boolean", 1, 0, 1);
  param = AVSadd_parameter("Flip Sign",    "boolean", 0, 0, 1);

  param = AVSadd_float_parameter("Distance",0.0, FLOAT_UNBOUND, FLOAT_UNBOUND);

  param = AVSadd_parameter("N per cell","integer", 4, 1, 50 );

  param = AVSadd_parameter("Normalize", "boolean", 0, 0, 1);
  param = AVSadd_parameter("Absolute Value", "boolean", 0, 0, 1);
  param = AVSadd_parameter("Show Intersect", "boolean", 1, 0, 1);
  param = AVSadd_parameter("Node Labels",
                           "string", "Node Data","Node Data", NULL);
  AVSconnect_widget( param, "text");
  param = AVSadd_parameter("node data", "choice", "<none>","<none>","#");


  /* create some text output area */
  param = AVSadd_parameter("Pick Result", "string_block",
      "Pick Arrow with Left Mouse","","");
  AVSconnect_widget( param, "textblock");
  AVSadd_parameter_prop(param, "width",  "integer",  4 );
  AVSadd_parameter_prop(param, "height", "integer",  8 );


  /* routine pointers */
  AVSset_compute_proc (ucd_profile);
  AVSset_init_proc    (ucd_profile_init);
  AVSset_destroy_proc (ucd_profile_finis);


}  /* end of description routine */

AVSinit_modules()
{
        AVSmodule_from_desc(ucd_profile_desc);
}

