/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/

/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 * -- ucd streak
 *    Variation on ucd_stream module,
 *    Experimental Version
 *
 *    Modifications by: Ian Curington
 *    Revision History:
 *    1 Feb 93   ianc - First Revision, as non-mongo
 *                      Changed name to streak
 *                      Added max_steps control
 *   22 Feb 93   ianc - added cell-boundary detection
 *   26 Feb 93   ianc - added boundary cross projection, markers
 *    1 Mar 93   ianc - fixed boundary offset
 *                      added visibility and colour control
 *   30 Apr 93   ianc - worked on data menu bug
 *   24 May 93   ianc - worked on numerical problem on integration,
 *                      removed sqrt declaration and fast_fsqrt
 *   22 June 93  ianc - corrected IBM appearent bug, array misdimension
 *    2 Nov  93  ianc - uninitialized var bug fix
 *
 *
 * Description:
 *
 *  The ucd streak module is an advanced variation of the ucd_streamlines
 *  module in AVS5. It contains an optional mode where the streamlines
 *  follow the boundary of the flow domain, tracking along the surface,
 *  as long at the velocity field is into the boundary surface, and
 *  are not displayed when they leave the surface. This simulates
 *  oil drop streak lines from exterior flow wind tunnel tests.
 *
 *  The flow is integrated through the 3D boundary elements,
 *  and optional integration step markers can be shown.
 *  Although the streamlines are only displayed at the surface, the
 *  whole interior 3D streamline calculation is taking place,
 *  so this method is quite different from a 2D surface only
 *  particle track algorithm. Any velocity component going into the
 *  boundary surface is projected back inside boundary cell
 *  a small fraction of a cell size away from the boundary,
 *  and another full 3D integration step is performed.
 *  The projection is performed normal to the boundary surface geometry.
 *  The zig-zag markers illustrate the boundary tracking algorithm, and
 *  show the last interior point, the integration step point outside the
 *  domain, the internal projection of cross-over, and the vertices
 *  of the cell face used in the projection.
 *  Additional controls allow the integration to be halted at a
 *  preset number of steps. No options have been removed from
 *  ucd streamlines, however the new boundary following algorithm
 *  and "ribbons" are mutually exclusive.
 *
 *
 */
#ifdef SCCS
	static char sccsid[]="@(#)ucd_stream.c	8.5 Stardent 92/12/11";
#endif
/*
  Copyright (c) 1989 by
  Stardent Computer Inc.
  All Rights Reserved
  
  This software comprises unpublished confidential information of
  Stardent Computer Inc. and may not be used, copied or made
  available to anyone, except in accordance with the license
  under which it is furnished.
  
  This file is under sccs control at Stardent in:
  /nfs/europa/root/sccs1.p/avs/modules/ucd/mappers/s.ucd_stream.c
  
  */
/*-----------------------------------------------------*
 *                                                     *
 *           ****  ucd streak module  ****             *
 *                                                     *
 *-----------------------------------------------------*/

#include <stdio.h>

#include <avs/avs.h>

/*
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
 */
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>

#include <avs/math_util.h>

#include <avs/geom.h>
#include <avs/ucd_defs.h>
#include <avs/field.h>

#include <avs/udata.h>
#include <avs/colormap.h>

/*-----------------------------------------------------*/

#define MAX_BUF_START 1000

#define EPS1 0.000001
#define ndebug_stream

extern char *AVSstatic;
static create_marker();

typedef struct _ucd_stats {
	int   mesh_id;
	float max_vect_mag, extent[6], center[3],  diff[3], max_dim;
	int new_probe, integ_meth, mag_comp, num_vcomp, offset, num_comp, 
	*nd_comp_list;
} Ucd_Stats_Type;

static float imat[][4] = {{1.0, 0.0, 0.0, 0.0},
			  {0.0, 1.0, 0.0, 0.0},
			  {0.0, 0.0, 1.0, 0.0},
			  {0.0, 0.0, 0.0, 1.0}};

static int  Colors;

static int ADAPT_FLAG;

typedef float XFORM[4][4];

float extent[6], cx, cy, cz, max_dim;


/* ucd cell type topology, in AVS5 this can be found in ucd_topo.h */
static int   tri_topo[]  = {3, 0, 1, 2},

             quad_topo[] = {4, 0, 1, 2, 3},

             tet_topo[]  = {3, 1, 2, 0,
                            3, 2, 3, 0,
                            3, 3, 1, 0,
                            3, 1, 3, 2},

             pyr_topo[]  = {3, 0, 1, 2,
                            3, 0, 2, 3,
                            3, 0, 3, 4,
                            3, 4, 1, 0,
                            4, 1, 4, 3, 2},

             prism_topo[]= {3, 5, 4, 3,
                            3, 0, 1, 2,
                            4, 1, 4, 5, 2,
                            4, 1, 0, 3, 4,
                            4, 0, 2, 5, 3},

             hex_topo[]  = {4, 0, 1, 2, 3,
                            4, 1, 5, 6, 2,
                            4, 3, 2, 6, 7,
                            4, 0, 3, 7, 4,
                            4, 0, 4, 5, 1,
                            4, 4, 7, 6, 5};

static int *cell_topos[] = {0, 0, tri_topo, quad_topo, tet_topo, pyr_topo,
                           prism_topo, hex_topo}, me_node_mask = 0xffffff;



/*-----------------------------------------------------*
 *                                                     *
 *         ****  ucd_streak_init  ****             *
 *                                                     *
 *-----------------------------------------------------*/

ucd_streak_init()
{
	AVSstatic = (char *)0;
}


/*-----------------------------------------------------*
 *                                                     *
 *         ****  ucd_streak_finis  ****            *
 *                                                     *
 *-----------------------------------------------------*/

ucd_streak_finis()
{
	Ucd_Stats_Type *ucd_stats;
	
	/**************
	 ***  body  ***
	 **************/
	
	if (AVSstatic == NULL) return;
	
	ucd_stats = (Ucd_Stats_Type *)AVSstatic;
	if (ucd_stats->mesh_id)
		UTILucd_delete_block_table(ucd_stats->mesh_id);


/* IAC CODE CHANGE : 	free (ucd_stats); */
	 free(ucd_stats);
}


/*-----------------------------------------------------*
 *                                                     *
 *           ****  ucd_streak_desc  ****           *
 *                                                     *
 *-----------------------------------------------------*/

ucd_streak_desc () 
{
	
	int param, ucd_streak();
	
	static char *choices = "<data 1>.<data 2>.<data 3>.<data 4>.<data 5>";
	
	/****************
	 ***   body   ***
	 ****************/
	if (getenv("AVS_ADAPT_FLAG") == NULL)
		ADAPT_FLAG = 0;
	else
		ADAPT_FLAG = 1;

	AVSset_module_name ("ucd streak", MODULE_MAPPER);
	
	param = AVScreate_input_port ("Input", "ucd", REQUIRED);
	param = AVScreate_input_port ("Input Colormap", "colormap", OPTIONAL);
	param = AVScreate_input_port("Probe",
                 "field irregular 3-space ", OPTIONAL);
	
	param = AVScreate_input_port ("Transform Info",
                                      "struct upstream_transform",
				      OPTIONAL | INVISIBLE);
	AVSset_input_class (param, "Output:upstream_transform");

	param = AVScreate_output_port ("Output", "geom");
	param = AVScreate_output_port("Upstream Transform",
                                      "struct upstream_transform");
	AVSset_output_flags(param, INVISIBLE);
	AVSset_output_class(param,"Probe:upstream_transform");
	
	param = AVSadd_parameter("Node Data", "string",
                                 "Node Data", "Node Data",
				 NULL);
	AVSconnect_widget (param, "text");
	
	param = AVSadd_parameter ("node data",
                "choice", "<data 1>", choices, ".");
	
	param = AVSadd_parameter ("N Segment", "integer", 16, 2, 64);
	param = AVSadd_parameter ("choice", "choice", "point", 
			  "point.line.circle.plane", ".");
	
	param = AVSadd_parameter ("N Steps", "integer", 2, 2, 10);
	
	param = AVSadd_parameter("Integration",
                           "string", "Integration", "Integration",
				 NULL);
	AVSconnect_widget (param, "text");
	
	param = AVSadd_parameter ("integ method", "choice", "1st Order", 
			  "1st Order.2nd Order.3rd Order", ".");
	
	param = AVSadd_parameter ("Ribbons", "boolean", 0, 0, 1);
	param = AVSadd_float_parameter ("Ribbon Width", 1.0, 0.0, 1000.0);
	param = AVSadd_float_parameter ("Ribbon Angle", 0.0, 0.0, 360.0);

	param = AVSadd_parameter ("Backward", "boolean", 0, 0, 1);
	param = AVSadd_parameter ("Color Streams", "boolean", 0, 0, 1);
	param = AVSadd_parameter ("Show Bounds", "boolean", 0, 0, 1);

	param = AVSadd_parameter("Interaction Mode",
                           "string", "Interaction Mode", 
				 "Interaction Mode", NULL);
	AVSconnect_widget (param, "text");
	
	param = AVSadd_parameter ("inter mode", "choice", "Immediate", 
			  "Immediate.Wait.Button Up", ".");
	
	param = AVSadd_parameter ("Start Streams", "boolean", 0, 0, 1);

        /* artificial limit to number of integration steps */
	param = AVSadd_parameter ("Max Steps",
                  "integer", 1000, INT_UNBOUND, INT_UNBOUND);
	AVSconnect_widget (param, "typein_integer");

        /* special experimental boundary follower parameters */
	param = AVSadd_parameter ("Follow Boundary", "boolean", 0, 0, 1);
	param = AVSadd_parameter ("Show Markers",    "boolean", 0, 0, 1);
	param = AVSadd_parameter ("Boundary Only",   "boolean", 1, 0, 1);
	
	/* define a sensible initial layout */
	AVSadd_parameter_prop(param, "layout", "string_block", 
   "panel \"$Module\" -w panel -xy 0,64 -wh 250,782 \n\
    manipulator \"$Module:Node Data\"       -w text          -p \"$Module\" -xy 10,10   -wh 118,22 \n\
    manipulator \"$Module:node data\"       -w radio_buttons -p \"$Module\" -xy 10,30   -wh 118,110 \n\
    manipulator \"$Module:N Segment\"       -w idial         -p \"$Module\" -xy 140,150 -wh 90,130 \n\
    manipulator \"$Module:N Steps\"         -w idial         -p \"$Module\" -xy 140,290 -wh 90,130 \n\
    manipulator \"$Module:Integration\"     -w text          -p \"$Module\" -xy 10,290  -wh 118,22 \n\
    manipulator \"$Module:integ method\"    -w radio_buttons -p \"$Module\" -xy 10,310  -wh 118,66 \n\
    manipulator \"$Module:Ribbons\"         -w toggle        -p \"$Module\" -xy 10,440  -wh 118,22 \n\
    manipulator \"$Module:Ribbon Width\"    -w dial          -p \"$Module\" -xy 140,470 -wh 90,130 \n\
    manipulator \"$Module:Ribbon Angle\"    -w dial          -p \"$Module\" -xy 10,470  -wh 90,130 \n\
    manipulator \"$Module:Backward\"        -w toggle        -p \"$Module\" -xy 130,30  -wh 118,22 \n\
    manipulator \"$Module:Color Streams\"   -w toggle        -p \"$Module\" -xy 130,60  -wh 118,22 \n\
    manipulator \"$Module:Interaction Mode\" -w text         -p \"$Module\" -xy 10,630  -wh 118,22 \n\
    manipulator \"$Module:inter mode\"      -w radio_buttons -p \"$Module\" -xy 10,660  -wh 118,66 \n\
    manipulator \"$Module:Start Streams\"   -w toggle        -p \"$Module\" -xy 10,730  -wh 118,22 \n\
    manipulator \"$Module:Max Steps\"       -w typein_integer -p \"$Module\" -xy 10,418 -wh 118,22 \n\
    manipulator \"$Module:Follow Boundary\" -w toggle        -p \"$Module\" -xy 130,660 -wh 118,22 \n\
    manipulator \"$Module:Show Markers\"    -w toggle        -p \"$Module\" -xy 130,690 -wh 118,22 \n\
    manipulator \"$Module:Boundary Only\"   -w toggle        -p \"$Module\" -xy 130,720 -wh 118,22 \n\
    manipulator \"$Module:choice\"          -w radio_buttons -p \"$Module\" -xy 14,155  -wh 118,88");

	AVSset_init_proc (ucd_streak_init);
	
	AVSset_destroy_proc (ucd_streak_finis);
	
	AVSset_compute_proc (ucd_streak);
	
#ifndef sep_exe
	AVSset_module_flags (COOPERATIVE);
#endif
}

#ifdef sep_exe
AVSinit_modules()
{
	int ucd_streak_desc();
	
	AVSmodule_from_desc (ucd_streak_desc);
}
#endif



/*-----------------------------------------------------*/
/*  ucd_streak Module Compute Function                 */
/*-----------------------------------------------------*/

ucd_streak (ucd_input, colormap_input, samples,
                xform_info, geom_output, to_samplers,
		dummy, data_type, probe_res, sample_type,
                num_seg, dummy1, type_integ,
		ribbons, rib_width, rib_angle,
		backward, color_streams, show_bounds,
                dummy2, inter_mode, start_streams,
                max_steps, boundary_constrain, show_markers, bound_only )
    
    AVScolormap *colormap_input;
    AVSfield        *samples;
    char *dummy, *dummy1, *dummy2, *data_type,
         *sample_type, *type_integ, *inter_mode;
    
    GEOMedit_list **geom_output;
    
    int probe_res, num_seg, backward,
        start_streams, color_streams, ribbons, show_bounds;
    float  *rib_width, *rib_angle;
    
    UCD_structure *ucd_input;
    
    upstream_transform *xform_info, **to_samplers;

    int  max_steps, boundary_constrain;
    int  show_markers;
    int  bound_only;
{
	
	char string[80], model_name[100], data_labels[UCD_LABEL_LEN], delim[2], 
	old_data_type[UCD_LABEL_LEN];
	
	float init_point[3], end_point[3], time_step, probe_point[3], *point_list,
	xform_mat[4][4], ribbon_w, ribbon_a, sample_ext[6];
	
	GEOMobj *obj, *pobj;
	
	int nverts, i, j, cell, node, name, ncells, *cell_list, count, name_flag, 
	util_flag, *nlist, cell_count, boundary_flag, next_cell, total_count, 
	cell_name, element_type, material_type, cell_type, mid_edge_flags,
	null_mat, new_input, do_streams;
	
	float *xc, *yc, *zc, *node_data, width, depth, height, min_extent[3], 
        max_extent[3], max_vect_mag, xform[4][4]; 
	
	int data_len, cell_len, node_len, num_vcomp, num_nodes, *active_list, 
	*nd_comp_list, num_comp, offset, num_cells, num_sample_pts,
	comp_num, mag_comp, integ_meth, new_probe, mesh_id, found;
	
	float *sample_pts;
	
	Ucd_Stats_Type *ucd_stats;
	
	XFORM matrix;
        int select_number;
	
	/**************
	 ***  body  ***
	 **************/

/********
  int ii;
  printf(" struct ptr %ld\n", (long int)ucd_input );
  printf(" struct name %s\n",ucd_input->name );
  printf(" struct ncells %d\n",ucd_input->ncells );
  printf(" struct veclen %d\n",ucd_input->node_veclen );
  for(ii=0; ii<20; ii++)
    printf(" nodes %f %ld %g\n",
       ucd_input->node_data[ii],
       ucd_input->node_data[ii],
       ucd_input->node_data[ii]);
 ********/
	
	strcpy(old_data_type, data_type);
	ribbon_w = *rib_width;
	ribbon_a = *rib_angle*M_PI/180.;

	if (!UCDstructure_get_header (ucd_input, model_name, &data_len, &name_flag,
				      &num_cells, &cell_len, &num_nodes, &node_len,
				      &util_flag)) {
		AVSerror ("Error in ucd_streak: can't get header.\n");
		return (0);
	}
	
printf("node len %d\n", node_len );

	if (!UCDstructure_get_node_positions (ucd_input, &xc, &yc, &zc)) {
		AVSerror ("Error in ucd_streak: can't get node coordinates.\n");
		return (0);
	}
	
	if (!UCDstructure_get_node_data (ucd_input, &node_data)) {
		AVSerror ("Error in ucd_streak: can't get node data.\n");
		return (0);
	}
	
	UCDstructure_get_extent (ucd_input, min_extent, max_extent);
	
	if (!UCDstructure_get_mesh_id (ucd_input, &mesh_id)) {
		AVSerror ("Error in ucd_streak: can't get mesh id.\n"); 
		return (0);
	}

	if (AVSinput_changed("Input", 0)) {

		extent[0] = min_extent[0], extent[1] = max_extent[0];
		extent[2] = min_extent[1], extent[3] = max_extent[1];
		extent[4] = min_extent[2], extent[5] = max_extent[2];
		
		cx = (extent[0] + extent[1]) / 2.0;
		cy = (extent[2] + extent[3]) / 2.0;
		cz = (extent[4] + extent[5]) / 2.0;
		
		width = extent[1] - extent[0];
		height = extent[3] - extent[2];
		depth = extent[5] - extent[4];
		

		max_dim = (width > height ? width : height);	
		max_dim = (depth > max_dim ? depth : max_dim);
		
		
		/*  define the node data menu.  */
		
		UCDstructure_get_node_active (ucd_input, &active_list);
		
		UCDstructure_get_node_components (ucd_input, &nd_comp_list);
		
		UCDstructure_get_node_labels (ucd_input, data_labels, delim);
		
/**********
		for (i = 0, num_comp = 1; data_labels[i] != '\0'; i++)
			if (data_labels[i] == delim[0]) num_comp++;
		
		ucd_define_menu (ucd_input, node_len, cell_len, 1, &num_comp, &num_vcomp,
				 &nd_comp_list, 3, string);
		
		comp_num = ucd_get_offset (ucd_input, num_nodes, num_comp, nd_comp_list,
					   string, &offset);
		
		for (j = 0, found = 0; j < num_comp && !found; j++) {
			UCDstructure_get_node_label (ucd_input, j, string);
			found = !strcmp (string, old_data_type);
		}
		if (found) {
			AVSmodify_parameter ("node data",  AVS_VALUE, string,
					     data_labels, ".");
			comp_num = ucd_get_offset (ucd_input, num_nodes,
                                                   num_comp, nd_comp_list,
						   string, &offset);
		}
 *********/
 num_comp=1;



                AVSmodify_parameter("node data",
                       AVS_VALUE | AVS_MINVAL | AVS_MAXVAL,
                       data_type, data_labels, delim );

                select_number = AVSchoice_number("node data", data_type )-1;
                offset = node_len * select_number * 3;
                if ( nd_comp_list[ select_number ] != 3 )
                {
/*
                    AVSerror("The selected node data is not 3-vector, try again!");
                    return(0);
 */
                    select_number = offset = 0;
                    num_vcomp = 1;
                }
                if ( select_number > node_len )
                {
                    AVSerror("The selected node data out of range, internal error!");
                    return(0);
                }

/*****end * change ****/

		if (AVSstatic == NULL) {
			ucd_stats = (Ucd_Stats_Type *)malloc(sizeof(Ucd_Stats_Type));
			ucd_stats->nd_comp_list = NULL;
			ucd_stats->mesh_id = 0;
		}
		else {
			ucd_stats = (Ucd_Stats_Type *)AVSstatic;
		} 
		
		ucd_stats->extent[0] = min_extent[0], ucd_stats->extent[1] = max_extent[0];
		ucd_stats->extent[2] = min_extent[1], ucd_stats->extent[3] = max_extent[1];
		ucd_stats->extent[4] = min_extent[2], ucd_stats->extent[5] = max_extent[2];
		
		ucd_stats->nd_comp_list = nd_comp_list;
		ucd_stats->num_comp = num_comp;
		ucd_stats->num_vcomp = num_vcomp;
		ucd_stats->offset = offset;
		
		ucd_stats->center[0] = cx;
		ucd_stats->center[1] = cy;
		ucd_stats->center[2] = cx;
		ucd_stats->max_dim = max_dim;
		
		AVSstatic = (char *)ucd_stats;
		
		if (num_vcomp > 0){
			if (mesh_id != ucd_stats->mesh_id) {
				if (ucd_stats->mesh_id)
					UTILucd_delete_block_table(ucd_stats->mesh_id);
				UTILucd_build_block_table(ucd_input, mesh_id, ADAPT_FLAG);	   
			}
			ucd_stats->mesh_id = mesh_id;
		}
		ucd_stats->mag_comp = 0;
		ucd_stats->max_vect_mag = 0.0;
		ucd_stats->integ_meth = 1;
		ribbon_w = 0.1*max_dim;
		AVSmodify_float_parameter ("Ribbon Width",  
					   AVS_VALUE|AVS_MAXVAL|AVS_MINVAL, 
					   ribbon_w, 0.0, 20*ribbon_w);
	}
	else {
		new_input = 0;
		ucd_stats = (Ucd_Stats_Type *)AVSstatic;
		nd_comp_list = ucd_stats->nd_comp_list;
		num_comp = ucd_stats->num_comp;
		offset = ucd_stats->offset;
		num_vcomp = ucd_stats->num_vcomp;
		
		cx = ucd_stats->center[0];
		cy = ucd_stats->center[1];
		cz = ucd_stats->center[2];
		max_dim = ucd_stats->max_dim;
	}

printf("num_vcomp %d\n", num_vcomp );
	
/*
	if (ucd_stats->num_vcomp < 1) {
		AVSerror ("Error in ucd_streak: no vector components.\n");
		return (0);
	}
 */
	
	if (samples) {
		*to_samplers = xform_info;
		if (!AVSinput_changed("Transform Info", 0)) 
			AVSmark_output_unchanged("Upstream Transform");
		AVSparameter_visible("choice", 0);
		AVSparameter_visible("N Segment", 0);
		AVSparameter_visible("Show Bounds", 1);
	} else {
		AVSparameter_visible("choice", 1);
		AVSparameter_visible("N Segment", 1);
		AVSparameter_visible("Show Bounds", 0);
	}

	/* new boundary following system */
	if ( boundary_constrain && ribbons )
	{
		AVSerror ("Warning from ucd_streak: Follow Boundary and Ribbons incompatable modes\n");
		return (0);
	}
	if ( boundary_constrain )
	{
		AVSparameter_visible("Boundary Only", 1);
		AVSparameter_visible("Show Markers", 1);
	}
	else
	{
		AVSparameter_visible("Boundary Only", 0);
		AVSparameter_visible("Show Markers", 0);
	}


/*****begin * change ****/

/*******
	if (AVSparameter_changed("node data")) {
		comp_num = ucd_get_offset (ucd_input, num_nodes, num_comp, nd_comp_list,
					   data_type, &offset);
		ucd_stats->offset = offset;
		ucd_stats->mag_comp = 0;
	}
 ******/
	if (AVSparameter_changed("node data")) {

                select_number = AVSchoice_number("node data", data_type )-1;
                offset = node_len * select_number * 3;
                if ( nd_comp_list[ select_number ] != 3 )
                {
/*
                    AVSerror("The selected node data is not 3-vector, try again!");
                    return(0);
 */
                    select_number = 0;
                }
                if ( select_number > node_len )
                {
                    AVSerror("The selected node data out of range, internal error!");
                    return(0);
                }
		ucd_stats->offset = offset;
		ucd_stats->mag_comp = 0;
	}


/*****end * change ****/
	
	if (color_streams && !ucd_stats->mag_comp) {
		ucd_comp_vect_mag (num_nodes, &node_data[offset], &max_vect_mag);
		
		if (max_vect_mag == 0.0) {
			AVSerror ("Error in ucd_streak: vector components are all zero.\n");
			return (0);
		}
		
		ucd_stats->mag_comp = 1;
		ucd_stats->max_vect_mag = max_vect_mag;
	}
	
	
	if (AVSparameter_changed("integ method")) 
		ucd_stats->integ_meth = AVSchoice_number ("integ method", type_integ); 
	
	
	/*  send those streaks back in time.  */
	
	if (backward)
		num_seg = -num_seg;
	
	
	/*  if the probe changes re-define its geometry.  */
	
	sample_pts = NULL;

	if (color_streams && colormap_input)
		Colors = 1;
	else
		Colors = 0;
	
	if (ribbons) {
		AVSparameter_visible("Ribbon Width", 1);
		AVSparameter_visible("Ribbon Angle", 1);
	}
	else {
		AVSparameter_visible("Ribbon Width", 0);
		AVSparameter_visible("Ribbon Angle", 0);
	}

	AVSparameter_visible("Start Streams", 0);

	if (!strcmp(inter_mode, "Immediate")) {
		do_streams = 1;
	}
	else if (!strcmp(inter_mode, "Wait")) {
		AVSparameter_visible("Start Streams", 1);
		if (start_streams) {
			AVSmodify_parameter ("Start Streams", AVS_MINVAL | AVS_VALUE, 0, 0, 1);
			do_streams = 1;
		}
		else
			do_streams = 0;
	}
	else if (!strcmp(inter_mode, "Button Up"))
		if (AVSinput_changed("Transform Info", 0) &&
		    xform_info && !strncmp(xform_info->object_name, "streak probe",
					   strlen("streak probe")) && 
		    (xform_info->flags & BUTTON_UP))
			do_streams = 1;
		else
			do_streams = 0;
	else {
		AVSerror ("Error in ucd_streak: unknown interactive mode.\n");
		return (0);
	}
	*geom_output = (GEOMedit_list *)GEOMinit_edit_list(*geom_output);

	pobj = GEOMcreate_obj (GEOM_POLYTRI, NULL);

	if (samples) {
		num_sample_pts = AVSfield_prod(samples->ndim, samples->dimensions);
		if (num_sample_pts == 0)
			return(0);

		sample_pts = (float *)malloc(num_sample_pts*3*sizeof(float));
		
		/* create bounding box of samples */
		if (samples->dimensions[0] == 1) {
			for (i=0; i<3; i++) {
				sample_pts[i] = samples->points[i];
				sample_ext[2*i] = samples->points[i] - 0.05*max_dim;
				sample_ext[2*i+1] = samples->points[i] + 0.05*max_dim;
			}
		} 
		else {
			for (i=0; i<3; i++) {
				sample_ext[2*i]=samples->points[i*num_sample_pts];
				sample_ext[2*i+1]=samples->points[i*num_sample_pts];
			}
			for (i=0; i<num_sample_pts; i++) {
				sample_pts[3*i] = samples->points[i];
				sample_pts[3*i+1] = samples->points[i+num_sample_pts];
				sample_pts[3*i+2] = samples->points[i+2*num_sample_pts];
			}
			if (show_bounds) {
				for (i=0; i<num_sample_pts; i++) {
					if (samples->points[i] < sample_ext[0])
						sample_ext[0] = samples->points[i];
					if (samples->points[i] > sample_ext[1])
						sample_ext[1] = samples->points[i];
					if (samples->points[i+num_sample_pts] < sample_ext[2])
						sample_ext[2] = samples->points[i+num_sample_pts];
					if (samples->points[i+num_sample_pts] > sample_ext[3])
						sample_ext[3] = samples->points[i+num_sample_pts];
					if (samples->points[i+2*num_sample_pts] < sample_ext[4])
						sample_ext[4] = samples->points[i+2*num_sample_pts];
					if (samples->points[i+2*num_sample_pts] > sample_ext[5])
						sample_ext[5] = samples->points[i+2*num_sample_pts];
				}			
				make_box(pobj, sample_ext);
			}
		}
	}
	else {
		if (xform_info &&
		    !strncmp(xform_info->object_name, "streak probe", strlen("streak probe"))) 
			UTILsample (sample_type, probe_res + 1, xform_info->msxform,
				    min_extent, max_extent, &sample_pts, &num_sample_pts);
		else
			UTILsample (sample_type, probe_res + 1, imat,
				    min_extent, max_extent, &sample_pts, &num_sample_pts);
		
		create_marker(pobj, sample_type, min_extent, max_extent, sample_pts, probe_res + 1);
	}
	GEOMedit_geometry (*geom_output, "streak probe", pobj);
	GEOMedit_window (*geom_output, "streak probe", ucd_stats->extent);
	GEOMedit_transform_mode (*geom_output, "streak probe", "redirect",
				 BUTTON_DOWN | BUTTON_MOVING | BUTTON_UP);
/**
	GEOMedit_center (*geom_output, "streak probe", ucd_stats->center);
***/
	GEOMdestroy_obj (pobj);
			
	if (do_streams) {
		obj = GEOMcreate_obj (GEOM_POLYTRI, NULL);
		for (i = 0; i < num_sample_pts; i++) {
			create_streak (ucd_input, obj, num_cells, sample_pts+3*i, xc, 
					   yc, zc, &node_data[offset], 
					   color_streams ? colormap_input : NULL, 
					   ucd_stats->max_vect_mag, num_seg, 
					   ucd_stats->integ_meth,
					   ribbons, ribbon_w, ribbon_a,
                                           max_steps, boundary_constrain, show_markers,
					   bound_only );
		}
		GEOMedit_geometry (*geom_output, "streak", obj);
		GEOMedit_window (*geom_output, "streak", ucd_stats->extent);
		GEOMedit_transform_mode (*geom_output, "streak", "parent", 0);
		GEOMdestroy_obj (obj);

	}
	else if (AVSinput_changed("Input", 0)) {
		obj = GEOMcreate_obj (GEOM_POLYTRI, NULL);
		GEOMedit_geometry (*geom_output, "streak", obj);
		GEOMedit_window (*geom_output, "streak", ucd_stats->extent);
		GEOMedit_transform_mode (*geom_output, "streak", "parent", 0);
		GEOMdestroy_obj (obj);
	}
	if (sample_pts)

/* IAC CODE CHANGE : 		free (sample_pts); */
		 free(sample_pts);
	return (1);
}


/*-----------------------------------------------------*
 *                                                     *
 *           ****  create_streak  ****                 *
 *   create the streak line for each sample point      *
 *   called once per streamline seeding point          *
 *                                                     *
 *-----------------------------------------------------*/
create_streak (ucd_input, obj, num_cells, sample_pt, xc, yc, zc, node_data,
		   colormap, max_vect_mag, num_seg, integ_meth, 
		   ribbon, init_rad, init_ang, max_steps,
                   boundary_constrain, show_markers, bound_only  )
    
    UCD_structure *ucd_input;	/* ucd input structure pointer */
    GEOMobj *obj;		/* output geom shape for steak line */
    AVScolormap *colormap;	/* color map for streamline=vecmag [could be NULL] */
    
    float *xc, *yc, *zc,	/* pointers to selected node coordinates */
          *node_data,		/* pointer to selected nodal data array  */
          *sample_pt,		/* starting position for this stream line */
           max_vect_mag,	/* maximum magnitude of vector for coloring */
           init_rad,		/* initial radius of ribbon */
           init_ang;		/* initial angle of ribbon */
    
    int num_cells,		/* number of cells in ucd structure */
        num_seg,		/* number of steps per cell to make */
        integ_meth,		/* integration method choice */
        ribbon;			/* line or ribbon mode */
    
    int max_steps,		/* artificially limit streamline to n-steps */
        boundary_constrain,	/* boundary treatment mode (experimental) */
        show_markers,		/* show integration boundary markers */
        bound_only;		/* show lines on boundary only, hide interior lines */
{
	
	float fast_fsqrt();
	float interp_val[3], end_pt[6], streak[303], *acc_streak,
	time_step, *pts, colors[303], init_pt[6], *acc_colors, uvw[3],
	radius[101], angle[101], time[101], *acc_rad, *acc_ang, *acc_time, 
	vx, vy, vz, mag, cur_rad;
        float intersect[3];
        float proj_pt[3];
        float cell_extent;
	
	int i, j, m, cell, boundary_flag, total_count, next_cell, count,
	indexer, alloc_count, rib_count, num_steps;
	float   *verts, *vert_colors, *normals, v0[3], v1[3], v2[3], vi[3],xfm[3][3];
	
	/**************
	 ***  body  ***
	 **************/
	num_steps = num_cells/10;	/* guess at number of integration steps */
	if (num_steps < 10)		/* min=10, max=1000, buffer size for alloc */
		num_steps=10;
	if (num_steps > MAX_BUF_START)
		num_steps=MAX_BUF_START;
	alloc_count = 1;			/* number of allocated buffers */
	acc_streak = NULL; acc_colors = NULL; 
	acc_rad = NULL; acc_ang = NULL; acc_time = NULL;
	acc_streak = (float *)malloc(num_steps*3*alloc_count*sizeof(float));
	if (acc_streak == NULL) {
		AVSerror("ucd streak: cannot allocate streaks location buffer\n");
		return(0);
	}
	if (colormap) {
		acc_colors = (float *)malloc(num_steps*3*alloc_count*sizeof(float));
		if (acc_colors == NULL) {
			AVSerror("ucd streak: cannot allocate streaks color table\n");
			return(0);
		}
	}
	if (ribbon) {
		acc_rad = (float *)malloc(num_steps*alloc_count*sizeof(float));
		acc_ang = (float *)malloc(num_steps*alloc_count*sizeof(float));
		acc_time = (float *)malloc(num_steps*alloc_count*sizeof(float));
		if (acc_rad == NULL || acc_ang == NULL || acc_time == NULL) {
			AVSerror("ucd streak: cannot allocate streaks ribbon table\n");
			return(0);
		}
	}
	mat_build_sqrt_table();
	
        /* intitialize the sample position */
	init_pt[0] = sample_pt[0];
	init_pt[1] = sample_pt[1];
	init_pt[2] = sample_pt[2];
	
	/* convert to local cell coordinates, find cell for starting sample */
	cell = UTILucd_interp_cell(ucd_input, 3, node_data, init_pt,interp_val, uvw); 

        /* if outside of domain, stop */
	if (cell < 0) {
		return(0);
	}
	acc_streak[0] = init_pt[0];
	acc_streak[1] = init_pt[1];
	acc_streak[2] = init_pt[2];
	if (ribbon) {
		acc_rad[0] = 0.0;
		acc_ang[0] = 0.0;
		acc_time[0] = 0.0;
	}

	if (colormap)  {
		vx = interp_val[0], vy = interp_val[1], vz = interp_val[2];
		mag = /* fast_fsqrt */ sqrt(vx*vx + vy*vy + vz*vz);
		if (mag < EPS1)
			return(0);
		if (max_vect_mag == 0.0) {
			AVSerror("ucd streak: cannot divide by zero, vecmag minmax\n");
			i = colormap->size - 1;
		}
		/* auto-normalize color range here! */
		else {
			i = (colormap->size - 1) * (mag / max_vect_mag);
		}
		
		FILTERhsv_to_rgb (&acc_colors[0], &acc_colors[1], &acc_colors[2], 
				 colormap->hue[i],
                                 colormap->saturation[i], colormap->value[i]);
	}
	
	/*  create streak for one cell at a time until boundary is hit.  */
	boundary_flag = 1;
	count = 0;
	rib_count = 1;
	indexer = 3;
	total_count = 3;

	/*
	 * Keep looping, while we are don't hit the boundary and below limit
	 */
	while ( boundary_flag && total_count < max_steps*3 )
        {
		/*
		 * compute the new stream position, and return the new point
		 * and the cell to go to next
		 */
		if (ucd_comp_streak (ucd_input, cell, num_seg, init_pt, end_pt, streak,
					 colors, colormap, interp_val, max_vect_mag, 
					 &count, integ_meth, node_data, 
					 ribbon, radius, angle, time,
					 &next_cell, obj, &cell_extent, bound_only ))
                {


			total_count += 3*count; 
			/*
			 * bump up buffer
			 */
			if (total_count >= 3*alloc_count*num_steps) {
				alloc_count++;
				acc_streak = (float *)realloc(acc_streak, 
						  num_steps*3*alloc_count*sizeof(float));
				if (acc_streak == NULL) {
				  AVSerror( "ucd streak: cannot re-allocate streaks buffer\n");
					return(0);
				}
				if (ribbon) {
					acc_rad = (float *)realloc(acc_rad, num_steps*
								   alloc_count*sizeof(float));
					acc_ang = (float *)realloc(acc_ang, num_steps*
								   alloc_count*sizeof(float));
					acc_time = (float *)realloc(acc_time, num_steps*
								    alloc_count*sizeof(float));
					if (acc_rad == NULL || acc_ang == NULL || acc_time == NULL) {
				          AVSerror( "ucd streak: cannot re-allocate ribbon buffer\n");
						return(0);
					}
				}
				if (colormap) {
					acc_colors = (float *)realloc(acc_colors, 
								      num_steps*3*alloc_count*sizeof(float));
					if (acc_colors == NULL) {
				          AVSerror( "ucd streak: cannot re-allocate color buffer\n");
						return(0);
					}
				}
			}
			/*
			 * Update Line List
			 * load the new position and color into buffer
			 */
			for (i = 0; i < 3*count; i++) {
				if (colormap)
					acc_colors[indexer] = colors[i];
				acc_streak[indexer++] = streak[i];
			}
			
			if (ribbon) {
				for (i = 0; i < count; i++) {
					acc_rad[rib_count] = radius[i];
					acc_ang[rib_count] = angle[i];
					acc_time[rib_count++] = time[i];
				}
			}

			/*
			 * boundary condition
			 */
			if (next_cell < 0)
			{
				/*
				 * give up, we have moved outside of domain
				 * the end point is now just outside, past the
				 * last line seg of streamline.
				 */
				boundary_flag = 0;

				/*
				 *  check for special case of boundary following
				 */
				if ( boundary_constrain )
				{
					boundary( ucd_input,
          					node_data,
          					obj,
          					uvw,
          					cell,
					        &next_cell,
          					xc, yc, zc,
          					init_pt, end_pt,
          					interp_val,
          					&boundary_flag,
						0.25 * cell_extent/(float)num_seg,
						show_markers  );

					/* draw the surface line */
					if ( boundary_flag )
					{
				            if (colormap)
					      mark_pt( obj, init_pt, end_pt, 4, colors );
					    else
					      mark_pt( obj, init_pt, end_pt, 0, NULL );
					}
				}
			}
			else
   				/* keep going, still inside domain */
				boundary_flag = 1;

			/*
			 * give up, if we have made an enormous number of steps
			 */
			if (total_count > num_cells * 10 )  /* why stop here? */
				boundary_flag = 0;
			/*
			 * Move to Next Cell, start again at last position
			 */
			if (boundary_flag) {
				cell = next_cell;
				
				init_pt[0] = end_pt[0];
				init_pt[1] = end_pt[1];
				init_pt[2] = end_pt[2];
			}
		}
		else
			boundary_flag = 0;
	}

	if (ribbon) {
		if (rib_count < 2) {
			if (acc_streak)

/* IAC CODE CHANGE : 				free(acc_streak); */
				 free(acc_streak);
			if (acc_colors)

/* IAC CODE CHANGE : 				free(acc_colors); */
				 free(acc_colors);
			if (acc_rad)

/* IAC CODE CHANGE : 				free(acc_rad); */
				 free(acc_rad);
			if (acc_ang)

/* IAC CODE CHANGE : 				free(acc_ang); */
				 free(acc_ang);
			if (acc_time)

/* IAC CODE CHANGE : 				free(acc_time); */
				 free(acc_time);
			return(1);
		}

		calc_ribbon_ang(integ_meth, rib_count, acc_time, init_ang, acc_ang);
		calc_ribbon_rad(integ_meth, rib_count, acc_time, init_rad, acc_rad);
		verts = NULL; vert_colors = NULL;
		verts = (float *)malloc(2*total_count*sizeof(float));
		normals = (float *)malloc(2*total_count*sizeof(float));
		if (colormap)
			vert_colors = (float *)malloc(2*total_count*sizeof(float));

		/*** calculate init vector ***/
		v0[0]=acc_streak[3]-acc_streak[0];
		v0[1]=acc_streak[4]-acc_streak[1];
		v0[2]=acc_streak[5]-acc_streak[2];
		AVS_UNITIZE(v0, EPS1);
		v1[0]=0.0; v1[1]=0.0; v1[2]=1.0;
		AVS_CROSS(v0, v1, v2);
		mag = AVS_LENGTH(v2);
		if (mag < EPS1) {
			v1[0]=0.0; v1[1]=1.0; v1[2]=0.0;
			AVS_CROSS(v0, v1, v2);
		}
		AVS_CROSS(v2, v0, v1);
		/** transform from local to global CS **/
		for (i=0; i<3; i++) {
			xfm[0][i] = v0[i];
			xfm[1][i] = v1[i];
			xfm[2][i] = v2[i];
		}
		v1[0] = 0.0;
		v1[1] = cos(init_ang);
		v1[2] = sin(init_ang);
		vec_by_mat(v1, xfm, vi, 1, 3, 3);
		for (i=0; i<3; i++) {
			verts[i] = acc_streak[i];
			verts[3+i] = acc_streak[i] + init_rad*vi[i];
		}
		if (colormap) 
			for (i=0; i<3; i++) {
				vert_colors[i] = acc_colors[i];
				vert_colors[3+i] = acc_colors[i];
			}
		AVS_CROSS(v0, vi, v2);
		for (i=0; i<3; i++) {
			normals[i] = v2[i];
			normals[3+i] = v2[i];
		}
		count = 2;
		for(m=1; m<rib_count; m++) {
			if (m == rib_count-1) {
				v0[0]=acc_streak[3*m]-acc_streak[3*m-3];
				v0[1]=acc_streak[3*m+1]-acc_streak[3*m-2];
				v0[2]=acc_streak[3*m+2]-acc_streak[3*m-1];
			}
			else {
				v0[0]=acc_streak[3*m+3]-acc_streak[3*m-3];
				v0[1]=acc_streak[3*m+4]-acc_streak[3*m-2];
				v0[2]=acc_streak[3*m+5]-acc_streak[3*m-1];
			}
			AVS_UNITIZE(v0, EPS1);
			/** Project the previous normal vector(vi)     **/
			/** on the plane normal to local tangent(v0)   **/
			mag = AVS_DOT(vi, v0);
			for(j=0; j<3; j++) 
				v1[j] = vi[j] - mag*v0[j];
			AVS_UNITIZE(v1, EPS1);
			AVS_CROSS(v0, v1, v2);
			
			/** transform from local to global CS **/
			for (i=0; i<3; i++) {
				xfm[0][i] = v0[i];
				xfm[1][i] = v1[i];
				xfm[2][i] = v2[i];
			}
			v1[0] = 0.0;
			v1[1] = cos(acc_ang[m]-acc_ang[m-1]);
			v1[2] = sin(acc_ang[m]-acc_ang[m-1]);
			vec_by_mat(v1, xfm, vi, 1, 3, 3);
			cur_rad =acc_rad[m];
			for (i=0; i<3; i++) {
				verts[3*count+i] = acc_streak[3*m+i];
				verts[3*count+3+i] = acc_streak[3*m+i] + cur_rad*vi[i];
			}
			if (colormap)
				for (i=0; i<3; i++) {
					vert_colors[3*count+i] = acc_colors[3*m+i];
					vert_colors[3*count+3+i] = acc_colors[3*m+i];
				}
			AVS_CROSS(v0, vi, v2);
			for (i=0; i<3; i++) {
				normals[3*count+i] = v2[i];
				normals[3*count+3+i] = v2[i];
			}
			count += 2;
		}

		GEOMadd_polytriangle(obj, verts, normals, vert_colors, count,
				     GEOM_COPY_DATA);

/* IAC CODE CHANGE : 		free(verts); */
		 free(verts);
		if (vert_colors)

/* IAC CODE CHANGE : 			free(vert_colors); */
			 free(vert_colors);

/* IAC CODE CHANGE : 		free(normals); */
		 free(normals);
	}
	else {
		count = (int)((total_count+0.1)/3.0);
		if (count < 2) {
			if (acc_streak)

/* IAC CODE CHANGE : 				free(acc_streak); */
				 free(acc_streak);
			if (acc_colors)

/* IAC CODE CHANGE : 				free(acc_colors); */
				 free(acc_colors);
			if (acc_rad)

/* IAC CODE CHANGE : 				free(acc_rad); */
				 free(acc_rad);
			if (acc_ang)

/* IAC CODE CHANGE : 				free(acc_ang); */
				 free(acc_ang);
			if (acc_time)

/* IAC CODE CHANGE : 				free(acc_time); */
				 free(acc_time);
			return(1);
		}
		/*
		 * Send the StreamLine Data to the GeomViewer
		 */
		if ( !bound_only || !boundary_constrain )
		{
		  if (colormap) 
			GEOMadd_polyline (obj, acc_streak, acc_colors, count, 
					  GEOM_COPY_DATA);
		  else
			GEOMadd_polyline (obj, acc_streak, GEOM_NULL, count, 
					  GEOM_COPY_DATA);
		}
	}
	if (acc_streak)

/* IAC CODE CHANGE : 		free(acc_streak); */
		 free(acc_streak);
	if (acc_colors)

/* IAC CODE CHANGE : 		free(acc_colors); */
		 free(acc_colors);
	if (acc_rad)

/* IAC CODE CHANGE : 		free(acc_rad); */
		 free(acc_rad);
	if (acc_ang)

/* IAC CODE CHANGE : 		free(acc_ang); */
		 free(acc_ang);
	if (acc_time)

/* IAC CODE CHANGE : 		free(acc_time); */
		 free(acc_time);
	return(1);
}


/*-----------------------------------------------------*
 *                                                     *
 *           **** ucd_comp_streak  ****                *
 *  compute the next streamline sample position,       *
 *  result of path integration                         *
 *                                                     *
 *  returns 0 if end of stream, 1 if more to do        *
 *-----------------------------------------------------*/
#if defined(titan) || defined(SX)
#pragma OPT_LEVEL 0
#endif
ucd_comp_streak (input, cell, num_seg, init_point, end_point, streak,
		     colors, colormap, init_val, max_vect_mag, count, integ_meth,
		     node_data, ribbon, radius, angle, time,
		     next_cell, obj, cell_extent, bound_only )
    
    UCD_structure *input;	/* input ucd structure pointer */
    AVScolormap   *colormap;	/* optional colormap input structure */
    float         *init_point,	/* input position of current sample */
                  *end_point,	/* return new position, after integration */
                  *streak,
                  *colors, 
                  *radius,
                  *angle,
                  *time,
                  *init_val,
                  max_vect_mag,	/* max vector mag of input data */
                  *node_data;   /* pointer to selected node data */
    int           cell,		/* current cell the last sample position was in */
                  num_seg,	/* suggested samples per cell */
                  *count,
                  integ_meth,	/* integration method choice */
                  ribbon,	/* line or ribbon toggle */
                  *next_cell;  	/* return value for next cell to go into */
    GEOMobj *obj;		/* output geom shape for steak line */
    float         *cell_extent; /* size of cell, minimum guess, RETURNED */
    int           bound_only;   /* show boundary constrained lines only */
{
	float fast_fsqrt();	
	float dist, eps1, eps2, x_loc, y_loc, z_loc, uvw[3], value[3], 
        *xc, *yc, *zc, xmax, xmin, ymax, ymin, zmax, zmin, min_extent,
	avextent, r, g, b, vx, vy, vz, mag, time_step, *data, ave_vel, prev_vel[3];
	
	int cell_id, int_cell_name, mat_id, cell_type, num_nodes, me_flags, node, j,
	*node_list, node_data_index, i, in_out, k; 

	float in[6], out[6];
        float mid_pt[6];     /* was 3! */
	
	/************
	 *** body ***
	 ************/
	
	/* make lookup for fast square root routine */
	mat_build_sqrt_table();
	
	/*  make sure time_steps are small enough.  */
	
	UCDstructure_get_node_positions (input, &xc, &yc, &zc);
	
	if (!UCDcell_get_information (input, cell, &cell_id, &int_cell_name,
				      &mat_id, &cell_type, &me_flags, &node_list)) {
		AVSerror( "Error in ucd_streak: can't get cell info.\n");
		return(0);
	}
	
	*count = 0;
	/*
	 * explicit calculation of model geometric extent of current cell
	 */
	num_nodes = UCD_num_nodes[cell_type];
	node = node_list[0];
	xmax = xmin = xc[node];
	ymax = ymin = yc[node];
	zmax = zmin = zc[node];
	
	for (j = 1; j < num_nodes; j++) {
		node = node_list[j];
		xmin = (xc[node] < xmin ? xc[node] : xmin);
		xmax = (xc[node] > xmax ? xc[node] : xmax);
		ymin = (yc[node] < ymin ? yc[node] : ymin);
		ymax = (yc[node] > ymax ? yc[node] : ymax);
		zmin = (zc[node] < zmin ? zc[node] : zmin);
		zmax = (zc[node] > zmax ? zc[node] : zmax);	
	}
	/*
	 * rough guess at size of current cell
	 */
	min_extent = 0.33*(xmax-xmin + ymax-ymin + zmax-zmin);
	*cell_extent = min_extent;	

	/*
	 * find average field velocity
	 */
	ave_vel=/* fast_fsqrt */ sqrt(init_val[0]*init_val[0]+
			   init_val[1]*init_val[1]+init_val[2]*init_val[2]);

	prev_vel[0] = init_val[0]; prev_vel[1]=init_val[1]; prev_vel[2]=init_val[2];
	/*
	 * stagnation, give up, nothing moving
	 */
	if (ave_vel < EPS1) {
		end_point[0] = init_point[0]; 
		end_point[1] = init_point[1];
		end_point[2] = init_point[2];
		return(0);
	}		
	/*
	 * rough estimate of time steps, based on
	 * size of cell and average velocity and
	 * steps per cell
	 * set time step such that at initial velocity
	 * we will stay inside the cell for "num_seg" steps
	 */
	time_step = min_extent / (ave_vel * (float)num_seg);

	eps1 = min_extent/fabs((float)num_seg);
	eps2 = 0.000001*min_extent;

	/*
	 *  integrate to find vertices in streak.
	 *  why 1 to 100?
	 */
	
	for (i = 0; i < 100; i++) {
		in[0] = init_point[0];
		in[1] = init_point[1];
		in[2] = init_point[2];

		/*
		 * Apply Numerical Integration Technique to move
		 * point to new position, using vector field data
		 */
		if (integ_meth == 1)
			ucd_euler (input, cell, node_data, in, out, time_step);
		else if (integ_meth == 2)
			ucd_ralston (input, cell, node_data, in, out, time_step);
		else if (integ_meth == 3)
			ucd_rkutta3 (input, cell, node_data, in, out, time_step);
		else 
			ucd_rkutta4 (input, cell, node_data, in, out, time_step);

		
		/*
		 * now we have a new point, how far have we moved?
		 */
		dist = /* fast_fsqrt */ sqrt((in[0]-out[0])*(in[0]-out[0]) +
                                  (in[1]-out[1])*(in[1]-out[1]) +
				  (in[2]-out[2])*(in[2]-out[2]));

		
		x_loc = out[0];  /* new sample point */
		y_loc = out[1];
		z_loc = out[2];
		
		/* check where we are in current cell, local coords and data  */
		/* in_out: 1=inside cell, 0=outside cell */
		/* this call computes to interpolated vector value at the new position, */
		/* and returns an error code if the sample point cannot be placed in the cell */
		ucd_extrap_cell (input, 3, node_data, cell, x_loc, y_loc, z_loc, uvw, 
				 &in_out, value);

		/* if in_out ==0, */
		/* in = almost all last points on lines, but not all, some are next to last. */
		/* out = all outlying points, outside domain, past the last point on lines */
		/* also, both have may points scattered along each line, not just ends  */

		/*  check if stepped outside current cell, if not, keep going inside cell.  */
		if (in_out<1)
		{
			k = 0;
			while (dist > eps1) {
				time_step *= 0.5;
				
				/*
		 		* Apply Numerical Integration Technique to move
		 		* point to new position, using vector field data
		 		*/
				if (integ_meth == 1)
					ucd_euler (input, cell, node_data, in, mid_pt, time_step);
				else if (integ_meth == 2)
					ucd_ralston (input, cell, node_data, in, mid_pt, time_step);
				else if (integ_meth == 3)
					ucd_rkutta3 (input, cell, node_data, in, mid_pt, time_step);
				else 
					ucd_rkutta4 (input, cell, node_data, in, mid_pt, time_step);
				

				x_loc = mid_pt[0]; /* new sample point */
				y_loc = mid_pt[1];
				z_loc = mid_pt[2];
				
		                /* check where we are in current cell, local coords and data  */
				ucd_extrap_cell (input, 3, node_data, cell, 
						 x_loc, y_loc, z_loc, uvw, 
						 &in_out, value);


				/*
		 		 * now we have a new point, how far have we moved?
		 		 */
				/* find distance along integration path */
				dist = /*fast_fsqrt */sqrt((in[0]-mid_pt[0])*(in[0]-mid_pt[0]) + 
						  (in[1]-mid_pt[1])*(in[1]-mid_pt[1]) +
						  (in[2]-mid_pt[2])*(in[2]-mid_pt[2]));

				/* if we have left the current cell, look for new cell */
				if (in_out == 0) {
					out[0] = mid_pt[0];
					out[1] = mid_pt[1];
					out[2] = mid_pt[2];
				}

				/* take current cell new position, add to graphical representation */
				else if (in_out == 1) {
					in[0] = mid_pt[0];
					in[1] = mid_pt[1];
					in[2] = mid_pt[2];
					add_stream(input, node_data, count, streak, 
						   colors, radius, angle, time,
						   colormap, max_vect_mag,
						   ribbon, cell, mid_pt, value,
						   uvw, time_step, prev_vel, dist);
					time_step *= 2.0;
					prev_vel[0] = value[0];
					prev_vel[1] = value[1];
					prev_vel[2] = value[2];
					continue;
				}
				else {
					end_point[0] = init_point[0]; 
					end_point[1] = init_point[1];
					end_point[2] = init_point[2];
					*count = 0;

					/* nothing here */


					return(0);
				}
			}  /* fall through - gone outside current cell immediately */

			/* find out where it goes next */
			*next_cell = UTILucd_get_cell(input, 3, node_data, 
							out, value, uvw); 

			/* if valid new cell, add to position graphics */
                        /* fallen into new cell, update */
			if (*next_cell >= 0) {
				add_stream(input, node_data, count, streak, 
					   colors, radius, angle, time,
					   colormap, max_vect_mag,
					   ribbon, *next_cell, out, value, 
					   uvw, time_step, prev_vel, dist);
				prev_vel[0]=value[0];prev_vel[1]=value[1];prev_vel[2]=value[2];
				init_val[0]=value[0];init_val[1]=value[1];init_val[2]=value[2];
			}
			end_point[0] = out[0];
			end_point[1] = out[1];
			end_point[2] = out[2];

			/* points along the line at intervals, and end points */

			return(1);
		}    /***  end if (out) ***/


		if (dist < eps2) {
			end_point[0] = init_point[0]; 
			end_point[1] = init_point[1];
			end_point[2] = init_point[2];
			*count = 0;

			/* nothing useful */


			return(0);
		}		
		add_stream(input, node_data, count, streak, 
			   colors, radius, angle, time,
			   colormap, max_vect_mag,
			   ribbon, cell, out, value, 
			   uvw, time_step, prev_vel, dist);
		prev_vel[0] = value[0]; prev_vel[1]=value[1]; prev_vel[2]=value[2];
		
		/* if time step is too small increase it */
		if (dist < 0.25 * min_extent)
			time_step *= 2.0 ;
		
		init_point[0] = out[0];
		init_point[1] = out[1];
		init_point[2] = out[2];

		/* some scattered points on line, not all end points,
		   some out-lying points */

	} /* end of 100 loop */

        /* nothing useful here */

	return(1);
}


/*-----------------------------------------------------*
 *                                                     *
 *           **** add_stream  ****                     *
 *  add the next stream position onto the running list *
 *                                                     *
 *-----------------------------------------------------*/

static add_stream(input, node_data, count, streak, colors, radius, angle, time,
		  colormap, max_vect_mag,
		  ribbon, cell, point, value, uvw, step, prev_val, dist)
    UCD_structure *input;
    float         *node_data;
    AVScolormap *colormap;
    int  cell, *count, ribbon;
    float *streak, *colors, *radius, *angle, *time, max_vect_mag;
    float *point, *value, *uvw, step, *prev_val, dist;
{
	float vx, vy, vz, mag, r, g, b, deriv[3][3], div, curl[3], v[3];
	int k, i;
	float fast_fsqrt();

	mat_build_sqrt_table();
	streak[(*count)*3] = point[0];
	streak[(*count)*3+1] = point[1];
	streak[(*count)*3+2] = point[2];
	if (colormap)  {
		vx = value[0], vy = value[1], vz = value[2];
		mag = /*fast_fsqrt */ sqrt(vx * vx + vy * vy + vz * vz);
		if (mag > 0.0)
			k = (colormap->size - 1)*(mag / max_vect_mag);
		else 
			k =  0;
		FILTERhsv_to_rgb (&r, &g, &b, colormap->hue[k], colormap->saturation[k], 
				  colormap->value[k]);
		
		colors[(*count)*3] = r;
		colors[(*count)*3 + 1] = g;
		colors[(*count)*3 + 2] = b;
	}
	if (ribbon) {
		k = (*count);
		time[k]=step;
		ucd_deriv(input, node_data, 3, cell, uvw, deriv);

		/** Calculate function for radius of the ribbon **/
		div = deriv[0][0]+deriv[1][1]+deriv[2][2];
		vx = value[0], vy = value[1], vz = value[2];
		r = /* fast_fsqrt */ sqrt(vx * vx + vy * vy + vz * vz);
		vx = prev_val[0], vy = prev_val[1], vz = prev_val[2];
		g = /* fast_fsqrt */ sqrt (vx * vx + vy * vy + vz * vz);
		mag = r-g;
		radius[k] = div-mag/dist;
/****
		fprintf(stderr, "cell=%d  pt(%f %f %f)  uvw(%f %f %f)\n",
			point[0], point[1],point[2],cell,uvw[0],uvw[1],uvw[2]);
		fprintf(stderr, "     vel=%f    prev_vel=%f  step=%f time=%f\n",
			r, g, step, time[k]);
		fprintf(stderr, "     diag(%f %f %f) div=%f dv=%f,dd=%f  rad=%f\n",
			deriv[0][0],deriv[1][1],deriv[2][2],div,mag,dist, radius[k]);
****/

		/** Calculate function for angle of the ribbon  **/
		curl[0] = deriv[1][2]-deriv[2][1];
		curl[1] = deriv[2][0]-deriv[0][2];
		curl[2] = deriv[0][1]-deriv[1][0];
		v[0] = value[0]; v[1] = value[1]; v[2] = value[2];
		AVS_UNITIZE(v, EPS1);
		angle[k] = 0.5*AVS_DOT(curl,v);
	}
	(*count) ++;
}

static calc_ribbon_ang(order, count, time, ang0, ang)
    int count, order;
    float *time, *ang, ang0;
{
	float val, val1;
	int i;

	/*** integrate angle function ***/
	val1 = ang0;
	for (i=1; i< count; i++) {
		val = val1+0.5*(ang[i-1]+ang[i])*time[i];
		ang[i-1] = val1;
		val1 = val;
	}
	ang[count-1] = val;
}

static calc_ribbon_rad(order, count, time, rad0, rad)
    int count, order;
    float *time, *rad, rad0;
{
	float val, val1;
	int i;

	/*** integrate radius function ***/
	val1 = rad0;
	for (i=1; i< count; i++) {
		val = val1*exp(0.25*(rad[i-1]+rad[i])*time[i]);
		rad[i-1] = val1;
		val1 = val;
	}
	rad[count-1] = val;
}

static create_marker(obj, style, min_extent, max_extent, pts, res)
    GEOMobj *obj;
    char *style;
    float pts[][3], min_extent[3], max_extent[3];
    int res;
{
	int i, j, n;
	float verts[65][3], vcolor[65][3], ext[6], dist;
	
	if (Colors)
		for(i=0; i<65; i++)
			vcolor[i][0] = vcolor[i][1] = vcolor[i][2] = 1.0;
	if (!strcmp(style, "point")) {
		n = 6;
		dist = 0.1 * (max_extent[0] - min_extent[0] +
			max_extent[1] - min_extent[1] +
			max_extent[2] - min_extent[2])/3;
		for(i=0; i<3; i++) {
#if _CRAY
#pragma _CRI ivdep
#endif
			for(j=0; j<3; j++) { 
				if (j == i) {
					verts[2*i][j] = pts[0][j] - dist;
					verts[2*i+1][j] = pts[0][j] + dist;
				} else {
					verts[2*i][j] = pts[0][j];
					verts[2*i+1][j] = pts[0][j];
				}
			}
		}
		if (Colors)
			GEOMadd_disjoint_line(obj, verts, vcolor, n, GEOM_COPY_DATA);
		else 
			GEOMadd_disjoint_line(obj, verts, NULL, n, GEOM_COPY_DATA);
	} else if (!strcmp(style, "line")) {
		n = res;
		for (i=0; i<res; i++)
#if _CRAY
#pragma _CRI ivdep
#endif
			for (j=0; j<3; j++)
				verts[i][j] = pts[i][j];
		if (Colors)
			GEOMadd_polyline(obj, verts, vcolor, n, GEOM_COPY_DATA);
		else 
			GEOMadd_polyline(obj, verts, NULL, n, GEOM_COPY_DATA);
	} else if (!strcmp(style, "circle")) {
		n = res;

		/* Why is this "$dir scalar" directive here? */
		/* verts is a local array so there can't be a recurrence. */
		/* Maybe compiler thinks that verts can be aliased because */
		/* its address was passed to GEOMadd_polyline. */
		
		/*$dir scalar */
		for (i=0; i<res; i++)
#if _CRAY
#pragma _CRI ivdep
#endif
			for (j=0; j<3; j++)
				verts[i][j] = pts[i][j];
		/*$dir scalar */
/*#if _CRAY*/
/*#pragma _CRI ivdep*/
/*#endif*/
/*
		for (j=0; j<3; j++)
			verts[i][j] = pts[0][j];
*/
		if (Colors)
			GEOMadd_polyline(obj, verts, vcolor, n, GEOM_COPY_DATA);
		else 
			GEOMadd_polyline(obj, verts, NULL, n, GEOM_COPY_DATA);
	} else if (!strcmp(style, "plane")) {
		n = 5;
#if _CRAY
#pragma _CRI ivdep
#endif
		for(i=0; i<3; i++){
			verts[0][i] = pts[0][i];
			verts[1][i] = pts[res-1][i];
			verts[2][i] = pts[res*res - 1][i];
			verts[3][i] = pts[res*res - res][i];
			verts[4][i] = pts[0][i];
		}
		if (Colors)
			GEOMadd_polyline(obj, verts, vcolor, n, GEOM_COPY_DATA);
		else 
			GEOMadd_polyline(obj, verts, NULL, n, GEOM_COPY_DATA);
	} else if (!strcmp(style, "space")) {
		n = 24;
#if _CRAY
#pragma _CRI ivdep
#endif
		for (j=0; j<3; j++) {
			verts[0][j] = pts[0][j];
			verts[1][j] = pts[res-1][j];
			
			verts[2][j] = pts[res-1][j];
			verts[3][j] = pts[res*res-1][j];
			
			verts[4][j] = pts[res*res-1][j];
			verts[5][j] = pts[res*res-res][j];
			
			verts[6][j] = pts[res*res-res][j];
			verts[7][j] = pts[0][j];
			
			verts[8][j] = pts[0][j];
			verts[9][j] = pts[res*res*res - res*res][j];
			
			verts[10][j] = pts[res-1][j];
			verts[11][j] = pts[res*res*res - res*res + res - 1][j];
			
			verts[12][j] = pts[res*res-1][j];
			verts[13][j] = pts[res*res*res-1][j];
			
			verts[14][j] = pts[res*res-res][j];
			verts[15][j] = pts[res*res*res - res][j];
			
			verts[16][j] = pts[res*res*res - res*res][j];
			verts[17][j] = pts[res*res*res - res*res + res -1][j];
			
			verts[18][j] = pts[res*res*res - res*res + res -1][j];
			verts[19][j] = pts[res*res*res-1][j];
			verts[20][j] = pts[res*res*res-1][j];
			verts[21][j] = pts[res*res*res-res][j];
			
			verts[22][j] = pts[res*res*res-res][j];
			verts[23][j] = pts[res*res*res - res*res][j];
		}
		if (Colors)
			GEOMadd_disjoint_line(obj, verts, vcolor, n, GEOM_COPY_DATA);
		else 
			GEOMadd_disjoint_line(obj, verts, NULL, n, GEOM_COPY_DATA);
	} 
}

/******************************************************************************/
#define SET_BOX(x,y,z) verts[ind][0] = x; \
  verts[ind][1] = y; \
  verts[ind][2] = z; \
  ++ind;

/******************************************************************************/

static make_box(obj, ext)
GEOMobj *obj;
float ext[6];
{
	int ind = 0, i;
	float verts[24][3], colors[24][3];

	SET_BOX(ext[0], ext[2], ext[4]);    /* origin */
	SET_BOX(ext[1], ext[2], ext[4]);    /* set the x axis */
	SET_BOX(ext[1], ext[2], ext[4]);    
	SET_BOX(ext[1], ext[2], ext[5]);
	SET_BOX(ext[1], ext[2], ext[5]);    
	SET_BOX(ext[0], ext[2], ext[5]);
	SET_BOX(ext[0], ext[2], ext[5]);    /* set the z axis */
	SET_BOX(ext[0], ext[2], ext[4]);    /* origin */
	SET_BOX(ext[0], ext[3], ext[4]);    
	SET_BOX(ext[1], ext[3], ext[4]);
	SET_BOX(ext[1], ext[3], ext[4]);    
	SET_BOX(ext[1], ext[3], ext[5]);
	SET_BOX(ext[1], ext[3], ext[5]);    
	SET_BOX(ext[0], ext[3], ext[5]);
	SET_BOX(ext[0], ext[3], ext[5]);    
	SET_BOX(ext[0], ext[3], ext[4]);
	SET_BOX(ext[0], ext[2], ext[4]);    /* origin */
	SET_BOX(ext[0], ext[3], ext[4]);    /* set the y axis */
	SET_BOX(ext[1], ext[2], ext[4]);    
	SET_BOX(ext[1], ext[3], ext[4]);
	SET_BOX(ext[1], ext[2], ext[5]);   
	SET_BOX(ext[1], ext[3], ext[5]);
	SET_BOX(ext[0], ext[2], ext[5]);    
	SET_BOX(ext[0], ext[3], ext[5]);
	
	GEOMadd_disjoint_line(obj, verts, NULL, 24, GEOM_COPY_DATA);
}

/*-----------------------------------------------------*/
/*  find_boundary                                      */
/*-----------------------------------------------------*/
/*
 * find the intersection point of exiting vector from cell
 * and cell wall surface.
 * This will be the exit point, where we can cut the vector into
 * two pieces, and project the outside part onto the
 * wall.
 * returns success at finding intersections.
 */
int
find_boundary( ucd_input, obj,
               xc, yc, zc, init_pt, end_pt,
               proj_pt, intersect,
               cell, wall_offset, show_markers, face_eqn )

    UCD_structure *ucd_input; /* ucd input structure pointer */
    GEOMobj *obj;               /* output geom shape for steak line */
    float *xc, *yc, *zc;      /* pointers to selected node coordinates */
    float *init_pt;           /* starting point for vector segment */
    float *end_pt;            /* ending point for vector segment */
    float *proj_pt;           /* new ending projected point, RETURNED */
    float *intersect;         /* where the vector hit the wall RETURNED */
    int   cell;               /* what cell we are in and have just departed */
    float wall_offset;        /* distance to lift line off wall */
    int   show_markers;       /* show diagnostic cell traversal markers */
    float face_eqn[4];        /* RETURNED face equation of intersection face */
{
        char ctype[40];
        float verts[8][3], cx, cy, cz, x, y, z;

        int cell_id, mat_id, cell_type, me_flags, *node_list,
          count, num_faces, *topo, node, face, v, numv, num_fv,
          num_nodes, i, k, j, found;

        float vector[3];
        float planeq[4];
        float colors[3];
        float face_normal[4];
        float value, t, length;
        float edge[2][3];
        float vtemp[3];
        float new_point[3];
        float marker_temp[3];


        /****************
         ***   body   ***
         ****************/

        found = 0;

        /* copy end points to edge array */
        for (i=0; i<3; i++ )
        {
            edge[0][i] = init_pt[i];
            edge[1][i] = end_pt[i];
        }

        /* query cell */
        UCDcell_get_information (ucd_input,
                                 cell,
                                 &cell_id,
                                 ctype, &mat_id,
                                 &cell_type,
                                 &me_flags,
                                 &node_list);

        /* identify cell topology */
        num_nodes = UCD_num_nodes[cell_type];
        num_faces = UCD_num_faces[cell_type];
        topo      = cell_topos[cell_type];

        /* test each face */
        for (face = 0, count = 0; face < num_faces; face++ )
        {
            numv = topo [ count++ ];  /* number of vertices for this face */

            /* vertex loop */
            for (j = 0; j < numv; j++)
            {
                v = node_list[topo[count++]];  /* get relative offset into vertex list */
                verts[j][0] = xc[v];           /* copy vertex list */
                verts[j][1] = yc[v];
                verts[j][2] = zc[v];
            }  /* end of vertex loop */
            verts[numv][0] = verts[0][0];      /* close loop with extra vertex */
            verts[numv][1] = verts[0][1];
            verts[numv][2] = verts[0][2];

            /* find face normal vector */
            get_planeq ( verts, face_normal );


            /* check if we have a face and edge intersect point */
            if ( check_overlap( edge, face_normal, vtemp ) )
            {

                /* check if the intersect point is contained in the face */
                if ( check_contained ( verts, numv, vtemp ) )
                {

                    /* some are missing, check_contained doesn't pass good ones */
                    if ( show_markers )
                      for (j = 0; j < numv; j++)
                      {
                        marker_temp[0] = verts[j][0]+wall_offset;
                        marker_temp[1] = verts[j][1];
                        marker_temp[2] = verts[j][2];
                        mark_pt ( obj, &(verts[j][0]), marker_temp,  1, NULL);
                      }

                    project_pt( face_normal, end_pt, new_point, wall_offset );

		    for (i=0; i<4; i++ )
                        face_eqn[i]=face_normal[i];

                    /*
                     * Modify the previous trajectory to make a face path
                     */
		    for (i=0; i<3; i++ )
                    {
                        proj_pt [i] = new_point[i];
                        intersect[i] = vtemp[i];
                    }
                    found = 1;

                }

            } 

         } /* end of face loop */



     return( found );

} /* end of function */


/*-----------------------------------------------------*/
/* get plane equation                                  */
/*-----------------------------------------------------*/

/* get plane equation from two edges */
get_planeq ( v, eq )
    float v[5][3], eq[4];
{

/* page 114 in Bowyer and Woodwark */

    float xkj, ykj, zkj, xlj, ylj, zlj;

    /* get difference vectors */
    xkj = v[1][0] - v[0][0];
    ykj = v[1][1] - v[0][1];
    zkj = v[1][2] - v[0][2];

    xlj = v[2][0] - v[0][0];
    ylj = v[2][1] - v[0][1];
    zlj = v[2][2] - v[0][2];

    /* cross product for plane normal */
    eq[0] = ykj * zlj - zkj * ylj;
    eq[1] = zkj * xlj - xkj * zlj;
    eq[2] = xkj * ylj - ykj * xlj;

    /* normalize vector */
    if ( vnorm( eq ) == 0 )
    {
        eq[0] = eq[1] = 0.0;
        eq[2] = 1.0;
    }

    /* use plane equation for distance offset */
    eq[3] = -1.0 * (v[1][0] * eq[0] +
                    v[1][1] * eq[1] +
                    v[1][2] * eq[2] );

}


/*--------------------------------------------------------*/
/*   ---- Check Overlap ---                               */
/* check if any overlap of edge with plane equation.      */
/* verts is line seqment, with two ends, eq is normalized */
/* plane equation. This will return 1 if overlap exists,  */
/* otherwise zero. The edge intersection position is      */
/* returned in new_v.                                     */
/*--------------------------------------------------------*/

#define SSGN(a) (a >= 0.0 ? 1 : -1)

int
check_overlap( v, eq, new_v )
    float v[2][3];     /* input vertex list of 3D line seqment */
    float eq[4];       /* normalized plane equation to check with */
    float new_v[3];    /* return new vertex at intersection */
{
    float sr[5];  /* actual distances */
    int   sn[5];  /* sign of dist */
    int   n, i;
    float denom, t;

    n = 2;  /* only do line segments */

    /* compute signed distance from plane to each vertex */
    for (i=0; i < n; i++ )
    {
        sr[i] = eq[0]*v[i][0] +           /* actual */
                eq[1]*v[i][1] +
                eq[2]*v[i][2] + eq[3];
        sn[i] = SSGN( sr[i] );            /* sign only */
    }

    /* check sign of each dist, check for a cross */
    /* early get out if no overlap found */
    if ( sn[0] == sn[1] ) 
        return(0);

    /* compute the explicit intersection of the edge and plane */
    denom = eq[0]*(v[1][0]-v[0][0]) +
            eq[1]*(v[1][1]-v[0][1]) +
            eq[2]*(v[1][2]-v[0][2]);
    if ( denom == 0.0 ) denom = 0.0001;

    /* t is the parametric intersection parm for the edge-plane */
    t = -1.0 *
              ( eq[0]*v[0][0] +
                eq[1]*v[0][1] +
                eq[2]*v[0][2] +
                eq[3] ) / denom;

    /* load outgoing array with the two intersection points */
    new_v[0] = v[0][0] +
                  (v[1][0]-v[0][0]) * t;
    new_v[1] = v[0][1] +
                  (v[1][1]-v[0][1]) * t;
    new_v[2] = v[0][2] +
                  (v[1][2]-v[0][2]) * t;

    return(1);
}

/*--------------------------------------------------------*/
/*   ---- Check  Contained ---                            */
/* check if the sample 3D point is inside or outside      */
/* of the 3D polygon. We already can assume that the point*/
/* is in the plane of the polygon.                        */
/*--------------------------------------------------------*/

int
check_contained( v, n, point )
    float v[5][3];     /* input vertex list of 3D face poly */
    int n;             /* number of vertex's in poly */
    float point[3];    /* vertex point to check */
{
    float sr[5];  /* actual distances */
    int   sn[5];  /* sign of dist */
    int   i;
    int   num_crosses;

    /* compute cosine of angle from point to each edge */
    /* dot the edge and the vert to point line, save sign */
    for (i=0; i < n; i++ )
    {
        sr[i] = (point[0]-v[i][0])*(v[i+1][0]-v[i][0]) +
                (point[1]-v[i][1])*(v[i+1][1]-v[i][1]) +
                (point[2]-v[i][2])*(v[i+1][2]-v[i][2]);
        sn[i] = SSGN( sr[i] );         /* sign only */
    }
    sn[n] = sn[0];   /* close loop */

    /* check sign of each dist, check for a cross */
    /* early get out if no overlap found */
    num_crosses = 0;
    for (i=0; i < n; i++ )
    {
       if ( sn[i] != sn[i+1] )
           num_crosses++;
    }
    /*
     * if no crosses, then the point stayed inside all the way
     * arround, if not, then it was outside of some edge.
     * checking inequality makes it clockwise-counterclockwise
     * independent.
     */
    if ( num_crosses == 0 )
       return(1);
    else
       return(0);
}

/*-----------------------------------------------------*/
/* normalize the length of a 3-vector                  */
/*-----------------------------------------------------*/
int
vnorm (v)
        float v[];
{
  double mag;
 /*  double sqrt(); */

  mag = sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);

  if (mag == 0.0) {
    v[0] = 0.0;
    v[1] = 0.0;
    v[2] = 0.0;
    return (0);
    }
  else {
    v[0] = v[0] / mag;
    v[1] = v[1] / mag;
    v[2] = v[2] / mag;
    }
    return (1);
}

/*-----------------------------------------------------*/
/* project_pt  Project a point onto a plane            */
/*-----------------------------------------------------*/

/*
 * takes the equation of the wall surface,
 * a point on the wrong side, as the result of
 * an integration step that has crossed the wall,
 * projects that point back onto the wall,
 * and optionally puts it the same distance
 * OVER the wall, like a mirror projection distance.
 * or a fixed distance over the wall, from input parm.
 */
project_pt( eq, point, new_point, wall_offset )

    float eq[4];        /* equation of plane, normalized */
    float point[3];     /* position in space to project */
    float new_point[3]; /* new projected point */
    float wall_offset;  /* distance away from wall to leave point */
{
    float sr;
    int   i;

#define PROJ_ON_WALL        -1.0
#define PROJ_AWAY_FROM_WALL -2.0

    /*
     * get distance of perpendicular projection of
     * point onto plane, make allowance for distance
     * away from wall.
     */
    sr = (eq[0] * point[0] +
          eq[1] * point[1] +
          eq[2] * point[2] +
          eq[3] ) * PROJ_ON_WALL -
          wall_offset ;

    /*
     * scale the normal vector up to be this length,
     *  then subtract it off the point to get the
     *  plane position
     */

    for ( i=0; i<3; i++ )
        new_point[i] = point[i] + sr * eq[i];


    return;
}


/**********************************************************
 *   boundary                                             *
 * ---   boundary condition  ---                          *
 * do something special here                              *
 * find intersect of vector and cell face                 *
 * make adjustment of next point to keep inside model     *
 **********************************************************/

boundary( ucd_input,
          node_data,
          obj,
          uvw,
          cell, next_cell,
          xc, yc, zc,
          init_pt, end_pt,
          interp_val,
          boundary_flag,
          wall_offset,
          show_markers  )

    UCD_structure *ucd_input;   /* ucd input structure pointer */
    GEOMobj *obj;               /* output geom shape for steak line */

    float *xc, *yc, *zc,        /* pointers to selected node coordinates */
          *node_data;           /* pointer to selected nodal data array  */

    float uvw[3];		/* interp position in cell */
    int *boundary_flag;          /* boundary result code */
    float interp_val[3],
             init_pt[6],
              end_pt[6];

    int cell, *next_cell;	/* input and output cells */

    float  wall_offset;		/* dist. to lift streak off wall */
    int show_markers;		/* show diagnostic markers for integration positions */
{

    float intersect[3];
    float proj_pt[3];
    float new_init[3];
    float face_eqn[4];
    int i;
    int second_cell;    /* second try at cell search */


    /* take a first look at computing the boundary constrained next point */
    if ( find_boundary( ucd_input, obj,
             xc, yc, zc,
             init_pt, end_pt,
             proj_pt, intersect,
             cell, wall_offset,
             show_markers, face_eqn ) )
    {
            if ( show_markers )
            {
                mark_pt ( obj, init_pt, intersect, 1, NULL);
                mark_pt ( obj, intersect, end_pt,  2, NULL);
                mark_pt ( obj, intersect, proj_pt, 3, NULL);
            }

            /*
             * convert to local cell coordinates,
             *  find cell for starting sample
             */
            *next_cell = UTILucd_interp_cell(ucd_input,
                   3, node_data, proj_pt, interp_val, uvw);


            if (*next_cell >= 0)
            {
                  end_pt[0] = proj_pt[0];  /* move along boundary */
                  end_pt[1] = proj_pt[1];
                  end_pt[2] = proj_pt[2];
                  *boundary_flag = 1;
            }
            else
            {     /*
                   * trouble finding next valid point, try again
                   * try projecting init point accross wall,
                   * test is it is inside a valid cell, if so move
                   * context to that cell and try again.
                   */
                  project_pt( face_eqn, init_pt, new_init, -0.01 * wall_offset );

                  if ( show_markers )
                      mark_pt ( obj, init_pt, new_init, 4, NULL);

                  second_cell = UTILucd_interp_cell(ucd_input,
                         3, node_data, new_init, interp_val, uvw);

                  /* try again from new cell context */
                  if ( second_cell >= 0 &&
                       find_boundary( ucd_input, obj,
                           xc, yc, zc,
                           new_init, end_pt,
                           proj_pt, intersect,
                           second_cell, wall_offset,
                           show_markers, face_eqn ) )
                  {

                      if ( show_markers )
                      {
                          mark_pt ( obj, init_pt, intersect, 1, NULL);
                          mark_pt ( obj, intersect, end_pt,  2, NULL);
                          mark_pt ( obj, intersect, proj_pt, 3, NULL);
                      }
          
                      /*
                       * convert to local cell coordinates,
                       *  find cell for starting sample
                       */
                      *next_cell = UTILucd_interp_cell(ucd_input,
                             3, node_data, proj_pt, interp_val, uvw);


                      if (*next_cell >= 0)
                      {
                            end_pt[0] = proj_pt[0];  /* move along boundary */
                            end_pt[1] = proj_pt[1];
                            end_pt[2] = proj_pt[2];
                            *boundary_flag = 1;
                      }
                  } /* end of second boundary check */

            }

    } /* end of if */

}  /* end of boundary routine */

/*-----------------------------------------------------*/
/* mark_pt  Draw a line to mark the new line           */
/*-----------------------------------------------------*/

mark_pt ( obj, init_pt, end_pt, tag, colour )
    GEOMobj *obj;		/* output geom shape for steak line */
    float *init_pt, *end_pt;    /* line seg end points */
    int tag;                    /* color tag */
    float colour[3];            /* data dependent colour */

{
        static float mark_c1[2][3] = {{ .9, .9, .1},{ .9, .9, .1}}; /* yellow? */
        static float mark_c2[2][3] = {{ .9, .3, .6},{ .9, .3, .6}}; /* violet? */
        static float mark_c3[2][3] = {{ .2, .9, .6},{ .2, .9, .6}}; /* aqua marine? */
        static float mark_c4[2][3] = {{ .95, .0, .0},{ .95, .0, .0}}; /* red */
        float  data_cols[2][3];
        float mark_v[2][3];
        int i;

        for ( i=0; i<3; i++ )
        {
            mark_v[0][i] = init_pt[i];
            mark_v[1][i] = end_pt[i];
        }

        if ( colour )
        {
            for ( i=0; i<3; i++ )
                data_cols[0][i] = data_cols[1][i] = colour[i];

	    GEOMadd_disjoint_line(obj, mark_v, data_cols, 2, GEOM_COPY_DATA);
            return;
        }

	/* pre-defined marker colours */
        else if ( tag == 0 )  /* none */
	GEOMadd_disjoint_line(obj, mark_v, NULL, 2, GEOM_COPY_DATA);
        else if ( tag == 1 )
	GEOMadd_disjoint_line(obj, mark_v, mark_c1, 2, GEOM_COPY_DATA);
        else if ( tag == 2 )
	GEOMadd_disjoint_line(obj, mark_v, mark_c2, 2, GEOM_COPY_DATA);
        else if ( tag == 3 )
	GEOMadd_disjoint_line(obj, mark_v, mark_c3, 2, GEOM_COPY_DATA);
        else if ( tag == 4 )
	GEOMadd_disjoint_line(obj, mark_v, mark_c4, 2, GEOM_COPY_DATA);

}


