/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "ucdtoprim" (Mapper) (Subroutine)                       */
/* Author:  << Penny Rheingans , US EPA Viz Center >>                    */
/* Date Created: Mon Apr 20 15:19:10 1992                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* input 0 "Data" ucd REQUIRED                                           */
/* input 1 "Colors" colormap OPTIONAL                                    */
/* output 0 "output_geom" geom Spheres                                   */
/* End of Module Description Comments                                    */

#include <stdio.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/geom.h>
#include <avs/ucd_defs.h>
#include <avs/colormap.h>
 
/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/
#define MAX_NODES 32000
#define LOOKUP(data,n,nn,s) (data[s*nn + n])

/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Specification                   */
/* *****************************************/
int ucdtoprim_spec()
{

	int in_port, out_port, param;
	extern int ucdtoprim_compute();

	AVSset_module_name("ucd to prim", MODULE_MAPPER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("Data", "ucd", REQUIRED);
	in_port = AVScreate_input_port("Colors", "colormap", OPTIONAL);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("output_geom", "geom");

	/* Parameter Specifications                */
	param = AVSadd_float_parameter("Scale", 1.0, -100.0, 100.0);
	AVSconnect_widget(param, "dial");
	param = AVSadd_parameter("Primitive", "choice", "Prism", 
		"Sphere:Prism", ":");
	AVSconnect_widget(param, "radio_buttons");
	param = AVSadd_parameter("Species", "integer", 0, 0, 8);
	AVSconnect_widget(param, "idial");

	AVSset_compute_proc( ucdtoprim_compute);
/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int  ucdtoprim_compute( Data, Colors, output_geom, Scale, Primitive, Species)
	UCD_structure *Data;
	AVScolormap *Colors;
	GEOMedit_list *output_geom;
	float *Scale;
	char *Primitive;
	int Species;
{

/* ----> START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */
 	GEOMobj *obj0;                                                       
	char *name;
	int data_veclen, cell_veclen, node_veclen;
	int name_flag, util_flag;
	int ncells, nnodes;
	float *x, *y, *z;
	float *data;
	int i;
	float verts[MAX_NODES][3];
	float *radii;
	float colors[MAX_NODES][3];
	float *min;
	float *max;
	float range_scale;
	int color_index;

	nnodes = Data->nnodes;
	node_veclen = Data->node_veclen;
	if (Species >= node_veclen) {
	  printf ("ucdtoprim : invalid species %d\n", Species);
	  return (0);
	  }
	min = (float *)malloc(node_veclen*sizeof(float));
	max = (float *)malloc(node_veclen*sizeof(float));

	UCDstructure_get_node_positions(Data, &x, &y, &z);
	UCDstructure_get_node_data(Data, &data);
	UCDstructure_get_node_minmax(Data, min, max);
	range_scale = 1.0/(max[Species]-min[Species]);

	if (!strcmp(Primitive, "Sphere")) {
	  /* make spheres from nodes */
	  radii = (float *)malloc(nnodes*sizeof(float));
	  for (i = 0; i < nnodes; i++) {
	    verts[i][0] = (x[i]);
	    verts[i][1] = (y[i]);
	    verts[i][2] = (z[i]);
	    radii[i] = *Scale;

	    /* if colormap, look up node color */
	    if (Colors) {
	      color_index = AVScmap_index(Colors,LOOKUP(data,i,nnodes,Species));
	      hsv_to_rgb(Colors->hue[color_index],
			Colors->saturation[color_index],
			Colors->value[color_index], &(colors[i][0]),
			&(colors[i][1]), &(colors[i][2]));
	      }
	    else { /* map to grey scale */
	      colors[i][0] = 
		  (LOOKUP(data,i,nnodes,Species)-min[Species])*range_scale;
	      colors[i][1] = 
		  (LOOKUP(data,i,nnodes,Species)-min[Species])*range_scale;
	      colors[i][2] = 
		  (LOOKUP(data,i,nnodes,Species)-min[Species])*range_scale;
	      }
	    }

	  obj0 = GEOMcreate_sphere(GEOM_NULL, verts, radii, 
			      GEOM_NULL, GEOM_NULL, nnodes, GEOM_COPY_DATA);
	  GEOMadd_float_colors(obj0, colors, nnodes, GEOM_COPY_DATA);
	  }
	else if (!strcmp(Primitive, "Prism")) {
	  /* make vectors from nodes */
	  for (i = 0; i < nnodes; i++) {
	    verts[2*i][0] =  verts[2*i+1][0] = (x[i]);
	    verts[2*i][1] = verts[2*i+1][1] = (y[i]);
	    verts[2*i][2] = (z[i]);
	    verts[2*i+1][2] = z[i] +
		*Scale*LOOKUP(data,i,nnodes,Species);

	    /* if colormap, look up node color */
	    if (Colors) {
	      color_index = AVScmap_index(Colors,LOOKUP(data,i,nnodes,Species));
	      hsv_to_rgb(Colors->hue[color_index],
			Colors->saturation[color_index],
			Colors->value[color_index], &(colors[2*i][0]),
			&(colors[2*i][1]), &(colors[2*i][2]));
	      }
	    else { /* map to grey scale */
	      colors[2*i][0] = 
		  (LOOKUP(data,i,nnodes,Species)-min[Species])*range_scale;
	      colors[2*i][1] = 
		  (LOOKUP(data,i,nnodes,Species)-min[Species])*range_scale;
	      colors[2*i][2] = 
		  (LOOKUP(data,i,nnodes,Species)-min[Species])*range_scale;
	      }
	    colors[2*i+1][0] = colors[2*i][0];
	    colors[2*i+1][1] = colors[2*i][1];
	    colors[2*i+1][2] = colors[2*i][2];
	    }

	  obj0 = GEOMcreate_obj(GEOM_POLYTRI, GEOM_NULL);
	  GEOMadd_disjoint_line(obj0, verts, colors, 2*nnodes, GEOM_COPY_DATA);
	  }

	/* Create the GEOM Edit List for output_geom            */
 	*output_geom = GEOMinit_edit_list(*output_geom);                     
 	GEOMedit_geometry(*output_geom, "output_geom", obj0);                
 	GEOMdestroy_obj(obj0);                                               
/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*filter_mod_list[])()) = {
	 ucdtoprim_spec,
};
#define NMODS (sizeof(filter_mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(filter_mod_list, NMODS);
}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/
hsv_to_rgb(hue, saturation, value, red, green, blue)
float hue, saturation, value;
float *red, *green, *blue;
  {
  float	h;
  int	i;
  float	f;
  float	p;
  float	q;
  float	t;

	if (saturation == 0.0)
	{
		*red   = value;
		*green = value;
		*blue  = value;

		return;
	}

	if (hue == 1.0) hue = 0.0;
	h = hue * 6.0;
	i = floor (h);
	f = h - i;

	p = value * (1.0 -  saturation);
	q = value * (1.0 - (saturation * f));
	t = value * (1.0 - (saturation * (1.0 - f)));

	switch (i)
	{
	case 0: *red = value; *green = t;     *blue  = p;     break;
	case 1: *red = q;     *green = value; *blue  = p;     break;
	case 2: *red = p;     *green = value; *blue  = t;     break;
	case 3: *red = p;     *green = q;     *blue  = value; break;
	case 4: *red = t;     *green = p;     *blue  = value; break;
	case 5: *red = value; *green = p;     *blue  = q;     break;
	}

	return;
}
/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */
