/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/********************************************************************** 
 *
 *	file name: 	v_bounds_2d.c
 *
 *	description:	create volume bounds of 2 dimentional field 
 *			data.
 *
 *     			Copyright (c) 1991 by 
 *			KUBOTA COMPUTER INC.
 *			All Rights Reserved
 *
 **********************************************************************/

#include <stdio.h>
#include <avs/flow.h>
#include <avs/avs_data.h>
#include <avs/field.h>
#include <avs/geom.h>

#define COORD_X_2D(field, i, j) \
       (( (field)->points )[ ( (field)->dimensions[0] ) * (j) + (i)] )

#define COORD_Y_2D(field, i, j) \
       (( (field)->points )[  (field)->dimensions[0] * \
                         ( (field)->dimensions[1] + (j) ) + (i)])

#define COORD_Z_2D(field, i, j) \
         (( (field)->points)[ (field)->dimensions[0] * \
                         ( 2*((field)->dimensions[1]) + (j) ) + (i)])


/**********************************************************************
 *
 *	function name: 	AVSinit_modules
 *
 *	description:	initilize
 *
 **********************************************************************/

AVSinit_modules()
{
    int             volume();

    AVSmodule_from_desc(volume);
}



/**********************************************************************
 *
 *	function name: 	volume
 *
 *	description:	description function
 *
 **********************************************************************/

volume()
{
    int             volume_compute();	/* declare the compute function
					 * (below) */


    /* Set the module name and type */
    AVSset_module_name("volume bounds 2D", MODULE_MAPPER);

    /* Create an input port for the required field input */
    AVScreate_input_port("Input Field", "field 2D ", REQUIRED);

    /* Create an output port for the result */
    AVScreate_output_port("Geometry", "geom");


    AVSadd_parameter("display", "choice", "outline", "outline@mesh", "@");

    /* Tell avs what subroutine to call to do the compute */
    AVSset_compute_proc(volume_compute);
}



/**********************************************************************
 *
 *	function name: 	volume_compute
 *
 *	description:	computation function
 *
 *	input:	input	field structure
 *		disp	on/off flag of volume bounds
 *
 *	output:	output	geometry of volume bounds	
 *
 *	return:	0/1
 *
 **********************************************************************/

volume_compute(input, output, disp)
    AVSfield       *input;
    GEOMedit_list  *output;
    char           *disp;
{
    float          *verts;
    int             line_num, di, dj;
    GEOMobj        *obj;


    if (!strcmp(disp, "outline")) {
	di = MAXX(input) - 1;
	dj = MAXY(input) - 1;
	if (input->uniform == IRREGULAR) {
	    line_num = 2 * (MAXX(input) + MAXY(input) - 2);
	} else {
	    line_num = 4;
	}
    } else {
	di = 1;
	dj = 1;
	if (input->uniform == IRREGULAR) {
	    line_num = MAXX(input) * (MAXY(input) - 1)
		+ MAXY(input) * (MAXX(input) - 1);
	} else {
	    line_num = MAXX(input) + MAXY(input);
	}
    }

    verts = (float *) malloc(sizeof(float) * 6 * line_num);

    if (input->uniform == IRREGULAR) {
	case_irregular(verts, input, di, dj);
    } else {
	case_nonirregular(verts, input, di, dj);
    }

    obj = GEOMcreate_obj(GEOM_POLYTRI, GEOM_NULL);
    GEOMadd_disjoint_line(obj, verts, NULL, 2 * line_num, GEOM_COPY_DATA);
    *output = GEOMinit_edit_list(*output);
    GEOMedit_geometry(*output, "mesh2d", obj);

    GEOMdestroy_obj(obj);
    free(verts);
    return (1);
}



/**********************************************************************
 *
 *	function name: 	case_nonrirregular
 *
 *	description:	get vertices of volume bounds from uniform or 
 *			rectilinear field data.
 *
 *	input:	input	field structure
 *		di, dj	number of grid points between lines which will 
 *			be generated.
 *
 *	output:	verts	vertices of lines
 *
 *	return:	0/1
 *
 **********************************************************************/

case_nonirregular(verts, input, di, dj)

    float          *verts;
    AVSfield       *input;
    int             di, dj;
{
    int             i, j, icnt;


    for (icnt = 0, i = 0; i < MAXX(input); i += di) {
	verts[icnt] = COORD_X_3D(input, i, 0, 0);
	verts[icnt + 1] = COORD_Y_3D(input, i, 0, 0);
	verts[icnt + 2] = 0.;
	icnt += 3;
	verts[icnt] = COORD_X_3D(input, i, MAXY(input) - 1, 0);
	verts[icnt + 1] = COORD_Y_3D(input, i, MAXY(input) - 1, 0);
	verts[icnt + 2] = 0.;
	icnt += 3;
    }
    for (j = 0; j < MAXY(input); j += dj) {
	verts[icnt] = COORD_X_3D(input, 0, j, 0);
	verts[icnt + 1] = COORD_Y_3D(input, 0, j, 0);
	verts[icnt + 2] = 0.;
	icnt += 3;
	verts[icnt] = COORD_X_3D(input, MAXX(input) - 1, j, 0);
	verts[icnt + 1] = COORD_Y_3D(input, MAXX(input) - 1, j, 0);
	verts[icnt + 2] = 0.;
	icnt += 3;
    }
    return (1);
}



/**********************************************************************
 *
 *	function name: 	case_irregular
 *
 *	description:	get vertices of volume bounds from irregular
 *			field data.
 *
 *	input:	input	field structure
 *		di, dj	number of grid points between lines which will 
 *			be generated.
 *
 *	output:	verts	vertices of lines
 *
 *	return:	0/1
 *
 **********************************************************************/

case_irregular(verts, input, di, dj)
    float          *verts;
    AVSfield       *input;
    int             di, dj;
{
    int             i, j, icnt;


    if (input->nspace == 2) {
	for (icnt = 0, i = 0; i < MAXX(input); i += di) {
	    for (j = 0; j < MAXY(input) - 1; j++) {
		verts[icnt] = COORD_X_2D(input, i, j);
		verts[icnt + 1] = COORD_Y_2D(input, i, j);
		verts[icnt + 2] = 0.;
		icnt += 3;
		verts[icnt] = COORD_X_2D(input, i, j + 1);
		verts[icnt + 1] = COORD_Y_2D(input, i, j + 1);
		verts[icnt + 2] = 0.;
		icnt += 3;
	    }
	}
	for (j = 0; j < MAXY(input); j += dj) {
	    for (i = 0; i < MAXX(input) - 1; i++) {
		verts[icnt] = COORD_X_2D(input, i + 1, j);
		verts[icnt + 1] = COORD_Y_2D(input, i + 1, j);
		verts[icnt + 2] = 0.;
		icnt += 3;
		verts[icnt] = COORD_X_2D(input, i + 1, j);
		verts[icnt + 1] = COORD_Y_2D(input, i + 1, j);
		verts[icnt + 2] = 0.;
		icnt += 3;
	    }
	}
    } else {
	for (icnt = 0, i = 0; i < MAXX(input); i += di) {
	    for (j = 0; j < MAXY(input) - 1; j++) {
		verts[icnt] = COORD_X_2D(input, i, j);
		verts[icnt + 1] = COORD_Y_2D(input, i, j);
		verts[icnt + 2] = COORD_Z_2D(input, i, j);
		icnt += 3;
		verts[icnt] = COORD_X_2D(input, i, j + 1);
		verts[icnt + 1] = COORD_Y_2D(input, i, j + 1);
		verts[icnt + 2] = COORD_Z_2D(input, i, j + 1);
		icnt += 3;
	    }
	}
	for (j = 0; j < MAXY(input); j += dj) {
	    for (i = 0; i < MAXX(input) - 1; i++) {
		verts[icnt] = COORD_X_2D(input, i, j);
		verts[icnt + 1] = COORD_Y_2D(input, i, j);
		verts[icnt + 2] = COORD_Z_2D(input, i, j);
		icnt += 3;
		verts[icnt] = COORD_X_2D(input, i + 1, j);
		verts[icnt + 1] = COORD_Y_2D(input, i + 1, j);
		verts[icnt + 2] = COORD_Z_2D(input, i + 1, j);
		icnt += 3;
	    }
	}
    }
}
