/*******************************************************************************
 *
 *  These are a set of utility FLOAT3 routines that can be used by 
 *  user-written AVS modules.
 *
 *	29 Mar 91  Phil McDonald, NOAA/ERL/FSL	Original version.
 *
 ******************************************************************************/



#include	"avs_utils.h"



/*******************************************************************************
 *
 *  Check two FLOAT3s to see if they are the same.
 *
 */

int	UTILS_float3_are_same (p1, p2)

FLOAT3		p1, p2;

{

    if ((p1 == NULL) || (p2 == NULL)) return (FALSE);
    if (p1[0] != p2[0]) return (FALSE);
    if (p1[1] != p2[1]) return (FALSE);
    if (p1[2] != p2[2]) return (FALSE);

    return (TRUE);

}



/*******************************************************************************
 *
 *  Copy one FLOAT3 to another.
 *
 */

void	UTILS_float3_copy (p1, p2)

FLOAT3		p1, p2;
{

    if ((p1 != NULL) && (p2 != NULL)) 
        p2[0] = p1[0], p2[1] = p1[1], p2[2] = p1[2];

    return;
}



/*******************************************************************************
 *
 *  Return the values of a FLOAT3.
 *
 */

void	UTILS_float3_get (p_f3, p_x, p_y, p_z)

FLOAT3		p_f3;
float		*p_x, *p_y, *p_z;
{

    if (p_f3 != NULL) *p_x = p_f3[0], *p_y = p_f3[1], *p_z = p_f3[2];

    return;
}



/*******************************************************************************
 *
 *  Set the values of a FLOAT3.
 *
 */

void	UTILS_float3_set (x, y, z, pf3)

float		x, y, z;
FLOAT3		pf3;
{

    if (pf3 != NULL) pf3[0] = x, pf3[1] = y, pf3[2] = z;

    return;
}
