c ------------------------------------------------------
        program fexample2    
c ------------------------------------------------------
c associate same 3D data with uniform, rectiliear and irregular grid
c displayed as isosurface

        integer dim1, dim2, dim3
        parameter (dim1=40,dim2=40,dim3=10)
        real s3(dim1, dim2, dim3), x(dim1), y(dim2), z(dim3),
     +  xi3(dim1, dim2, dim3), yi3(dim1, dim2, dim3),
     +  zi3(dim1, dim2, dim3)

c      call AVSI_initialize (netdir,localdir,DISPLAY,avsoptions)
       call AVSI_initialize ('./networks','.','*','*')

c remove files generated by AVSI_routines:
       call AVSI_remove_local('rm')

c >>>>>>>>>>> generate 3D data

        do 30 k=1, dim3
          do 20 j = 1, dim2
            do 10 i = 1, dim1
              s3(i, j, k) = k
10          continue
20        continue
30      continue
 
c display 3D data on uniform grid:

        print *
        print *,'>>> uniform grid <<<'

        call AVSI_3D_scalar_real_uniform('Isosurface','isou',
     +  dim1, dim2, dim3, s3)


c >>>>>>>> rectilinear grid

c generate row X ,Y and Z coodinates:
        do 40 i=1,dim1
           x(i)=i
40      continue

        do 50 i=1,dim2
           y(i)=i
50      continue

        do 60 k=1,dim3
           z(k)=4*k
60      continue

c display 3D data on rectilinear grid:

        print *
        print *,'>>> rectilinear grid <<<'

        call AVSI_3D_scalar_real_rectilinear('Isosurface','isor',
     +  dim1, dim2, dim3, s3, x, y,z)


c >>>>>>>> irregular grid 

        zmdl=4
        fac=dim1/6.28
        do 300 k=1, dim3
          do 200 j = 1, dim2
            do 100 i = 1, dim1
              xi3(i, j, k)= i
              yi3(i, j, k)= j
              zi3(i, j, k)= 4*k + zmdl * sin(i/fac) 
100          continue
200        continue
300      continue

c display 3D data om irregular grid:

        print *
        print *,'>>> irregular grid <<<'

        call AVSI_3D_scalar_real_irregular('Isosurface','isoi',
     +  dim1, dim2, dim3, s3, xi3, yi3, zi3)

        end


