c ----------------------------------------------------------
      program pfdemo 
c ----------------------------------------------------------
c This program demonstrates how to visualize data in 
c parallel array sp at the CM-5 with the CM Fortran compiler.
c Because AVSI is based upon serial arrays, the data in sp must
c be copied to the serial Front End array s2.
c
c declare CM parallel array:
       real, array (40,20) :: sp
cmf$   layout sp (:news, :news)

c declare FE serial array s2 for AVSI:
       dimension  s2(40,20)

c initialize AVS Interface:
c      call AVSI_initialize (netdir,localdir,display_name,avsoptions)
       call AVSI_initialize ('./networks','.','*','*')

c define remote AVS host:
c      call AVSI_remote(remote_host, remote_user,remote_dir)
c mind that the file .rhosts  at the remote host must contain a line with
c <name CM5 e.g. cm5.rc.rug.nl> <user name >
       call AVSI_remote('*','*','~')

c generate 2D data in parallel array sp:
       forall (i=1:40,j=1:20) sp (i, j) = i + j 

c copy to serial Front End array s2 :
       call CMF_FE_ARRAY_FROM_CM(s2, sp)

c visualize 2D data as an Image, other visualization techniques
c include Contour, 3D Bar Chart and (Colored) Surface:
       call AVSI_2D_scalar_real_uniform('Image','2Ds',40,20,s2)

       end   
