#
# Makefile for &1
#

AVS_PATH=/usr/avs
INC_FILE=$(AVS_PATH)/include/Makeinclude
include $(INC_FILE)

AVS_LIBS = $(AVS_PATH)/lib
INC = $(AVS_PATH)/include
BASELIBS=-lgeom -lutil -lm $(LASTFLIBS)
F77_FLOWLIBS=-L$(AVS_LIBS) -lflow_f $(BASELIBS)
F77_SIMLIBS=-L$(AVS_LIBS) -lsim_f $(BASELIBS)
F77_BIND = $(AVS_PATH)/bin/f77_binding
F77_INC = $(AVS_PATH)/include
F77FLAGS=-I$(INC) $(ANOOPTFFLAGS) $(LOCAL_FFLAGS)
FFLAGS=$(F77FLAGS)


all: avs &1

&1: &1.o
	$(F77) $(F77FLAGS) -o &1 &1.o $(F77_FLOWLIBS)

&1.o:	&1.f
	$(F77) $(F77FLAGS) -c &1.f

#********************************************************************
# This target will create a link to the include directory where the
# AVS Fortran include files can be found. This permits the use of
# the Fortran include statement to access 'avs/avs.inc' etc without
# relying on an absolute pathname. 

avs:
	rm -f avs
	ln -s $(F77_INC) avs
