{ AVSI_routines called from PASCAL, at HP workstations }

program pdemo;
type
   arr10       = array [1..10] of real;
   arr40_20    = array [1..40,1..20] of real;
   arr10_10_10 = array [1..10,1..10,1..10] of real;
   strng       = string[40];
var
   s1 : arr10;
   s2 : arr40_20;
   s3 : arr10_10_10;
   prompt, net_dir, file_dir,  fle :strng;
   i, j, k, i10, i20, i40 : integer;
   z : real;

   procedure AVSI_initialize(var txt1,txt2,txt3,txt4:strng);   external FTN77;
   procedure AVSI_transpose;                                   external FTN77;
   procedure AVSI_1D_scalar_real_uniform(var txt1,txt2:strng;
                var dim1:integer;var s:arr10);                 external FTN77;
   procedure AVSI_2D_scalar_real_uniform(var txt1,txt2:strng;
                var dim1,dim2:integer;var s:arr40_20);         external FTN77;
   procedure AVSI_3D_scalar_real_uniform(var txt1,txt2:strng;
                var dim1,dim2,dim3:integer;var s:arr10_10_10); external FTN77;
begin
{ initialize AVSI: }
   net_dir := './networks'; file_dir := '.'; prompt := '*';
   AVSI_initialize(net_dir, file_dir, prompt, prompt);

{ define transposition for Pascal calls }
  AVSI_transpose;

   fle := 'pascal_test'; i10 :=  10; i20 :=  20; i40 :=  40;

{ make XY_Graph of y= x * x for x = 1, 2,...,10 }
   for i := 1 to 10 do s1[i] := i * i;
   AVSI_1D_scalar_real_uniform(prompt, fle, i10, s1);

{ make Image of 2D data in s2: }
   for i := 1 to 40 do for j := 1 to 20 do s2[i,j] := i + j;
   AVSI_2D_scalar_real_uniform(prompt, fle, i40, i20, s2);

{ make Isosurface of 3D data in s3: }
   for i:=1 to 10 do for j := 1 to 10 do for k:=1 to 10 do
   begin
      z :=      -0.4 * i * i + 4 * i ;
      z := z * (-0.4 * j * j + 4 * j);
      z := z * (-0.4 * k * k + 4 * k);
      s3[i,j,k] := z;
   end;
   AVSI_3D_scalar_real_uniform(prompt, fle, i10, i10, i10, s3);
end.
