/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <string.h>
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include <avs/avs_math.h>

#include "field_math.h" 
#include "y.tab.h"


extern int 	Output_ndim;

extern long   	ndimens, count, skip[], rowlen[];   
extern long   	n_add_dimens, add_count, add_skip[], add_rowlen[];
extern float  	*row, *rrow;     

int curr_add_index[MAX_DIM];                          

extern ptitem push_new_var();
extern ptitem pop_exe_stack();
extern ptitem named_item();
extern void free_item();
extern void clear_all();
float	*op1,*op2,*res, *cop2;
int	s1,s2,sr;
long int rel;

void exe_cnv(ind,ii)
int	 ind;
long int ii;
{
float t;
int i,j,k,low,up;

   k=add_rowlen[ind]/2;
   low=0;
   if (curr_add_index[ind]<k) low=k-curr_add_index[ind];
   up=rowlen[ind];
   if (curr_add_index[ind]>k) up=up-curr_add_index[ind]+k;
   k=add_rowlen[ind]/2;

   ii=ii+low*skip[ind];
   if (ind>0)
     {
     for (i=low;i<up;i++,ii+=skip[ind])
	exe_cnv(ind-1,ii /* , op IAC CODE CHANGE */ );
     }
   else
     {
        for (i=low;i<up;i++,ii++)
	   *(res+sr*ii) += (*(op1+s1*(ii+rel)))*(*cop2);
     }
   ii=ii+(rowlen[ind]-up)*skip[ind];
}	

	

int convolution(result_name)
char *result_name;

{
ptitem 	 result;
ptitem	 oper1;
ptitem 	 oper2;
long int i,add_i,reloc;
int 	 j,oper_no,cycl_flag;
float 	 *r,mask;

  oper2 = pop_exe_stack();
  if ((oper2->type)==CONST)
    {
    AVSerror("Why convolve with constant?");
    clear_all();
    return(0);
    }
  if ((oper2->type)==MODVAR)
    {
    AVSerror("Convolution of index type vars not implemented yet");
    clear_all();
    return(0);
    }
  op2 = oper2->content.ptr;
  s2 = oper2->mult;

  oper1 = pop_exe_stack();
  if ((oper1->type)==CONST)
    {
    AVSerror("Why convolve constant?");
    clear_all();
    return(0);
    }
  
  if ((oper1->type)==MODVAR)
    {
    AVSerror("Convolution of index type vars not implemented yet");
    clear_all();
    return(0);
    }
  op1 = oper1->content.ptr;
  s1 = oper1->mult;
    
  if (result_name==NULL)
       result = push_new_var();
  else
	{
       	result=named_item(result_name,VAR);
       	result->used=NEWNAMED;
	}
  if (result==NULL) return (0);

  r = res = result->content.ptr;
  sr  = result->mult;

  for (i=0;i<count;i++,r+=sr) *r=0.;

  for (i=0;i<MAX_DIM;i++) curr_add_index[i]=0;
  for (add_i=0,cop2=op2;add_i<add_count;add_i++,(curr_add_index[0])++,cop2+=s2)
     {
     mask=*cop2;
     for  (j=0;j<Output_ndim;j++)
	{
	if (curr_add_index[j]<add_rowlen[j]) break;
        curr_add_index[j]=0;
        curr_add_index[j+1]+=1;
	}
     if ((mask>0?mask:-mask)<1.e-10) continue;
     for  (rel=0,j=0;j<Output_ndim;j++) rel+=(curr_add_index[j]-add_rowlen[j]/2)*skip[j];
     i=reloc=0;
        exe_cnv(Output_ndim-1,i);
  free_item(oper1);free_item(oper2);
  return (1);

}
}

