/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "Field Math" (Filter) (Coroutine)                        */
/* Author: Krzysztof Nowinski                                            */
/* Date Created: Mon Aug 16 12:47:22 1993                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* input 0 "infield" field float OPTIONAL                                */
/* input 1 "infield1" field float OPTIONAL                               */
/* output 0 "outfield" field float                                       */
/* param 0 "Output dimensions" typein "" "" ":"                          */
/* param 0 "Output min_ext" typein "" "" ":"                             */
/* param 0 "Output max_ext" typein "" "" ":"                             */
/* param 1 "Output veclen" islider 1 1 10                                */
/* param 2 "Make points" choice 0 0 1                                    */
/* param 3 "Output space dimension" islider 3 1 10                       */
/* param 4 "variables" textblock "" "" ":"                               */
/* param 5 "functions" textblock "" "" ":"                               */
/* param 6 "input line" typein "" "" ":"                                 */
/* param 7 "program" choice_browser " " " " ";"                          */
/* param 8 "execute" boolean 0 0 1                                       */
/* param 9 "clear" oneshot 0 0 1                                         */
/* param 10 "reset" oneshot 0 0 1                                         */
/* param 11 "edit" choice_browser "append" "append:edit:insert:delete" ":"*/
/* param 12 "Formula file" browser " " " " ":fmla"                       */
/* param 13 "Read formula" oneshot 0 0 1                                 */
/* param 14 "Write formula" oneshot 0 0 1                                */
/* param 15 "p0" typein_real 0 -99999. 99999.                            */
/* param 16 "p1" typein_real 0 -99999. 99999.                            */
/* param 17 "p2" typein_real 0 -99999. 99999.                            */
/* param 18 "p3" typein_real 0 -99999. 99999.                            */
/* param 19 "p4" typein_real 0 -99999. 99999.                            */
/* param 20 "p5" typein_real 0 -99999. 99999.                            */
/* End of Module Description Comments                                    */

#include <string.h>
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>

/* IAC CODE CHANGE : #include "field_math.h"*/  /* IAC CODE ADDITION  */
#include "y.tab.h"
 
/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
/* IAC CODE CHANGE : #include "avs/avs_math.h" */
#include "avs/avs_math.h"
#include "field_math.h"


int 	Output_ndim;
int 	out_dims[MAX_DIM];
int 	out_add_dims[MAX_DIM];
int	Output_veclen;
int	Output_uniform;
int 	Make_points;
int 	Output_space_dimension;

int 	oldndim=0, olddims[]={0,0,0,0,0,0};           /* used to check if field reallocation is necessary*/
int 	oldveclen=0;

item   	parameters[NUMPARAMS];
item   	preallocated[MAXPREALLOC];                 /* beginning contains infield data and coordinates, then
							    named temporaries then allocatable items*/
int 	first_output, output_items, first_alloc, first_alloc_orig;

nam_item 	named_stack[MAXNAMED];
int 		top_named, top_named_orig;

ptitem 	exe_stack[MAXEXESTACK],                    /* operational stack*/
	free_stack[MAXFREESTACK];                  /* stack of free items*/
float 	*discarded[MAXDISCARDED];                   /* stack of free allocated arrays*/ 
int 	top_exe_stack, top_free_stack, top_discarded;

float 	*inindices, *incoords, *outcoords;      

long   	ndimens, count, skip[MAX_DIM1], rowlen[MAX_DIM];
long   	n_add_dimens, add_count, add_skip[MAX_DIM1], add_rowlen[MAX_DIM];

char 	*functions         = "sin cos tan atan exp ln log sqr sqrt abs -\nmax min dif \
\nfmin fmax avg\ncnv";
char 	vars[MAXLABELLENGTH],*variables;
char 	*input_line;
char 	form[PROGRAMLENGTH]={'\0'},
	*formula;
char 	program[MAXPROGLINES][MAXPROGLINELENGTH];
int  	current_line = -1, program_length = 0;

char 	*progline;
float 	*row, *rrow;


extern int field_changed();
extern void make_inlabels();
extern void make_labels();
extern void update_formula();

int computation();
int next_name();
int Make_outfield();

ptitem create_item();
ptitem create_named_item();
void destr_item();
ptitem pop_exe_stack();
void free_item();
ptitem push_new_var();
ptitem push_constant();
void push_old_var();
ptitem named_item();
void clear();
void clear_all();
void copy_to();
ptitem getvalue();
void preallocate_variables();
void printitem();

void init_stacks();
void preallocate_variables();
void printitem();
int next_name();
ptitem getvalue();
ptitem find_named_item();
ptitem named_item();

extern void math_parse();

extern int binary();
extern int unary();
extern int fold_unary();

/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int Field_Math_desc()
{

	int in_port, in_port1, in_port2, in_port3, in_port4, in_port5, 
		out_port, param;

	AVSset_module_name("Field Math", MODULE_FILTER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("infield", "field float", OPTIONAL);
	in_port1 = AVScreate_input_port("infield1", "field float", OPTIONAL);
	in_port2 = AVScreate_input_port("infield2", "field float", OPTIONAL);
	in_port3 = AVScreate_input_port("infield3", "field float", OPTIONAL);
	in_port4 = AVScreate_input_port("infield4", "field float", OPTIONAL);
	in_port5 = AVScreate_input_port("infield_add", "field float", OPTIONAL);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("outfield", "field float");

	/* Parameter Specifications                */

	param = AVSadd_parameter("Output dimensions", "string", " ", " ", ":");
	AVSconnect_widget(param, "typein");
	AVSadd_parameter_prop(param,"width","integer",6);

	param = AVSadd_parameter("Output min_ext", "string", " ", " ", ":");
	AVSconnect_widget(param, "typein");
	AVSadd_parameter_prop(param,"width","integer",6);

	param = AVSadd_parameter("Output max_ext", "string", " ", " ", ":");
	AVSconnect_widget(param, "typein");
	AVSadd_parameter_prop(param,"width","integer",6);

	param = AVSadd_parameter("Output veclen", "integer", 1, 1, 10);
	AVSconnect_widget(param, "islider");

	param = AVSadd_parameter("Output geometry", "choice", 
                "uniform", "uniform:rectilinear:irregular:inherit", ":");

	param = AVSadd_parameter("Output space dimension", "integer", 3, 1,10);
	AVSconnect_widget(param, "islider");

	param = AVSadd_parameter("variables", "string_block", variables, " ", ":");
	AVSconnect_widget(param, "textblock");
	AVSadd_parameter_prop(param,"width","integer",5);
	AVSadd_parameter_prop(param,"height","integer",12);

	param = AVSadd_parameter("functions", "string_block", functions, " ", ":");
	AVSconnect_widget(param, "textblock");
	AVSadd_parameter_prop(param,"width","integer",5);
	AVSadd_parameter_prop(param,"height","integer",3);

	param = AVSadd_parameter("input line", "string", "", " ", ":");
	AVSconnect_widget(param, "typein");
	AVSadd_parameter_prop(param,"width","integer",9);

	param = AVSadd_parameter("program", "choice", " ", formula, ";");
	AVSconnect_widget(param, "choice_browser");
	AVSadd_parameter_prop(param,"width","integer",11);
	AVSadd_parameter_prop(param,"height","integer",11);

	param = AVSadd_parameter("execute", "boolean", 0, 0, 1);
	param = AVSadd_parameter("auto execute", "boolean", 0, 0, 1);
	param = AVSadd_parameter("show exec", "boolean", 0, 0, 1);

	param = AVSadd_parameter("Clear formula", "oneshot", 0, 0, 1);

	param = AVSadd_parameter("reset", "oneshot", 0, 0, 1);

	param = AVSadd_parameter("edit", "choice", "append", "append:edit:insert:delete", ":" );

	param = AVSadd_parameter("Formula file", "string", " ", " ", ".fmla");
	AVSconnect_widget(param, "browser");

	param = AVSadd_parameter("Read formula", "oneshot", 0, 0, 1);
	param = AVSadd_parameter("Merge formula", "oneshot", 0, 0, 1);

	param = AVSadd_parameter("Write formula", "oneshot", 0, 0, 1);
	param = AVSadd_parameter("Save formula", "oneshot", 0, 0, 1);

	param = AVSadd_float_parameter("p0", 0, FLOAT_UNBOUND, FLOAT_UNBOUND );
	AVSconnect_widget(param, "typein_real");

	param = AVSadd_float_parameter("p1", 0, FLOAT_UNBOUND, FLOAT_UNBOUND );
	AVSconnect_widget(param, "typein_real");

	param = AVSadd_float_parameter("p2", 0, FLOAT_UNBOUND, FLOAT_UNBOUND );
	AVSconnect_widget(param, "typein_real");

	param = AVSadd_float_parameter("p3", 0, FLOAT_UNBOUND, FLOAT_UNBOUND );
	AVSconnect_widget(param, "typein_real");

	param = AVSadd_float_parameter("p4", 0, FLOAT_UNBOUND, FLOAT_UNBOUND );
	AVSconnect_widget(param, "typein_real");

	param = AVSadd_float_parameter("p5", 0, FLOAT_UNBOUND, FLOAT_UNBOUND );
	AVSconnect_widget(param, "typein_real");

/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/

	AVSadd_parameter_prop(param,"layout","string_block", 
		"shell \"ui\" shell\n\
		panel Application -w app_panel -p ui -xy 348,2 -wh 621,830\n\
		panel \"Top Level Stack\" -w master_stack -p Application -xy 2,100 -wh 256,517\n\
		panel \"$Module\" -w panel -p ui -xy 590,9 -wh 621,830\n\
		manipulator \"$Module:Output dimensions\"      -w typein         -p \"$Module\" -xy 1,0     -wh 336,22 \n\
		manipulator \"$Module:Output min_ext\"         -w typein         -p \"$Module\" -xy 1,22    -wh 336,22 \n\
		manipulator \"$Module:Output max_ext\"         -w typein         -p \"$Module\" -xy 1,44    -wh 336,22 \n\
  		manipulator \"$Module:Output veclen\"          -w islider        -p \"$Module\" -xy 1,66    -wh 236,32 \n\
  		manipulator \"$Module:Output geometry\"        -w choice         -p \"$Module\" -xy 491,0   -wh 118,88 \n\
  		manipulator \"$Module:Output space dimension\" -w islider        -p \"$Module\" -xy 250,66  -wh 236,32 \n\
  		manipulator \"$Module:variables\"              -w textblock      -p \"$Module\" -xy 1,100   -wh 250,264\n\
  		manipulator \"$Module:functions\"              -w textblock      -p \"$Module\" -xy 1,375   -wh 250,66 \n\
  		manipulator \"$Module:input line\"             -w typein         -p \"$Module\" -xy 1,803   -wh 590,22 \n\
  		manipulator \"$Module:program\"                -w choice_browser -p \"$Module\" -xy 1,467   -wh 590,337\n\
  		manipulator \"$Module:execute\"                -w boolean        -p \"$Module\" -xy 491,155 -wh 118,22 \n\
  		manipulator \"$Module:auto execute\"           -w boolean        -p \"$Module\" -xy 491,133 -wh 118,22 \n\
  		manipulator \"$Module:show exec\"              -w boolean        -p \"$Module\" -xy 491,320 -wh 118,22 \n\
  		manipulator \"$Module:Clear formula\"          -w oneshot        -p \"$Module\" -xy 491,435 -wh 118,22 \n\
  		manipulator \"$Module:reset\"                  -w oneshot        -p \"$Module\" -xy 491,100 -wh 118,22 \n\
  		manipulator \"$Module:edit\"                   -w radio_buttons  -p \"$Module\" -xy 491,340 -wh 118,88 \n\
  		manipulator \"$Module:Formula file\"           -w browser        -p \"$Module\" -xy 250,100 -wh 240,314\n\
  		manipulator \"$Module:Read formula\"           -w oneshot        -p \"$Module\" -xy 250,413 -wh 118,22 \n\
  		manipulator \"$Module:Merge formula\"          -w oneshot        -p \"$Module\" -xy 250,435 -wh 118,22 \n\
  		manipulator \"$Module:Write formula\"          -w oneshot        -p \"$Module\" -xy 370,413 -wh 118,22 \n\
  		manipulator \"$Module:Save formula\"           -w oneshot        -p \"$Module\" -xy 370,435 -wh 118,22 \n\
 		manipulator \"$Module:p0\"                     -w typein_real    -p \"$Module\" -xy 491,184 -wh 118,22 \n\
 		manipulator \"$Module:p1\"                     -w typein_real    -p \"$Module\" -xy 491,206 -wh 118,22 \n\
		manipulator \"$Module:p2\"                     -w typein_real    -p \"$Module\" -xy 491,228 -wh 118,22 \n\
		manipulator \"$Module:p3\"                     -w typein_real    -p \"$Module\" -xy 491,250 -wh 118,22 \n\
		manipulator \"$Module:p4\"                     -w typein_real    -p \"$Module\" -xy 491,272 -wh 118,22 \n\
		manipulator \"$Module:p5\"                     -w typein_real    -p \"$Module\" -xy 491,294 -wh 118,22");


/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
#define UNIFORM_OUT		0
#define RECTILINEAR_OUT		1
#define IRREGULAR_OUT		2
#define INHERIT_OUT		3





	AVSfield_float *infield=NULL;
	AVSfield_float *field1=NULL;
	AVSfield_float *infield1=NULL;
	AVSfield_float *field2=NULL;
	AVSfield_float *infield2=NULL;
	AVSfield_float *field3=NULL;
	AVSfield_float *infield3=NULL;
	AVSfield_float *field4=NULL;
	AVSfield_float *infield4=NULL;
	AVSfield_float *infield_add=NULL;
	AVSfield_float *outfield=NULL;
	char *Output_dimensions;
	char *Output_min_ext;
	char *Output_max_ext;
	char *Output_geometry;
	int execute;
	int auto_execute;
	int show_exec;
	int something_new;
	int Clear_formula;
	int reset;
	char *edit;
	char *Formula_file;
	int Read_formula,Merge_formula;
	int Write_formula,Save_formula;
   	FILE *program_file;
        char file_input_line[80];
	float out_min_ext[MAX_DIM],out_max_ext[MAX_DIM];
        char extents[60],ext[10];
	float *p0,*p1,*p2,*p3,*p4,*p5;
	char parname[3];
	int edit_n;
        char *exts=extents;




	int min_ext_read = -10,max_ext_read = -10;
	int i,j,loop,newfield,preall=0;





/* *****************************************/
/* Coroutine Main Routine                  */
/* *****************************************/
int main(argc, argv)
	int argc;
	char **argv;
{

	int Field_Math_desc();

	formula=form;
	variables=vars;
	strcpy(formula,"");

	AVScorout_init(argc,argv,Field_Math_desc);

	something_new=0;


	for (i=0;i<MAXPROGLINES;i++)
		    program[i][0]='\0';
	program_length=0;
	update_formula();

	strcpy(variables,"To start creation of output field,\n\
connect the rightmost input port\nor set outfield dimensions\n\
in the Output dimensions\ntypein line above.");
	AVSmodify_parameter("variables",AVS_VALUE,variables,NULL,NULL);	    

	for(;;) {
	    AVScorout_wait();
/* Process the inputs                                                    */
	    AVScorout_input(&infield,&infield1,&infield2,&infield3,&infield4,&infield_add,
		&Output_dimensions,&Output_min_ext,&Output_max_ext,&Output_veclen,
		&Output_geometry,&Output_space_dimension,
		&variables,&functions,
		&input_line,&progline,
		&execute,&auto_execute,&show_exec,&Clear_formula,&reset,&edit,
		&Formula_file,&Read_formula,&Merge_formula,
		&Write_formula,&Save_formula,
		&p0,&p1,&p2,&p3,&p4,&p5);


	something_new=something_new||
		AVSinput_changed("infield",0)||
	    	AVSinput_changed("infield1",0)||
	    	AVSinput_changed("infield2",0)||
	    	AVSinput_changed("infield3",0)||
	    	AVSinput_changed("infield4",0)||
	    	AVSinput_changed("infield_add",0);


	if (strcmp(edit,"append")==0) edit_n=APPEND;
	if (strcmp(edit,"edit")==0)   edit_n=EDIT;
	if (strcmp(edit,"insert")==0) edit_n=INSERT;
	if (strcmp(edit,"delete")==0) edit_n=DELETE;
	    (parameters[0]).content.val = *p0;
	    (parameters[1]).content.val = *p1;
	    (parameters[2]).content.val = *p2;
	    (parameters[3]).content.val = *p3;
	    (parameters[4]).content.val = *p4;
	    (parameters[5]).content.val = *p5;

	Make_points=AVSchoice_number("Output geometry",Output_geometry)-1;

	if (infield==NULL)
	    {
	    AVSparameter_visible("Output dimensions",1);
	    AVSmodify_parameter("Output geometry" ,AVS_MINVAL,
                NULL,"uniform:rectilinear:irregular",NULL);
	    }
	else
	    {
	    AVSparameter_visible("Output dimensions",0);
	    AVSmodify_parameter("Output geometry" ,AVS_MINVAL,
                NULL,"uniform:rectilinear:irregular:inherit",NULL);
    	    }

	formula=form;
	variables=vars;

	current_line=program_length-1;
	if (progline!=NULL)
	    {
	    for (i=0;i<program_length;i++)
		if (strcmp(progline,program[i])==0) current_line=i;
	    }



	if ((infield!=NULL)&&((newfield=field_changed(infield))||
	    	AVSinput_changed("infield1",0)||
	    	AVSinput_changed("infield2",0)||
	    	AVSinput_changed("infield3",0)||
	    	AVSinput_changed("infield4",0)||
	    	AVSinput_changed("infield_add",0)))
		{
		field1=infield1;
		field2=infield2;
		field3=infield3;
		field4=infield4;
  /* Check for a valid field type */

	  	if( infield->type != AVS_TYPE_REAL)
		    {
	  	    AVSerror( "Field must be of type real" ) ;
	  	    continue ;
		    }
	     	if (infield1!=NULL)
		    {
	  	    if( infield1->type != AVS_TYPE_REAL )
		    	{
	  	    	AVSerror( "Field1 must be of type real - ignoring" ) ;
		    	field1=NULL;
		    	}
  	           for (loop=0; loop <(infield->ndim);loop++)
	    	       if ((infield->dimensions)[loop]!=(infield1->dimensions)[loop]) field1=NULL;
		   }
	     	if (infield2!=NULL)
		    {
	  	    if( infield2->type != AVS_TYPE_REAL )
		    	{
	  	    	AVSerror( "Field2 must be of type real - ignoring" ) ;
		    	field2=NULL;
		    	}
  	            for (loop=0; loop <(infield->ndim);loop++)
	 	        if ((infield->dimensions)[loop]!=(infield2->dimensions)[loop]) field2=NULL;
		    }
	     	if (infield3!=NULL)
		    {
	  	    if( infield3->type != AVS_TYPE_REAL )
		    	{
	  	    	AVSerror( "Field3 must be of type real - ignoring" ) ;
		    	field3=NULL;
		    	}
  	            for (loop=0; loop <(infield->ndim);loop++)
	 	        if ((infield->dimensions)[loop]!=(infield3->dimensions)[loop]) field3=NULL;
		    }
	     	if (infield4!=NULL)
		    {
	  	    if( infield4->type != AVS_TYPE_REAL )
		    	{
	  	    	AVSerror( "Field4 must be of type real - ignoring" ) ;
		    	field4=NULL;
		    	}
  	            for (loop=0; loop <(infield->ndim);loop++)
	 	        if ((infield->dimensions)[loop]!=(infield4->dimensions)[loop]) field4=NULL;
		    }
	        Output_ndim=infield->ndim;
	        strcpy(exts,"");
	        for (i=0;i<infield->nspace;i++)
		    {
		    out_min_ext[i] = *((infield->min_extent)+i);
	 	    sprintf(ext,"%7.4f ",out_min_ext[i]);
                    exts=strcat(exts,ext);
		    }
	        AVSmodify_parameter("Output min_ext",AVS_VALUE,exts,NULL,NULL);
	        strcpy(exts,"");
	        for (i=0;i<infield->nspace;i++)
		    {
		    out_max_ext[i] = *((infield->max_extent)+i);
		    sprintf(ext,"%7.4f ",out_max_ext[i]);
                    exts=strcat(exts,ext);
		    }
	        AVSmodify_parameter("Output max_ext",AVS_VALUE,exts,NULL,NULL);
	        make_labels(infield,field1,field2,field3,field4,infield_add,variables);
 	        }

	if ((infield!=NULL)&&(
		AVSparameter_changed("Output veclen")||
		AVSparameter_changed("Output space dimension")||
		AVSparameter_changed("Output geometry")))
	                   make_labels(infield,field1,field2,field3,field4,infield_add,variables);

	if ((infield!=NULL)&&(newfield||
		AVSparameter_changed("Output veclen")||
		AVSparameter_changed("Output space dimension")||
		AVSparameter_changed("Output geometry")))  
			{
			preall=1;
		  	if ((Make_points==UNIFORM)||(Make_points==RECTILINEAR))
			    Output_space_dimension=infield->ndim;
		  	if (Make_points==INHERIT_OUT)
			    Output_space_dimension=infield->nspace;
	        	AVSmodify_parameter("Output space dimension",AVS_VALUE,Output_space_dimension,NULL,NULL);
			}

        if (AVSparameter_changed("Output min_ext"))
            min_ext_read=sscanf(Output_min_ext,"%f %f %f %f %f %f",
                        out_min_ext,out_min_ext+1,out_min_ext+2,
                        out_min_ext+3,out_min_ext+4,out_min_ext+5);
        if (AVSparameter_changed("Output max_ext"))
            max_ext_read=sscanf(Output_max_ext,"%f %f %f %f %f %f",
                        out_max_ext,out_max_ext+1,out_max_ext+2,
			out_max_ext+3,out_max_ext+4,out_max_ext+5);


	if (infield==NULL&&
	    (AVSparameter_changed("Output dimensions")||
	    AVSparameter_changed("Output veclen")||
            AVSparameter_changed("Output space dimension")||
	    AVSparameter_changed("Output geometry")))
	    {
	    preall=1;

	    Output_ndim=sscanf(Output_dimensions,"%d %d %d %d %d %d",
			out_dims,out_dims+1,out_dims+2,out_dims+3,out_dims+4,out_dims+5);
	    if ((Make_points==UNIFORM)||(Make_points==RECTILINEAR))
		    Output_space_dimension=Output_ndim;
	    AVSmodify_parameter("Output space dimension",AVS_VALUE,Output_space_dimension,NULL,NULL);

	    infield=field1=field2=field3=field4=NULL;
	    make_labels(infield,field1,field2,field3,field4,infield_add,variables);
	    }


	    if (edit_n==DELETE)
		if ((current_line>=0)&&(current_line<program_length))
		    {
		    program_length-=1;
		    for (i=current_line;i< program_length;i++)
		    	for (j=0;j<MAXPROGLINELENGTH;j++)
			    program[i][j]=program[i+1][j];

		    current_line=program_length-1;
		    update_formula();
		    AVSmodify_parameter("program",AVS_MINVAL,NULL,formula,NULL);
		    AVSmodify_parameter("edit",AVS_VALUE,"append",NULL,NULL);
		    AVSmodify_parameter("input line", AVS_VALUE, "", NULL, NULL);
		    continue;
		    }


	    if (AVSparameter_changed("edit"))
		AVSmodify_parameter("input line", AVS_VALUE, "", NULL, NULL);

	    if (AVSparameter_changed("input line"))
		{
		switch (edit_n)
		    {
		case EDIT:
		    if ((current_line>-1)&&(current_line<program_length))
		        strcpy(program[current_line],input_line);
		    break;
		case APPEND:
		    current_line+=1;
		    if (add_line(&current_line)==0) continue;
		    AVSmodify_parameter("input line", AVS_VALUE, "", NULL, NULL);
		    break;
		case INSERT:
		    if (add_line(&current_line)==0) continue;
		    current_line+=1;
		    AVSmodify_parameter("input line", AVS_VALUE, "", NULL, NULL);
		    break;
		default:
		    break;
		    }
		update_formula();
		continue;
		}

	    if ((edit_n==EDIT)&&
		(current_line>-1)&&
		(current_line<program_length))
		    AVSmodify_parameter("input line", AVS_VALUE,
					program[current_line] , NULL, NULL);


	    if (Clear_formula!=0) 
		{
		for (i=0;i<MAXPROGLINES;i++)
		    program[i][0]='\0';
		    program_length=0;
		    current_line = -1;
		    update_formula();
		    AVSmodify_parameter("edit",AVS_VALUE,"append",NULL,NULL);
	    	}

	    if (Make_points==IRREGULAR_OUT) 
		AVSparameter_visible("Output space dimension",1);
	    else
		AVSparameter_visible("Output space dimension",0);

      if( Write_formula )
        {

           /* Attempt to open macro filename */

           program_file = fopen( Formula_file, "w" ) ;

           if( program_file == NULL )
             AVSwarning( "Could open macro file, macro not saved" ) ;
           else
             {
                for( i = 0; i < program_length ; i++ )
                   fprintf( program_file, "%s\n", program[i] ) ;
                fclose( program_file ) ;
             }
        }

      if( Read_formula||Merge_formula)
        {
	   if (Read_formula)
		{
		for (i=0;i<MAXPROGLINES;i++)
		    program[i][0]='\0';
		    program_length=0;
		    current_line = -1;
		    update_formula();
		    AVSmodify_parameter("edit",AVS_VALUE,"append",NULL,NULL);
	    	}

           /* Attempt to open macro filename */

           program_file = fopen( Formula_file, "r" ) ;

           if( program_file == NULL )
             AVSwarning( "Could open macro file, macro not saved" ) ;
           else
             {
		preall=0;
		i=AVSchoice_number("edit",edit);
                while( fgets( file_input_line, MAXPROGLINELENGTH, program_file ) != NULL )
		    {
		    for (j=0;j<MAXPROGLINELENGTH;j++) 
			if (*(file_input_line+j)=='\n') *(file_input_line+j)='\0';
		    if (*file_input_line == '!')
			{
			if (strncmp(file_input_line+1,"dimensions",10)==0)
			    {
			    Output_ndim=sscanf(file_input_line+11,"%d %d %d %d %d %d",
			    		out_dims,out_dims+1,out_dims+2,out_dims+3,
					out_dims+4,out_dims+5);
			    AVSmodify_parameter("Output dimensions",AVS_VALUE,file_input_line+11,NULL,NULL);
			    preall=2;
			    }
			if (strncmp(file_input_line+1,"min_ext",7)==0)
			    {
            		    min_ext_read=sscanf(file_input_line+8,"%f %f %f %f %f %f",
                        		out_min_ext,out_min_ext+1,out_min_ext+2,
                        		out_min_ext+3,out_min_ext+4,out_min_ext+5);
			    AVSmodify_parameter("Output min_ext",AVS_VALUE,file_input_line+8,NULL,NULL);
			    }
			if (strncmp(file_input_line+1,"max_ext",7)==0)
			    {
            		    max_ext_read=sscanf(file_input_line+8,"%f %f %f %f %f %f",
                        		out_max_ext,out_max_ext+1,out_max_ext+2,
                        		out_max_ext+3,out_max_ext+4,out_max_ext+5);
			    AVSmodify_parameter("Output max_ext",AVS_VALUE,file_input_line+8,NULL,NULL);
			    }
			if (strncmp(file_input_line+1,"veclen",4)==0)
			    {
			    sscanf(file_input_line+8,"%d",&Output_veclen);
			    AVSmodify_parameter("Output veclen",AVS_VALUE,Output_veclen,NULL,NULL);
			    if (preall==0) preall=1;
			    }
			if (strncmp(file_input_line+1,"nspace",4)==0)
			    {
			    sscanf(file_input_line+8,"%d",&Output_space_dimension);
			    AVSmodify_parameter("Output space dimension",AVS_VALUE,
						Output_space_dimension,NULL,NULL);
			    AVSmodify_parameter("Output geometry",AVS_VALUE,"irregular",NULL,NULL);
			    Make_points=IRREGULAR;
			    if (preall==0) preall=1;
			    }
			}
		    if  (i==APPEND) 
			{
			current_line+=1;
			read_line(&current_line,file_input_line);
			}
		    else
			{
			read_line(&current_line,file_input_line);
			current_line+=1;
			}
		    }

                fclose( program_file ) ;
		if (preall)
	     		make_labels(infield,field1,field2,field3,field4,infield_add,variables);
		update_formula();
		

             }

        }
	    if (reset!=0) {clear_all();preall=1;};


	    if	(auto_execute!=0&&something_new) 
		{
		execute=1;
		AVSmodify_parameter("execute",AVS_VALUE,execute,NULL,NULL);
		}
	    if  (execute!=0)
	      {
	      something_new=0;
	      if (preall||(outfield==NULL))
	      	{
	      	if (infield!=NULL)
		  {
		  Output_ndim=infield->ndim;
		  for (i=0;i<Output_ndim;i++)
			out_dims[i] = *(infield->dimensions+i);
		  if (Make_points==INHERIT_OUT) 
			{
			Output_space_dimension=infield->nspace;
			Output_uniform=infield->uniform;
			}
		  else
			{
			Output_uniform=Make_points;
		  	if ((Make_points==UNIFORM)||(Make_points==RECTILINEAR))
			    Output_space_dimension=infield->ndim;
			}
		  }
	      	else
		  Output_uniform=Make_points;

	      	if (! Make_outfield(Output_ndim,Output_veclen,Output_uniform,
				Output_space_dimension,out_dims,&outfield)) continue;
              	if ((min_ext_read==Output_ndim)&&(max_ext_read==Output_ndim))
		                AVSfield_set_extent(outfield,out_min_ext,out_max_ext);
	      	if (Make_points==INHERIT_OUT) 
		  AVSfield_copy_points( infield, outfield ) ;
	        else
	      	  if (Make_points==UNIFORM) 
		     for (i=0;i<Output_ndim;i++)
			 {
			 *(outfield->points+2*i)=out_min_ext[i];
			 *(outfield->points+2*i+1)=out_max_ext[i];
			 }
	      
	        preallocate_variables(infield,field1,field2,field3,field4,infield_add,outfield);
		output_items=Output_veclen;
		if (Make_points==IRREGULAR) output_items+=Output_space_dimension;
		}
		preall=0;
	        if (computation(program,outfield)!=0)
	    		{
			AVSfield_reset_minmax(outfield);
	    		AVScorout_output(outfield);
	    		AVScorout_exec();
			}
		for (i=0;i<NUMPARAMS;i++)
			{
			sprintf(parname,"p%d",i);
			AVSmodify_float_parameter(parname,AVS_VALUE,
				(double)((parameters[i]).content.val),NULL,NULL);
			}
		execute=0;
		AVSmodify_parameter("execute",AVS_VALUE,execute,NULL,NULL);
		}
	}
}

 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/



int computation(prg,outfield)
char prg[MAXPROGLINES][MAXPROGLINELENGTH];
AVSfield_float *outfield;
{

  int                   line, i ,j, loopdepth, nextline, cond;         
  char *                specie_left ;        /* Left bracket location for a species  */
  char                  specie_name[VarSize] ;  /* Current specie being processed       */
  char                  left_hand_name[VarSize] ;
  char *                ptr ;
  char *                left_hand_ptr ;
  ptitem		arg_item;
  char *                result_name;
  char			prgline[MAXPROGLINELENGTH];
  char      		rpn_formula[MAXPROGLINELENGTH],
      			left_sizes[SINGLELABELLENGTH];
  int			jump_target[MAXPROGLINES],jptar[MAXPROGLINES];
  float			res;
  float			*parval[6];



/******************computation starts here****************/
  loopdepth=-1;
  for (line=program_length-1;line>=0;line--)
      {
	strcpy(prgline,prg[line]);
        if (strncmp(prgline,"end while",9)==0) 
	    {
	    loopdepth+=1;
	    jptar[loopdepth]=line+1;
	    }
        if (strncmp(prgline,"while",5)==0) 
	    {
	    if (loopdepth<0)
		{
                AVSerror( "Loop beginning in line number %d not ended",line ) ;
		return(0);
		}
	    jump_target[line]=jptar[loopdepth];
	    jump_target[jump_target[line]-1]=line;
	    loopdepth-=1;
	    }
	}
  init_stacks();
  loopdepth=0;
  for ( line=0;line<program_length;line=nextline)
      { if (line>=program_length) break;
        nextline=line+1;
	cond=0;
	strcpy(left_sizes,"");
	strcpy(rpn_formula,"");
	strcpy(prgline,prg[line]);
	if (show_exec) AVSmodify_parameter("program",AVS_VALUE,prg[line],NULL,NULL);

	if ((*prgline == '#')||(*prgline == '!')||(strlen(prgline)<3)) continue
;
        if (strncmp(prgline,"end while",9)==0) 
	    {
	    nextline=jump_target[line];
	    continue;
	    }
        if (strncmp(prgline,"flush",5)==0)
	    {
  	    j=0;
  	    for (i=first_output;i<first_output+output_items;i++)
		{
		if ((preallocated[i]).used < NAMED)
	            break;
		if ((preallocated[i]).used > NAMED) 
		   j+=1;
		(preallocated[i]).used = NAMED;
		}
	    if (j==output_items)
	    	{
		AVSfield_reset_minmax(outfield);
    		AVScorout_output(outfield);
	    	AVScorout_exec();
		}
	    continue;
	    }
        if (strncmp(prgline,"while",5)==0)
	    {
            cond=1;
            loopdepth+=1;
            sprintf(left_sizes,"LOOPV=");
            for (j=0;j<6;j++) prgline[j]=left_sizes[j];
	    strcpy(left_sizes,"");
	    strcpy(rpn_formula,"");
	    }
	    if (execute==0) AVScorout_wait();
	    AVScorout_input(&infield,&infield1,&infield2,&infield3,&infield4,&infield_add,
		&Output_dimensions,&Output_min_ext,&Output_max_ext,&Output_veclen,
		&Output_geometry,&Output_space_dimension,
		&variables,&functions,
		&input_line,&progline,
		&execute,&auto_execute,&show_exec,&Clear_formula,&reset,&edit,
		&Formula_file,&Read_formula,&Merge_formula,
		&Write_formula,&Save_formula,
		&p0,&p1,&p2,&p3,&p4,&p5);

	    something_new=something_new||
		AVSinput_changed("infield",0)||
	    	AVSinput_changed("infield1",0)||
	    	AVSinput_changed("infield2",0)||
	    	AVSinput_changed("infield3",0)||
	    	AVSinput_changed("infield4",0)||
	    	AVSinput_changed("infield_add",0);

	    if (reset) return(0);

	    parval[0]=p0;
	    parval[1]=p1;
	    parval[2]=p2;
	    parval[3]=p3;
	    parval[4]=p4;
	    parval[5]=p5;


	    for (i=0;i<NUMPARAMS;i++)
		{
		sprintf(parname,"p%d",i);
		if (AVSparameter_changed(parname))
		    (parameters[i]).content.val=*parval[i];
		else
		    AVSmodify_float_parameter(parname,AVS_VALUE,
			(double)((parameters[i]).content.val),NULL,NULL);
		}

	    
	math_parse(prgline,left_sizes,rpn_formula);
  	ptr = rpn_formula;
  	left_hand_ptr=left_sizes;
/*	printf("\n%s %d",prgline,top_free_stack);fflush(stdout);*/
        if (!next_name(&left_hand_ptr,'\n',left_hand_name)) 
	  return(0);
	  
        while ( *ptr != '\n' )
          {
            switch( *ptr )
              {

                case '[':       /* A variable index number */

                  specie_left = ptr+1;
      		  if (!next_name(&specie_left,']',specie_name)) 
			{
			AVSerror( "Bad name at \"%s\" (sep=%c) in line number %d (%s)",
				  specie_left,']',line+1, ptr) ;
                        clear_all();
	 		return(0);
			}
		  ptr=specie_left;

                  
		  arg_item=find_named_item(specie_name);
                  if( arg_item==NULL )
                      {
                       AVSerror( "Undefined variable \"%s\" in line number %d",specie_name,line+1 ) ;
                       clear_all();
                       return( 0 ) ;
                      }
		  
                  if( arg_item->used < NAMED )
                      {
                       AVSerror( "Undefined variable \"%s\" in line number %d",specie_name,line+1 ) ;
                       clear_all();
                       return( 0 ) ;
                      }
		  

                  exe_stack[++top_exe_stack] = arg_item;
		  if (*ptr=='\n') 
			copy_to(left_hand_name);

                  break ;


                case '{':       /* A function name */

		  specie_left=ptr+1;
      		  if (!next_name(&specie_left,'}',specie_name)) 
			{
			AVSerror( "Bad name at \"%s\" (sep=%c) in line number %d (%s)",
				specie_left,'}',line+1, ptr) ;
                        clear_all();
	 		return(0);
			}

                  ptr = specie_left;
		  if (*ptr=='\n') 
			result_name=left_hand_name;
		  else
			result_name=NULL;
		  

                 /* Do unary operation */

                  if( fold_unary( specie_name, result_name) ) break;
                  if( noarg( specie_name, result_name) ) break;

                  if( ! unary( specie_name, result_name) )
                    {
                      AVSerror( "Invalid function \"%s\" in line  number %d",specie_name,line+1 ) ;
                      
                      clear_all() ;
                      return( 0 ) ;
                    }

                  break ;

                case '<':       /* A number */

                  /* Get the value of a number */

                  if( ! getvalue( &ptr ) )
                    {
                       AVSerror( "Invalid floating point number in input formula" ) ;
                       clear_all() ;
                       return( 0 ) ;
                    }

		  if (*ptr=='\n') 
			copy_to(left_hand_name);

                  break ;


                default:
                  /* Evaluate the binary operation */

		  if (*(ptr+1)=='\n') 
			result_name=left_hand_name;
		  else
			result_name=NULL;
		  
                  if( ! binary(*ptr,result_name) )
                    {
                       AVSerror( "Unrecognized operator in input formula" ) ;
                       clear_all() ;
                       return( 0 ) ;
                    }

                  ptr++ ;
                  break ;

              } /* End of switch( *ptr ) */

          } /* End of while */
     ptr++;
     if (cond)
	{
        arg_item=named_item(left_hand_name,CONST);
	res=(arg_item->content).val;
	if ((res>-1.0e-6)&&(res<1.0e-6)) 
	    {
	    nextline=jump_target[line];
	    loopdepth-=1;
	    }
	else
	    nextline=line+1;
	}
     } /* End of lines*/
  clear();
  j=0;
  for (i=first_output;i<first_output+output_items;i++)
	{
	if ((preallocated[i]).used < NAMED)
            return( 0 ) ;
	if ((preallocated[i]).used > NAMED) 
	   j=1;
	(preallocated[i]).used = NAMED;
	}

  return(j);

}


int next_name(ptr,sep,name)
char **ptr;
char sep;
char *name;
{
char *end_ptr;
      if( (end_ptr = strchr( *ptr, sep ) ) == NULL )
	  {
          clear_all();
          return( 0 );
          }
      if( ( end_ptr-(*ptr)+1 ) > (VarSize+1) )
          {
          AVSerror( "Variable name too long, recompile module with larger VarSize" ) ;
          clear_all();
          return( 0 ) ;
          }
      strncpy( name, *ptr, end_ptr-(*ptr) ) ;
      *(name+(end_ptr-(*ptr)))='\0';
      *ptr=end_ptr+1;
      return(1);
}

int Make_outfield(ndim,veclen,uniform,nspace,dims,outfield)
int ndim, veclen, uniform, *dims;
AVSfield_float **outfield;
{
char outfield_des[200];
int loop;
	if (uniform==UNIFORM)
	        sprintf(outfield_des,"field %dD %d-vector float uniform",
			ndim,veclen);
	else
	   {
	   if (uniform==RECTILINEAR)
	        sprintf(outfield_des,"field %dD %d-vector float rectilinear",
			ndim,veclen);
	   else
	        sprintf(outfield_des,"field %dD %d-vector float %d-space irregular",
			ndim,veclen,nspace);
	   }
 	if( *outfield )  AVSfield_free( *outfield ) ;
	if( ( *outfield = (AVSfield_float *) AVSdata_alloc( outfield_des, dims ) ) == NULL )
	 	{
	  	AVSerror( "Output field allocation error" ) ;
	  	return(0);;
	 	}
  	count=1;
	if (uniform!=IRREGULAR) (*outfield)->nspace=(*outfield)->ndim;
  	for (loop=0; loop <((*outfield)->ndim);loop++)
     		    count *= ((*outfield)->dimensions)[loop];
	return(1);
}	
