/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <string.h>
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
 
/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/
#include <avs/avs_math.h>

#include "field_math.h" 
#include "y.tab.h"

extern int	Output_veclen;
extern int 	Make_points;
extern int 	Output_space_dimension;
extern item   	parameters[NUMPARAMS];
extern item   	preallocated[MAXPREALLOC];                 /* beginning contains infield data and coordinates, then
							    named temporaries then allocatable items*/
extern int 	first_output, last_output, first_alloc, first_alloc_orig;

extern nam_item 	named_stack[MAXNAMED];
extern int 		top_named, top_named_orig;

extern ptitem 	exe_stack[MAXEXESTACK],                    /* operational stack*/
		free_stack[MAXFREESTACK];                  /* stack of free items*/
extern float 	*discarded[MAXDISCARDED];                   /* stack of free allocated arrays*/ 
extern int 	top_exe_stack, top_free_stack, top_discarded;

extern float 	*inindices, *incoords, *outcoords;      
extern long   	ndimens, count, skip[MAX_DIM1], rowlen[MAX_DIM]; 
extern long   	n_add_dimens, add_count, add_skip[MAX_DIM1], add_rowlen[MAX_DIM];                   
extern float 	*row, *rrow;


void init_stacks()
{
int i;

for (i=0;i<MAXEXESTACK;i++)
    exe_stack[i]=NULL;

for (i=0;i<MAXDISCARDED;i++)
    discarded[i]=NULL;
top_exe_stack =  top_discarded = -1;
}

ptitem create_item(tp, mul, mod, var)
int tp; 
int mul, mod;
float *var;
{
ptitem newitem;
int i;
    newitem=NULL;
    if (tp==VAR)
    	for (i=first_output;i<first_alloc;i++)
 	    if (((preallocated[i]).used==FREE)&&((preallocated[i]).type==tp))
	   	{
	    	(preallocated[i]).used=USED;
	    	newitem=&(preallocated[i]);
	    	return (newitem);   /*  outputs have their variable fields already allocated*/
    	    	}

if (top_free_stack>-1)
   {
   newitem=free_stack[top_free_stack];
   top_free_stack--;
   }

   if (newitem == NULL)
      	{
	if ((newitem = (ptitem) malloc(sizeof(item))) == NULL)
          return (NULL);
	printf("  a@%dk",(sizeof(item))/1024);
    	newitem->allocated = ALLOCATED;
        }                       /* STRUCT newitem allocated. Now allocate variable field*/
    newitem->used=USED;
    newitem->type = tp;
    newitem->mult = mul;
    newitem->modulo = mod;
    switch (tp)
    {
    case VAR:
	if (var!=NULL)
            newitem->content.ptr = var;
    	else if (top_discarded>=0)
 	    {
            newitem->content.ptr=discarded[top_discarded];
/*	    printf(" r@%d ",top_discarded);*/
	    top_discarded--;
	    }
    	else
           {
           if ((newitem->content.ptr = (float *) malloc(count*sizeof(float))) == NULL)
         	return (NULL);
	   printf(" Allocating %dk ",(count*sizeof(float))/1024);
           }
	break;

    case CONST:
	if (var!=NULL)
	    newitem->content.val = *var;
	break;
    default:
	if (var!=NULL)
            newitem->content.ptr = var;
    }
    return (newitem);
}

ptitem create_named_item(tp, name, var)
int tp; 
char *name;
float *var;
{
ptitem newitem;
int i;
/*printf ("Creating %s\n",name);*/
   newitem=NULL;
   if (top_free_stack>-1)
   	{
   	newitem=free_stack[top_free_stack];
   	top_free_stack--;
   	}

   if (newitem == NULL)
      	{
	if ((newitem = (ptitem) malloc(sizeof(item))) == NULL)
              return (NULL);
    	newitem->allocated = ALLOCATED;
        }                       /* STRUCT newitem allocated. Now allocate variable field*/
    newitem->used = NEWNAMED;
    newitem->type = tp;
    newitem->modulo = 0;
    switch (tp)
    {
    case VAR:
	if (top_discarded>=0)
	    {
            newitem->content.ptr=discarded[top_discarded];
/*	    printf(" r@%d ",top_discarded);*/
	    top_discarded--;
	    }
    	else
           {
           if ((newitem->content.ptr = (float *) malloc(count*sizeof(float))) == NULL)
         	return (NULL);
	   printf(" A %d",count*sizeof(float));
           }
    	newitem->mult = 1;
	break;

    case CONST:
	if (var!=NULL)
	    newitem->content.val = *var;
    	    newitem->mult = 0;
	break;
    }
    return (newitem);
}


void destr_item(it)
ptitem it;
{
  if (((it->allocated) >= ALLOCATED) && ((it->type) == VAR))
     {
/*     printf("freeing %d\n",(it->content).ptr);*/

/* IAC CODE CHANGE :      free ((it->content).ptr); */

/* IAC CODE CHANGE :       free(it->content.ptr); */
       free(it->content.ptr);
     }
  if ((it->allocated) == ALLOCATED)
     {

/* IAC CODE CHANGE :      free (it); */

/* IAC CODE CHANGE :       free(it); */
       free(it);
     }
  else
     it->used=FREE;
}

ptitem pop_exe_stack()
{
ptitem topitem;
int i;
topitem=exe_stack[top_exe_stack--];
if ((topitem->allocated == OUTPUT)&&(topitem->used < NAMED))
  {
  topitem->used=FREE;
  return(topitem);
  }
    if (((topitem->type) == VAR)&& ((topitem->allocated) >= ALLOCATED) && ((topitem->used) < NAMED))
        discarded[++top_discarded]=topitem->content.ptr;
/* error if top_exe_stack < 0                 */
return (topitem);
}

void free_item(topitem)
ptitem topitem;
{
if (((topitem->allocated) >= ALLOCATED)&&((topitem->used) < NAMED))
    free_stack[++top_free_stack]=topitem;
if (((topitem->allocated)>=ALLOCATED)&&(topitem->used==USED))
    topitem->used=FREE;

}

ptitem push_new_var()
{
   exe_stack[++top_exe_stack] = create_item(VAR,1,0,NULL);
   return(exe_stack[top_exe_stack]);
}

ptitem push_constant(val)
float *val;
{
   exe_stack[++top_exe_stack] = create_item(CONST,1,0,val);
   return(exe_stack[top_exe_stack]);
}

void push_old_var(var_item)
ptitem var_item;
{
   exe_stack[++top_exe_stack] = var_item;
}

ptitem find_named_item(item_name)
char *item_name;
{
int i;
   for (i=0;i<top_named;i++)
      {
      if (strcmp((named_stack[i]).name,item_name)==0)
	     return((named_stack[i]).item);
      }
   return (NULL);
}

ptitem named_item(name,type)
char *name;
int type;
{
ptitem item_found;
   if ((item_found=find_named_item(name))!=NULL)
	return(item_found);
   item_found=create_named_item(type, name, NULL);
   strcpy((named_stack[top_named]).name,name);
   (named_stack[top_named]).item=item_found;
   top_named++;
   return(item_found);
}



void clear()
{
int i,j;

for ( ; top_discarded >= 0; top_discarded--)
    {
    printf("freeing %d\n",discarded[top_discarded]);

/* IAC CODE CHANGE :     free(discarded[top_discarded]); */

/* IAC CODE CHANGE :      free(discarded[top_discarded]); */
      free(discarded[top_discarded]);
    }
}
void clear_all()
{
int i,j;
for ( ; top_exe_stack >= 0; top_exe_stack--)
    {
    destr_item(exe_stack[top_exe_stack]);
    exe_stack[top_exe_stack] = NULL;
    }
  for (j=first_output; j<first_alloc_orig;j++)
    if (((preallocated[j]).used)!= FREE)
     {
     (preallocated[j]).used	     = FREE;
     free_stack[top_free_stack++]                 = &preallocated[j];
     }
  for (j=first_alloc_orig; j<MAXPREALLOC;j++)
    if (((preallocated[j]).used)!= FREE)
     {
     (preallocated[j]).used	     = FREE;
     (preallocated[j]).allocated     = ALLOCATABLE;
     free_stack[top_free_stack++]    = &preallocated[j];
     }
for ( top_free_stack-=1; top_free_stack >= 0; top_free_stack--)
    {
    destr_item(free_stack[top_free_stack]);
    }
  top_named=top_named_orig;

  for (i=0,j=top_named; j<MAXPREALLOC;i++,j++)
     {
     (preallocated[j]).used        = FREE;
     (preallocated[j]).allocated   = ALLOCATABLE;
     free_stack[i]                 = &preallocated[j];
     }
  top_free_stack=i-1;
}


void copy_to(result_name)
char *result_name;
{
ptitem arg_item;
ptitem result;
float *arg,*res;
int index;

    arg_item = pop_exe_stack();
    if ((arg_item->type) == CONST)
    	{
	result=named_item(result_name,CONST);
	result->used=NEWNAMED;
	if ((result->type) == CONST)
	    result->content.val = arg_item->content.val;
	else
	    {
            res = result->content.ptr;
            for (index=0;index<count;index++,res+=result->mult)
	        *res=arg_item->content.val;
	    }
	}
    else
	{
        result=named_item(result_name,VAR);
        result->used=NEWNAMED;
    	arg = arg_item->content.ptr;
    	res = result->content.ptr;

    	if ((arg_item->type) == VAR)
            for (index=0;index<count;index++,res+=result->mult,arg+=arg_item->mult)
          		*res = *arg;
    	else
            for (index=0;index<count;index++,res+=result->mult)
          		*res = *(arg+(index/(arg_item->mult))%(arg_item->modulo));
    	}
    free_item(arg_item);
}


ptitem getvalue( buf)
char ** buf;

{
  float val;
  char  *right ;

  if( **buf != '<' )
    return( NULL ) ;

  if( ! sscanf( *buf, "<%f>", &val ) )
    return( NULL ) ;

  if( ( right = strchr( *buf, '>' ) ) == NULL )
    return( NULL ) ;

  *buf = right + 1 ;

  return (push_constant(&val));

}



void preallocate_variables(infield,infield1,infield2,infield3,infield4,infield_add,outfield)
AVSfield_float *infield, *infield1, *infield2, *infield3, *infield4, *infield_add, *outfield;
{
int i,j,k,l,ldata,lrdata,n;
float delta;
int Make_out_points;

ndimens=outfield->ndim;

for (i=j=k=l=n=0;i<NUMPARAMS;i++,n++)
    {
    (parameters[i]).type=CONST;
    (parameters[i]).used=NAMED;
    (parameters[i]).allocated=PREALLOCATED;
    sprintf((named_stack[n]).name,"p%d",i);
    (named_stack[n]).item = &(parameters[i]);
    }
for (i=0,lrdata=ldata=0; i<outfield->ndim; i++) 
    {
    ldata += (outfield->dimensions)[i];
    if ((outfield->dimensions)[i]>lrdata) lrdata=(outfield->dimensions)[i];
    }

/* IAC CODE CHANGE : if (row!=NULL) free (row); */

/* IAC CODE CHANGE : if (row!=NULL)  free(row); */
if (row!=NULL)   free(row);
row = (float *)malloc(lrdata*sizeof(float));

/* IAC CODE CHANGE : if (rrow!=NULL) free (rrow); */

/* IAC CODE CHANGE : if (rrow!=NULL)  free(rrow); */
if (rrow!=NULL)   free(rrow);
rrow = (float *)malloc(lrdata*sizeof(float));

  for (i=0; i<outfield->ndim; i++,j++,n++)
     {
     (named_stack[n]).item=&(preallocated[j]); 
     sprintf((named_stack[n]).name,"dim%d",i);
     (preallocated[j]).used        = NAMED;
     (preallocated[j]).type        = CONST;
     (preallocated[j]).allocated   = PREALLOCATED;
     (preallocated[j]).mult        = 0;
     (preallocated[j]).modulo      = 0;
     (preallocated[j]).content.val = 1.*(*((outfield->dimensions)+i));
     }
if (infield!=NULL)
  {
  for (i=0; i<infield->veclen; i++,j++,n++)
     {
     (named_stack[n]).item=&(preallocated[j]); 
     sprintf((named_stack[n]).name,"a%d",i);
     (preallocated[j]).used        = NAMED;
     (preallocated[j]).type        = VAR;
     (preallocated[j]).allocated   = PREALLOCATED;
     (preallocated[j]).mult        = infield->veclen;
     (preallocated[j]).modulo      = 0;
     (preallocated[j]).content.ptr = (infield->data)+i;
     }
  if ((infield->uniform)==IRREGULAR)
     {
     for (i=0; i<infield->nspace; i++,j++,n++)
        {
        (named_stack[n]).item=&(preallocated[j]); 
        sprintf((named_stack[n]).name,"x%d",i);
        (preallocated[j]).used        = NAMED;
        (preallocated[j]).type        = VAR;
        (preallocated[j]).allocated   = PREALLOCATED;
        (preallocated[j]).mult        = 1;
        (preallocated[j]).modulo      = 0;
        (preallocated[j]).content.ptr = (infield->points)+i*count;
        }
	lrdata=infield->nspace;
     }
  else
     {
     if ((infield->uniform)==UNIFORM)
     	{
     	incoords = (float *)malloc(ldata*sizeof(float));
  	l=0;
     	for (i=0; i<infield->ndim; i++)
     	   {
     	   if (((infield->max_extent)!=NULL)&&(((infield->max_extent)[i]-(infield->min_extent)[i])>0.))
      	     {
      	     delta=((infield->max_extent)[i]-(infield->min_extent)[i])/((infield->dimensions)[i]-1);
     	     for (k=0; k < (infield->dimensions)[i]; k++,l++)
            	  incoords[l]=(infield->min_extent)[i] + k*delta;
             }
           else
              for (k=0; k < (infield->dimensions)[i]; k++,l++)
                 incoords[l]=1.*k;
          }
       }
     else
       incoords=infield->points;
     

     k=1;
     for (i=0; i<infield->ndim; i++,j++,n++)
        {
        (named_stack[n]).item=&(preallocated[j]); 
	sprintf((named_stack[n]).name,"x%d",i);
        (preallocated[j]).used        = NAMED;
        (preallocated[j]).type        = MODVAR;
        (preallocated[j]).allocated   = PREALLOCATED;
        (preallocated[j]).mult        = k;
        (preallocated[j]).modulo      = (infield->dimensions)[i];
        (preallocated[j]).content.ptr = incoords;
        k *= (infield->dimensions)[i];
        incoords += (infield->dimensions)[i];
        }
     }
  if (infield1!=NULL)
     for (i=0; i<infield1->veclen; i++,j++,n++)
        {
        (named_stack[n]).item=&(preallocated[j]); 
	sprintf((named_stack[n]).name,"b%d",i);
        (preallocated[j]).used        = NAMED;
        (preallocated[j]).type        = VAR;
        (preallocated[j]).allocated   = PREALLOCATED;
        (preallocated[j]).mult        = infield1->veclen;
        (preallocated[j]).modulo      = 0;
        (preallocated[j]).content.ptr = (infield1->data)+i;
        }
  if (infield2!=NULL)
     for (i=0; i<infield2->veclen; i++,j++,n++)
        {
        (named_stack[n]).item=&(preallocated[j]); 
	sprintf((named_stack[n]).name,"c%d",i);
        (preallocated[j]).used        = NAMED;
        (preallocated[j]).type        = VAR;
        (preallocated[j]).allocated   = PREALLOCATED;
        (preallocated[j]).mult        = infield2->veclen;
        (preallocated[j]).modulo      = 0;
        (preallocated[j]).content.ptr = (infield2->data)+i;
        }
  if (infield3!=NULL)
     for (i=0; i<infield3->veclen; i++,j++,n++)
        {
        (named_stack[n]).item=&(preallocated[j]); 
	sprintf((named_stack[n]).name,"d%d",i);
        (preallocated[j]).used        = NAMED;
        (preallocated[j]).type        = VAR;
        (preallocated[j]).allocated   = PREALLOCATED;
        (preallocated[j]).mult        = infield3->veclen;
        (preallocated[j]).modulo      = 0;
        (preallocated[j]).content.ptr = (infield3->data)+i;
        }
  if (infield4!=NULL)
     for (i=0; i<infield4->veclen; i++,j++,n++)
        {
        (named_stack[n]).item=&(preallocated[j]); 
	sprintf((named_stack[n]).name,"e%d",i);
        (preallocated[j]).used        = NAMED;
        (preallocated[j]).type        = VAR;
        (preallocated[j]).allocated   = PREALLOCATED;
        (preallocated[j]).mult        = infield4->veclen;
        (preallocated[j]).modulo      = 0;
        (preallocated[j]).content.ptr = (infield4->data)+i;
        }
  }
  if (infield_add!=NULL)
     {
     add_count=1;
     add_skip[0]=1;
     for (i=0; i<infield_add->veclen; i++,j++,n++)
        {
        (named_stack[n]).item=&(preallocated[j]); 
	sprintf((named_stack[n]).name,"f%d",i);
        (preallocated[j]).used        = NAMED;
        (preallocated[j]).type        = VAR;
        (preallocated[j]).allocated   = PREALLOCATED;
        (preallocated[j]).mult        = infield_add->veclen;
        (preallocated[j]).modulo      = 0;
        (preallocated[j]).content.ptr = (infield_add->data)+i;
	}
     for (i=0; i<infield_add->ndim; i++)
        {
        add_count *= (infield_add->dimensions)[i];
        add_skip[i+1]=add_count;
        add_rowlen[i]= (infield_add->dimensions)[i];
        }
     }
  inindices = (float *)malloc(ldata*sizeof(float));
  l=0;
  for (i=0; i<outfield->ndim; i++)
     for (k=0; k < (outfield->dimensions)[i]; k++,l++)
         inindices[l]=1.*k;
  k=1;
  skip[0]=1;
  for (i=0; i<outfield->ndim; i++,j++,n++)
     {
     (named_stack[n]).item=&(preallocated[j]); 
     sprintf((named_stack[n]).name,"i%d",i);
     (preallocated[j]).used        = NAMED;
     (preallocated[j]).type        = MODVAR;
     (preallocated[j]).allocated   = PREALLOCATED;
     (preallocated[j]).mult        = k;
     (preallocated[j]).modulo      = (outfield->dimensions)[i];
     (preallocated[j]).content.ptr = inindices;
     rowlen[i]= (outfield->dimensions)[i];
     k *= (outfield->dimensions)[i];
     skip[i+1]=k;
     inindices += (outfield->dimensions)[i];
     }

  first_output=j;
  for (i=0; i<outfield->veclen; i++,j++,n++)
     {
     (named_stack[n]).item=&(preallocated[j]); 
     sprintf((named_stack[n]).name,"w%d",i);
     (preallocated[j]).used        = FREE;
     (preallocated[j]).type        = VAR;
     (preallocated[j]).allocated   = OUTPUT;
     (preallocated[j]).mult        = outfield->veclen;
     (preallocated[j]).modulo      = 0;
     (preallocated[j]).content.ptr = (outfield->data)+i;
     }
     if ((outfield->uniform)==UNIFORM)
        	outcoords = (float *)malloc(ldata*sizeof(float));
	else
		outcoords = outfield->points;
     if (((outfield->uniform)==UNIFORM)||((outfield->uniform)==RECTILINEAR))
     	{
	l=0;
     	for (i=0; i<outfield->nspace; i++)
     	   {
     	   if (((outfield->max_extent)!=NULL)&&(((outfield->max_extent)[i]-(outfield->min_extent)[i])>0.))
      	     {
      	     delta=((outfield->max_extent)[i]-(outfield->min_extent)[i])/((outfield->dimensions)[i]-1);
     	     for (k=0; k < (outfield->dimensions)[i]; k++,l++)
            	  outcoords[l]=(outfield->min_extent)[i] + k*delta;
             }
           else
              for (k=0; k < (outfield->dimensions)[i]; k++,l++)
                 outcoords[l]=1.*k;
          }
       }
   k=1;
   for (i=0; i<outfield->nspace; i++,j++,n++)
     {
     (named_stack[n]).item=&(preallocated[j]); 
     sprintf((named_stack[n]).name,"y%d",i);
     (preallocated[j]).allocated   = OUTPUT;
     switch (outfield->uniform)
	{
     case UNIFORM:
     case RECTILINEAR:
	(preallocated[j]).type        = MODVAR;
        (preallocated[j]).used        = NAMED;
        (preallocated[j]).content.ptr = outcoords;
        (preallocated[j]).mult        = k;
        (preallocated[j]).modulo      = (outfield->dimensions)[i];
        k *= (outfield->dimensions)[i];
        outcoords += (outfield->dimensions)[i];
	break;
     case IRREGULAR:
        (preallocated[j]).content.ptr = (outfield->points)+i*count;
        (preallocated[j]).used        = FREE;
	(preallocated[j]).type        = VAR;
        (preallocated[j]).mult        = 1;
        (preallocated[j]).modulo      = 0;
	}
     }
  
  first_alloc=first_alloc_orig=j;
  top_named=top_named_orig=n;

  for (i=0; j<MAXPREALLOC;i++,j++)
     {
     (preallocated[j]).used        = FREE;
     (preallocated[j]).allocated   = ALLOCATABLE;
     free_stack[i]                 = &preallocated[j];
     }
  top_free_stack=i-1;

}

void printitem(txt,pit)
char *txt;
ptitem pit;
{
printf("%s ",txt);
printf ("%d  %d  used=%d   ",pit->type,pit->allocated,
                                      pit->used);
if ((pit->type) == CONST)
    printf("%8.3f\n",pit->content.val);
else
    printf("%8.3f %8.3f %8.3f %8.3f %8.3f \n",*(pit->content.ptr),
                        *(pit->content.ptr+1),*(pit->content.ptr+2),
                        *(pit->content.ptr+1),*(pit->content.ptr+1));
}

