/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/
/*********************************************************************

Copyright (C) 1994, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus it is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>
#include "vr_util.h"

AVSinit_modules()
{
    int Vr_2float();
    AVSmodule_from_desc(Vr_2float);
}

int
Vr_2float()
{
    int Vr_2float_compute();
    
    AVSset_module_name("VR to floats",MODULE_FILTER);
    AVScreate_input_port("input field",VR_FIELD_STRING,REQUIRED);
    AVScreate_output_port("X Translation","real");
    AVScreate_output_port("Y Translation","real");
    AVScreate_output_port("Z Translation","real");
    
    AVScreate_output_port("X Rotation","real");
    AVScreate_output_port("Y Rotation","real");
    AVScreate_output_port("Z Rotation","real");

    AVSset_compute_proc(Vr_2float_compute);
}

static float trans[3],rot[3];

int
Vr_2float_compute(inf,tx,ty,tz,rx,ry,rz)
AVSfield *inf;
float **tx,**ty,**tz;
float **rx,**ry,**rz;
{
    float *t;

    t = inf->field_union.field_data_float_u;
    
    VR_GET_TRANS_VECTOR(trans[0],trans[1],trans[2],inf); 
    *tx = trans;
    *ty = trans+1;
    *tz = trans+2;

    VR_GET_ROT_VECTOR(rot[0],rot[1],rot[2],inf); 
    *rx = rot;
    *ry = rot+1;
    *rz = rot+2;

    return(1);
}
