/*
 * sbcustom.h
 *
 * Configuration file for the Spaceball Library Unix implementation
 *
 * Version: L4.05
 * Release Date:	       29 August  1989
 * Latest modification:        13 May	  1989
 *
 * Written by John Hilton, Spatial Systems Inc, May 1988
 *
 * Copyright (C) 1988 Spatial Systems Inc. All Rights Reserved.
 * Spaceball is a registered trademark of Spatial Systems Inc.
 *
 * Refer to the Spaceball Application Developer's Reference (Document
 * Number D1005) for more information on the following code.
 *
 * RESTRICTIONS
 *
 * The following code is licensed for use and distribution provided the
 * code is used exclusively in conjunction with a Spaceball.  No portion
 * may be used for other purposes without prior written permission from
 * Spatial Systems Inc.  This notice must accompany any full or partial
 * copies.
 */

#ifndef Sb_SBCUSTOM_H	    /* have we been here before? */
#define Sb_SBCUSTOM_H

#ifndef TRUE
#define TRUE	1
#endif

#ifndef FALSE
#define FALSE	0
#endif

#ifndef SystemV
#   ifdef BERKELEY
#      define  SystemV	   0
#   else
#      define  SystemV	   1
#   endif
#endif

/* define usage of floating point reals */
typedef float	SbReal;

/* Set the number of rows and the number of columns used by matrices */
#define 	Sb_ROWS 		    4
#define 	Sb_COLUMNS		    4

/* define the index ordering of matrices */
#define 	Sb_INDEX( mat, idx1, idx2 ) mat[ idx1 ][ idx2 ]

/* define an octally specified bit mask which determines which rows and/or
 * columns are negated so as to match rotational directions.  For instance,
 * if x and z rotations are in the wrong direction use a value of 044 to
 * cause them to reverse directions.  The value 044 (preceeding 0 indicates
 * an octal value) effectively causes a mirroring transformation in Z to be
 * applied before and after the rotation matrices resulting in X and Y
 * rotations to reverse directions.  Bit usage is 00 [row2][row1][row0]
 * [col2][col1][col0].	Note:  The number of bits set must be even otherwise
 * the matrix determinant will be negative.  */
#define 	Sb_MATRIX_CONVERSION	    000

/* define the number of Spaceballs used by the application
 * A value of 1 will cause efficient run time addressing but there is
 * still the flexibility to utilize the library with more than
 * one Spaceball if ever required. */
#define 	Sb_NUMBER_OF_SPACEBALLS     1

/* SWAP_BYTES is TRUE for machines using lo-hi ordering such as Intel
 * microprocessors. For most machines it is FALSE. */
/*#define 	Sb_SWAP_BYTES		    FALSE */
#define 	Sb_SWAP_BYTES		    TRUE

/* Some machines cannot access words on odd address boundaries */
#define 	Sb_ODD_ADDR_OK		    FALSE

/* Some implementations cannot utilize the binary communications mode */
#define 	Sb_PRINTABLE_MODE	    TRUE

/* Some C compilers allow argument checking */
#define 	Sb_CHECK_ARGS		    FALSE

/* define the environment variables required for use in sbcustom.c */

/* Sb_USING_POLL is TRUE when SystemV poll() system call is used */
#define 	Sb_USING_POLL		    FALSE

/* Sb_LOCK_TTY turns on tty locking which prevents other Spaceball
 * library programs from accessing the Spaceball line at the same time.
 * Some systems allow exclusive access through other means. */
#define 	Sb_LOCK_TTY		    FALSE

#ifdef Sb_ENVIRONMENT_INCLUDES
/* include any system libraries which are required for defining
 * SbEnvironmentType. These files will normally be included by
 * application programs themselves but are required here by
 * sblibry.c. */
#if irix3
#include    <bsd/sys/types.h>
#else
#include    <sys/types.h>
#endif
#if hpcisc || hppa
#    include	<time.h>
#else
#    include	<sys/time.h>
#endif
#   if Sb_USING_POLL
#   include    <poll.h>
#   endif
#endif
#if ibm
#include <sys/select.h>
#endif


typedef struct {
    int
      Backslash,    /* flag used to remove additional backslashes from input */
      Fd;	    /* Spaceball tty file descriptor */
    char
      *Lock_name;   /* pointer to lock file name */
    FILE
      *Lock_fp;     /* lock file pointer */
#if Sb_USING_POLL
    struct pollfd
      Fds[ 1 ];
#else
    fd_set
      Fdset;
#endif
} SbEnvironmentType;

#define     SbBackslash		    Sb->Environment.Backslash
#define     SbFd		    Sb->Environment.Fd
#define     SbLock_name 	    Sb->Environment.Lock_name
#define     SbLock_fp		    Sb->Environment.Lock_fp
#if Sb_USING_POLL
#define     SbFds		    Sb->Environment.Fds
#else
#define     SbFdset		    Sb->Environment.Fdset
#endif

/* define the environment variables initialisation */
#if Sb_USING_POLL
#define     Sb_DEFAULT_ENVIRONMENT  { TRUE, -1, NULL, NULL, { -1 } }
#else
#define     Sb_DEFAULT_ENVIRONMENT  { TRUE, -1, NULL, NULL, { 0 } }
#endif

#endif /* Sb_SBCUSTOM_H */
