/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/
/**********************************************************************

Copyright (C) 1995, 1996  E. O. Lawrence Berkeley National Laboratory.  
All Rights Reserved.  Permission to copy and/or redistribute this software 
and its documentation (if any) is hereby granted, provided that this notice 
is retained thereon and on all copies.  

This software is provided as a professional academic contribution for 
joint exchange.   Thus it is experimental and scientific in nature, 
undergoing development, and is provided "as is" with no warranties of 
any kind whatsoever, no support, promise of updates or printed 
documentation.

This work is supported by the U. S. Department of Energy under contract 
number DE-AC03-76SF00098 between the U. S. Department of Energy and the 
University of California.


	Author: Wes Bethel
		Lawrence Berkeley National Laboratory
                Berkeley, California 

  "this software is 100% hand-crafted by a human being in the USA"

  Fri Apr 19 10:39:31 PDT 1996

  in the vr_cam_ui_p routine is code which implements two different
  ways of controlling the camera.  one of them is if 0'd out and
  not compiled.  it works fine, and the "feel" of this model is
  markedly different from that of the default model.  the default
  model is to have the camera position and orientation directly
  attached to the "head" sensor.  in this simpler model, the hand
  field makes no contribution to camera position other than to possibly
  reset the camera position to some default position and orientation.
  i encourage you to experiment with each model.

***********************************************************************/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>

#include "vr_util.h"

AVSinit_modules()
{
    int vr_cam_ui();
    AVSmodule_from_desc(vr_cam_ui);
}

int
vr_cam_ui()
{
    int p,vr_cam_ui_p();

    AVSset_module_name("VR camera UI",MODULE_FILTER);
    AVSset_compute_proc(vr_cam_ui_p);

    AVScreate_input_port("hand_event_stream",VR_FIELD_STRING,REQUIRED);
    AVScreate_input_port("head_event_stream",VR_FIELD_STRING,REQUIRED);
    
    AVScreate_output_port("camera_event_stream",VR_FIELD_STRING);
    
    p = AVSadd_float_parameter("trans event scale",1.,0.,1.0);
    p = AVSadd_float_parameter("rot event scale",0.5,0.,1.);
}

int
vr_cam_ui_p(head,hand,camera,scale,rscale)
AVSfield *head,*hand,**camera;
float *scale,*rscale;
{
    AVSfield template;
    float tvec[3],rvec[3],new_tvec[3],new_rvec[3];
    int have_button_event;
    int left_button,right_button,middle_button,top_button,bottom_button;
    int i;

    if (*camera)
	AVSfield_free(*camera);
    
    memset((char *)&template,0,sizeof(AVSfield));
    MAKE_VR_AVS_FIELD_TEMPLATE(&template);
    *camera = (AVSfield *)AVSfield_alloc(&template,VR_field_dims);

    VR_COPY_ALL_DATA((*camera),head);

    /* parse button events, possibly modifying the translational
       component of the VR device stream. */

    TEST_BUTTONS_FLAG(have_button_event,hand);
    if (have_button_event)
    {

	/* here is where the actual button-to-action mapping occurs. */
	VR_TEST_BUTTON(VR_BUTTON1_MASK,left_button,hand);
	VR_TEST_BUTTON(VR_BUTTON2_MASK,middle_button,hand);
	VR_TEST_BUTTON(VR_BUTTON3_MASK,right_button,hand);
	VR_TEST_BUTTON(VR_BUTTON4_MASK,top_button,hand);
	VR_TEST_BUTTON(VR_BUTTON5_MASK,bottom_button,hand);

	/* clear all the buttons flags in the output field */
	VR_SET_BUTTON(VR_BUTTON1_MASK,0,(*camera));
	VR_SET_BUTTON(VR_BUTTON2_MASK,0,(*camera));
	VR_SET_BUTTON(VR_BUTTON3_MASK,0,(*camera));
	VR_SET_BUTTON(VR_BUTTON4_MASK,0,(*camera));
	VR_SET_BUTTON(VR_BUTTON5_MASK,0,(*camera));

	new_tvec[0] = new_tvec[1] = new_tvec[2] = 0.;
	new_rvec[0] = new_rvec[1] = new_rvec[2] = 0.;

#if 0
	/* the code contained in this if 0'd out code can be used
	 to implement a "caterpiller" drive camera.  this means that
	 you can press the top button (index finger) and you'll go
	 "forward" (in whichever direction you're looking.  etc.
	 i personally don't like this method of manipulating a camera,
	 but it does have it's uses.  this code works fine, i just
	 preferred the simpler interface below. */
	
	if (left_button)      
	{
	    if (top_button)	/* top + left = roll left */
		new_rvec[2] += *rscale;
	    else		/* left only = go left */
		new_tvec[0] -= *scale;
	}
	if (right_button)     /* go right */
	{
	    if (top_button)	/* top + right = roll right */
		new_rvec[2] -= *rscale;
	    else		/* right only = go right */
		new_tvec[0] += *scale;
	}
	if (top_button)	 
	{
	    if (middle_button)	/* top+middle = go up */
		new_tvec[1] += *scale;
	    else		/* top only = go forward */
		new_tvec[2] += *scale;
	}
	if (bottom_button)    
	{
	    if (middle_button)	/* middle+bottom = go down */
		new_tvec[1] -= *scale;
	    else		/* bottom only = go backwards */
		new_tvec[2] -= *scale;
	}
#endif

#if 0
	if ((middle_button) && (!top_button) && (!bottom_button))
	    /* translate middle button into a #1 button
	       for the camera control module.  that module
	       interprets a #1 button event as a reset.*/
	if ((top_button) && (bottom_button)) /* top + bottom = reset */
#endif
        if (middle_button)	/* middle button = reset */
	{
	    /* if the middle button is pushed, set a "button1"
	     event.  this event is interpreted by the VR Transform Camera
	     module as a request to reset the camera position to it's
	     default location. */
	    VR_SET_BUTTON(VR_BUTTON1_MASK,1,(*camera));
	    SET_BUTTONS_FLAG(1,(*camera));
	}
	else
	{
	    SET_BUTTONS_FLAG(0,(*camera));
	}
	VR_GET_TRANS_VECTOR(tvec[0],tvec[1],tvec[2],head);
	VR_GET_ROT_VECTOR(rvec[0],rvec[1],rvec[2],head);
	for (i=0;i<3;i++)
	{
	    tvec[i] += new_tvec[i];
	    rvec[i] += new_rvec[i];
	}
  	VR_SET_TRANS_VECTOR(tvec[0],tvec[1],tvec[2],(*camera));
	VR_SET_ROT_VECTOR(rvec[0],rvec[1],rvec[2],(*camera));
    }

    return(1);

}


